/***************************************************************************
                          menge.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qglobal.h> // fr ASSERT()

#include "menge.h"

Menge::Menge(bool alles /*= false*/) {
  for (int i = 0; i < mengengroesse; i++)
    mDaten[i] = alles;
}
Menge::~Menge(){
}

/** Fgt b zur Menge hinzu (oder hinweg) */
void Menge::dazu(char b, bool rein /*= true*/){
  mDaten[buchNr(b)] = rein;
}

/** fgt ein ganzes Intervall zur Menge hinzu (oder hinweg) */
void Menge::dazu(char a, char b, bool rein /*= true*/) {
  int a0 = buchNr(a);
  int b0 = buchNr(b);
  for (int i = a0; i <= b0; i++)
    mDaten[i] = rein;
}

/** liefert die Nummer vom Buchstaben */
int Menge::buchNr(char b) const {
  if (b >= 'A' && b <= 'Z')
    return b - 'A';
  else if (b >= 'a' && b <= 'z')
    return b - 'a' + 26;
  //else if (b == '*')
  //	return 52;
  ASSERT(false);
  return 0; // um keine Warnung zu bekommen
}

/** liefert true, wenn b in der Menge ist */
bool Menge::drin(char b) const {
  return mDaten[buchNr(b)];
}
/** tut, was man erwarten wrde */
void Menge::komplementiere(){
  for (int i = 0; i < mengengroesse; i++)
    mDaten[i] = !mDaten[i];
}
/** liefert true, wenn die beiden Mengen nicht-leeren
    Schnitt haben */
bool Menge::ueberschneidet(const Menge & m) const {
  for (int i = 0; i < mengengroesse; i++)
    if (mDaten[i] && m.mDaten[i])
      return true;
  return false;
}
/** Liefert die Anzahl der Elemente der Menge geschnitten mit dem
    Intervall ['A', bis] */
int Menge::groesse(char bis /*= 'z'*/) const {
  int r = 0;
  for (int i = 0; i <= buchNr(bis); i++)
    if (mDaten[i]) r++;
  return r;
}
