
/*
 * Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: frame.h,v 1.8 2001/03/14 19:17:56 stes Exp $
 */

extern id curframe;
extern id activeframe;
extern id framelist;
extern int getreq(WINDOW*w);

#define C_NONE 0
#define C_MENU 1
#define C_FORM 2
#define C_TEXT 3

extern id openframe(char *t,int what,id args);

@interface Frame : Object
{
  id args;
  id filename;

  /* frame descriptors */

  id altslks; /* whether to display SLKs 9 through 16 */
  id begrow; /* original top left corner row */
  id begcol; /* original top left corner column */
  id close; /* evaluated when menu closed */
  id columns; /* desired number of columns */
  id done; /* for multi-select menu */
  id framemsg; /* displayed as long as menu is current */
  id help;
  id init; /* whether to open menu frame */
  id interrupt;
  id lifetime;
  id formtitle; /* title */
  id menu; /* title */
  id multiselect;
  id oninterrupt;
  id reread;
  id rows; /* desired number of rows */
  id scrlabkeys;

  int num;
  id boundrect; /* 0,0  - w,h */
  id framerect; /* x1,y1 - x1+w,y1+h */
  WINDOW *eti_win;
  WINDOW *eti_subwin;
  BOOL alternate; /* whether to display SLKs 9 through 16 */
  BOOL isactive;
  BOOL cyclic; /* default = false */
  BOOL needdisplay;
  BOOL iscmdmenu;
  BOOL ischoicemenu;
  BOOL dontdrawbox;
}

+ (int)blockalarm;
+ (int)unblockalarm;

- framemsg;
- filename;
- setfilename:v;
- (STR)name;
- (int)num;
- (BOOL)mustopenframe;

- setargs:v;
- setnum:(int)i;
- renumber;

- setmenu:m;
- setform:f;
- setrows:r;
- setcolumns:r;
- setframemsg:m;
- setcyclic:m;
- setinit:m;
- setdone:m;
- setreread:m;
- setclose:m;
- sethelp:m;
- setbegrow:m;
- setbegcol:m;
- setscrlabkeys:x;
- setaltslks:x;
- altslkstoggle;
- setlifetime:x;
- setmultiselect:x;
- setinterrupt:x;
- setoninterrupt:x;
- setsiginthandler;

- (int)height;
- (int)width;
- (int)left;
- (int)top;

- (BOOL)needsreread;

- frametoolarge;
- setframerect:aRect;
- (int)fixedbegrow;
- (int)fixedbegcol;
- begframerect:(int)width:(int)height;

- activate;
- deactivate;

- nextframe;
- prevframe;

- setslk;
- create;
- destroy;
- draw;
- display;
- displayifneeded;

- drawbox:(char*)s;
- drawscrollbar:(int)y1:(int)y2:(int)h;

- home;
- end;

- pageup;
- pagedown;

- arrowup;
- arrowdown;
- arrowleft;
- arrowright;
- clearEol;

- (int)getkey;
- getevent;
- keydown:(int)c;

- help;
- enter;
- chgkeys;
- cancel;
- close;
- closeshortterm;
- save;
- setchoice;
- choices;
- needsdisplay;
- refresh;
- update;
- showcmdmenu;

- move;
- reshape;

- writeOn:proc delim:(char*)d;

@end
 
