# numbers.rb : Qt methods for strings
# Copyright (C) 2006 Vincent Fourmond
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA


module MetaBuilder

  # The module ParameterTypes should be used for all subclasses of
  # ParameterType, to keep the place clean and tidy.
  module ParameterTypes

    # An integer
    class FileParameter

      def qt4_create_input_widget(parent = nil, target = nil, style = nil)
        return Qt4MB::FileInputWidget.new(parent, self)
      end

      # Directly wraps to Qt::FileDialog.get_open_file_name;
      # the _title_ is therefore ignored...
      def qt4_get(parent, title, label, default, target = nil) 
  
        file = Qt::FileDialog.get_open_file_name(parent, label,
                                                 File.dirname(default),
                                                 filter)
        if file.nil?
          raise CancelInput
        end
      end

    end

  end

  module Qt4MB
    
    # A widget with a nice Browse box to choose 
    class FileInputWidget < Qt::Widget

      # Emitted when the value is changed. Connected to
      # editingFinished().
      signals 'value_changed()' 

      # When the button is clicked
      slots   'button_clicked()'

      # Creates a Generic widget. _type_ is the FileParameter
      # instance for whom we should do conversion.
      def initialize(parent, type)
        super(parent)
        @type = type
        @layout = Qt::HBoxLayout.new(self)

        @line_edit = Qt::LineEdit.new
        @layout.add_widget(@line_edit)
        connect(@line_edit, SIGNAL('editingFinished()'),
                SIGNAL('value_changed()'))

        @button = Qt::PushButton.new("Browse")
        @layout.add_widget(@button)
        connect(@button, SIGNAL('clicked()'),
                SLOT('button_clicked()'))
      end

      def button_clicked
        file = @type.qt4_get(parent, "dummy", 
                             "Select file", text)
        self.text=file
      rescue
        # Nothing, just don't set the current value
      end

      def text
        return @line_edit.text
      end

      def text=(t)
        @line_edit.setText(t)
      end


      def value
        return text
      end
      
      def value=(v)
        self.text=v
      end

    end
  end

end
