#!/bin/sh
# This file contains some 'visual tests' for ctioga to make sure that when
# I add some features to ctioga, I don't break everything existing.
# As such, it also stands as a 'feature list' for ctioga.

. ./test_style.sh

# We first create several data files using ctable

tmpfile=`mktemp -t "ctioga-test-XXXXXXX"`

echo "Generating temporary data file ${tmpfile}"

# Here: warning; density is quite high (500 points)
ruby -e 'include Math; srand(Time.now.to_f); 0.upto(500) do |i|
x = 3.1415 * (1- 2*rand)
puts "#{i}\t#{x}\t#{sin(x)}\t#{cos(x) + 0.1*rand}\t#{0.2*sin(x)}"
end
' > $tmpfile

ctioga -N -t 'Raw data' --text --marker auto --line-style Dashes \
    $tmpfile@2:3

ctioga -N -t 'Without lines' --text --marker auto --line-style No \
    $tmpfile@2:3

ctioga -N -t '20\% error bars' --text --marker auto --line-style No \
    $tmpfile@2:3:5

ctioga -N -t 'Noisy cosine' --text --marker auto --line-style No \
    $tmpfile@2:4

# Two small exercises:
# * why did I draw the y = 1 line ?
# * compute the envelope of the obtained dot cloud ;-)...

ctioga -N -t 'Nearly one !' --text --marker auto --line-style No \
    --draw 'line: -3.14,1 3.14,1 line_style=Dashes color=Gray' \
    $tmpfile@'$2:$3**2 + $4**2'


# Now, demonstrating the --sort filter:

ctioga -N -t 'Sorted data' --text --sort --marker auto \
    --line-style Dashes $tmpfile@2:3

ctioga -N -t 'Sorted data with error bars' --text --sort --marker auto \
    --line-style Dashes $tmpfile@2:3:5

ctioga -N -t 'Cosine' --text --marker auto --line-style No \
    --legend-inside 'tl' \
    -l "Original" $tmpfile@2:4 \
    --smooth 7 -l 'Smoothed before sorting' $tmpfile@2:4 \
    --filter-clear --sort \
    --smooth 7 -l 'Smoothed after sorting' $tmpfile@2:4

# rm -f $tmpfile

echo "Generating temporary (nearly) redundant data ${tmpfile}"

# Here: warning; density is quite high (500 points)
ruby -e 'include Math; srand(Time.now.to_f); 0.upto(50) do |i|
x = 3.1415 * (1- 2*rand)
20.times { puts "#{x}\t#{sin(x) + (1.6*(rand - 0.5))**3}" }
end
puts "0\t0"
' > $tmpfile

ctioga -N -t 'Redundant data' --text --marker auto --line-style Dashes \
    $tmpfile

ctioga -N -t 'Sorted redundant data' --text --marker auto \
    --sort --line-style Dashes \
    $tmpfile

ctioga -N -t 'After averageing duplicates' --text --marker auto \
    --line-style Dashes --avgdup $tmpfile

ctioga -N -t 'Computing standard deviation' --text --marker auto \
    --sort --stddev \
    --line-style Dashes --avgdup $tmpfile

rm -f $tmpfile