# theme/fits.rb, copyright (c) 2007 by Vincent Fourmond: 
# The "fits" theme
  
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (in the COPYING file).


require 'Tioga/tioga'
require 'CTioga/themes'
require 'CTioga/movingarrays'


module CTioga

  module Themes

    # A theme where marker-only curves (data) alternate with
    # lines-only curves (fits)
    class FitsTheme < BaseTheme
      
      include Tioga::FigureConstants

      # Mainly for listing purposes:
      attr_reader :sets

      def initialize(color_set = 'standard',
                     marker_set = 'standard',
                     # By default, the marker color will match
                     # the line color, even if the latter is set
                     # manually.
                     marker_color_set = :"=>color",
                     linestyle_set = Line_Type_Solid)
        @sets = {
          :colors => MovingArray.new(Styles::COLORS, color_set),
          :markers => MovingArray.new(Styles::MARKERS, marker_set),
          :markers_colors => MovingArray.new(Styles::COLORS, 
                                          marker_color_set),
          :linestyle => MovingArray.new(Styles::LINES, linestyle_set)
        }
        
        @data = true
      end
      
      
      def next_curve_style(name)
        if @data
          @last_color = @sets[:colors].value
          style = CurveStyle.new(@last_color, 
                                 @sets[:markers].value,
                                 @last_color,
                                 false,
                                 name, 
                                 1.0,
                                 false,  # Does not interpolate by default
                                 0.5)
          @data = false
        else
          style = CurveStyle.new(@last_color, 
                                 false, 
                                 @last_color,
                                 @sets[:linestyle].value,
                                 name, 
                                 1.0,
                                 true,  # Data is interpolated by default
                                 0.5)
          @data = true
        end
        return style
      end

      def choose_set(type, set)
        @sets[type].choose_current_set(set)
      end

      def cmdline_extra_args
        return ["--marker", "auto"]
      end


    end

  end

end
