/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#include "../../config.h"

#include "AboutDlg.hh"
#include "Common.hh"
#include <wx/statline.h>
#ifndef __WXMSW__
#include "pics/idealx.xpm"
#endif

AboutDlg::AboutDlg(wxWindow *parent, wxWindowID id , const wxString &title)
    : CryptonitDlg( parent , id , title ){

    wxBoxSizer *aboutSizer = new wxBoxSizer( wxVERTICAL );
    
    wxBitmap idealx = wxBITMAP( idealx );
    
    
    wxString text = wxString::Format(_("Cryptonit version %s"),std2wx(VERSION).c_str());
    text += _T("\n\n");
    text += _("Cryptonit has been developed by IDEALX");
    text+=_T("   \n");
    text+=_T("http://www.idealx.com http://www.cryptonit.org");
    text+=_T("\n");
    text+=_T("\n");
    text+=_T("This program is free software; you can redistribute it and/or");
    text+=_T("\n");
    text+=_T("modify it under the terms of the GNU General Public License version");
    text+=_T("\n");
    text+=_T("2 as published by the Free Software Foundation. Idealx SAS adds");
    text+=_T("\n");
    text+=_T("two special exceptions to this licence.");
    text+=_T("\n");
    text+=_T("Please read LICENCE file for more information");
    text+=_T("\n\n");
    text+=_T("This product includes software developed by the OpenSSL Project");
    text+=_T("\n");
    text+=_T("for use in the OpenSSL Toolkit.");
    text+=_T("OpenSSL (www.openssl.org)");
    text+=_T("\n");
    text+=_T("Copyright (c) 1998-2005 The OpenSSL Project.");
    text+=_T("\n");
    text+=_T("Copyright (c) 1995-1998 Eric Young (eay@cryptsoft.com)");
    text+=_T("\n");
    text+=_T("\n");
    text+=_T("Portion of Cryptonit source code uses (by the way of headers inclusion) some work");
    text+=_T("\n");
    text+=_T("\"derived from RSA Security Inc. PKCS #11 Cryptographic Token Interface (Cryptoki)\"");
    text+=_T("\n\n");
    text+= _("Cryptonit also uses: ");    
    text+=_T("\n\n");
    text+=_T("sha2.c");
    text+=_T("\n");
    text+=_T("Copyright (c) 2000-2001, Aaron D. Gifford");
    text+=_T("\n");
    text+=_T("\n");
    text+=_T("OpenLDAP (www.openldap.org) ");
    text+=_T("\n");
    text+=_T("Copyright (c) OpenLDAP Foundation");
    text+=_T("\n");
    text+=_T("\n");
    text+=_T("wxWidgets (www.wxwidgets.org) ");
    text+=_T("\n");
    text+=_T("Copyright (c) 1998 Julian Smart, Robert Roebling et al");

    aboutSizer->Add( new wxStaticBitmap(this, -1, idealx ) , 0 , wxEXPAND | wxCENTER | wxALL , 5 );
    aboutSizer->Add( new wxStaticText( this, -1 , text ) ,   0 , wxEXPAND | wxCENTER | wxALL , 5 );
    aboutSizer->Add( new wxStaticLine( this , -1 ) ,  0 , wxEXPAND | wxCENTER | wxTOP  , 10 );
     
    mainSizer->Add( aboutSizer , 1 , wxEXPAND | wxCENTER | wxALL , 2 );
    
}
