#include "balancer"

void Balancer::init() {
    // Set the listening socket.
    if (! config.sport()) {
	// In inetd mode, set the server socket to fd 0.
	// Else it will be initialized.
	server_fd.fd(0);
    } else {
	// In TCP mode: Prepare the binding.
	server_fd.bind(config.sipaddr(), config.sport());
    }
    
    // Start the web interface if requested.
    if (config.usewebinterface() && !config.foregroundmode()) {
	webinterface = new Webinterface();
	if (! webinterface)
	    throw Error("Memory fault in Balancer::init");
	webinterface->start();
    }

    // Add workable back ends, display initial states.
    for (int i = 0; i < config.backends(); i++) 
	addbackend (config.backend(i));
    msg("Back end start states of " << nbackends() << " backends:\n");
    for (unsigned i = 0; i < nbackends(); i++) 
	msg(' ' << backend(i).description() << " is " <<
	    backend(i).availablestr() << '\n');
}
