// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __PaxMaze_hpp__
#define __PaxMaze_hpp__

#include <Maze.hpp>

//the pacmaze class add the screen handling, and adds some new elements
//(in addition to the walls).
class PuckMaze:public Maze
{
private:

    int points;
    void AddElements( void);

public:

    PuckMaze( int width, int height);
    void MakeNew( void);
    void AddPowerpoints( int numPoints);

    void ClearPoint( int x, int y)
    {
	RemoveElement( x, y, POINT);
	points--;
    }

    void Draw( void);
    void Redraw( int X, int Y, int W, int H);
    int  Points( void){ return( points);}
};

#endif
