// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __Character_hpp__
#define __Character_hpp__

// Character base class
//

#include <PuckMaze.hpp>

class Character
{
protected:
    int x;
    int y;
    PuckMaze *maze;

    int oldx;
    int oldy;
    char bgPixmap[9];

public:
    Character( PuckMaze *maze);
    virtual ~Character(){};

    virtual void Draw( void) = 0;
    virtual void Add( void);
    virtual void Remove( void);

    virtual bool Move( int dir);
    void SetPosition( int newx, int newy);
};

#endif
