// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __BaseSurface_hpp__
#define __BaseSurface_hpp__

#include <string>

using std::string;

class BaseSurface
{
public:
    BaseSurface( int w, int h);
    virtual ~BaseSurface();

    static void createSurface( const string &type, int w, int h);

    static BaseSurface* instance( void)
    {
	if( !_surf)
	{
	    createSurface( "_DEFAULT_", 640, 480);
	}
	return _surf;
    }

    virtual void SetColor( int index, int red, int green, int blue) = 0;
    virtual void SetPixel( int x, int y, unsigned char colorIndex) = 0;
    virtual unsigned char GetPixel( int x, int y) = 0;
    virtual void Flip( void) = 0;

    virtual void Snapshot( void){;}

    int Width( void)
    {
	return _width;
    }
    int Height( void)
    {
	return _height;
    }

    virtual const string &Type( void) = 0;

private:
    static BaseSurface *_surf;
    int _width;
    int _height;
};

inline BaseSurface *SurfaceS(void)
{
    return BaseSurface::instance();
}

#endif
