/* crank.h - shared header file
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#ifndef H_CRANK
#define H_CRANK

#include <gtk/gtk.h>
#include <gmodule.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#define POSIX

#ifdef POSIX
#include <dirent.h> 
#endif

#define VERSION "0.1.4"
#define INTERFACE_VERSION 1

#define TOGGLE(x) (x = ((x) ? FALSE : TRUE))

#define GLOBAL_TRANSFORMED_TEXT (gtk_editable_get_chars(GTK_EDITABLE(textarea), 0, -1))

#define BUFFER_SIZE 1024

#define STR_ABOUT "Crank v" VERSION "\n" \
                  "============\n\n" \
                  "Author: Matthew Russell <twig5151@yahoo.com>\n" \
                  "Crank Homepage: http://crank.sourceforge.net/\n" 

typedef struct _plugin_data {
    char *name; 
    char *version; 
    char *author;
    char *description;
    int interface_version;                      /* Version of the interface used by the plugin */
    int plugin_type;                            /* Floating or mode? */
    char *menu_string;                          /* Full path to menu in ItemFactory notation */
    int (*boot) (void);                         /* Function run at startup */
    void (*init_plugin) (void);                 /* Initialise data structures when new instance is created */
    void (*deactivate_plugin) (void);           /* Clean up after plugin is removed */
    GtkWidget *(*make_widget) (char *);         /* Make user interface component */
    char *(*transform) (char *);                /* Perform transformation on some text */ 
    void (*reset) (void);                       /* Reset a mode plugin to a hopefully neutral effect */
    float (*fitness) (char *);                  /* Evaluate the closeness of a text to plaintext */
    struct _plugin_data *next;
} plugin_data;

#define PLUGIN_MODE     1 /* A plugin which transforms the source according to a user interface control */
#define PLUGIN_FLOATING 2 /* A plugin which displays a dialog display independantly of the current mode plugin */
#define PLUGIN_FITNESS  3 /* A plugin which provides a fitness evaluation function for text being plaintext */

#define PLUGIN_BOOT_OK   1
#define PLUGIN_BOOT_FAIL 2

#endif
