/**************************************************************************/
/*                                                                        */
/*  cpbk - a mirroring utility for backing up your files                  */
/*  Copyright (C) 1998 Kevin Lindsay <klindsay@mkintraweb.com>            */
/*  Copyright (C) 2001 Yuuki NINOMIYA <gm@debian.or.jp>                   */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2, or (at your option)   */
/*  any later version.                                                    */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful,       */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*  GNU General Public License for more details.                          */
/*                                                                        */
/*  You should have received a copy of the GNU General Public License     */
/*  along with this program; if not, write to the                         */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,          */
/*  Boston, MA 02111-1307, USA.                                           */
/*                                                                        */
/**************************************************************************/

/* $Id: variable.h,v 1.6 2001/03/30 13:16:36 gm Exp $ */

#ifndef VARIABLE_H_INCLUDED
#define VARIABLE_H_INCLUDED

#ifdef GLOBAL_VALUE_DEFINE
#  define GLOBAL
#  define GLOBAL_VAL(v) =(v)
#else
#  define GLOBAL extern
#  define GLOBAL_VAL(v) /* */
#endif

#include <sys/stat.h>
#include <sys/types.h>

#include "parsecfg.h"


#ifndef PATH_MAX
#  define PATH_MAX 4096
#endif

#define BUFSIZE 8192


typedef enum {
	FALSE,
	TRUE
} bool;

typedef enum {
	ALWAYS_EXIT,
	CAN_PROCEED
} ProcessOnError;

typedef enum {
	ENTER,
	LEAVE,
	NEW,
	UPDATE,
	REMOVE,
	MKDIR,
	RMDIR,
	CHMOD,
	END
} Action;


typedef struct {
	char *source_dir;
	char *dest_dir;
	char *trashbin_dir;
	cfgList *exclude_path;
	bool simulate;
	bool inode_ctime_check;
	bool file_size_check;
	bool save_exclude_path;
	bool ignore_minor_error;
	bool force;
	bool quiet;
	bool suppress_progress;
	bool verbose;
} Configuration;	

typedef struct {
	char *config_file;
	char *linear_exclude_path;
	char *trashbin_dir;
	bool list;
	bool nlist;
	bool simulate;
	bool inode_ctime_check;
	bool ignore_minor_error;
	bool force;
	bool quiet;
	bool suppress_progress;
	bool verbose;
} CommandLineOption;	

typedef struct {
	char *name;
	bool isdir;
	struct stat status;
} FileState;

typedef struct {
	char *path;
	int num_files;
	FileState *file_state;
} PathState;

typedef struct {
	int num_paths;
	PathState *path_state;
} FileData;


typedef struct {
	Action action;
	char *file;
	char *src_dir;
	char *dest_dir;
	bool isdir;
	struct stat status;
} Order;


/* definition/declaration of global variables */

GLOBAL Configuration config;
GLOBAL CommandLineOption command_line_option;


#undef GLOBAL
#undef GLOBAL_VAL
#endif /* VARIABLE_H_INCLUDED */
