/*****************************************************************
 *
 *   fonts.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"

gchar *font_name = NULL;
GtkFontSelectionDialog *fontsel;

void pass_fonts(GtkWidget *button, GtkWidget *entry)
{
	font_name = gtk_font_selection_dialog_get_font_name(fontsel);
	gtk_entry_set_text(GTK_ENTRY(entry),font_name);
	gtk_widget_destroy(GTK_WIDGET(fontsel));
}

void getFonts(GtkWidget *entry)
{
	GtkWidget *dialog;
	
	font_name = NULL;

	dialog = gtk_font_selection_dialog_new(_("Font Selector"));
	fontsel = GTK_FONT_SELECTION_DIALOG(dialog);

	gtk_signal_connect(GTK_OBJECT(fontsel->ok_button),"clicked",
			GTK_SIGNAL_FUNC(pass_fonts), entry);
	gtk_signal_connect_object(GTK_OBJECT(fontsel->cancel_button),"clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(fontsel));
	gtk_signal_connect_object(GTK_OBJECT(fontsel),"destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(fontsel));

	gtk_grab_add(dialog);
	gtk_widget_show(dialog);
	gtk_main();
}
