#!/bin/sh
# this requires GNU find to be used because of -printf feature
# you might want to change this to GNU find's full path:
FIND=find
FINDEXP="%P -- %l\n"
for dir in `ls -d test*` ; do $FIND $dir/ -printf "$FINDEXP" > out-$dir ; done
#
echo smartness-test
rm -rf test.tmp
cp -r test test.tmp
../convmv -f iso8859-15 -t utf8 --notest -r test.tmp
false
$FIND test.tmp -printf "$FINDEXP" > out.tmp
diff out-test out.tmp > diff.tmp|| { echo "smartness-test failed." ; exit 1; }
#
echo double-utf8 test
../convmv -f iso8859-15 -t utf8 --notest -r --nosmart test.tmp
$FIND test.tmp -printf "$FINDEXP" > out.tmp
diff out-test-utf8 out.tmp > diff.tmp|| { echo "double-utf8 test failed." ; exit 1; }
#
../convmv -f utf8 -t iso8859-15 --notest -r test.tmp
$FIND test.tmp -printf "$FINDEXP" > out.tmp
diff out-test out.tmp > diff.tmp|| { echo undo-double-utf8 test failed. ; exit 1; }
#
echo utf8-to-iso8859-15-test
rm -r test.tmp
cp -r test test.tmp
../convmv -f utf8 -t iso8859-15 --notest -r test.tmp
$FIND test.tmp -printf "$FINDEXP" > out.tmp
diff out-test-iso8859-15 out.tmp > diff.tmp|| { echo utf8-to-iso8859-15-test failed. ; exit 1; }
#
echo iso8859-15-to-utf8-test
rm -r test.tmp
cp -r test-iso8859-15 test.tmp
../convmv -f iso8859-15 -t utf8 --notest -r test.tmp
$FIND test.tmp -printf "$FINDEXP" > out.tmp
diff out-test out.tmp > diff.tmp|| { echo iso8859-15-to-utf8-test failed. ; exit 1; }
#
echo nfc-test
rm -r test.tmp
cp -r test test.tmp
../convmv -f utf-8 -t utf-8 --nfd --notest -r test.tmp
$FIND test.tmp -printf "$FINDEXP" > out.tmp
diff out-test-nfd out.tmp > diff.tmp|| { echo nfd-test failed. ; exit 1; }
#
../convmv -f utf8 -t utf8 --nfc --notest -r test.tmp
$FIND test.tmp -printf "$FINDEXP" > out.tmp
diff out-test out.tmp > diff.tmp|| { echo nfc-test failed. ; exit 1; }
#
echo escaped-test
rm -r test.tmp
cp -r test-escaped test.tmp
../convmv --unescape --notest -r test.tmp
$FIND test.tmp -printf "$FINDEXP" > out.tmp
diff out-test out.tmp > diff.tmp|| { echo escaped-test failed. ; exit 1; }
#
echo upper-test
rm -r test.tmp
cp -r test test.tmp
../convmv --upper -f utf8 --notest -r test.tmp
$FIND TEST.TMP -printf "$FINDEXP" > out.tmp
diff out-test-upper out.tmp > diff.tmp|| { echo upper-test failed. ; exit 1; }

echo All tests successful, cleaning up now ...
rm -rf TEST.TMP *.tmp out*
