/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.math3.ml.neuralnet;

import org.junit.Test;
import org.junit.Assert;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well44497b;

/**
 * Wraps a given initializer.
 */
public class OffsetFeatureInitializer
    implements FeatureInitializer {
    /** Wrapped initializer. */
    private final FeatureInitializer orig;
    /** Offset. */
    private int inc = 0;

    /**
     * Creates a new initializer whose {@link #value()} method
     * will return {@code orig.value() + offset}, where
     * {@code offset} is automatically incremented by one at
     * each call.
     *
     * @param orig Original initializer.
     */    
    public OffsetFeatureInitializer(FeatureInitializer orig) {
        this.orig = orig;
    }

    /** {@inheritDoc} */
    public double value() {
        return orig.value() + inc++;
    }
}
