/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *         building on original work by Thomas Nowotny <tnowotny@ucsd.edu>
 *
 * License: GPL-2+
 *
 * Initial version: 2009-03-31
 *
 * Synapse units: alpha-beta
 */


#ifndef LIBCN_BASE_SYNAPSE_H
#define LIBCN_BASE_SYNAPSE_H

#include <cmath>
#include <vector>
#include <list>
#include <map>
#include <algorithm>

#include "base-unit.hh"

#include "config.h"


using namespace std;
using namespace CNRun;



namespace CNRun {

class C_BaseSynapse;
class C_BaseNeuron;
class CModel;


typedef map<C_BaseSynapse*, double> SCleft;

class C_BaseSynapse
  : public C_BaseUnit {

    friend class CModel;
    friend class C_BaseNeuron;

    protected:
	C_BaseSynapse(); // not constructible without parameters

	C_BaseNeuron	*_source;
	list<C_BaseNeuron*>
			_targets;
	typedef list<C_BaseNeuron*>::iterator lni;
	typedef list<C_BaseNeuron*>::reverse_iterator lnri;
	typedef list<C_BaseNeuron*>::const_iterator lnci;
	bool has_target( const C_BaseNeuron *tgt) __attribute__ ((pure))
		{
			return find( _targets.begin(), _targets.end(), tgt) != _targets.end();
		}

	double t_last_release_started;

    public:
	C_BaseNeuron
		*source()	{  return _source;  }

	double g_on_target( const C_BaseNeuron &which) const;
	void set_g_on_target( C_BaseNeuron &which, double g);

	C_BaseSynapse *clone_to_target( C_BaseNeuron *nt, double g);
	C_BaseSynapse *make_clone_independent( C_BaseNeuron *target);

    protected:
	C_BaseSynapse( TUnitType intype,
		       C_BaseNeuron *insource, C_BaseNeuron *intarget,
		       double ing, CModel *inM, int s_mask = 0);
	virtual ~C_BaseSynapse();

    public:
	void reset_state()
		{
			C_BaseUnit::reset_state();
			t_last_release_started = -INFINITY;
		}

	virtual double Isyn( const C_BaseNeuron &with_neuron, double g) const = 0;
	virtual double Isyn( vector<double> &base, const C_BaseNeuron &with_neuron, double g) const = 0;
	// no gsyn known to the synapse: now C_BaseNeuron::SCleft knows it

	void dump( bool with_params = false, FILE *strm = stdout) const;

    private:
	virtual void update_queue()
		{}
};

}

#endif

// EOF
