
;;; When compiling this code produces a call to find-uses from the
;;; aref optimizer on a node with a :deleted continuation.

(eval-when (compile load eval)
  (unless (member :pcl *features*)
    (load "target:pcl/pclload")
    (gc :full t)))

(defmacro define-test (name arglist expected-result description &body body)
  (define-test-1 name arglist expected-result description body '*clos-speed-tests*))


(eval-when (compile load eval)
(defun define-test-1 (name arglist expected-result description body test-suite)
  (let ((setup (member '&body body)))
    (when setup
      (psetq setup (set-difference body setup)
	     body (rest setup)))
    (let ((lambda-list (mapcar #'first arglist))
	  (function-name (intern (format nil "~a-internal" name))))
      (macrolet ((if-metering-substrate (#+genera yes no)
		   #+genera `(if *use-metering-substrate* ,yes ,no)
		   #-genera no))
       (labels ((kludge-up (form)
		  (cond ((and (symbolp form) (not (constantp form)))
			 `(locally (declare (special ,form)) ,form))
			((and (consp form) (symbolp (first form))
			      (not (special-operator-p (first form)))
			      (not (macro-function (first form))))
			 (cons (first form) (mapcar #'kludge-up (rest form))))
			(t form))))
	`(progn
	   ,(if-metering-substrate
	     #+genera `(metering:define-metering-function ,function-name ,lambda-list
							  (:values t)
			 ,@body)
		      `(defun ,function-name (repeat ,@lambda-list)
			 (dotimes (n repeat)
			   (declare (ignore n))
			   (declare (fixnum n))
			   ,@body)))
	   (defun ,name ()
	     (let (,@(loop for (var val) in arglist
			   collect `(,var ,(kludge-up val))))
	       (format t "~2&~a:~%" ',description)
	       ,@setup
	       ,(unless (eq expected-result ':no-result-check)
		  `(assert-eql ,(if (cdr body) `(progn ,@body) (car body)) ,expected-result))
	       ,(if-metering-substrate
		 #+genera `(multiple-value-bind (average histogram)
			       (,function-name ,@lambda-list)
			     (dw:with-output-as-presentation (:object histogram
							      :type 'metering:metering-results)
			       (format t "~&takes ~2$ microseconds using metering substrate.~%"
				       (metering:average histogram)))
			     average)
			  `(time-function #',function-name ,@lambda-list))))
	   (define-test-2 ',name ',test-suite ',description)))))))
);eval-when

(defun define-test-2 (name test-suite description)
  (let ((list (list name description))
	(cons (member name (symbol-value test-suite) :key #'car)))
    (if cons
	(setf (car cons) list)
	(setf (symbol-value test-suite) (nconc (symbol-value test-suite) (cons list nil))))
    name))


(defclass point
	  ()
    ((x :initform 0 :accessor x :initarg :x)
     (y :initform 2 :accessor y :initarg :y)))


(define-test make-instance-1 ((x 1) (y 2)) :no-result-check
  "make-instance of a constant class with two slots and no initialization methods"
  (make-instance 'point :x x :y y))


(define-test meter-class-of-1 ((x p)) (find-class 'point)
  "class-of a standard-object"
  (class-of x))
