;;;
;;; Cross-compiler x86 to x86, allowing incompatible changes to the
;;; native code generation.
;;;
(load "target:code/exports")

(in-package "USER")

(load "setenv-common")
;;; Setup the path for the cross compiler.
(setf (ext:search-list "target:")
	   '(	"./x86-cross1/"      ; object dir
        	"./src/"))   ; source dir
(setf (ext:search-list "src:")
	"./src/"))

(load "target:tools/setup" :if-source-newer :load-source)
(comf "target:tools/setup" :load t)

(setf *interactive* nil)
(setf *gc-verbose* nil)

;;; Rename the X86 package and backend so that new-backend does the
;;; right thing.
(rename-package "X86" "OLD-X86")
(setf (c:backend-name c:*native-backend*) "OLD-X86")

;;; FreeBSD pure 18b cross compile.
#+nil
(c::new-backend "X86"
   '(:x86 :x86-bootstrap :new-assembler :gencgc :random-mt19937
     :hash-new :mp :i486 :bsd :FreeBSD :small 
;     :direct-syscall
     )
   '(:alpha :osf1 :sparc :mips :sunos :pentium :cgc :new-random
     :random-df :random-lfsr113 :random-acarry-skip :random-acarrypc
     :random-mt19937-ext))

;;; FreeBSD CMUCL current experimental source cross compile.
#+nil
(c::new-backend "X86"
   '(:x86 :x86-bootstrap :new-assembler :gencgc :random-mt19937
     :hash-new :long-float :mp :i486 :bsd :FreeBSD :direct-syscall)
   '(:alpha :osf1 :sparc :mips :sunos :pentium :cgc :new-random))

;;; FreeBSD to Linux cross compile.
#+nil
(c::new-backend "X86"
   '(:x86 :x86-bootstrap :new-assembler :gencgc :random-mt19937
     :hash-new :long-float :mp :i486 :linux :glibc2 :direct-syscall)
   '(:bsd :FreeBSD :cgc :pentium :random-df :random-lfsr113
     :random-acarry-skip :random-acarrypc))

;;; Linux to Linux
;#+nil
(c::new-backend "X86"
   '(:x86 :x86-bootstrap :new-assembler :gencgc :random-mt19937
     :hash-new :mp :i486 :linux :glibc2)
 :direct-syscall
   '(:alpha :osf1 :sparc :mips :sunos :pentium :cgc :new-random
     :random-df :random-lfsr113 :random-acarry-skip :random-acarrypc
     :random-mt19937-ext :long-float))

;;; Extern-alien-name for the new backend.
(in-package "VM")
(defun extern-alien-name (name)
  (declare (type simple-string name))
  name)
(export 'extern-alien-name)
(export 'fixup-code-object)
(export 'sanctify-for-execution)
(in-package "USER")

;;; Compile the new backend.
(pushnew :bootstrap *features*)
(load "target:tools/comcom")

;;; Load the new backend.
(setf (search-list "c:")
      '("target:compiler/"))
(setf (search-list "vm:")
      '("c:x86/" "c:generic/"))
(setf (search-list "assem:")
      '("target:assembly/" "target:assembly/x86/"))
;;; Note: may need to add extra files to load to loadbackend, perhaps
;;; float-tran and srctran; try to follow the order in comcom as this
;;; is often important.
(load "crabuild:cross-loadbackend")
(load "vm:new-genesis")

;;; OK, the cross compiler backend is loaded.

;;;; Setup the path for the new build.
(setf (ext:search-list "target:")
	   '(	"./x86-cross/"      ; object dir
        	"./src/"))   ; source dir

;;; Info environment hacks.
(macrolet ((frob (&rest syms)
	     `(progn ,@(mapcar #'(lambda (sym)
				   `(defconstant ,sym
				      (symbol-value
				       (find-symbol ,(symbol-name sym)
						    :vm))))
			       syms))))
  (frob OLD-X86:BYTE-BITS OLD-X86:WORD-BITS
	#+long-float OLD-X86:SIMPLE-ARRAY-LONG-FLOAT-TYPE 
	OLD-X86:SIMPLE-ARRAY-DOUBLE-FLOAT-TYPE 
	OLD-X86:SIMPLE-ARRAY-SINGLE-FLOAT-TYPE
	#+long-float OLD-X86:SIMPLE-ARRAY-COMPLEX-LONG-FLOAT-TYPE 
	OLD-X86:SIMPLE-ARRAY-COMPLEX-DOUBLE-FLOAT-TYPE 
	OLD-X86:SIMPLE-ARRAY-COMPLEX-SINGLE-FLOAT-TYPE
	OLD-X86:SIMPLE-ARRAY-UNSIGNED-BYTE-2-TYPE 
	OLD-X86:SIMPLE-ARRAY-UNSIGNED-BYTE-4-TYPE
	OLD-X86:SIMPLE-ARRAY-UNSIGNED-BYTE-8-TYPE 
	OLD-X86:SIMPLE-ARRAY-UNSIGNED-BYTE-16-TYPE 
	OLD-X86:SIMPLE-ARRAY-UNSIGNED-BYTE-32-TYPE 
	OLD-X86:SIMPLE-ARRAY-SIGNED-BYTE-8-TYPE 
	OLD-X86:SIMPLE-ARRAY-SIGNED-BYTE-16-TYPE
	OLD-X86:SIMPLE-ARRAY-SIGNED-BYTE-30-TYPE 
	OLD-X86:SIMPLE-ARRAY-SIGNED-BYTE-32-TYPE
	OLD-X86:SIMPLE-BIT-VECTOR-TYPE
	OLD-X86:SIMPLE-STRING-TYPE OLD-X86:SIMPLE-VECTOR-TYPE 
	OLD-X86:SIMPLE-ARRAY-TYPE OLD-X86:VECTOR-DATA-OFFSET))

(let ((function (symbol-function 'kernel:error-number-or-lose)))
  (let ((*info-environment* (c:backend-info-environment c:*target-backend*)))
    (setf (symbol-function 'kernel:error-number-or-lose) function)
    (setf (info function kind 'kernel:error-number-or-lose) :function)
    (setf (info function where-from 'kernel:error-number-or-lose) :defined)))

(defun fix-class (name)
  (let* ((new-value (find-class name))
	 (new-layout (kernel::class-layout new-value))
	 (new-cell (kernel::find-class-cell name))
	 (*info-environment* (c:backend-info-environment c:*target-backend*)))
    (remhash name kernel::*forward-referenced-layouts*)
    (kernel::%note-type-defined name)
    (setf (info type kind name) :instance)
    (setf (info type class name) new-cell)
    (setf (info type compiler-layout name) new-layout)
    new-value))
(fix-class 'c::vop-parse)
(fix-class 'c::operand-parse)

#+random-mt19937
(declaim (notinline kernel:random-chunk))

(setf c:*backend* c:*target-backend*)

;;; Ready to build.
(pushnew :bootstrap *features*)
(load "target:tools/worldcom")
(load "target:tools/comcom")

;;; If worldbuild produces a warning that "The C header file has
;;; changed." then it will be necessary to recompile the C code, and
;;; run worldload again.
(load "target:tools/worldbuild")
