package Language::INTERCAL::Interface;

# User interface for sick and intercalc

# This file is part of CLC-INTERCAL

# Copyright (c) 2006 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

use strict;

use Carp;

use vars qw($PERVERSION @EXPORT_OK);
$PERVERSION = "CLC-INTERCAL INTERCAL/Interface.pm 1.-94.-4";

@EXPORT_OK = qw(user_interface);

use Language::INTERCAL::Exporter '1.-94.-4';

sub user_interface {
    @_ >= 1 or croak "Usage: user_interface(PREFER, TRY_LIST)";
    my $prefer = shift;
    my $lasterr = "Could not load user interface";
    for my $name ($prefer || @_) {
	my $modname = "Language::INTERCAL::Interface::$name";
	eval "require $modname";
	if ($@) {
	    $lasterr = $@;
	    next;
	}
	my $obj = eval { $modname->new() };
	return $obj if $obj && ref $obj;
	$lasterr = $@ if $@;
    };
    $lasterr .= "\n" if $lasterr !~ /\n$/;
    die $lasterr;
}

1;

