/*
	$Id: cl_glabel.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include <API/GUI/cl_glabel.h>
#include <API/GUI/cl_gapplication.h>

CL_GLabel::CL_GLabel(CL_GWidget* parent, int x, int y, int w, int h, CL_Font *font) :
  CL_GWidget(parent, x, y , w, h),
  label_font(font),
  align(ALIGN_RIGHT)
{
	register_slot(cl_slot(CL_GLabel::set_text));

	if(label_font == 0)
		label_font = uapp->getButtonFont();
}

CL_GLabel::~CL_GLabel()
{
	deregister_slot(cl_slot(CL_GLabel::set_text));
}

void CL_GLabel::create()
{
	//debugN(17,cerr<<"CL_GLabel blitting text: \""<<labelText_<<"\""<<endl;);
	CL_GWidget::create(); //todo: why call this
/* lp
  USurface *text = labelFont_->getString(labelText_);

  if(fontPal_.size() != 0)
    text->setPalette(fontPal_);
*/
	if (!label_font) return;
	
	int text_width = label_font->get_text_width(label_text.c_str());
    int text_height = label_font->get_height();

    CL_SurfaceProvider *surf_prov = surface_->get_provider();
	CL_GRect dest;

	switch(align)
	{
		case ALIGN_CENTER:
			dest = CL_GRect((surf_prov->get_width()-text_width)/2,
				(surf_prov->get_height()-text_height)/2,
				text_width, text_height);
			
			break;
			
		case ALIGN_LEFT:
			dest = CL_GRect(0,
				(surf_prov->get_height()-text_height)/2,
				text_width, text_height);
			break;
			
		case ALIGN_RIGHT:
		 	dest = CL_GRect((surf_prov->get_width()-text_width),
				(surf_prov->get_height()-text_height)/2,
				text_width, text_height);
			break;
    }
/* lp
  text->blit(surface_, dest);
  delete text;
*/
	label_font->put_target(dest.upperLeft().x, dest.upperLeft().y, label_text.c_str(), surf_prov);
}


//SLOT_IMPL(CL_GLabel, setText, const char*)
void CL_GLabel::set_text(const char *data)
{
  cerr << "setText(" << data << ")" <<endl;
	label_text = std::string(data);
	needsUpdate_ = true;
}

/* lp
void CL_GLabel::setTextColor(const UColor& fontCol, const UColor& backCol)
{
  int rdiff = fontCol.r - backCol.r;
  int gdiff = fontCol.g - backCol.g;
  int bdiff = fontCol.b - backCol.b;
  
  int r = backCol.r;
  int g = backCol.g;
  int b = backCol.b;

  fontPal_.clear();
  fontPal_.push_back(UColor(0,0,0));

  for(unsigned char num=1; num < 5; num++)
    fontPal_.push_back(UColor(r + num * rdiff/4,
			      g + num * gdiff/4,
			      b + num * bdiff/4));
  
  needsUpdate_ = true;
}
*/






