/*
	$Id: sound.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <API/Core/Sound/sound.h>

std::list<CL_SoundCard*> CL_Sound::preload_cards;
std::vector<CL_SoundCard*> CL_Sound::cards;

void CL_Sound::clear_card_preload()
{
	CL_Sound::preload_cards.clear();
}

void CL_Sound::add_card_preload(CL_SoundCard *card)
{
	CL_Sound::preload_cards.push_front(card);
}

void CL_Sound::remove_card_preload(CL_SoundCard *card)
{
	CL_Sound::preload_cards.remove(card);
}

