
#ifdef USE_NETWORK

#ifndef header_network_generic
#define header_network_generic

#include <stdio.h>
#include <list>
#include <queue>
#include <string>

#include "API/Core/Network/network.h"
#include "API/Core/Network/netcomputer.h"
#include "API/Core/Network/netgroup.h"
#include "API/Core/Network/netgame.h"
#include "API/Core/Network/netmessage.h"
#include "API/Core/System/thread.h"
#include "API/Core/System/mutex.h"
#include "API/Core/System/cl_assert.h"
#include "API/Core/System/error.h"
#include "API/Core/System/keep_alive.h"

#include "Core/IOData/Generic/inputsource_memory_generic.h"
#include "Core/IOData/Generic/outputsource_memory_generic.h"

#include "network_delivery_impl.h"

class CL_NetGame_Generic;
class CL_IncomingGame;

class CL_Network_Generic : public CL_Network, CL_KeepAlive
{
public:
	CL_Network_Generic(CL_ConnectionProvider *provider);
	~CL_Network_Generic();

	void find_games_broadcast(
		std::string game_id,
		int port);
	void find_game_at(
		std::string game_id,
		const char *host_address,
		int port);
	bool peek_game_found();
	CL_NetGame *receive_game_found(int timeout_millis);
	void clear_games_found();
	CL_NetGame *create_game(std::string game_id, int port);

	CL_ConnectionProvider *provider;
	std::queue<CL_NetGame*> queue;
	std::list<CL_NetGame_Generic*> netgames;
	std::list<CL_IncomingGame*> incoming_netgames;

	static CL_Network_Generic *self;
	
	void keep_alive();
private:
	CL_UDPConnection *udp_connection;
};

class CL_IncomingGame
{
public:
	CL_Connection *connection;
	std::string game_id;
};

#endif

#endif
