/*
	ClanLib, the platform independent game SDK.
	This library is distributed under the GNU LIBRARY GENERAL PUBLIC
	LICENSE version 2. See COPYING for details. For a total list of
	contributers see CREDITS.

	$Id: datafile_writer.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

*/

#ifndef header_datafilewriter
#define header_datafilewriter

#define datafile_id "ClanSoft datafile version 3.0"

#ifdef __BEOS__
#include <gnu/zlib.h>
#else
#include <zlib.h> // Zlib compression library
#endif

#include "API/Core/System/clanstring.h"
#include "API/Core/IOData/outputsource.h"
#include "API/Core/IOData/outputsource_provider.h"

/*
class CL_Datafile_Write
{
protected:
	char *filename;

	int datafile;
	int index;
	int data;
	gzFile data_indexed;
	bool index_open;
	int num_indexes;

	void init_datafile();
	void finish_datafile();

	void copy_file(int dest, int source, long len);

	int cur_index_size;

public:
	CL_Datafile_Write(char *filename);
	virtual ~CL_Datafile_Write();

	void create_index(char *index);
	void write_data(void *data, int data_size);
	gzFile get_file_pointer();
};
*/

class DatafileIndex
{
public:
	CL_String name;
	int pos;
	int size;

	DatafileIndex(const char *_name, int _pos)
	{
		name = _name;
		pos = _pos;
		size = 0;
	}
};

class OutputSourceProvider_Datafile : public CL_OutputSourceProvider
{
protected:
	CL_String filename;
	int datafile_fd;

	std::list<DatafileIndex*> indexes;

public:
	OutputSourceProvider_Datafile(const char *filename);
	virtual ~OutputSourceProvider_Datafile();

	gzFile create_index(const char *index);
	void close_index(gzFile gz_fd, int size);

	virtual CL_OutputSource *open_source(const char *handle);
	virtual CL_OutputSourceProvider *clone();
};

class OutputSource_Datafile : public CL_OutputSource
{
protected:
	OutputSourceProvider_Datafile *provider;
	gzFile output_fd;
	int pos;

public:
	OutputSource_Datafile(const char *handle, OutputSourceProvider_Datafile *provider);
	virtual ~OutputSource_Datafile();

	virtual void set_system_mode();
	virtual void set_big_endian_mode();
	virtual void set_little_endian_mode();

	virtual void write_int32(int data);
	virtual void write_uint32(unsigned int data);

	virtual void write_short16(short data);
	virtual void write_ushort16(unsigned short data);

	virtual void write_char8(char data);
	virtual void write_uchar8(unsigned char data);

	virtual void write_float32(float data);

	virtual int write(const void *data, int size);

	virtual void open();
	virtual void close();

	virtual CL_OutputSource *clone();

	virtual int tell();
	virtual int size();

	virtual void write_string(const char *string);
};

#endif
