/*
	$Id: provider_magick.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="SurfaceProviders"

#ifndef header_MagickProvider
#define header_MagickProvider

#include "../core.h"

class CL_SetupMagick
{
public:
	static void init();
	static void deinit();
};

class CL_MagickProvider : public CL_SurfaceProvider_Generic
//: Surface provider that can nearly load any graphics file format.
{
public:
	static CL_Surface *create(
		std::string name,
		CL_InputSourceProvider *provider,
		EPixelFormat pixelformat = RGBA8888,
		bool use_transcol=false,
		int transcol=0);

	static CL_Surface *create(
		std::string name,
		CL_InputSourceProvider *provider,
		int red_mask,
		int green_mask,
		int blue_mask,
		int alpha_mask,
		bool use_transcol=false,
		int transcol=0);

	CL_MagickProvider(
		std::string name,
		CL_InputSourceProvider *provider,
		EPixelFormat pixelformat = RGBA8888,
		bool use_transcol=false,
		int transcol=0);

	CL_MagickProvider(
		std::string name,
		CL_InputSourceProvider *provider,
		int red_mask,
		int green_mask,
		int blue_mask,
		int alpha_mask,
		bool use_transcol=false,
		int transcol=0);

	virtual ~CL_MagickProvider();

	virtual unsigned int get_pitch() const;
	//: Returns the pitch of the image (bytes per line).

	virtual unsigned int get_width() const;
	//: Returns the width of the image.

	virtual unsigned int get_height() const;
	//: Returns the height of the image.

	virtual unsigned int get_num_frames() const;
	//: Returns the number of subsprites in the image.

	virtual unsigned int get_red_mask() const;
	//: Returns the red mask.
	
	virtual unsigned int get_green_mask() const;
	//: Returns the blue mask.
	
	virtual unsigned int get_blue_mask() const;
	//: Returns the green mask.
	
	virtual unsigned int get_alpha_mask() const;
	//: Returns the alpha mask.
	
	virtual CL_Palette *get_palette() const;
	//: Returns the palette used by the image. NULL if system palette.

	virtual unsigned int get_src_colorkey() const;
	//: Returns the transparency color used.

	virtual bool uses_src_colorkey() const;
	//: Returns whether src colorkeying is used.

	virtual bool is_indexed() const;
	//: Returns always false as the Magick Provider doesn't support PAL8 output
	
	virtual void *get_data() const;
	//: Returns the image data. Provider must be locked before pointer is valid.

	virtual void perform_lock();
	//: Locks the surface provider.

	virtual void perform_unlock();
	//: Unlocks the surface provider.

private:
	void init(
		std::string name,
		CL_InputSourceProvider *provider,
		int red_mask,
		int green_mask,
		int blue_mask,
		int alpha_mask,
		bool uses_transcol,
		int trans_col);

	CL_InputSourceProvider *provider;
	int pitch, height, width;
	unsigned int rmask, gmask, bmask, amask;
	int transcol;
	bool uses_transcol;
	std::string name;

	unsigned char *data;
};

#endif
