/*
	$Id: stream_soundprovider.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Sound"

#ifndef header_stream_soundprovider
#define header_stream_soundprovider

#include "soundformat.h"

class CL_StreamSoundProvider_Session;
class CL_StreamSoundProvider
//: Streamed soundprovider.
// Interface to streamed sound sources. Used by the CL_SoundBuffer class to
// start and stop playback.
{
public:
	virtual ~CL_StreamSoundProvider() { ; }

	virtual CL_StreamSoundProvider_Session *begin_session()=0;
	//: Called by CL_SoundBuffer when a new session starts.
	//!retval: The soundbuffer session to be attached to the newly
	//!retval: started session.

	virtual void end_session(CL_StreamSoundProvider_Session *session)=0;
	//: Called by CL_SoundBuffer when a session has finished. After this call,
	//: CL_SoundBuffer will not access the session anymore. It can safely be deleted
	//: here (and in most cases should be delete here).
};

class CL_StreamSoundProvider_Session
//: Streamed soundprovider playback session
// Interface used by ClanLib during playback of streamed soundbuffers.
{
public:
	virtual ~CL_StreamSoundProvider_Session() { ; }

	virtual bool eof() const =0;
	//: Returns true if no more input data is available.
	//!retval: True if end of input data. False otherwise.
	
	virtual void stop()=0;
	//: Stops the current stream.

	virtual bool play()=0;
	//: Start/continue playing of the stream.
	//!retval: True for success. False otherwise.
		
	virtual bool set_position(int pos)=0;
	//: Sets the position within the current stream.
	//!param: pos - Position to seek to.
	//!retval: True for success. False otherwise.
	
	virtual int get_data(void *data_ptr, int data_requested)=0;
	//: Called when a playback session needs more sample data.
	//!param: data_ptr - Points to a buffer that should be filled with
	//!param:            sample data.
	//!param: data_requested - Bytes of data requested.
	//!retval: Number of bytes actually filled with sample data.

	virtual int get_frequency() const =0;
	//: Returns the playback frequency of the input data.
	//!retval: Playback frequency.

	virtual SoundFormat get_format() const =0;
	//: Returns the playback sample format.
	//!retval: The playback Sample format.
};

#endif
