/*
	$Id: inputsource_provider.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="I/O Data"	

#ifndef header_inputsource_provider
#define header_inputsource_provider

class CL_InputSource;
class CL_InputSourceProvider
//: Interface that provide input sources.
// CL_InputSourceProvider is used to open inputsources. This can be from 
// datafile where the inputsource is an index - or it a directory where the
// files are the inputsources.
{
public:
	virtual ~CL_InputSourceProvider() { return; }

	static CL_InputSourceProvider *create_file_provider(const char *path);
	//: Creates a file provider. Input sources opened are considered as files.
	//!param: path - Path where the files are located.
	//!retval: The file input provider created.

	static CL_InputSourceProvider *create_datafile_provider(const char *filename);
	//: Creates a datafile provider. Input sources are opened as indexes in the
	//: specified datafile.
	//!param: filename - Name of the datafile to be used.
	//!retval: The datafile input provider created.

	virtual CL_InputSource *open_source(const char *handle)=0;
	//: Opens an inputsource using the passed handle.
	//!param: handle - handle/index/filename/identier to the input source requested.
	//!retval: The opened input source.

	virtual CL_InputSourceProvider *clone()=0;
	//: Returns a copy of the current provider.
	//!retval: The copy of the inputsource provider.
};

#endif
