/*
	$Id: palette.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Display 2D"

#ifndef header_palette
#define header_palette

class CL_InputSourceProvider;
class CL_InputSource;

class CL_Palette
//: Palette class.
// <p>CL_Palette represents a palette in the form of a 256 byte array.</p>
//
// <p>Palettes are in ClanLib only used by surface providers. A provider
// specifies it's palette by returning a CL_Palette. But It can also choose
// to return NULL. In that case it will use the system palette. You can
// change the system palette from CL_Display or CL_DisplayCard.</p>
//!also: CL_Display - The system palette is set here.
//!also: CL_DisplayCard - The card specific system palette is set here.
//!also: CL_SurfaceProvider - Palettelized surfaces use this class.
{
public:
	unsigned char *palette; // = new unsigned char[num_colors*3]
	//: The actual palette. 1 byte for each color component (rgb), 256 colors.

	int num_colors;
	//: Number of colours in the palette.

public:
	CL_Palette();
	//: Creates a palette.
	
	virtual ~CL_Palette();

	CL_Palette(unsigned char *palette, int num_colors=256);
	//: Creates a palette using values from an unsigned char array.
	//!param: palette - palette source.
	//!param: num_colors - number of palette colors.
	
	CL_Palette(char *palette_id, CL_InputSourceProvider *provider);
	//: Creates a palette from a input source.
	//!param: palette_id - ID used to get palette from provider.
	//!param: provider - Input source type (eg. a datafile or a normal file).

	CL_Palette(CL_InputSource *input);
	//: Creates a palette from an already open input source.
	//!param: input - Input source to read from.
};

#endif
