#include <ClanLib/core.h>
#include <fstream>

class ScreenShootApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "ScreenShoot application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupCore::init_display();
	}

	int save(std::string output_name, int x_min, int y_min, int x_max, int y_max)
	{

		int width   = x_max - x_min; 
		int height  = y_max - y_min;
		int max_val = 255;

		output_name += ".ppm";
				
		ofstream outfile(output_name.c_str());

		cout << endl << "ScreenShoot saved as " << output_name.c_str();

		
		//Write PPM P3 header
		outfile << "P3" << "\n";
		outfile << "# This file was created by ClanLib(www.clanlib.org)" << "\n";
		outfile << width << " " << height << "\n";
		outfile << max_val << "\n";

		//Write PPM P3 image
		unsigned int R=0,G=0,B=0,A=0;
		float r=0, g=0, b=0, a=0;

		short k=0;

		for (int x=x_min; x<x_max; x++)
		{
			for (int y=y_min; y<y_max; y++)

			{
				CL_Display::get_target()->get_pixel(x,y, &r, &g, &b, &a);

				R = (unsigned char)r * 255;
				G = (unsigned char)g * 255;
				B = (unsigned char)b * 255;


				outfile << R << " " << G << " " << B << " ";

				k++;
				
				if(k>=5) //(70/R+G+B+3)
				{
					//a line in a PPM ASCII file can't be longer than 70 ASCII charaters. 
					outfile << "\n";
					k=0;
				}
			}
			
		}
		outfile.close();
	
		return 1;
	}
	
	virtual void deinit_modules()
	{
		CL_SetupCore::deinit_display();
		CL_SetupCore::deinit();
	}

	virtual int main(int, char **)
	{
		try
		{
			// Set mode: 320x200 16 bpp
			CL_Display::set_videomode(320, 200, 16, false);

			cout << endl << "Press space to get a screenshoot";

			int number=0;
			std::string name="test";

			name += '1';//can some one help me? ;-)

		
			// Loop until the user hits escape:
			while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
			{
				CL_Display::clear_display();
				
				CL_Display::fill_rect(1,1,200,200,0.2f,0.2f,0.2f,1.0f);
				
				CL_Display::fill_rect(1,1,50,50,1.0f,0.0f,0.0f,1.0f);//red

				CL_Display::fill_rect(50,50,100,100,0.0f,1.0f,0.0f,1.0f);//green

				CL_Display::fill_rect(150,150,200,200,0.0f,0.0f,1.0f,1.0f);//blue

				

				CL_Display::flip_display();
				
			
				CL_System::keep_alive();

			
				if (CL_Keyboard::get_keycode(CL_KEY_SPACE) == true)
				{
					save(name.c_str(),0,0,200,200);
					number++;
					
					name += '1';//can some one help me? ;-)
				}



			}

		
		}
		catch (CL_Error err)
		{
			cout << "Error: " << err.message.c_str() << endl;
		}

		return 0;
	}
} app;
