/*
	NetDataObjects demonstration application.

	Copyright (c)1999 by Kenneth Gangstoe.
*/

#include "netdataobject.h"

NetDataObjectDemo app;

char *NetDataObjectDemo::get_title()
{
	return "NetDataObject Demo";
}

int NetDataObjectDemo::main(int argc, char **argv)
{
	if (argc < 2)
	{
		cout << "Syntax: netdataobject <server|client>" << endl << endl;
		return 0;
	}
	
	try
	{
		CL_System::init_network();

		if (CL_String(argv[1]) == "server") {
			create_game();
			run_server();
		}
		else if (CL_String(argv[1]) == "client") {
			join_game();
			run_client();
		}
		else
		{
			cout << "Syntax: netdataobject <server|client>" << endl << endl;
			return 0;
		}
	}
	catch (CL_Error err)
	{
		cout << "Error caught: " << err.message << endl;
	}

	return 1;
}

void NetDataObjectDemo::create_game()
{
	netgame = CL_Network::create_game("netdataobj", 2105);
}

void NetDataObjectDemo::join_game()
{
	CL_Network::find_game_at("netdataobj", "localhost", 2105);
	netgame = CL_Network::receive_game_found(0);
}

void NetDataObjectDemo::run_client()
{
	cout << "Initializing netdataobject controller" << endl;
	data_controller.init(netgame, DATA_CHANNEL, this);

	cout << "Beginning client loop" << endl;
	while(1)
	{
		// update netobject
		data_controller.update_client();

		if (CL_System::keep_alive()) break;
	}

	delete netgame;
}

void NetDataObjectDemo::run_server()
{
	cout << "Initializing netdataobject controller" << endl;
	data_controller.init(netgame, DATA_CHANNEL, this);

	cout << "Creating object on server" << endl;
	object=new Object(10000);
	
	cout << "Beginning server loop" << endl;
	while(1)
	{
		// check for joining computers - give access and send data
		const CL_NetComputer *computer = netgame->receive_computer_join();
		if (computer != NULL) {
			cout << "Computer joined - sending data" << endl;
			netgame->set_access(DATA_CHANNEL, computer, ACCESS_CHANNEL_READ);
			data_controller.send(computer, object, 0, OBJECT_DATA);
		}
		
		// update netobject
		data_controller.update_server();

		if (CL_System::keep_alive()) break;
	}

	delete netgame;
}

// Only called client-side
CL_NetObject *NetDataObjectDemo::create(int netobj_id, CL_InputSource *input)
{
	switch(netobj_id) {
	case OBJECT_DATA:
		cout << "Creating new object" << endl;
		CL_NetObject *object=new Object();
		return object;
	}

	cout << "Unknown netobject id: "<< netobj_id << endl;
	return NULL;
}

/***************************************************************************/

// Only called server-side
Object::Object(int new_size)
{
	size=new_size;
	init();
}

// Only called client-side
Object::Object()
{
	size=0;
}

void Object::init()
{
	data=new char[size];
}

// Only called server-side
// This function tells how much data is to be sent totally.
int Object::get_size()
{
	return size;
}

// Only called server-side
// This function serializes the first packet to be sent; put all initialization
// data here.
void Object::serialize_save(CL_OutputSource *output)
{
	output->write_int32(size);
}

// Only called server-side
// This function serializes the data itself. Care must be taken to serialize
// only stuff between [pos, pos+length]
void Object::serialize_save(CL_OutputSource *output, int pos, int length)
{
	output->write(data + pos, length);
}

// Only called client-side
void Object::serialize_load(CL_InputSource *input)
{
	size=input->read_int32();
	init();
}

// Only called client-side
void Object::serialize_load(CL_InputSource *input, int pos, int length)
{
	input->read(data + pos, length);
	if(pos + length == size)
		cout << "Data successfully received" << endl;
	else
		cout << "Receiving data: " << ((pos+length)*100 / size) << "% complete" << endl;
}