#include <ClanLib/core.h>
#include <ClanLib/gui.h>

class myApp : public CL_ClanApplication, public CL_GApplication
{
public:
virtual char *get_title() { return "GUI Test"; }

virtual ~myApp() {};

virtual void init_modules(){CL_SetupCore::init_display();}
virtual void deinit_modules(){CL_SetupCore::deinit_display();}
virtual int main(int argc, char **argv)
{
	init(320, 200, 16);
	exec();
	return 0;
}

virtual int startupProc(void)
{
	cout << "starting up..." <<endl;
	return 0;
}

virtual bool handleEvent(const CL_GEvent *event)
{
	bool handled = CL_GApplication::handleEvent(event);
	
	if (!handled)
	{
		switch (event->type())
		{
			case (CL_GEvent::KEY):
			{
				CL_GKeyEvent *e = (CL_GKeyEvent*)event;
				
				// ignore the RELEASED event
				if (e->get_state() == CL_GKeyEvent::PRESSED)
				{
				CL_Key k = e->get_key();
				cout << "key event: key = " << k.id << endl;
				if (k.id == CL_KEY_ESCAPE)
				{
					quit(0);
					handled = true;
				}
				}
			}
				break;
				
			case (CL_GEvent::MOUSEMOTION):
			{
				CL_GMouseMotionEvent *e = (CL_GMouseMotionEvent*)event;
				CL_GPoint pos = e->position();
				cout << "mouse event: x=" << pos.x << " y=" << pos.y << endl;
			}
				break;
			
			case (CL_GEvent::MOUSEBUTTON):
			{
				CL_GMouseButtonEvent *e = (CL_GMouseButtonEvent*)event;
				
				/* left button */
				if (e->buttons() & CL_GMouseButtonEvent::BUTTON_LEFT)
				{
					cout << "left button ";
				}
				/* right button */
				else if (e->buttons() & CL_GMouseButtonEvent::BUTTON_RIGHT)
				{
					cout << "right button ";
				}
				/* middle button */
				else if (e->buttons() & CL_GMouseButtonEvent::BUTTON_MIDDLE)
				{
					cout << "middle button ";
				}

				if (e->state() == CL_GMouseButtonEvent::PRESSED)
					cout << "pressed"<<endl;
				else
					cout << "released"<<endl;

				handled = true;
								
			}
				break;

			default: 
				break;
		} // end switch
	}
	
	return handled;
}

virtual int eventloopProc(void)
{
	// do your processing here...
	a++;
}

virtual int shutdownProc(void)
{
	cout << "shutting down..." <<endl;
	return 0;
}

private:
	int a;

} app;


