/*
        Font Example
*/

#include <ClanLib/core.h>

class MinimumApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "Font Example"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupCore::init_display();
	}

	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
	}
	
	virtual int main(int, char **)
	{
		try
		{
			CL_Display::set_videomode(320,200,16);
			// for the GLX target...
			CL_Display::clear_display();


			CL_ResourceManager* resources = CL_ResourceManager::create("font.dat", true);
			CL_Font* font = CL_Font::load("Fonts/fnt_clansoft", resources);

			CL_Display::fill_rect(160, 0, 319, 199, 1.0, 1.0, 1.0, 1.0);
			font->print_center(160, 80, "Hello World");

			CL_Display::flip_display();
			CL_System::sleep(2500);
		}
		catch (CL_Error err)
		{
			cout << "Exception caught: " << err.message.c_str() << endl;
			return -1;
		}
		return 0;
	}
} app;
