;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: log.lisp,v 1.6 2003/03/24 21:51:31 adam Exp $
;;;
;;; Copyright (c) 2000 - 2003 onShore Development, Inc.

;;; Calls to unix syslog(3) facility
;;; TODO: May be Linux specific, probably needs porting.

(in-package :odcl)

(defvar *syslog-state* nil)

(alien:def-alien-routine "openlog" c-call:void
  (ident c-call:c-string :in)
  (option c-call:int :in)
  (facility c-call:int :in))

(alien:def-alien-routine "syslog" c-call:void
  (priority c-call:int :in)
  (format c-call:c-string :in))

(alien:def-alien-routine "closelog" c-call:void)

(defvar *syslog-priority*
  '(:emerg :alert :crit :err :warning :notice :info :debug))

(defvar *syslog-facility*
  '((:kern . 0)
    (:user . 1)
    (:mail . 2)
    (:daemon . 3)
    (:auth . 4)
    (:syslog . 5)
    (:lpr . 6)
    (:news . 7)
    (:uucp . 8)
    (:cron . 9)
    (:authpriv . 10)
    (:ftp . 11)
    (:local0 . 16)
    (:local1 . 17)
    (:local2 . 18)
    (:local3 . 19)
    (:local4 . 20)
    (:local5 . 21)
    (:local6 . 22)
    (:local7 . 23)))

(defun get-syslog-facility (facility-name)
  (ash (or (get-alist facility-name *syslog-facility*)
           (error "invalid facility ~s" facility-name))
       3))

(defun ensure-syslog (name facility)
  (when (null *syslog-state*)
    (openlog name 0 (get-syslog-facility facility))
    (setf *syslog-state* (cons name facility))))

(defun write-syslog (name facility priority text)
  (ensure-syslog name facility)
  (syslog (or (position priority *syslog-priority*)
              (error "invalid priority"))
          text))

(defun testlog (prog  string)
  (write-syslog prog :local7 :info string))
