      SUBROUTINE USER_EVAL(XVAR,MODE)
      INCLUDE 'O8COMM.INC'
      INCLUDE 'O8FINT.INC'
      INCLUDE 'O8CONS.INC'
      INTEGER MODE
      DOUBLE PRECISION XVAR(*)
C
C**************************************
C     CALLED ONLY IF BLOC=.TRUE.
C     INTERFACE TO A USERS EVALUATION CODE OF FUNCTIONS
C     WHICH DEFINE THE OPTIMIZATION PROBLEM
C     MODE=-1 : EVALUATE FUNCTION VALUES AT XVAR ONLY, STORE THEM IN FU
C
C     MODE=0  : EVALUATE INEQUALITY CONSTRAINTS AND
C               EQUALITY CONSTRAINTS WITH GUNIT(1,.)=1 ONLY AT XVAR
C     MODE=1  : EVALUATE FUNCTION AND GRADIENT VALUES AT XVAR AND STORE THEM IN
C               FU AND FUGRAD
C
C     MODE=2  : EVALUATE GRADIENTS ONLY AT XVAR AND STORE THEM IN FUGRAD
C
C     THE USERS EVALUATION ROUTINE
C
C               EVAL_EXTERN(MODE)
C
C     IS CALLED WITH THREE SETINGS OF ITS MODE ONLY:
C     MODE=0: EVALUATE CONSTRAINTS WHICH DEPEND LINEARLY
C     ON ONE VARIABLE ONLY (GUNIT(1,I)=1).
C     MODE=1: SET FUNCTION VALUE
C     FU USING XTR, MODE=2 SET FUNCTION VALUES FU AND GRADIENTS FUGRAD USING
C     XTR
C     SINCE DONLP2 USES INTERNALLY A SCALED VALUE OF X, THE EXTERNAL VALUE XTR
C     IS OBTAINED BY MULTIPLYING WITH XSC. IN EVALUATING THE GRADIENTS,
C     THE USER MUST NOT TAKE CARE OF THIS SCALING. SCALING OF THE GRADIENTS
C     IS DONE BY DONLP2 INTERNALLY.
C
C     IF THE USER HAS SET ANALYT=TRUE, HE IS RESPONSIBLE FOR COMPUTING
C     THE GRADIENTS HIMSELF CORRECTLY
C     OTHERWISE, IF ANALYT=.FALSE., THEN THIS ROUTINE DOES NUMERICAL
C     DIFFERENTIATION ACCORDING TO THE METHOD DEFINED BY DIFFTYPE:
C
C     DIFFTYPE=1   ORDINARY FORWARD DIFFERENCE QUOTIENT, USING
C                  MIN(0.1*SQRT(EPSFCN),1.D-2) AS STEPSIZE
C                  EPSFCN IS THE ASSUMED PRECISION OF FUNCTION VALUES
C                  AND MUST BE SET BY THE USER IN SETUP0
C     DIFFTYPE=2   CENTRAL DIFFERENCE QUOTIENT WITH STEPSIZE
C                  MIN(0.1*EPSFCN**(2/3),1.D-2) AS STEPSIZE
C     DIFFTYPE=3   6-TH ORDER RICHARDSON EXTRAPOLATION METHOD USING
C                  6 FUNCTION VALUES FOR EACH COMPONENT OF GRAD,
C                  WITH STEPSIZE MIN(0.01*EPSFCN**(6/7),0.01)
C
C     THIS IS DONE BY SEVERAL CALLS OF EVAL_EXTERN
C     XTR IS THE CURRENT DESIGN TO BE USED BY THE EXTERNAL ROUTINE
C
C     VALUES MUST BE RETURNED IN THE ARRAYS FU (AND FUGRAD).
C      THE ORDER OF INFORMATION IS AS FOLLOWS:
C
C      FU(0)  OBJECTIVE FUNCTION VALUE
C      FUGRAD(I,0) : OBJECTIVE FUNCTION GRADIENT, I=1,...,N THE COMPONENTS
C
C      FU(1),...,FU(NH)  EQUALITY CONSTRAINTS (IF ANY)
C      FUGRAD(I,1),.., FUGRAD(I,NH) GRADIENTS OF EQUALITY CONSTRAINTS
C
C      FU(NH+1),...,FU(NG+NH) INEQUALITY CONSTRAINTS
C      FUGRAD(I,NH+1),...,FUGRAD(I,NH+NG) THE GRADIENTS OF THE INEQUALITY
C                   CONSTRAINTS, WTIH COMPONENT I=1,..,N
C      IF THERE ARE BOUND CONSTRAINTS OR FIXED VARIABLES AS DESCRIBED
C      BY THE ARRAY GUNIT IN SETUP0, THESE MUST BE EVALUATED HERE TOO.
C      THEIR GRADIENTS HOWEVER NEED NOT TO BE COMPUTED.
C
C      THE METHOD USES THE PARAMETERS
C
C           EPSFCN = RELATIVE ACCURACY OF FUNCTION VALUES
C           TAUBND = AMOUNT BY WHICH BOUND CONSTRAINTS MAY BE VIOLATED
C                    DURING FINITE DIFFERENCING
C           DIFFTYPE (SEE ABOVE)
C           ANALYT (SEE ABOVE)
C
C      THESE MUST BE SET PRIOR IN SETUP0
C****************************************************************
      DOUBLE PRECISION FUSAVE(0:NRESM),XHELP,XINCR,SD1,SD2,SD3,
     *  D1,D2,D3
      INTEGER I,J
      LOGICAL CHANGED
      IF ( MODE .LT. -1 .OR. MODE .GT. 2 )
     *   STOP 'DONLP2: CALL OF USER_EVAL WITH UNDEFINED MODE'
      IF ( MODE .EQ. 0 ) THEN
        DO I=1,N
          XTR(I)=XSC(I)*XVAR(I)
        ENDDO
        CALL EVAL_EXTERN(0)
        VALID=.TRUE.
      ENDIF
      IF ( MODE .EQ. -1 ) THEN
        CHANGED=.FALSE.
        DO I=1,N
          IF ( XTR(I) .NE. XSC(I)*XVAR(I) ) CHANGED=.TRUE.
        ENDDO
        IF ( CHANGED .OR. .NOT. VALID ) THEN
          DO I=1,N
            XTR(I)=XSC(I)*XVAR(I)
          ENDDO
          CALL EVAL_EXTERN(1)
          VALID=.TRUE.
        ENDIF
        RETURN
      ENDIF
      IF ( MODE .GE. 1 ) THEN
C******* EVALUATE FUNCTIONS AND ITS GRADIENTS
        DO I=1,N
          XTR(I)=XSC(I)*XVAR(I)
        ENDDO
C******* EVEN IF XTR DID NOT CHANGE WE MUST EVALUATE EXTERNALLY, SINCE NOW
C******* GRADIENTS ARE REQUIRED
        IF ( ANALYT ) THEN
          CALL EVAL_EXTERN(2)
          VALID=.TRUE.
          RETURN
        ELSE
          IF ( MODE .EQ. 1 ) CALL EVAL_EXTERN(1)
        ENDIF
C**** CONTINUE WITH COMPUTING THE GRADIENTS : MODE=1 OR MODE=2 REQUIRE GRADIENTS
        IF ( DIFFTYPE .EQ. 1 ) THEN
          DELDIF=MIN(TM1*SQRT(EPSFCN),TM2)
          IF ( MODE .EQ. 2 ) CALL EVAL_EXTERN(1)
          DO J=0,NRES
            FUSAVE(J)=FU(J)
          ENDDO
          DO I=1,N
            XHELP=XTR(I)
            XINCR=MIN(TM2,DELDIF*ABS(XHELP)+DELDIF,TAUBND)
            IF ( XHELP .GE. ZERO ) THEN
              XTR(I)=XHELP+XINCR
            ELSE
              XTR(I)=XHELP-XINCR
            ENDIF
            CALL EVAL_EXTERN(1)
            DO J=0,NRES
              FUGRAD(I,J)=(FU(J)-FUSAVE(J))/(XTR(I)-XHELP)
            ENDDO
            XTR(I)=XHELP
          ENDDO
          DO J=0,NRES
            FU(J)=FUSAVE(J)
          ENDDO
          VALID=.TRUE.
          RETURN
        ELSEIF ( DIFFTYPE .EQ. 2 ) THEN
          DELDIF=MIN(TM1*EPSFCN**(ONE/THREE),TM2)
          DO J=0,NRES
            FUSAVE(J)=FU(J)
          ENDDO
          DO I=1,N
            XHELP=XTR(I)
            XINCR=MIN(TM2,DELDIF*ABS(XHELP)+DELDIF,TAUBND)
            XTR(I)=XHELP+XINCR
            CALL EVAL_EXTERN(1)
            DO J=0,NRES
              FUD(J,1)=FU(J)
            ENDDO
            XTR(I)=XHELP-XINCR
            CALL EVAL_EXTERN(1)
            DO J=0,NRES
              FUD(J,2)=FU(J)
            ENDDO
            DO J=0,NRES
              FUGRAD(I,J)=(FUD(J,1)-FUD(J,2))/(XINCR+XINCR)
            ENDDO
            XTR(I)=XHELP
          ENDDO
          DO J=0,NRES
            FU(J)=FUSAVE(J)
          ENDDO
          VALID=.TRUE.
          RETURN
        ELSE
          DELDIF=MIN(TM1*EPSFCN**(ONE/SEVEN),TM2)
          DO J=0,NRES
            FUSAVE(J)=FU(J)
          ENDDO
          DO I=1,N
            XHELP=XTR(I)
            XINCR=MIN(TM2,DELDIF*ABS(XHELP)+DELDIF,TAUBND/FOUR)
            XTR(I)=XHELP-XINCR
            CALL EVAL_EXTERN(1)
            DO J=0,NRES
              FUD(J,1)=FU(J)
            ENDDO
            XTR(I)=XHELP+XINCR
            CALL EVAL_EXTERN(1)
            DO J=0,NRES
              FUD(J,2)=FU(J)
            ENDDO
            XINCR=XINCR+XINCR
            D1=XINCR
            XTR(I)=XHELP-XINCR
            CALL EVAL_EXTERN(1)
            DO J=0,NRES
              FUD(J,3)=FU(J)
            ENDDO
            XTR(I)=XHELP+XINCR
            CALL EVAL_EXTERN(1)
            DO J=0,NRES
              FUD(J,4)=FU(J)
            ENDDO
            XINCR=XINCR+XINCR
            D2=XINCR
            XTR(I)=XHELP-XINCR
            CALL EVAL_EXTERN(1)
            DO J=0,NRES
              FUD(J,5)=FU(J)
            ENDDO
            XTR(I)=XHELP+XINCR
            CALL EVAL_EXTERN(1)
            DO J=0,NRES
              FUD(J,6)=FU(J)
            ENDDO
            XTR(I)=XHELP
            D3=XINCR+XINCR
            DO J=0,NRES
              SD1=(FUD(J,2)-FUD(J,1))/D1
              SD2=(FUD(J,4)-FUD(J,3))/D2
              SD3=(FUD(J,6)-FUD(J,5))/D3
              SD3=SD2-SD3
              SD2=SD1-SD2
              SD3=SD2-SD3
              FUGRAD(I,J)=SD1+P4*SD2+SD3/C45
            ENDDO
          ENDDO
          DO J=0,NRES
            FU(J)=FUSAVE(J)
          ENDDO
          VALID=.TRUE.
          RETURN
        ENDIF
      ENDIF
      END
