<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Price/LineItem.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:b80ad6c535fb23d2a40fc36104895a79)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Price_DAO_LineItem extends CRM_Core_DAO {
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_line_item';
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Line Item
   *
   * @var int unsigned
   */
  public $id;
  /**
   * table which has the transaction
   *
   * @var string
   */
  public $entity_table;
  /**
   * entry in table
   *
   * @var int unsigned
   */
  public $entity_id;
  /**
   * FK to civicrm_contribution
   *
   * @var int unsigned
   */
  public $contribution_id;
  /**
   * FK to civicrm_price_field
   *
   * @var int unsigned
   */
  public $price_field_id;
  /**
   * descriptive label for item - from price_field_value.label
   *
   * @var string
   */
  public $label;
  /**
   * How many items ordered
   *
   * @var float
   */
  public $qty;
  /**
   * price of each item
   *
   * @var float
   */
  public $unit_price;
  /**
   * qty * unit_price
   *
   * @var float
   */
  public $line_total;
  /**
   * Participant count for field
   *
   * @var int unsigned
   */
  public $participant_count;
  /**
   * FK to civicrm_price_field_value
   *
   * @var int unsigned
   */
  public $price_field_value_id;
  /**
   * FK to Financial Type.
   *
   * @var int unsigned
   */
  public $financial_type_id;
  /**
   * Portion of total amount which is NOT tax deductible.
   *
   * @var float
   */
  public $non_deductible_amount;
  /**
   * tax of each item
   *
   * @var float
   */
  public $tax_amount;
  /**
   * class constructor
   *
   * @return civicrm_line_item
   */
  function __construct() {
    $this->__table = 'civicrm_line_item';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contribution_id', 'civicrm_contribution', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'price_field_id', 'civicrm_price_field', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'price_field_value_id', 'civicrm_price_field_value', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'financial_type_id', 'civicrm_financial_type', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Dynamic(self::getTableName() , 'entity_id', NULL, 'id', 'entity_table');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item ID') ,
          'description' => 'Line Item',
          'required' => true,
        ) ,
        'entity_table' => array(
          'name' => 'entity_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Line Item Entity Type') ,
          'description' => 'table which has the transaction',
          'required' => true,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
        ) ,
        'entity_id' => array(
          'name' => 'entity_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Entity') ,
          'description' => 'entry in table',
          'required' => true,
        ) ,
        'contribution_id' => array(
          'name' => 'contribution_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Contribution') ,
          'description' => 'FK to civicrm_contribution',
          'FKClassName' => 'CRM_Contribute_DAO_Contribution',
        ) ,
        'price_field_id' => array(
          'name' => 'price_field_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Price Field') ,
          'description' => 'FK to civicrm_price_field',
          'FKClassName' => 'CRM_Price_DAO_PriceField',
        ) ,
        'label' => array(
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Line Item Label') ,
          'description' => 'descriptive label for item - from price_field_value.label',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'default' => 'NULL',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'qty' => array(
          'name' => 'qty',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Line Item Quantity') ,
          'description' => 'How many items ordered',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'unit_price' => array(
          'name' => 'unit_price',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Unit Price') ,
          'description' => 'price of each item',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'line_total' => array(
          'name' => 'line_total',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Line Item Total') ,
          'description' => 'qty * unit_price',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
        ) ,
        'participant_count' => array(
          'name' => 'participant_count',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Participant Count') ,
          'description' => 'Participant count for field',
          'default' => 'NULL',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'price_field_value_id' => array(
          'name' => 'price_field_value_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Option') ,
          'description' => 'FK to civicrm_price_field_value',
          'default' => 'NULL',
          'FKClassName' => 'CRM_Price_DAO_PriceFieldValue',
        ) ,
        'financial_type_id' => array(
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Type') ,
          'description' => 'FK to Financial Type.',
          'default' => 'NULL',
          'FKClassName' => 'CRM_Financial_DAO_FinancialType',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'non_deductible_amount' => array(
          'name' => 'non_deductible_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Non-deductible Amount') ,
          'description' => 'Portion of total amount which is NOT tax deductible.',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'default' => '0.0',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'tax_amount' => array(
          'name' => 'tax_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Tax Amount') ,
          'description' => 'tax of each item',
          'precision' => array(
            20,
            2
          ) ,
          'import' => true,
          'where' => 'civicrm_line_item.tax_amount',
          'headerPattern' => '/tax(.?am(ou)?nt)?/i',
          'dataPattern' => '/^\d+(\.\d{2})?$/',
          'export' => true,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'line_item', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'line_item', $prefix, array());
    return $r;
  }
}
