#include "cp_types.h"
#include "cp_proto.h"

/* Return an edge path from start edge as described in datastr,
using either (flag=0) multiple-choice (default: for multi-sheeted
surfaces) or (flag=1) flower-increment next vertices. 

datastr describes path in terms of 'turns' in combinatoric direction.
First in list <v..> must be a neighbor of v1, then succession of
increments.  E.g., "path_c 23 57 2 4 0 3 3" will start with edge
<23,57>, then <57,x>, where in the flower for 57, <57,x> is "2" edges
counterclockwise from <57,23>, then "4" edges around x, then "0" (back
up), etc.  In a hex packing, "path_c 23 57 3 3 3 ..." defines a
combinatorial straight path. */

struct Vertlist *path_construct(struct p_data *p,int flag,char *datastr)
{
  int count=2,v1,v2,v,m,cur_vert,inc,dir;
  char *nextpoint,next[256];
  struct Vertlist *trace,*clobber,*final;

  stripsp(datastr);
  nextpoint=datastr;
  if (*datastr=='-')
    {
      grab_next(&nextpoint,next);
      if (next[1]=='i') flag=1;
    }
  if (!(v1=grab_one_vert(p,&nextpoint))) return NULL;
  final=trace=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  final->v=cur_vert=v1;
  clobber=trace;
  trace=trace->next=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  if (flag==0) /* multiple-choice; exit upon hitting illegal */
    {
      while ((v=grab_one_vert(p,&nextpoint)))
	if (nghb(p,cur_vert,v)>=0)
	  {
	    trace->v=v;
	    clobber=trace;
	    trace=trace->next=(struct Vertlist *)
	      calloc((size_t)1,sizeof(struct Vertlist));
	    cur_vert=v;
	    count++;
	  }
    }
  else if (flag==1 && (v2=grab_one_vert(p,&nextpoint))
      && (dir=nghb(p,v2,v1))>=0) /* incremental; exit upon illegal. */
    {
      trace->v=cur_vert=v2;
      clobber=trace;
      trace=trace->next=(struct Vertlist *)
	calloc((size_t)1,sizeof(struct Vertlist));
      while (grab_next(&nextpoint,next) && sscanf(next,"%d",&inc)
	   && inc>=0 && (!p->packK_ptr[cur_vert].bdry_flag
	   || (inc+dir)<=p->packK_ptr[cur_vert].num))
	{
	  m=(inc+dir)%(p->packK_ptr[cur_vert].num);
	  trace->v=p->packK_ptr[cur_vert].flower[m];
	  clobber=trace;
	  dir=nghb(p,trace->v,cur_vert);
	  cur_vert=trace->v;
	  trace=trace->next=(struct Vertlist *)
	    calloc((size_t)1,sizeof(struct Vertlist));
	  count++;
	}
    }
  else count=0;
  clobber->next=NULL;
  free(trace);
  return final;
} /* path_construct */
	  
