#include "cp_types.h"
#include "cp_proto.h"

/* like h_anglesum_overlap, but flag tells about incompatibilities: 
(routines need work)
  =0, no incompatibilities; 
  =1, rad too small for one or more faces;
  =2, rad too large for one or more faces;
  =3, mixed, too large for some, small for other(s)
incompat_err accumulates amounts of incompat as sum |cos(x)|-1. */

int h_as_overlap(struct p_data *p,int i,double s,double *c,
		 int *flag,double *incompat_err)
{
  int k,j2,j1,tmpflag;
  double s1,s2,o1,o2,o3,ang;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  *flag=0;
  *incompat_err=0.0;
  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  *c=0;
  if (s<=0) return 1; /* infinite radius at vertex of interest */
  j2=pK_ptr[i].flower[0];
  s2=pR_ptr[j2].rad;
  if (!p->overlap_status)
    for (k=1;k<=pK_ptr[i].num;k++)
      {
	s1=s2;
	s2=pR_ptr[pK_ptr[i].flower[k]].rad;
	*c+=acos(h_comp_cos(s,s1,s2));
      }
  else
    {
      o2=pK_ptr[i].overlaps[0];
      for (k=1;k<=pK_ptr[i].num;k++)
	{
	  s1=s2;
	  o1=o2;
	  j1=j2;
	  j2=pK_ptr[i].flower[k];
	  s2=pR_ptr[j2].rad;
	  o2=pK_ptr[i].overlaps[k];
	  o3=pK_ptr[j1].overlaps[nghb(p,j1,j2)];
	  tmpflag=0;
	  ang=h_cos_overlap_special(s,s1,s2,o3,o2,o1,&tmpflag,incompat_err);
	  if (tmpflag && ang==-1.0) /* too large */
	    {
	      if ((*flag)==0) *flag=2;
	      if ((*flag)==1) *flag=3;
	    }
	  else if (tmpflag && ang==1.0) /* too small */
	    {
	      if ((*flag)==0) *flag=1;
	      if ((*flag)==2) *flag=3;
	    }
	  *c += acos(ang);
	}
    }
  return 1;
} /* h_as_overlap */
