/*
 *  Copyright (C) 2010 Ji YongGang <jungleji@gmail.com>
 *
 *  ChmSee is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.

 *  ChmSee is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with ChmSee; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

/*
 * Copyright (C) 2004 Imendio AB
 * Copyright (C) 2004 Marco Pesenti Gritti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef __GECKO_UTILS_H__
#define __GECKO_UTILS_H__

#include <gtkmozembed.h>

G_BEGIN_DECLS

enum {
        GECKO_PREF_FONT_VARIABLE,
        GECKO_PREF_FONT_FIXED
};

gboolean gecko_utils_init(void);
void gecko_utils_shutdown(void);
gint gecko_utils_get_mouse_event_button(gpointer);
gint gecko_utils_get_mouse_event_modifiers(gpointer);
void gecko_utils_set_font(gint, const gchar *);
void gecko_utils_set_default_lang(gint);
void gecko_utils_select_all(GtkMozEmbed *);
gboolean gecko_utils_can_copy_selection(GtkMozEmbed *);
void gecko_utils_copy_selection(GtkMozEmbed *);
gfloat gecko_utils_get_zoom(GtkMozEmbed *);
void gecko_utils_set_zoom(GtkMozEmbed *, gfloat);
gboolean gecko_utils_find(GtkMozEmbed *, const gchar *, gboolean, gboolean);

G_END_DECLS

#endif /* __GECKO_UTILS_H__ */
