/* Generated from posixwin.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2010-05-11 12:52
   Version 4.4.0 
   linux-unix-gnu-x86 [ manyargs dload ptables ]
   compiled 2010-05-11 on galinha (Linux)
   command line: posixwin.scm -optimize-level 2 -include-path . -include-path ./ -inline -explicit-use -no-trace -output-file posixwin.c
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

/*
MinGW should have winsock2.h and ws2tcpip.h as well.
The CMake build will set HAVE_WINSOCK2_H and HAVE_WS2TCPIP_H.
However, the _MSC_VER test is still needed for vcbuild.bat.
./configure doesn't test for these.  It should, for MinGW.
*/
#if (_MSC_VER > 1300) || (defined(HAVE_WINSOCK2_H) && defined(HAVE_WS2TCPIP_H))
# include <winsock2.h>
# include <ws2tcpip.h>
#else
# include <winsock.h>
#endif

#include <signal.h>
#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <process.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <direct.h>
#include <utime.h>

#include <time.h>

#define ARG_MAX		256
#define PIPE_BUF	512
#ifndef ENV_MAX
# define ENV_MAX	1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS struct stat C_statbuf;

/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

/* platform information; initialized for cached testing */
static C_TLS char C_hostname[256] = "";
static C_TLS char C_osver[16] = "";
static C_TLS char C_osrel[16] = "";
static C_TLS char C_processor[16] = "";
static C_TLS char C_shlcmd[256] = "";

/* Windows NT or better */
static int C_isNT = 0;

/* Current user name */
static C_TLS TCHAR C_username[255 + 1] = "";

/* Directory Operations */

#define C_mkdir(str)	    C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)	    C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)	    C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR * C_fcall
opendir(const char *name)
{
    int name_len = strlen(name);
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(name_len + 3);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    strcpy(what, name);
    if (strchr("\\/", name[name_len - 1]))
	strcat(what, "*");
    else
	strcat(what, "\\*");

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}

static int C_fcall
closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}

static struct dirent * C_fcall
readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)		(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)	    (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)			     C_fix(_pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_getpid	    getpid
#define C_chmod(fn, m)	    C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)	    C_fix(fileno(C_port_file(p)))
#define C_dup(x)	    C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)	    C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)	    C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d, m)	    C_fix(_pipe(C_pipefds, PIPE_BUF, C_unfix(m)))
#define C_close(fd)	    C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_putenv(s)	    C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)	    C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)	    C_fix(fstat(C_unfix(f), &C_statbuf))

static C_word C_fcall
C_setenv(C_word x, C_word y)
{
    char *sx = C_data_pointer(x),
	 *sy = C_data_pointer(y);
    int n1 = C_strlen(sx),
	n2 = C_strlen(sy);
    char *buf = (char *)C_malloc(n1 + n2 + 2);
    if (buf == NULL)
	return(C_fix(0));
    else
    {
	C_strcpy(buf, sx);
	buf[ n1 ] = '=';
	C_strcpy(buf + n1 + 1, sy);
	return(C_fix(putenv(buf)));
    }
}

static void C_fcall
C_set_arg_string(char **where, int i, char *dat, int len)
{
    char *ptr;
    if (dat)
    {
	ptr = (char *)C_malloc(len + 1);
	C_memcpy(ptr, dat, len);
	ptr[ len ] = '\0';
    }
    else
	ptr = NULL;
    where[ i ] = ptr;
}

static void C_fcall
C_free_arg_string(char **where) {
  while (*where) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)

#define C_free_exec_args()		(C_free_arg_string(C_exec_args), C_SCHEME_TRUE)
#define C_free_exec_env()		(C_free_arg_string(C_exec_env), C_SCHEME_TRUE)

#define C_execvp(f)	    C_fix(execvp(C_data_pointer(f), (const char *const *)C_exec_args))
#define C_execve(f)	    C_fix(execve(C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args))
#define C_spawnvpe(m, f)    C_fix(spawnvpe(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)	    C_fix(mktemp(C_c_string(t)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)   C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_flushall()	    C_fix(_flushall())

#define C_ctime(n)	    (C_secs = (n), ctime(&C_secs))

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set(v) (C_tm_set_08(v), &C_tm)

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_a_mktime(ptr, c, v)  C_flonum(ptr, mktime(C_tm_set(v)))

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

/*
  mapping from Win32 error codes to errno
*/

typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;

static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,	  EINVAL},
    {ERROR_FILE_NOT_FOUND,	  ENOENT},
    {ERROR_PATH_NOT_FOUND,	  ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,	  EMFILE},
    {ERROR_ACCESS_DENIED,	  EACCES},
    {ERROR_INVALID_HANDLE,	  EBADF},
    {ERROR_ARENA_TRASHED,	  ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,	  ENOMEM},
    {ERROR_INVALID_BLOCK,	  ENOMEM},
    {ERROR_BAD_ENVIRONMENT,	  E2BIG},
    {ERROR_BAD_FORMAT,		  ENOEXEC},
    {ERROR_INVALID_ACCESS,	  EINVAL},
    {ERROR_INVALID_DATA,	  EINVAL},
    {ERROR_INVALID_DRIVE,	  ENOENT},
    {ERROR_CURRENT_DIRECTORY,	  EACCES},
    {ERROR_NOT_SAME_DEVICE,	  EXDEV},
    {ERROR_NO_MORE_FILES,	  ENOENT},
    {ERROR_LOCK_VIOLATION,	  EACCES},
    {ERROR_BAD_NETPATH,		  ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,	  ENOENT},
    {ERROR_FILE_EXISTS,		  EEXIST},
    {ERROR_CANNOT_MAKE,		  EACCES},
    {ERROR_FAIL_I24,		  EACCES},
    {ERROR_INVALID_PARAMETER,	  EINVAL},
    {ERROR_NO_PROC_SLOTS,	  EAGAIN},
    {ERROR_DRIVE_LOCKED,	  EACCES},
    {ERROR_BROKEN_PIPE,		  EPIPE},
    {ERROR_DISK_FULL,		  ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,	  EINVAL},
    {ERROR_WAIT_NO_CHILDREN,	  ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,	  ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,	  EINVAL},
    {ERROR_SEEK_ON_DEVICE,	  EACCES},
    {ERROR_DIR_NOT_EMPTY,	  ENOTEMPTY},
    {ERROR_NOT_LOCKED,		  EACCES},
    {ERROR_BAD_PATHNAME,	  ENOENT},
    {ERROR_MAX_THRDS_REACHED,	  EAGAIN},
    {ERROR_LOCK_FAILED,		  EACCES},
    {ERROR_ALREADY_EXISTS,	  EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,	  EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,	  ENOMEM},
    {0, 0}
};

static void C_fcall
set_errno(DWORD w32err)
{
    errmap_t *map = errmap;
    for (; errmap->win32; ++map)
    {
	if (errmap->win32 == w32err)
	{
	    errno = errmap->libc;
	    return;
	}
    }
}

static int C_fcall
set_last_errno()
{
    set_errno(GetLastError());
    return 0;
}

/* Functions for creating process with redirected I/O */

static int C_fcall
zero_handles()
{
    C_rd0 = C_wr0 = C_wr0_ = INVALID_HANDLE_VALUE;
    C_rd1 = C_wr1 = C_rd1_ = INVALID_HANDLE_VALUE;
    C_save0 = C_save1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
close_handles()
{
    if (C_rd0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd0);
    if (C_rd1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1);
    if (C_wr0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0);
    if (C_wr1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr1);
    if (C_rd1_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1_);
    if (C_wr0_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0_);
    if (C_save0 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	CloseHandle(C_save0);
    }
    if (C_save1 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	CloseHandle(C_save1);
    }
    return zero_handles();
}

static int C_fcall
redir_io()
{
    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = NULL;

    zero_handles();

    C_save0 = GetStdHandle(STD_INPUT_HANDLE);
    C_save1 = GetStdHandle(STD_OUTPUT_HANDLE);
    if (!CreatePipe(&C_rd0, &C_wr0, &sa, 0)
	    || !SetStdHandle(STD_INPUT_HANDLE, C_rd0)
	    || !DuplicateHandle(GetCurrentProcess(), C_wr0, GetCurrentProcess(),
		&C_wr0_, 0, FALSE, DUPLICATE_SAME_ACCESS)
	    || !CreatePipe(&C_rd1, &C_wr1, &sa, 0)
	    || !SetStdHandle(STD_OUTPUT_HANDLE, C_wr1)
	    || !DuplicateHandle(GetCurrentProcess(), C_rd1, GetCurrentProcess(),
		&C_rd1_, 0, FALSE, DUPLICATE_SAME_ACCESS))
    {
	set_last_errno();
	close_handles();
	return 0;
    }

    CloseHandle(C_wr0);
    C_wr0 = INVALID_HANDLE_VALUE;
    CloseHandle(C_rd1);
    C_rd1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
run_process(char *cmdline)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    ZeroMemory(&si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);

    C_wr0_ = C_rd1_ = INVALID_HANDLE_VALUE; /* these handles are saved */

    if (CreateProcess(NULL, cmdline, NULL, NULL, TRUE, 0, NULL,
		      NULL, &si, &pi))
    {
	CloseHandle(pi.hThread);

	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	C_save0 = C_save1 = INVALID_HANDLE_VALUE;

	CloseHandle(C_rd0);
	CloseHandle(C_wr1);
	C_rd0 = C_wr1 = INVALID_HANDLE_VALUE;
	return (int)pi.hProcess;
    }
    else
	return set_last_errno();
}

static int C_fcall
pipe_write(int hpipe, void* buf, int count)
{
    DWORD done = 0;
    if (WriteFile((HANDLE)hpipe, buf, count, &done, NULL))
	return 1;
    else
	return set_last_errno();
}

static int C_fcall
pipe_read(int hpipe)
{
    DWORD done = 0;
    /* TODO:
    if (!pipe_ready(hpipe))
	go_to_sleep;
    */
    if (ReadFile((HANDLE)hpipe, &C_rdbuf, 1, &done, NULL))
    {
	if (done > 0) /* not EOF yet */
	    return 1;
	else
	    return -1;
    }
    return set_last_errno();
}

static int C_fcall
pipe_ready(int hpipe)
{
    DWORD avail = 0;
    if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL) && avail)
	return 1;
    else
    {
	Sleep(0); /* give pipe a chance */
	if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL))
	    return (avail > 0);
	else
	    return 0;
    }
}

#define C_zero_handles() C_fix(zero_handles())
#define C_close_handles() C_fix(close_handles())
#define C_redir_io() (redir_io() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_run_process(cmdline) C_fix(run_process(C_c_string(cmdline)))
#define C_pipe_write(h, b, n) (pipe_write(C_unfix(h), C_c_string(b), C_unfix(n)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_pipe_read(h) C_fix(pipe_read(C_unfix(h)))
#define C_pipe_ready(h) (pipe_ready(C_unfix(h)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define close_handle(h) CloseHandle((HANDLE)h)

static int C_fcall
process_wait(int h, int t)
{
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    return set_last_errno();
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_SCHEME_UNDEFINED)

static int C_fcall
get_hostname()
{
    /* Do we already have hostname? */
    if (strlen(C_hostname))
    {
	return 1;
    }
    else
    {
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
	{
	    int nok = gethostname(C_hostname, sizeof(C_hostname));
	    WSACleanup();
	    return !nok;
	}
	return 0;
    }
}

static int C_fcall
sysinfo()
{
    /* Do we need to build the sysinfo? */
    if (!strlen(C_osrel))
    {
	OSVERSIONINFO ovf;
	ZeroMemory(&ovf, sizeof(ovf));
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (get_hostname() && GetVersionEx(&ovf))
	{
	    SYSTEM_INFO si;
	    _snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d",
			ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	    strncpy(C_osrel, "Win", sizeof(C_osrel) - 1);
	    switch (ovf.dwPlatformId)
	    {
	    case VER_PLATFORM_WIN32s:
		strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
		break;
	    case VER_PLATFORM_WIN32_WINDOWS:
		if (ovf.dwMajorVersion == 4)
		{
		    if (ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win95", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 10)
			strncpy(C_osrel, "Win98", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 90)
			strncpy(C_osrel, "WinMe", sizeof(C_osrel) - 1);
		}
		break;
	    case VER_PLATFORM_WIN32_NT:
		C_isNT = 1;
		if (ovf.dwMajorVersion == 6)
		    strncpy(C_osrel, "WinVista", sizeof(C_osrel) - 1);
		else if (ovf.dwMajorVersion == 5)
		{
		    if (ovf.dwMinorVersion == 2)
			strncpy(C_osrel, "WinServer2003", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 1)
			strncpy(C_osrel, "WinXP", sizeof(C_osrel) - 1);
		    else if ( ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win2000", sizeof(C_osrel) - 1);
		}
		else if (ovf.dwMajorVersion <= 4)
		   strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
		break;
	    }
	    GetSystemInfo(&si);
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    switch (si.wProcessorArchitecture)
	    {
	    case PROCESSOR_ARCHITECTURE_INTEL:
		strncpy(C_processor, "x86", sizeof(C_processor) - 1);
		break;
#	    ifdef PROCESSOR_ARCHITECTURE_IA64
	    case PROCESSOR_ARCHITECTURE_IA64:
		strncpy(C_processor, "IA64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_AMD64
	    case PROCESSOR_ARCHITECTURE_AMD64:
		strncpy(C_processor, "x64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_IA32_ON_WIN64
	    case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:
		strncpy(C_processor, "WOW64", sizeof(C_processor) - 1);
		break;
#	    endif
	    }
	}
	else
	    return set_last_errno();
    }
    return 1;
}

static int C_fcall
get_shlcmd()
{
    /* Do we need to build the shell command pathname? */
    if (!strlen(C_shlcmd))
    {
	if (sysinfo())
	{
	    char *cmdnam = C_isNT ? "\\cmd.exe" : "\\command.com";
	    UINT len = GetSystemDirectory(C_shlcmd, sizeof(C_shlcmd) - strlen(cmdnam));
	    if (len)
		strcpy(C_shlcmd + len, cmdnam);
	    else
		return set_last_errno();
	}
	else
	    return 0;
    }
    return 1;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_get_shlcmd() (get_shlcmd() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* GetUserName */

static int C_fcall
get_user_name()
{
    if (!strlen(C_username))
    {
	DWORD bufCharCount = sizeof(C_username) / sizeof(C_username[0]);
	if (!GetUserName(C_username, &bufCharCount))
	    return set_last_errno();
    }
    return 1;
}

#define C_get_user_name() (get_user_name() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* User Information */

#if 0
static int C_fcall
get_netinfo()
{
    HINSTANCE hNet = 0,
	      hLoc = 0;

    if (isNT)
	hNet = LoadLibrary("netapi32.dll");
    else
    {
	hLoc = LoadLibrary("rlocal32.dll");
	hNet = LoadLibrary("radmin32.dll");
	//hNet = LoadLibrary("netapi.dll");
    }

    if (!hNet)
	return 0;

    
}
#endif

/*
    Spawn a process directly.
    Params:
    app		Command to execute.
    cmdlin	Command line (arguments).
    env		Environment for the new process (may be NULL).
    handle, stdin, stdout, stderr
		Spawned process info are returned in integers.
		When spawned process shares standard io stream with the parent
		process the respective value in handle, stdin, stdout, stderr
		is -1.
    params	A bitmask controling operation.
		Bit 1: Child & parent share standard input if this bit is set.
		Bit 2: Share standard output if bit is set.
		Bit 3: Share standard error if bit is set.

    Returns: zero return value indicates failure.
*/
static int C_fcall
C_process(const char * app, const char * cmdlin, const char ** env,
	  int * phandle,
	  int * pstdin_fd, int * pstdout_fd, int * pstderr_fd,
	  int params)
{
    int i;
    int success = TRUE;
    const int f_share_io[3] = { params & 1, params & 2, params & 4};
    int io_fds[3] = { -1, -1, -1 };
    HANDLE
	child_io_handles[3] = { NULL, NULL, NULL },
	standard_io_handles[3] = {
	    GetStdHandle(STD_INPUT_HANDLE),
	    GetStdHandle(STD_OUTPUT_HANDLE),
	    GetStdHandle(STD_ERROR_HANDLE)};
    const char modes[3] = "rww";
    HANDLE cur_process = GetCurrentProcess(), child_process = NULL;
    void* envblk = NULL;

    /****** create io handles & fds ***/

    for (i=0; i<3 && success; ++i)
    {
	if (f_share_io[i])
	{
	    success = DuplicateHandle(
		cur_process, standard_io_handles[i],
		cur_process, &child_io_handles[i],
		0, FALSE, DUPLICATE_SAME_ACCESS);
	}
	else
	{
	    HANDLE a, b;
	    success = CreatePipe(&a,&b,NULL,0);
	    if(success)
	    {
		HANDLE parent_end;
		if (modes[i]=='r') { child_io_handles[i]=a; parent_end=b; }
		else		   { parent_end=a; child_io_handles[i]=b; }
		success = (io_fds[i] = _open_osfhandle((long)parent_end,0)) >= 0;
	    }
	}
    }

    /****** make handles inheritable */

    for (i=0; i<3 && success; ++i)
	success = SetHandleInformation(child_io_handles[i], HANDLE_FLAG_INHERIT, -1);

#if 0 /* Requires a sorted list by key! */
    /****** create environment block if necessary ****/

    if (env && success)
    {
	char** p;
	int len = 0;

	for (p = env; *p; ++p) len += strlen(*p) + 1;

	if (envblk = C_malloc(len + 1))
	{
	    char* pb = (char*)envblk;
	    for (p = env; *p; ++p)
	    {
		strcpy(pb, *p);
		pb += strlen(*p) + 1;
	    }
	    *pb = '\0';
	}
	else
	    success = FALSE;
    }
#endif

    /****** finally spawn process ****/

    if (success)
    {
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&pi,sizeof pi);
	ZeroMemory(&si,sizeof si);
	si.cb = sizeof si;
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = child_io_handles[0];
	si.hStdOutput = child_io_handles[1];
	si.hStdError = child_io_handles[2];

	/* FIXME passing 'app' param causes failure & possible stack corruption */
	success = CreateProcess(
	    NULL, (char*)cmdlin, NULL, NULL, TRUE, 0, envblk, NULL, &si, &pi);

	if (success)
	{
	    child_process=pi.hProcess;
	    CloseHandle(pi.hThread);
	}
	else
	    set_last_errno();
    }
    else
	set_last_errno();

    /****** cleanup & return *********/

    /* parent must close child end */
    for (i=0; i<3; ++i) CloseHandle(child_io_handles[i]);

    if (success)
    {
	*phandle = (int)child_process;
	*pstdin_fd = io_fds[0];
	*pstdout_fd = io_fds[1];
	*pstderr_fd = io_fds[2];
    }
    else
    {
	for (i=0; i<3; ++i) _close(io_fds[i]);
    }

    return success;
}

static int set_file_mtime(char *filename, C_word tm)
{
  struct _utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return _utime(filename, &tb);
}

static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[398];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,49,54,32,108,111,99,49,55,32,109,115,103,49,56,32,46,32,97,114,103,115,49,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,50,50,32,102,108,97,103,115,50,51,32,46,32,109,111,100,101,50,52,41,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,99,108,111,115,101,32,102,100,51,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,114,101,97,100,32,102,100,52,48,32,115,105,122,101,52,49,32,46,32,98,117,102,102,101,114,52,50,41,0,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,119,114,105,116,101,32,102,100,53,54,32,98,117,102,102,101,114,53,55,32,46,32,115,105,122,101,53,56,41,0,0,0,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,55,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,52,41,0,0,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,115,116,97,116,32,102,49,48,50,32,46,32,116,109,112,49,48,49,49,48,51,41,0,0,0,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,49,50,41};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,51,52,41,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,51,55,41,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,52,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,52,51,41,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,24),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,110,97,109,101,49,52,54,41};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,25),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,110,97,109,101,49,53,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,20),40,102,54,54,52,49,32,102,110,97,109,101,49,53,54,54,54,52,48,41,0,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,20),40,102,54,54,51,53,32,102,110,97,109,101,49,53,54,54,54,51,52,41,0,0,0,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,20),40,102,54,54,50,57,32,102,110,97,109,101,49,53,54,54,54,50,56,41,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,20),40,102,54,54,50,51,32,102,110,97,109,101,49,53,54,54,54,50,50,41,0,0,0,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,49,54,49,32,112,111,115,49,54,50,32,46,32,119,104,101,110,99,101,49,54,51,41,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,11),40,103,50,50,52,32,120,50,50,54,41,0,0,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,50,49,55,32,103,50,50,49,50,50,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,48,49,32,46,32,116,109,112,50,48,48,50,48,50,41,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,53,53,41,0,0,0,0,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,26),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,54,50,41,0,0,0,0,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,35),40,98,111,100,121,50,56,52,32,115,112,101,99,50,57,51,32,115,104,111,119,45,100,111,116,102,105,108,101,115,63,50,57,52,41,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,35),40,100,101,102,45,115,104,111,119,45,100,111,116,102,105,108,101,115,63,50,56,55,32,37,115,112,101,99,50,56,50,51,50,55,41,0,0,0,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,115,112,101,99,50,56,54,41,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,55,55,50,55,56,41,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,21),40,100,105,114,101,99,116,111,114,121,63,32,102,110,97,109,101,51,51,52,41,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,51,52,53,51,52,54,41,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,7),40,97,50,56,51,49,41,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,19),40,97,50,56,50,53,32,101,120,118,97,114,51,57,50,52,48,53,41,0,0,0,0,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,7),40,97,50,56,52,57,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,7),40,97,50,56,54,49,41,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,20),40,97,50,56,53,53,32,46,32,97,114,103,115,52,48,48,52,49,54,41,0,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,7),40,97,50,56,52,51,41,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,15),40,97,50,56,49,57,32,107,51,57,57,52,48,52,41,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,5),40,99,119,100,41,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,52,51,56,32,114,52,51,57,41};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,24),40,99,97,110,111,110,105,99,97,108,45,112,97,116,104,32,112,97,116,104,52,49,55,41};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,26),40,99,104,101,99,107,32,99,109,100,52,52,55,32,105,110,112,52,52,56,32,114,52,52,57,41,0,0,0,0,0,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,52,53,51,32,46,32,109,52,53,52,41,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,52,54,50,32,46,32,109,52,54,51,41};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,52,55,49,41,0,0,0,0,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,7),40,97,51,51,53,57,41,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,20),40,97,51,51,54,53,32,46,32,114,101,115,117,108,116,115,52,57,49,41,0,0,0,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,52,56,55,32,112,114,111,99,52,56,56,32,46,32,109,111,100,101,52,56,57,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,51,51,56,51,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,20),40,97,51,51,56,57,32,46,32,114,101,115,117,108,116,115,52,57,55,41,0,0,0,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,52,57,51,32,112,114,111,99,52,57,52,32,46,32,109,111,100,101,52,57,53,41};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,20),40,97,51,52,48,56,32,46,32,114,101,115,117,108,116,115,53,48,52,41,0,0,0,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,52,57,57,32,116,104,117,110,107,53,48,48,32,46,32,109,111,100,101,53,48,49,41};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,20),40,97,51,52,50,56,32,46,32,114,101,115,117,108,116,115,53,49,51,41,0,0,0,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,53,48,56,32,116,104,117,110,107,53,48,57,32,46,32,109,111,100,101,53,49,48,41,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,112,105,112,101,32,46,32,116,109,112,53,50,53,53,50,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,104,97,110,100,108,101,114,32,115,105,103,53,51,56,41,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,53,52,48,32,112,114,111,99,53,52,49,41,0,0,0,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,53,52,54,32,115,116,97,116,101,53,52,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,32),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,53,53,50,32,109,53,53,51,41};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,53,54,48,32,97,99,99,53,54,49,32,108,111,99,53,54,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,53,54,56,41,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,53,54,57,41};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,53,55,48,41,0,0,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,18),40,109,111,100,101,32,105,110,112,53,55,54,32,109,53,55,55,41,0,0,0,0,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,25),40,99,104,101,99,107,32,102,100,53,57,48,32,105,110,112,53,57,49,32,114,53,57,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,53,57,54,32,46,32,109,53,57,55,41,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,53,57,57,32,46,32,109,54,48,48,41};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,54,48,53,41,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,54,49,50,32,46,32,110,101,119,54,49,51,41,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,22),40,115,101,116,101,110,118,32,118,97,114,54,50,50,32,118,97,108,54,50,51,41,0,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,17),40,117,110,115,101,116,101,110,118,32,118,97,114,54,50,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,11),40,115,99,97,110,32,106,54,52,50,41,0,0,0,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,54,51,57,41,0,0,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,54,52,54,32,116,109,54,52,55,41};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,54,53,55,54,53,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,54,55,49,54,55,50,41,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,54,57,48,54,57,49,41,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,32),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,55,49,56,32,46,32,116,109,112,55,49,55,55,49,57,41};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,55,51,52,41,0,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,17),40,95,101,120,105,116,32,46,32,99,111,100,101,55,52,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,55,52,55,41};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,23),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,55,53,51,41,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,55,53,52,32,109,111,100,101,55,53,53,32,46,32,115,105,122,101,55,53,54,41,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,7),40,97,52,50,57,55,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,11),40,103,56,49,48,32,109,56,49,50,41,0,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,56,48,49,41,0,0,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,46),40,97,52,51,48,51,32,100,105,114,55,56,48,55,56,49,55,56,54,32,102,105,108,55,56,50,55,56,51,55,56,55,32,101,120,116,55,56,52,55,56,53,55,56,56,41,0,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,55,55,54,41,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,55,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,56,51,48,41,0,0,0,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,21),40,110,101,101,100,115,45,113,117,111,116,105,110,103,63,32,115,56,50,55,41,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,22),40,108,111,111,112,32,105,108,115,116,56,51,57,32,111,108,115,116,56,52,48,41,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,35),40,36,113,117,111,116,101,45,97,114,103,115,45,108,105,115,116,32,108,115,116,56,50,52,32,101,120,97,99,116,102,56,50,53,41,0,0,0,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,32),40,115,101,116,97,114,103,32,97,56,52,57,56,53,51,32,97,56,52,56,56,53,52,32,97,56,52,55,56,53,53,41};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,32),40,115,101,116,101,110,118,32,97,56,53,57,56,54,51,32,97,56,53,56,56,54,52,32,97,56,53,55,56,54,53,41};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,21),40,100,111,108,111,111,112,56,55,49,32,108,56,55,53,32,105,56,55,54,41,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,57),40,98,117,105,108,100,45,101,120,101,99,45,97,114,103,118,101,99,32,108,111,99,56,54,55,32,108,115,116,56,54,56,32,97,114,103,118,101,99,45,115,101,116,116,101,114,56,54,57,32,105,100,120,56,55,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,62),40,36,101,120,101,99,45,115,101,116,117,112,32,108,111,99,56,56,50,32,102,105,108,101,110,97,109,101,56,56,51,32,97,114,103,108,115,116,56,56,52,32,101,110,118,108,115,116,56,56,53,32,101,120,97,99,116,102,56,56,54,41,0,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,49),40,36,101,120,101,99,45,116,101,97,114,100,111,119,110,32,108,111,99,56,57,54,32,109,115,103,56,57,55,32,102,105,108,101,110,97,109,101,56,57,56,32,114,101,115,56,57,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,39),40,98,111,100,121,57,49,56,32,97,114,103,108,115,116,57,50,56,32,101,110,118,108,115,116,57,50,57,32,101,120,97,99,116,102,57,51,48,41,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,57,50,50,32,37,97,114,103,108,115,116,57,49,53,57,51,51,32,37,101,110,118,108,115,116,57,49,54,57,51,52,41,0,0,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,29),40,100,101,102,45,101,110,118,108,115,116,57,50,49,32,37,97,114,103,108,115,116,57,49,53,57,51,54,41,0,0,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,15),40,100,101,102,45,97,114,103,108,115,116,57,50,48,41,0};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,41),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,57,49,48,32,46,32,116,109,112,57,48,57,57,49,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,39),40,98,111,100,121,57,54,48,32,97,114,103,108,115,116,57,55,48,32,101,110,118,108,115,116,57,55,49,32,101,120,97,99,116,102,57,55,50,41,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,57,54,52,32,37,97,114,103,108,115,116,57,53,55,57,55,53,32,37,101,110,118,108,115,116,57,53,56,57,55,54,41,0,0,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,29),40,100,101,102,45,101,110,118,108,115,116,57,54,51,32,37,97,114,103,108,115,116,57,53,55,57,55,56,41,0,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,15),40,100,101,102,45,97,114,103,108,115,116,57,54,50,41,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,47),40,112,114,111,99,101,115,115,45,115,112,97,119,110,32,109,111,100,101,57,53,49,32,102,105,108,101,110,97,109,101,57,53,50,32,46,32,116,109,112,57,53,48,57,53,51,41,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,57,57,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,29),40,112,114,111,99,101,115,115,45,114,117,110,32,102,57,57,57,32,46,32,97,114,103,115,49,48,48,48,41,0,0,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,97),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,49,48,52,49,32,99,109,100,49,48,52,50,32,97,114,103,115,49,48,52,51,32,101,110,118,49,48,52,52,32,115,116,100,111,117,116,102,49,48,52,53,32,115,116,100,105,110,102,49,48,52,54,32,115,116,100,101,114,114,102,49,48,52,55,32,46,32,116,109,112,49,48,52,48,49,48,52,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,21),40,97,53,48,51,51,32,103,49,49,49,57,49,49,50,48,49,49,50,49,41,0,0,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,49,49,48,56,41,0,0,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,7),40,97,53,48,53,49,41,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,38),40,97,53,48,53,55,32,105,110,49,49,51,49,32,111,117,116,49,49,51,50,32,112,105,100,49,49,51,51,32,101,114,114,49,49,51,52,41,0,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,63),40,37,112,114,111,99,101,115,115,32,108,111,99,49,49,48,49,32,101,114,114,63,49,49,48,50,32,99,109,100,49,49,48,51,32,97,114,103,115,49,49,48,52,32,101,110,118,49,49,48,53,32,101,120,97,99,116,102,49,49,48,54,41,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,49,49,53,50,32,97,114,103,115,49,49,54,50,32,101,110,118,49,49,54,51,32,101,120,97,99,116,102,49,49,54,52,41,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,49,49,53,54,32,37,97,114,103,115,49,49,52,57,49,49,54,54,32,37,101,110,118,49,49,53,48,49,49,54,55,41,0,0,0,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,49,53,53,32,37,97,114,103,115,49,49,52,57,49,49,54,57,41,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,49,53,52,41,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,49,49,52,52,32,46,32,116,109,112,49,49,52,51,49,49,52,53,41,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,49,49,57,49,32,97,114,103,115,49,50,48,49,32,101,110,118,49,50,48,50,32,101,120,97,99,116,102,49,50,48,51,41,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,49,49,57,53,32,37,97,114,103,115,49,49,56,56,49,50,48,53,32,37,101,110,118,49,49,56,57,49,50,48,54,41,0,0,0,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,49,57,52,32,37,97,114,103,115,49,49,56,56,49,50,48,56,41,0,0,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,49,57,51,41,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,49,49,56,51,32,46,32,116,109,112,49,49,56,50,49,49,56,52,41};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,50,49,56,32,110,111,104,97,110,103,49,50,49,57,41,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,7),40,97,53,50,55,55,41,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,36),40,97,53,50,56,51,32,101,112,105,100,49,50,51,51,32,101,110,111,114,109,49,50,51,52,32,101,99,111,100,101,49,50,51,53,41,0,0,0,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,50,50,48,32,46,32,97,114,103,115,49,50,50,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,13),40,115,108,101,101,112,32,116,49,50,51,56,41,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,14),40,102,95,53,53,50,49,32,120,49,50,56,55,41,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,7),40,97,53,52,52,52,41,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,7),40,97,53,52,52,57,41,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,7),40,97,53,52,55,51,41,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,19),40,108,111,111,112,32,102,115,49,50,56,57,32,114,49,50,57,48,41,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,16),40,102,95,53,53,52,48,32,46,32,95,49,50,56,48,41};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,16),40,102,95,53,53,51,50,32,46,32,95,49,50,55,57,41};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,38),40,98,111,100,121,49,50,53,55,32,97,99,116,105,111,110,49,50,54,55,32,105,100,49,50,54,56,32,108,105,109,105,116,49,50,54,57,41,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,108,105,109,105,116,49,50,54,49,32,37,97,99,116,105,111,110,49,50,53,52,49,51,50,48,32,37,105,100,49,50,53,53,49,51,50,49,41,0,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,28),40,100,101,102,45,105,100,49,50,54,48,32,37,97,99,116,105,111,110,49,50,53,52,49,51,50,51,41,0,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,19),40,97,53,53,54,48,32,120,49,51,50,53,32,121,49,51,50,54,41,0,0,0,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,16),40,100,101,102,45,97,99,116,105,111,110,49,50,53,57,41};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,51),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,49,50,52,56,32,112,114,101,100,49,50,52,57,32,46,32,97,99,116,105,111,110,45,105,100,45,108,105,109,105,116,49,50,53,48,41,0,0,0,0,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,31),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,46,32,95,49,51,54,55,49,51,55,49,41,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,102,105,102,111,32,46,32,95,49,51,55,52,49,51,55,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,28),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,32,46,32,95,49,51,56,48,49,51,56,52,41,0,0,0,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,51,56,54,49,51,57,48,41,0,0,0,0,0,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,40),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,103,114,111,117,112,45,105,100,32,46,32,95,49,51,57,50,49,51,57,54,41};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,39),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,105,100,32,46,32,95,49,51,57,56,49,52,48,50,41,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,41),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,32,46,32,95,49,52,48,52,49,52,48,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,30),40,99,117,114,114,101,110,116,45,103,114,111,117,112,45,105,100,32,46,32,95,49,52,49,48,49,52,49,52,41,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,117,115,101,114,45,105,100,32,46,32,95,49,52,49,54,49,52,50,48,41,0,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,32),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,46,32,95,49,52,50,50,49,52,50,54,41};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,105,110,107,32,46,32,95,49,52,50,56,49,52,51,50,41,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,111,99,107,32,46,32,95,49,52,51,52,49,52,51,56,41,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,46,32,95,49,52,52,48,49,52,52,52,41};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,115,101,108,101,99,116,32,46,32,95,49,52,52,54,49,52,53,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,46,32,95,49,52,53,50,49,52,53,54,41,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,46,32,95,49,52,53,56,49,52,54,50,41,0,0,0,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,117,110,108,111,99,107,32,46,32,95,49,52,54,52,49,52,54,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,24),40,103,101,116,45,103,114,111,117,112,115,32,46,32,95,49,52,55,48,49,52,55,52,41};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,31),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,52,55,54,49,52,56,48,41,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,31),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,46,32,95,49,52,56,50,49,52,56,54,41,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,40),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,46,32,95,49,52,56,56,49,52,57,50,41};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,31),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,32,46,32,95,49,52,57,52,49,52,57,56,41,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,95,49,53,48,48,49,53,48,52,41,0,0,0,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,32,46,32,95,49,53,48,54,49,53,49,48,41,0,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,46,32,95,49,53,49,50,49,53,49,54,41,0,0,0,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,32),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,53,49,56,49,53,50,50,41};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,24),40,115,101,116,45,97,108,97,114,109,33,32,46,32,95,49,53,50,52,49,53,50,56,41};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,53,51,48,49,53,51,52,41,0,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,25),40,115,101,116,45,103,114,111,117,112,115,33,32,46,32,95,49,53,51,54,49,53,52,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,35),40,115,101,116,45,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,53,52,50,49,53,52,54,41,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,33),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,46,32,95,49,53,52,56,49,53,53,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,30),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,53,53,52,49,53,53,56,41,0,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,26),40,115,101,116,45,117,115,101,114,45,105,100,33,32,46,32,95,49,53,54,48,49,53,54,52,41,0,0,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,25),40,115,105,103,110,97,108,45,109,97,115,107,32,46,32,95,49,53,54,54,49,53,55,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,26),40,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,53,55,50,49,53,55,54,41,0,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,46,32,95,49,53,55,56,49,53,56,50,41,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,46,32,95,49,53,56,52,49,53,56,56,41,0,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,27),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,46,32,95,49,53,57,48,49,53,57,52,41,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,36),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,46,32,95,49,53,57,54,49,54,48,48,41,0,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,30),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,54,48,50,49,54,48,54,41,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,31),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,46,32,95,49,54,48,56,49,54,49,50,41,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,26),40,115,116,114,105,110,103,45,62,116,105,109,101,32,46,32,95,49,54,49,52,49,54,49,56,41,0,0,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,13),40,102,105,102,111,63,32,95,49,54,50,48,41,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,95,49,54,50,50,41,0,0,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,15),40,97,53,56,57,56,32,112,111,114,116,49,56,48,41,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,12),40,97,53,57,51,53,32,102,49,49,52,41,0,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,17),40,97,53,57,52,49,32,102,49,49,54,32,116,49,49,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k4872 */
static C_word C_fcall stub1011(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7) C_regparm;
C_regparm static C_word C_fcall stub1011(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
int *t3=(int *)C_c_pointer_or_null(C_a3);
int *t4=(int *)C_c_pointer_or_null(C_a4);
int *t5=(int *)C_c_pointer_or_null(C_a5);
int *t6=(int *)C_c_pointer_or_null(C_a6);
int t7=(int )C_unfix(C_a7);
C_r=C_mk_bool(C_process(t0,t1,t2,t3,t4,t5,t6,t7));
return C_r;}

/* from current-process-id in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static C_word C_fcall stub986(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub986(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from k4501 */
static C_word C_fcall stub860(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub860(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from k4484 */
static C_word C_fcall stub850(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub850(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k4165 */
static C_word C_fcall stub742(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub742(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub737(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub737(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char *z = (_daylight ? _tzname[1] : _tzname[0]);
return(z);
C_ret:
#undef return

return C_r;}

/* from strftime */
static C_word C_fcall stub707(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub707(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub701(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub701(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k4013 */
static C_word C_fcall stub681(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub681(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k3850 */
static C_word C_fcall stub634(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub634(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k5953 in k5976 in a5941 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static C_word C_fcall stub123(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub123(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k1900 */
static C_word C_fcall stub12(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub12(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1873)
static void C_ccall f_1873(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1876)
static void C_ccall f_1876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1879)
static void C_ccall f_1879(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1882)
static void C_ccall f_1882(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1885)
static void C_ccall f_1885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1888)
static void C_ccall f_1888(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1891)
static void C_ccall f_1891(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5942)
static void C_ccall f_5942(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5978)
static void C_ccall f_5978(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5955)
static void C_ccall f_5955(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5965)
static void C_fcall f_5965(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5936)
static void C_ccall f_5936(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5940)
static void C_ccall f_5940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2210)
static void C_ccall f_2210(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5899)
static void C_ccall f_5899(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5915)
static void C_ccall f_5915(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5903)
static void C_ccall f_5903(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5906)
static void C_ccall f_5906(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2348)
static void C_ccall f_2348(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3513)
static void C_ccall f_3513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5880)
static void C_ccall f_5880(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5877)
static void C_ccall f_5877(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5870)
static void C_ccall f_5870(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5864)
static void C_ccall f_5864(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5858)
static void C_ccall f_5858(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5852)
static void C_ccall f_5852(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5846)
static void C_ccall f_5846(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5840)
static void C_ccall f_5840(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5834)
static void C_ccall f_5834(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5828)
static void C_ccall f_5828(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5822)
static void C_ccall f_5822(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5816)
static void C_ccall f_5816(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5810)
static void C_ccall f_5810(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5804)
static void C_ccall f_5804(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5798)
static void C_ccall f_5798(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5792)
static void C_ccall f_5792(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5786)
static void C_ccall f_5786(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5780)
static void C_ccall f_5780(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5774)
static void C_ccall f_5774(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5768)
static void C_ccall f_5768(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5762)
static void C_ccall f_5762(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5756)
static void C_ccall f_5756(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5750)
static void C_ccall f_5750(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5744)
static void C_ccall f_5744(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5738)
static void C_ccall f_5738(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5732)
static void C_ccall f_5732(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5726)
static void C_ccall f_5726(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5720)
static void C_ccall f_5720(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5714)
static void C_ccall f_5714(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5708)
static void C_ccall f_5708(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5702)
static void C_ccall f_5702(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5696)
static void C_ccall f_5696(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5690)
static void C_ccall f_5690(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5684)
static void C_ccall f_5684(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5678)
static void C_ccall f_5678(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5672)
static void C_ccall f_5672(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5666)
static void C_ccall f_5666(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5660)
static void C_ccall f_5660(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5654)
static void C_ccall f_5654(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5648)
static void C_ccall f_5648(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5642)
static void C_ccall f_5642(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5636)
static void C_ccall f_5636(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5630)
static void C_ccall f_5630(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5624)
static void C_ccall f_5624(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5378)
static void C_ccall f_5378(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5378)
static void C_ccall f_5378r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5555)
static void C_fcall f_5555(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5561)
static void C_ccall f_5561(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5550)
static void C_fcall f_5550(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5545)
static void C_fcall f_5545(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5380)
static void C_fcall f_5380(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5532)
static void C_ccall f_5532(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5540)
static void C_ccall f_5540(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5387)
static void C_fcall f_5387(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5520)
static void C_ccall f_5520(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5514)
static void C_ccall f_5514(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5397)
static void C_ccall f_5397(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5399)
static void C_fcall f_5399(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5418)
static void C_ccall f_5418(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5500)
static void C_ccall f_5500(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5507)
static void C_ccall f_5507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5494)
static void C_ccall f_5494(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5433)
static void C_ccall f_5433(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5487)
static void C_ccall f_5487(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5484)
static void C_ccall f_5484(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5474)
static void C_ccall f_5474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5450)
static void C_ccall f_5450(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5472)
static void C_ccall f_5472(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5458)
static void C_ccall f_5458(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5465)
static void C_ccall f_5465(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5462)
static void C_ccall f_5462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5445)
static void C_ccall f_5445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5443)
static void C_ccall f_5443(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5521)
static void C_ccall f_5521(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5363)
static void C_ccall f_5363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5373)
static void C_ccall f_5373(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5332)
static void C_ccall f_5332(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5358)
static void C_ccall f_5358(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5343)
static void C_ccall f_5343(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5347)
static void C_ccall f_5347(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5351)
static void C_ccall f_5351(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5355)
static void C_ccall f_5355(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5320)
static void C_ccall f_5320(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5317)
static void C_ccall f_5317(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5257)
static void C_ccall f_5257(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5257)
static void C_ccall f_5257r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5284)
static void C_ccall f_5284(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5294)
static void C_ccall f_5294(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5278)
static void C_ccall f_5278(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5245)
static void C_ccall f_5245(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5165)
static void C_ccall f_5165(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5165)
static void C_ccall f_5165r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5182)
static void C_fcall f_5182(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5177)
static void C_fcall f_5177(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5172)
static void C_fcall f_5172(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5167)
static void C_fcall f_5167(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5085)
static void C_ccall f_5085(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5085)
static void C_ccall f_5085r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5102)
static void C_fcall f_5102(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5097)
static void C_fcall f_5097(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5092)
static void C_fcall f_5092(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5087)
static void C_fcall f_5087(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5023)
static void C_fcall f_5023(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5079)
static void C_ccall f_5079(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5083)
static void C_ccall f_5083(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5044)
static void C_ccall f_5044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5047)
static void C_ccall f_5047(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5058)
static void C_ccall f_5058(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_5052)
static void C_ccall f_5052(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5025)
static void C_fcall f_5025(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5034)
static void C_ccall f_5034(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4904)
static void C_ccall f_4904(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...) C_noret;
C_noret_decl(f_4904)
static void C_ccall f_4904r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t10) C_noret;
C_noret_decl(f_4908)
static void C_ccall f_4908(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4999)
static void C_ccall f_4999(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4911)
static void C_ccall f_4911(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4967)
static void C_ccall f_4967(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4971)
static void C_ccall f_4971(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4975)
static void C_ccall f_4975(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4979)
static void C_ccall f_4979(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4983)
static void C_ccall f_4983(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4846)
static void C_ccall f_4846(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4850)
static void C_ccall f_4850(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4960)
static void C_ccall f_4960(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4940)
static void C_ccall f_4940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4944)
static void C_ccall f_4944(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4948)
static void C_ccall f_4948(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4812)
static void C_ccall f_4812(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4812)
static void C_ccall f_4812r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4829)
static void C_ccall f_4829(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4833)
static void C_ccall f_4833(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4806)
static void C_ccall f_4806(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4785)
static void C_ccall f_4785(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4789)
static void C_ccall f_4789(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4801)
static void C_ccall f_4801(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4782)
static void C_ccall f_4782(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4695)
static void C_ccall f_4695(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4695)
static void C_ccall f_4695r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4719)
static void C_fcall f_4719(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4714)
static void C_fcall f_4714(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4709)
static void C_fcall f_4709(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4697)
static void C_fcall f_4697(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4701)
static void C_ccall f_4701(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4608)
static void C_ccall f_4608(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4608)
static void C_ccall f_4608r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4632)
static void C_fcall f_4632(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4627)
static void C_fcall f_4627(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4622)
static void C_fcall f_4622(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4610)
static void C_fcall f_4610(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4614)
static void C_ccall f_4614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4593)
static void C_fcall f_4593(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4597)
static void C_ccall f_4597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4557)
static void C_fcall f_4557(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_4564)
static void C_ccall f_4564(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4567)
static void C_ccall f_4567(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4584)
static void C_ccall f_4584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4570)
static void C_ccall f_4570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4573)
static void C_ccall f_4573(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4580)
static void C_ccall f_4580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4507)
static void C_fcall f_4507(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4519)
static void C_fcall f_4519(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4538)
static void C_ccall f_4538(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4490)
static void C_ccall f_4490(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4473)
static void C_ccall f_4473(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4394)
static void C_fcall f_4394(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4437)
static void C_fcall f_4437(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4468)
static void C_ccall f_4468(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4465)
static void C_ccall f_4465(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4399)
static void C_fcall f_4399(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4403)
static void C_ccall f_4403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4408)
static void C_fcall f_4408(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4432)
static void C_ccall f_4432(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4421)
static void C_ccall f_4421(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4277)
static void C_ccall f_4277(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4277)
static void C_ccall f_4277r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4283)
static void C_fcall f_4283(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4304)
static void C_ccall f_4304(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4383)
static void C_ccall f_4383(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4308)
static void C_ccall f_4308(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4311)
static void C_ccall f_4311(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4318)
static void C_ccall f_4318(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4320)
static void C_fcall f_4320(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4337)
static void C_ccall f_4337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4341)
static void C_fcall f_4341(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4349)
static void C_ccall f_4349(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4353)
static void C_ccall f_4353(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4298)
static void C_ccall f_4298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4218)
static void C_ccall f_4218(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4218)
static void C_ccall f_4218r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4222)
static void C_ccall f_4222(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4228)
static void C_ccall f_4228(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4237)
static void C_fcall f_4237(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4203)
static void C_ccall f_4203(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4210)
static void C_ccall f_4210(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4184)
static void C_ccall f_4184(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4188)
static void C_ccall f_4188(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4191)
static void C_ccall f_4191(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4168)
static void C_ccall f_4168(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4168)
static void C_ccall f_4168r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4156)
static void C_ccall f_4156(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4141)
static void C_ccall f_4141(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4145)
static void C_ccall f_4145(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4151)
static void C_ccall f_4151(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4074)
static void C_ccall f_4074(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4074)
static void C_ccall f_4074r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4078)
static void C_ccall f_4078(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4081)
static void C_ccall f_4081(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4103)
static void C_ccall f_4103(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4100)
static void C_ccall f_4100(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4090)
static void C_ccall f_4090(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4016)
static void C_ccall f_4016(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4016)
static void C_ccall f_4016r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4020)
static void C_ccall f_4020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4023)
static void C_ccall f_4023(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3972)
static void C_ccall f_3972(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3972)
static void C_ccall f_3972r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3976)
static void C_ccall f_3976(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3938)
static void C_ccall f_3938(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3938)
static void C_ccall f_3938r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3942)
static void C_ccall f_3942(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3919)
static void C_fcall f_3919(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3853)
static void C_ccall f_3853(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3859)
static void C_fcall f_3859(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3863)
static void C_ccall f_3863(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3871)
static void C_fcall f_3871(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3897)
static void C_ccall f_3897(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3901)
static void C_ccall f_3901(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3889)
static void C_ccall f_3889(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3833)
static void C_ccall f_3833(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3841)
static void C_ccall f_3841(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3816)
static void C_ccall f_3816(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3827)
static void C_ccall f_3827(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3831)
static void C_ccall f_3831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3786)
static void C_ccall f_3786(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3786)
static void C_ccall f_3786r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3793)
static void C_fcall f_3793(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3802)
static void C_ccall f_3802(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3796)
static void C_ccall f_3796(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3751)
static void C_ccall f_3751(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3755)
static void C_ccall f_3755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3784)
static void C_ccall f_3784(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3770)
static void C_ccall f_3770(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3764)
static void C_ccall f_3764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3737)
static void C_ccall f_3737(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3737)
static void C_ccall f_3737r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3749)
static void C_ccall f_3749(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3723)
static void C_ccall f_3723(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3723)
static void C_ccall f_3723r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3735)
static void C_ccall f_3735(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3705)
static void C_fcall f_3705(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3709)
static void C_ccall f_3709(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3721)
static void C_ccall f_3721(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3668)
static void C_fcall f_3668(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3676)
static void C_ccall f_3676(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3659)
static void C_ccall f_3659(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3653)
static void C_ccall f_3653(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3647)
static void C_ccall f_3647(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3623)
static void C_fcall f_3623(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3645)
static void C_ccall f_3645(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3641)
static void C_ccall f_3641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3633)
static void C_ccall f_3633(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3593)
static void C_ccall f_3593(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3621)
static void C_ccall f_3621(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3617)
static void C_ccall f_3617(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3609)
static void C_ccall f_3609(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3537)
static void C_ccall f_3537(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3547)
static void C_ccall f_3547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3524)
static void C_ccall f_3524(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3515)
static void C_ccall f_3515(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3439)
static void C_ccall f_3439(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3439)
static void C_ccall f_3439r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3443)
static void C_ccall f_3443(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3455)
static void C_ccall f_3455(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3446)
static void C_ccall f_3446(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3419)
static void C_ccall f_3419(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3419)
static void C_ccall f_3419r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3423)
static void C_ccall f_3423(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3429)
static void C_ccall f_3429(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3429)
static void C_ccall f_3429r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3433)
static void C_ccall f_3433(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3399)
static void C_ccall f_3399(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3399)
static void C_ccall f_3399r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3403)
static void C_ccall f_3403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3409)
static void C_ccall f_3409(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3409)
static void C_ccall f_3409r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3413)
static void C_ccall f_3413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3375)
static void C_ccall f_3375(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3375)
static void C_ccall f_3375r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3379)
static void C_ccall f_3379(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3390)
static void C_ccall f_3390(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3390)
static void C_ccall f_3390r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3394)
static void C_ccall f_3394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3384)
static void C_ccall f_3384(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3351)
static void C_ccall f_3351(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3351)
static void C_ccall f_3351r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3355)
static void C_ccall f_3355(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3366)
static void C_ccall f_3366(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3366)
static void C_ccall f_3366r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3370)
static void C_ccall f_3370(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3360)
static void C_ccall f_3360(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3332)
static void C_ccall f_3332(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3336)
static void C_ccall f_3336(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3339)
static void C_ccall f_3339(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3296)
static void C_ccall f_3296(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3296)
static void C_ccall f_3296r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3327)
static void C_ccall f_3327(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3317)
static void C_ccall f_3317(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3310)
static void C_ccall f_3310(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3260)
static void C_ccall f_3260(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3260)
static void C_ccall f_3260r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3291)
static void C_ccall f_3291(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3281)
static void C_ccall f_3281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3274)
static void C_ccall f_3274(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3242)
static void C_fcall f_3242(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3246)
static void C_ccall f_3246(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3258)
static void C_ccall f_3258(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2867)
static void C_ccall f_2867(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3214)
static void C_ccall f_3214(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3013)
static void C_fcall f_3013(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3200)
static void C_ccall f_3200(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3189)
static void C_ccall f_3189(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3196)
static void C_ccall f_3196(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3043)
static void C_fcall f_3043(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3182)
static void C_ccall f_3182(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3161)
static void C_ccall f_3161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3178)
static void C_ccall f_3178(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3167)
static void C_ccall f_3167(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3174)
static void C_ccall f_3174(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3085)
static void C_fcall f_3085(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3158)
static void C_ccall f_3158(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3137)
static void C_ccall f_3137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3154)
static void C_ccall f_3154(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3143)
static void C_ccall f_3143(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3150)
static void C_ccall f_3150(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3091)
static void C_ccall f_3091(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3134)
static void C_ccall f_3134(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3130)
static void C_ccall f_3130(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3123)
static void C_ccall f_3123(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3119)
static void C_ccall f_3119(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3098)
static void C_ccall f_3098(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3102)
static void C_ccall f_3102(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3079)
static void C_ccall f_3079(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3066)
static void C_ccall f_3066(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3050)
static void C_ccall f_3050(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3054)
static void C_ccall f_3054(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3058)
static void C_ccall f_3058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3037)
static void C_ccall f_3037(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3024)
static void C_ccall f_3024(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3020)
static void C_ccall f_3020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3007)
static void C_ccall f_3007(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2874)
static void C_ccall f_2874(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2993)
static void C_ccall f_2993(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2881)
static void C_ccall f_2881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2883)
static void C_fcall f_2883(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2890)
static void C_ccall f_2890(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2965)
static void C_ccall f_2965(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2974)
static void C_ccall f_2974(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2896)
static void C_ccall f_2896(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2943)
static void C_ccall f_2943(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2931)
static void C_ccall f_2931(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2939)
static void C_ccall f_2939(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2935)
static void C_ccall f_2935(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2912)
static void C_ccall f_2912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2920)
static void C_ccall f_2920(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2916)
static void C_ccall f_2916(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2811)
static void C_fcall f_2811(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2820)
static void C_ccall f_2820(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2844)
static void C_ccall f_2844(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2856)
static void C_ccall f_2856(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2856)
static void C_ccall f_2856r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2862)
static void C_ccall f_2862(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2850)
static void C_ccall f_2850(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2826)
static void C_ccall f_2826(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2832)
static void C_ccall f_2832(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2815)
static void C_ccall f_2815(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2744)
static void C_ccall f_2744(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2744)
static void C_ccall f_2744r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2748)
static void C_ccall f_2748(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2757)
static void C_ccall f_2757(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2760)
static void C_ccall f_2760(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2717)
static void C_ccall f_2717(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2742)
static void C_ccall f_2742(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2738)
static void C_ccall f_2738(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2724)
static void C_ccall f_2724(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2557)
static void C_ccall f_2557(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2557)
static void C_ccall f_2557r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2665)
static void C_fcall f_2665(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2673)
static void C_ccall f_2673(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2660)
static void C_fcall f_2660(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2559)
static void C_fcall f_2559(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2566)
static void C_ccall f_2566(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2569)
static void C_ccall f_2569(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2572)
static void C_ccall f_2572(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2659)
static void C_ccall f_2659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2576)
static void C_ccall f_2576(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2593)
static void C_fcall f_2593(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2603)
static void C_ccall f_2603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2615)
static void C_fcall f_2615(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2625)
static void C_ccall f_2625(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2585)
static void C_ccall f_2585(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2532)
static void C_ccall f_2532(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2555)
static void C_ccall f_2555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2539)
static void C_ccall f_2539(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2548)
static void C_ccall f_2548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2542)
static void C_ccall f_2542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2507)
static void C_ccall f_2507(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2530)
static void C_ccall f_2530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2514)
static void C_ccall f_2514(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2523)
static void C_ccall f_2523(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2517)
static void C_ccall f_2517(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2350)
static void C_ccall f_2350(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2350)
static void C_ccall f_2350r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2354)
static void C_ccall f_2354(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2360)
static void C_ccall f_2360(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2483)
static void C_ccall f_2483(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2475)
static void C_ccall f_2475(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2368)
static void C_ccall f_2368(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2380)
static void C_fcall f_2380(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2450)
static void C_ccall f_2450(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2388)
static void C_fcall f_2388(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2393)
static void C_ccall f_2393(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2406)
static void C_ccall f_2406(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2409)
static void C_ccall f_2409(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2422)
static void C_fcall f_2422(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2441)
static void C_ccall f_2441(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2433)
static void C_ccall f_2433(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2363)
static void C_ccall f_2363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2288)
static void C_ccall f_2288(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2288)
static void C_ccall f_2288r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2301)
static void C_ccall f_2301(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2313)
static void C_ccall f_2313(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2307)
static void C_ccall f_2307(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f6623)
static void C_ccall f6623(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f6629)
static void C_ccall f6629(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f6635)
static void C_ccall f6635(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f6641)
static void C_ccall f6641(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2259)
static void C_ccall f_2259(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2236)
static void C_ccall f_2236(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2257)
static void C_ccall f_2257(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2243)
static void C_ccall f_2243(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2230)
static void C_ccall f_2230(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2234)
static void C_ccall f_2234(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2224)
static void C_ccall f_2224(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2228)
static void C_ccall f_2228(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2218)
static void C_ccall f_2218(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2222)
static void C_ccall f_2222(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2212)
static void C_ccall f_2212(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2216)
static void C_ccall f_2216(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2202)
static void C_ccall f_2202(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2206)
static void C_ccall f_2206(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2171)
static void C_ccall f_2171(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2171)
static void C_ccall f_2171r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2175)
static void C_ccall f_2175(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2178)
static void C_ccall f_2178(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2133)
static void C_fcall f_2133(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2166)
static void C_ccall f_2166(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2162)
static void C_ccall f_2162(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2137)
static void C_ccall f_2137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2146)
static void C_ccall f_2146(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2095)
static void C_ccall f_2095(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2102)
static void C_ccall f_2102(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2105)
static void C_ccall f_2105(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2125)
static void C_ccall f_2125(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2108)
static void C_ccall f_2108(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2115)
static void C_ccall f_2115(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2053)
static void C_ccall f_2053(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2053)
static void C_ccall f_2053r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2060)
static void C_ccall f_2060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2075)
static void C_ccall f_2075(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2069)
static void C_ccall f_2069(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2008)
static void C_ccall f_2008(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2008)
static void C_ccall f_2008r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2018)
static void C_ccall f_2018(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2021)
static void C_ccall f_2021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2033)
static void C_ccall f_2033(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2024)
static void C_ccall f_2024(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1990)
static void C_ccall f_1990(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2003)
static void C_ccall f_2003(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1949)
static void C_ccall f_1949(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1949)
static void C_ccall f_1949r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1982)
static void C_ccall f_1982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1966)
static void C_ccall f_1966(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1975)
static void C_ccall f_1975(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1969)
static void C_ccall f_1969(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1903)
static void C_ccall f_1903(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_1903)
static void C_ccall f_1903r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_1907)
static void C_ccall f_1907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1918)
static void C_ccall f_1918(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1914)
static void C_ccall f_1914(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_5965)
static void C_fcall trf_5965(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5965(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5965(t0,t1);}

C_noret_decl(trf_5555)
static void C_fcall trf_5555(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5555(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5555(t0,t1);}

C_noret_decl(trf_5550)
static void C_fcall trf_5550(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5550(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5550(t0,t1,t2);}

C_noret_decl(trf_5545)
static void C_fcall trf_5545(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5545(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5545(t0,t1,t2,t3);}

C_noret_decl(trf_5380)
static void C_fcall trf_5380(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5380(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5380(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5387)
static void C_fcall trf_5387(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5387(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5387(t0,t1);}

C_noret_decl(trf_5399)
static void C_fcall trf_5399(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5399(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5399(t0,t1,t2,t3);}

C_noret_decl(trf_5182)
static void C_fcall trf_5182(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5182(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5182(t0,t1);}

C_noret_decl(trf_5177)
static void C_fcall trf_5177(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5177(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5177(t0,t1,t2);}

C_noret_decl(trf_5172)
static void C_fcall trf_5172(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5172(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5172(t0,t1,t2,t3);}

C_noret_decl(trf_5167)
static void C_fcall trf_5167(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5167(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5167(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5102)
static void C_fcall trf_5102(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5102(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5102(t0,t1);}

C_noret_decl(trf_5097)
static void C_fcall trf_5097(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5097(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5097(t0,t1,t2);}

C_noret_decl(trf_5092)
static void C_fcall trf_5092(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5092(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5092(t0,t1,t2,t3);}

C_noret_decl(trf_5087)
static void C_fcall trf_5087(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5087(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5087(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5023)
static void C_fcall trf_5023(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5023(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_5023(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_5025)
static void C_fcall trf_5025(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5025(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5025(t0,t1,t2);}

C_noret_decl(trf_4719)
static void C_fcall trf_4719(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4719(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4719(t0,t1);}

C_noret_decl(trf_4714)
static void C_fcall trf_4714(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4714(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4714(t0,t1,t2);}

C_noret_decl(trf_4709)
static void C_fcall trf_4709(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4709(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4709(t0,t1,t2,t3);}

C_noret_decl(trf_4697)
static void C_fcall trf_4697(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4697(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4697(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4632)
static void C_fcall trf_4632(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4632(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4632(t0,t1);}

C_noret_decl(trf_4627)
static void C_fcall trf_4627(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4627(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4627(t0,t1,t2);}

C_noret_decl(trf_4622)
static void C_fcall trf_4622(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4622(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4622(t0,t1,t2,t3);}

C_noret_decl(trf_4610)
static void C_fcall trf_4610(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4610(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4610(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4593)
static void C_fcall trf_4593(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4593(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4593(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4557)
static void C_fcall trf_4557(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4557(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_4557(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_4507)
static void C_fcall trf_4507(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4507(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4507(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4519)
static void C_fcall trf_4519(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4519(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4519(t0,t1,t2,t3);}

C_noret_decl(trf_4394)
static void C_fcall trf_4394(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4394(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4394(t0,t1,t2,t3);}

C_noret_decl(trf_4437)
static void C_fcall trf_4437(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4437(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4437(t0,t1,t2,t3);}

C_noret_decl(trf_4399)
static void C_fcall trf_4399(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4399(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4399(t0,t1,t2);}

C_noret_decl(trf_4408)
static void C_fcall trf_4408(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4408(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4408(t0,t1,t2);}

C_noret_decl(trf_4283)
static void C_fcall trf_4283(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4283(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4283(t0,t1,t2);}

C_noret_decl(trf_4320)
static void C_fcall trf_4320(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4320(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4320(t0,t1,t2);}

C_noret_decl(trf_4341)
static void C_fcall trf_4341(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4341(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4341(t0,t1,t2);}

C_noret_decl(trf_4237)
static void C_fcall trf_4237(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4237(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4237(t0,t1);}

C_noret_decl(trf_3919)
static void C_fcall trf_3919(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3919(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3919(t0,t1,t2);}

C_noret_decl(trf_3859)
static void C_fcall trf_3859(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3859(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3859(t0,t1,t2);}

C_noret_decl(trf_3871)
static void C_fcall trf_3871(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3871(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3871(t0,t1,t2);}

C_noret_decl(trf_3793)
static void C_fcall trf_3793(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3793(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3793(t0,t1);}

C_noret_decl(trf_3705)
static void C_fcall trf_3705(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3705(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3705(t0,t1,t2,t3);}

C_noret_decl(trf_3668)
static void C_fcall trf_3668(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3668(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3668(t0,t1,t2);}

C_noret_decl(trf_3623)
static void C_fcall trf_3623(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3623(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3623(t0,t1,t2,t3);}

C_noret_decl(trf_3242)
static void C_fcall trf_3242(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3242(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3242(t0,t1,t2,t3);}

C_noret_decl(trf_3013)
static void C_fcall trf_3013(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3013(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3013(t0,t1);}

C_noret_decl(trf_3043)
static void C_fcall trf_3043(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3043(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3043(t0,t1);}

C_noret_decl(trf_3085)
static void C_fcall trf_3085(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3085(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3085(t0,t1);}

C_noret_decl(trf_2883)
static void C_fcall trf_2883(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2883(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2883(t0,t1,t2,t3);}

C_noret_decl(trf_2811)
static void C_fcall trf_2811(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2811(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2811(t0,t1);}

C_noret_decl(trf_2665)
static void C_fcall trf_2665(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2665(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2665(t0,t1);}

C_noret_decl(trf_2660)
static void C_fcall trf_2660(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2660(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2660(t0,t1,t2);}

C_noret_decl(trf_2559)
static void C_fcall trf_2559(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2559(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2559(t0,t1,t2,t3);}

C_noret_decl(trf_2593)
static void C_fcall trf_2593(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2593(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2593(t0,t1);}

C_noret_decl(trf_2615)
static void C_fcall trf_2615(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2615(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2615(t0,t1);}

C_noret_decl(trf_2380)
static void C_fcall trf_2380(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2380(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2380(t0,t1,t2);}

C_noret_decl(trf_2388)
static void C_fcall trf_2388(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2388(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2388(t0,t1,t2);}

C_noret_decl(trf_2422)
static void C_fcall trf_2422(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2422(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2422(t0,t1);}

C_noret_decl(trf_2133)
static void C_fcall trf_2133(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2133(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2133(t0,t1);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr9r)
static void C_fcall tr9r(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9r(C_proc9 k){
int n;
C_word *a,t9;
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
n=C_rest_count(0);
a=C_alloc(n*3);
t9=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3094)){
C_save(t1);
C_rereclaim2(3094*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,398);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000/this function is not available on this platform");
lf[3]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[4]=C_h_intern(&lf[4],13,"string-append");
lf[6]=C_h_intern(&lf[6],15,"\003syssignal-hook");
lf[7]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[8]=C_h_intern(&lf[8],17,"\003syspeek-c-string");
lf[9]=C_h_intern(&lf[9],16,"\003sysupdate-errno");
lf[10]=C_h_intern(&lf[10],15,"\003sysposix-error");
lf[11]=C_h_intern(&lf[11],8,"pipe/buf");
lf[12]=C_h_intern(&lf[12],11,"open/rdonly");
lf[13]=C_h_intern(&lf[13],11,"open/wronly");
lf[14]=C_h_intern(&lf[14],9,"open/rdwr");
lf[15]=C_h_intern(&lf[15],9,"open/read");
lf[16]=C_h_intern(&lf[16],10,"open/write");
lf[17]=C_h_intern(&lf[17],10,"open/creat");
lf[18]=C_h_intern(&lf[18],11,"open/append");
lf[19]=C_h_intern(&lf[19],9,"open/excl");
lf[20]=C_h_intern(&lf[20],10,"open/trunc");
lf[21]=C_h_intern(&lf[21],11,"open/binary");
lf[22]=C_h_intern(&lf[22],9,"open/text");
lf[23]=C_h_intern(&lf[23],14,"open/noinherit");
lf[24]=C_h_intern(&lf[24],10,"perm/irusr");
lf[25]=C_h_intern(&lf[25],10,"perm/iwusr");
lf[26]=C_h_intern(&lf[26],10,"perm/ixusr");
lf[27]=C_h_intern(&lf[27],10,"perm/irgrp");
lf[28]=C_h_intern(&lf[28],10,"perm/iwgrp");
lf[29]=C_h_intern(&lf[29],10,"perm/ixgrp");
lf[30]=C_h_intern(&lf[30],10,"perm/iroth");
lf[31]=C_h_intern(&lf[31],10,"perm/iwoth");
lf[32]=C_h_intern(&lf[32],10,"perm/ixoth");
lf[33]=C_h_intern(&lf[33],10,"perm/irwxu");
lf[34]=C_h_intern(&lf[34],10,"perm/irwxg");
lf[35]=C_h_intern(&lf[35],10,"perm/irwxo");
lf[36]=C_h_intern(&lf[36],9,"file-open");
lf[37]=C_h_intern(&lf[37],11,"\000file-error");
lf[38]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[39]=C_h_intern(&lf[39],17,"\003sysmake-c-string");
lf[40]=C_h_intern(&lf[40],20,"\003sysexpand-home-path");
lf[41]=C_h_intern(&lf[41],10,"file-close");
lf[42]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[43]=C_h_intern(&lf[43],11,"make-string");
lf[44]=C_h_intern(&lf[44],9,"file-read");
lf[45]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[46]=C_h_intern(&lf[46],11,"\000type-error");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[48]=C_h_intern(&lf[48],10,"file-write");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[51]=C_h_intern(&lf[51],13,"string-length");
lf[52]=C_h_intern(&lf[52],12,"file-mkstemp");
lf[53]=C_h_intern(&lf[53],13,"\003syssubstring");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[55]=C_h_intern(&lf[55],8,"seek/set");
lf[56]=C_h_intern(&lf[56],8,"seek/end");
lf[57]=C_h_intern(&lf[57],8,"seek/cur");
lf[59]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[61]=C_h_intern(&lf[61],9,"file-stat");
lf[62]=C_h_intern(&lf[62],9,"\003syserror");
lf[63]=C_h_intern(&lf[63],9,"file-size");
lf[64]=C_h_intern(&lf[64],22,"file-modification-time");
lf[65]=C_h_intern(&lf[65],16,"file-access-time");
lf[66]=C_h_intern(&lf[66],16,"file-change-time");
lf[67]=C_h_intern(&lf[67],10,"file-owner");
lf[68]=C_h_intern(&lf[68],16,"file-permissions");
lf[69]=C_h_intern(&lf[69],13,"regular-file\077");
lf[70]=C_h_intern(&lf[70],13,"\003sysfile-info");
lf[71]=C_h_intern(&lf[71],14,"symbolic-link\077");
lf[72]=C_h_intern(&lf[72],17,"character-device\077");
lf[73]=C_h_intern(&lf[73],13,"block-device\077");
lf[74]=C_h_intern(&lf[74],5,"fifo\077");
lf[75]=C_h_intern(&lf[75],7,"socket\077");
lf[76]=C_h_intern(&lf[76],18,"set-file-position!");
lf[77]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[78]=C_h_intern(&lf[78],6,"stream");
lf[79]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[80]=C_h_intern(&lf[80],5,"port\077");
lf[81]=C_h_intern(&lf[81],13,"\000bounds-error");
lf[82]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[83]=C_h_intern(&lf[83],13,"file-position");
lf[84]=C_h_intern(&lf[84],16,"create-directory");
lf[85]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[86]=C_h_intern(&lf[86],12,"file-exists\077");
lf[87]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[88]=C_h_intern(&lf[88],12,"string-split");
lf[89]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[90]=C_h_intern(&lf[90],16,"change-directory");
lf[91]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[92]=C_h_intern(&lf[92],16,"delete-directory");
lf[93]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[94]=C_h_intern(&lf[94],6,"string");
lf[95]=C_h_intern(&lf[95],9,"directory");
lf[96]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[97]=C_h_intern(&lf[97],16,"\003sysmake-pointer");
lf[98]=C_h_intern(&lf[98],17,"current-directory");
lf[99]=C_h_intern(&lf[99],10,"directory\077");
lf[100]=C_h_intern(&lf[100],27,"\003sysplatform-fixup-pathname");
lf[101]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[102]=C_h_intern(&lf[102],5,"null\077");
lf[103]=C_h_intern(&lf[103],6,"char=\077");
lf[104]=C_h_intern(&lf[104],8,"string=\077");
lf[105]=C_h_intern(&lf[105],16,"char-alphabetic\077");
lf[106]=C_h_intern(&lf[106],10,"string-ref");
lf[107]=C_h_intern(&lf[107],17,"current-user-name");
lf[108]=C_h_intern(&lf[108],9,"condition");
lf[109]=C_decode_literal(C_heaptop,"\376B\000\000\003c:\134");
lf[110]=C_h_intern(&lf[110],22,"with-exception-handler");
lf[111]=C_h_intern(&lf[111],30,"call-with-current-continuation");
lf[112]=C_h_intern(&lf[112],14,"canonical-path");
lf[113]=C_h_intern(&lf[113],18,"string-intersperse");
lf[114]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[115]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[116]=C_h_intern(&lf[116],7,"reverse");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[118]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[119]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[120]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[121]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[122]=C_decode_literal(C_heaptop,"\376B\000\000\027Documents and Settings\134");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[124]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[125]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[126]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[127]=C_h_intern(&lf[127],13,"\003sysmake-port");
lf[128]=C_h_intern(&lf[128],21,"\003sysstream-port-class");
lf[129]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[130]=C_h_intern(&lf[130],15,"open-input-pipe");
lf[131]=C_h_intern(&lf[131],5,"\000text");
lf[132]=C_h_intern(&lf[132],7,"\000binary");
lf[133]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[134]=C_h_intern(&lf[134],16,"open-output-pipe");
lf[135]=C_h_intern(&lf[135],16,"close-input-pipe");
lf[136]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[137]=C_h_intern(&lf[137],14,"\003syscheck-port");
lf[138]=C_h_intern(&lf[138],17,"close-output-pipe");
lf[139]=C_h_intern(&lf[139],20,"call-with-input-pipe");
lf[140]=C_h_intern(&lf[140],21,"call-with-output-pipe");
lf[141]=C_h_intern(&lf[141],20,"with-input-from-pipe");
lf[142]=C_h_intern(&lf[142],18,"\003sysstandard-input");
lf[143]=C_h_intern(&lf[143],19,"with-output-to-pipe");
lf[144]=C_h_intern(&lf[144],19,"\003sysstandard-output");
lf[145]=C_h_intern(&lf[145],11,"create-pipe");
lf[146]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[147]=C_h_intern(&lf[147],11,"signal/term");
lf[148]=C_h_intern(&lf[148],10,"signal/int");
lf[149]=C_h_intern(&lf[149],10,"signal/fpe");
lf[150]=C_h_intern(&lf[150],10,"signal/ill");
lf[151]=C_h_intern(&lf[151],11,"signal/segv");
lf[152]=C_h_intern(&lf[152],11,"signal/abrt");
lf[153]=C_h_intern(&lf[153],12,"signal/break");
lf[154]=C_h_intern(&lf[154],11,"signal/alrm");
lf[155]=C_h_intern(&lf[155],11,"signal/chld");
lf[156]=C_h_intern(&lf[156],11,"signal/cont");
lf[157]=C_h_intern(&lf[157],10,"signal/hup");
lf[158]=C_h_intern(&lf[158],9,"signal/io");
lf[159]=C_h_intern(&lf[159],11,"signal/kill");
lf[160]=C_h_intern(&lf[160],11,"signal/pipe");
lf[161]=C_h_intern(&lf[161],11,"signal/prof");
lf[162]=C_h_intern(&lf[162],11,"signal/quit");
lf[163]=C_h_intern(&lf[163],11,"signal/stop");
lf[164]=C_h_intern(&lf[164],11,"signal/trap");
lf[165]=C_h_intern(&lf[165],11,"signal/tstp");
lf[166]=C_h_intern(&lf[166],10,"signal/urg");
lf[167]=C_h_intern(&lf[167],11,"signal/usr1");
lf[168]=C_h_intern(&lf[168],11,"signal/usr2");
lf[169]=C_h_intern(&lf[169],13,"signal/vtalrm");
lf[170]=C_h_intern(&lf[170],12,"signal/winch");
lf[171]=C_h_intern(&lf[171],11,"signal/xcpu");
lf[172]=C_h_intern(&lf[172],11,"signal/xfsz");
lf[173]=C_h_intern(&lf[173],12,"signals-list");
lf[174]=C_h_intern(&lf[174],18,"\003sysinterrupt-hook");
lf[175]=C_h_intern(&lf[175],14,"signal-handler");
lf[176]=C_h_intern(&lf[176],19,"set-signal-handler!");
lf[177]=C_h_intern(&lf[177],10,"errno/perm");
lf[178]=C_h_intern(&lf[178],11,"errno/noent");
lf[179]=C_h_intern(&lf[179],10,"errno/srch");
lf[180]=C_h_intern(&lf[180],10,"errno/intr");
lf[181]=C_h_intern(&lf[181],8,"errno/io");
lf[182]=C_h_intern(&lf[182],12,"errno/noexec");
lf[183]=C_h_intern(&lf[183],10,"errno/badf");
lf[184]=C_h_intern(&lf[184],11,"errno/child");
lf[185]=C_h_intern(&lf[185],11,"errno/nomem");
lf[186]=C_h_intern(&lf[186],11,"errno/acces");
lf[187]=C_h_intern(&lf[187],11,"errno/fault");
lf[188]=C_h_intern(&lf[188],10,"errno/busy");
lf[189]=C_h_intern(&lf[189],11,"errno/exist");
lf[190]=C_h_intern(&lf[190],12,"errno/notdir");
lf[191]=C_h_intern(&lf[191],11,"errno/isdir");
lf[192]=C_h_intern(&lf[192],11,"errno/inval");
lf[193]=C_h_intern(&lf[193],11,"errno/mfile");
lf[194]=C_h_intern(&lf[194],11,"errno/nospc");
lf[195]=C_h_intern(&lf[195],11,"errno/spipe");
lf[196]=C_h_intern(&lf[196],10,"errno/pipe");
lf[197]=C_h_intern(&lf[197],11,"errno/again");
lf[198]=C_h_intern(&lf[198],10,"errno/rofs");
lf[199]=C_h_intern(&lf[199],10,"errno/nxio");
lf[200]=C_h_intern(&lf[200],10,"errno/2big");
lf[201]=C_h_intern(&lf[201],10,"errno/xdev");
lf[202]=C_h_intern(&lf[202],11,"errno/nodev");
lf[203]=C_h_intern(&lf[203],11,"errno/nfile");
lf[204]=C_h_intern(&lf[204],11,"errno/notty");
lf[205]=C_h_intern(&lf[205],10,"errno/fbig");
lf[206]=C_h_intern(&lf[206],11,"errno/mlink");
lf[207]=C_h_intern(&lf[207],9,"errno/dom");
lf[208]=C_h_intern(&lf[208],11,"errno/range");
lf[209]=C_h_intern(&lf[209],12,"errno/deadlk");
lf[210]=C_h_intern(&lf[210],17,"errno/nametoolong");
lf[211]=C_h_intern(&lf[211],11,"errno/nolck");
lf[212]=C_h_intern(&lf[212],11,"errno/nosys");
lf[213]=C_h_intern(&lf[213],14,"errno/notempty");
lf[214]=C_h_intern(&lf[214],11,"errno/ilseq");
lf[215]=C_h_intern(&lf[215],16,"change-file-mode");
lf[216]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[217]=C_h_intern(&lf[217],17,"file-read-access\077");
lf[218]=C_h_intern(&lf[218],18,"file-write-access\077");
lf[219]=C_h_intern(&lf[219],20,"file-execute-access\077");
lf[220]=C_h_intern(&lf[220],12,"fileno/stdin");
lf[221]=C_h_intern(&lf[221],13,"fileno/stdout");
lf[222]=C_h_intern(&lf[222],13,"fileno/stderr");
lf[223]=C_h_intern(&lf[223],7,"\000append");
lf[224]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[225]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[226]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[227]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[228]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[229]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[230]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[231]=C_h_intern(&lf[231],16,"open-input-file*");
lf[232]=C_h_intern(&lf[232],17,"open-output-file*");
lf[233]=C_h_intern(&lf[233],12,"port->fileno");
lf[234]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[236]=C_h_intern(&lf[236],25,"\003syspeek-unsigned-integer");
lf[237]=C_h_intern(&lf[237],16,"duplicate-fileno");
lf[238]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file descriptor");
lf[239]=C_h_intern(&lf[239],6,"setenv");
lf[240]=C_h_intern(&lf[240],8,"unsetenv");
lf[241]=C_h_intern(&lf[241],9,"substring");
lf[242]=C_h_intern(&lf[242],25,"get-environment-variables");
lf[243]=C_h_intern(&lf[243],19,"current-environment");
lf[245]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[246]=C_h_intern(&lf[246],19,"seconds->local-time");
lf[247]=C_h_intern(&lf[247],18,"\003sysdecode-seconds");
lf[248]=C_h_intern(&lf[248],15,"current-seconds");
lf[249]=C_h_intern(&lf[249],17,"seconds->utc-time");
lf[250]=C_h_intern(&lf[250],15,"seconds->string");
lf[251]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[252]=C_h_intern(&lf[252],12,"time->string");
lf[253]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[254]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[255]=C_h_intern(&lf[255],19,"local-time->seconds");
lf[256]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[257]=C_h_intern(&lf[257],3,"fp=");
lf[258]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[259]=C_h_intern(&lf[259],27,"local-timezone-abbreviation");
lf[260]=C_h_intern(&lf[260],5,"_exit");
lf[261]=C_h_intern(&lf[261],14,"terminal-port\077");
lf[262]=C_h_intern(&lf[262],13,"terminal-size");
lf[263]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[264]=C_h_intern(&lf[264],19,"set-buffering-mode!");
lf[265]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[266]=C_h_intern(&lf[266],5,"\000full");
lf[267]=C_h_intern(&lf[267],5,"\000line");
lf[268]=C_h_intern(&lf[268],5,"\000none");
lf[269]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[270]=C_h_intern(&lf[270],6,"regexp");
lf[271]=C_h_intern(&lf[271],12,"string-match");
lf[272]=C_h_intern(&lf[272],12,"glob->regexp");
lf[273]=C_h_intern(&lf[273],13,"make-pathname");
lf[274]=C_h_intern(&lf[274],18,"decompose-pathname");
lf[275]=C_h_intern(&lf[275],4,"glob");
lf[276]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[277]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[278]=C_h_intern(&lf[278],13,"spawn/overlay");
lf[279]=C_h_intern(&lf[279],10,"spawn/wait");
lf[280]=C_h_intern(&lf[280],12,"spawn/nowait");
lf[281]=C_h_intern(&lf[281],13,"spawn/nowaito");
lf[282]=C_h_intern(&lf[282],12,"spawn/detach");
lf[283]=C_h_intern(&lf[283],16,"char-whitespace\077");
lf[285]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[286]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[287]=C_h_intern(&lf[287],24,"pathname-strip-directory");
lf[290]=C_h_intern(&lf[290],15,"process-execute");
lf[291]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[292]=C_h_intern(&lf[292],13,"process-spawn");
lf[293]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot spawn process");
lf[294]=C_h_intern(&lf[294],18,"current-process-id");
lf[295]=C_h_intern(&lf[295],17,"\003sysshell-command");
lf[296]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve system directory");
lf[297]=C_h_intern(&lf[297],24,"get-environment-variable");
lf[298]=C_decode_literal(C_heaptop,"\376B\000\000\007COMSPEC");
lf[299]=C_h_intern(&lf[299],27,"\003sysshell-command-arguments");
lf[300]=C_decode_literal(C_heaptop,"\376B\000\000\002/c");
lf[301]=C_h_intern(&lf[301],11,"process-run");
lf[302]=C_h_intern(&lf[302],11,"\003sysprocess");
lf[303]=C_h_intern(&lf[303],14,"\000process-error");
lf[304]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[305]=C_h_intern(&lf[305],17,"\003sysmake-locative");
lf[306]=C_h_intern(&lf[306],8,"location");
lf[307]=C_h_intern(&lf[307],16,"\003syscheck-string");
lf[308]=C_h_intern(&lf[308],12,"\003sysfor-each");
lf[309]=C_h_intern(&lf[309],7,"process");
lf[310]=C_h_intern(&lf[310],8,"process*");
lf[311]=C_h_intern(&lf[311],16,"\003sysprocess-wait");
lf[312]=C_h_intern(&lf[312],12,"process-wait");
lf[313]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[314]=C_h_intern(&lf[314],5,"sleep");
lf[315]=C_h_intern(&lf[315],13,"get-host-name");
lf[316]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[317]=C_h_intern(&lf[317],18,"system-information");
lf[318]=C_decode_literal(C_heaptop,"\376B\000\000\007windows");
lf[319]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system-information");
lf[320]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current user-name");
lf[321]=C_h_intern(&lf[321],13,"pathname-file");
lf[322]=C_h_intern(&lf[322],10,"find-files");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[324]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[325]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[326]=C_h_intern(&lf[326],16,"\003sysdynamic-wind");
lf[327]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[328]=C_h_intern(&lf[328],7,"regexp\077");
lf[329]=C_h_intern(&lf[329],17,"change-file-owner");
lf[330]=C_h_intern(&lf[330],5,"error");
lf[331]=C_h_intern(&lf[331],11,"create-fifo");
lf[332]=C_h_intern(&lf[332],14,"create-session");
lf[333]=C_h_intern(&lf[333],20,"create-symbolic-link");
lf[334]=C_h_intern(&lf[334],26,"current-effective-group-id");
lf[335]=C_h_intern(&lf[335],25,"current-effective-user-id");
lf[336]=C_h_intern(&lf[336],27,"current-effective-user-name");
lf[337]=C_h_intern(&lf[337],16,"current-group-id");
lf[338]=C_h_intern(&lf[338],15,"current-user-id");
lf[339]=C_h_intern(&lf[339],18,"map-file-to-memory");
lf[340]=C_h_intern(&lf[340],9,"file-link");
lf[341]=C_h_intern(&lf[341],9,"file-lock");
lf[342]=C_h_intern(&lf[342],18,"file-lock/blocking");
lf[343]=C_h_intern(&lf[343],11,"file-select");
lf[344]=C_h_intern(&lf[344],14,"file-test-lock");
lf[345]=C_h_intern(&lf[345],13,"file-truncate");
lf[346]=C_h_intern(&lf[346],11,"file-unlock");
lf[347]=C_h_intern(&lf[347],10,"get-groups");
lf[348]=C_h_intern(&lf[348],17,"group-information");
lf[349]=C_h_intern(&lf[349],17,"initialize-groups");
lf[350]=C_h_intern(&lf[350],26,"memory-mapped-file-pointer");
lf[351]=C_h_intern(&lf[351],17,"parent-process-id");
lf[352]=C_h_intern(&lf[352],12,"process-fork");
lf[353]=C_h_intern(&lf[353],16,"process-group-id");
lf[354]=C_h_intern(&lf[354],14,"process-signal");
lf[355]=C_h_intern(&lf[355],18,"read-symbolic-link");
lf[356]=C_h_intern(&lf[356],10,"set-alarm!");
lf[357]=C_h_intern(&lf[357],13,"set-group-id!");
lf[358]=C_h_intern(&lf[358],11,"set-groups!");
lf[359]=C_h_intern(&lf[359],21,"set-process-group-id!");
lf[360]=C_h_intern(&lf[360],19,"set-root-directory!");
lf[361]=C_h_intern(&lf[361],16,"set-signal-mask!");
lf[362]=C_h_intern(&lf[362],12,"set-user-id!");
lf[363]=C_h_intern(&lf[363],11,"signal-mask");
lf[364]=C_h_intern(&lf[364],12,"signal-mask!");
lf[365]=C_h_intern(&lf[365],14,"signal-masked\077");
lf[366]=C_h_intern(&lf[366],14,"signal-unmask!");
lf[367]=C_h_intern(&lf[367],13,"terminal-name");
lf[368]=C_h_intern(&lf[368],22,"unmap-file-from-memory");
lf[369]=C_h_intern(&lf[369],16,"user-information");
lf[370]=C_h_intern(&lf[370],17,"utc-time->seconds");
lf[371]=C_h_intern(&lf[371],12,"string->time");
lf[372]=C_h_intern(&lf[372],16,"errno/wouldblock");
lf[373]=C_h_intern(&lf[373],19,"memory-mapped-file\077");
lf[374]=C_h_intern(&lf[374],13,"map/anonymous");
lf[375]=C_h_intern(&lf[375],8,"map/file");
lf[376]=C_h_intern(&lf[376],9,"map/fixed");
lf[377]=C_h_intern(&lf[377],11,"map/private");
lf[378]=C_h_intern(&lf[378],10,"map/shared");
lf[379]=C_h_intern(&lf[379],10,"open/fsync");
lf[380]=C_h_intern(&lf[380],11,"open/noctty");
lf[381]=C_h_intern(&lf[381],13,"open/nonblock");
lf[382]=C_h_intern(&lf[382],9,"open/sync");
lf[383]=C_h_intern(&lf[383],10,"perm/isgid");
lf[384]=C_h_intern(&lf[384],10,"perm/isuid");
lf[385]=C_h_intern(&lf[385],10,"perm/isvtx");
lf[386]=C_h_intern(&lf[386],9,"prot/exec");
lf[387]=C_h_intern(&lf[387],9,"prot/none");
lf[388]=C_h_intern(&lf[388],9,"prot/read");
lf[389]=C_h_intern(&lf[389],10,"prot/write");
lf[390]=C_h_intern(&lf[390],11,"make-vector");
lf[391]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[392]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[393]=C_h_intern(&lf[393],18,"getter-with-setter");
lf[394]=C_h_intern(&lf[394],26,"set-file-modification-time");
lf[395]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[396]=C_h_intern(&lf[396],17,"register-feature!");
lf[397]=C_h_intern(&lf[397],5,"posix");
C_register_lf2(lf,398,create_ptable());
t2=C_mutate(&lf[0] /* (set! c1372 ...) */,lf[1]);
t3=C_mutate(&lf[2] /* (set! c109 ...) */,lf[3]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1873,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t4);}

/* k1871 */
static void C_ccall f_1873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1873,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1876,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1874 in k1871 */
static void C_ccall f_1876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1876,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1879,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1877 in k1874 in k1871 */
static void C_ccall f_1879(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1879,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1882,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1882(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1882,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1885,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1885,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1888,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1888(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1888,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1891,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 939  register-feature! */
((C_proc3)C_retrieve_proc(*((C_word*)lf[396]+1)))(3,*((C_word*)lf[396]+1),t2,lf[397]);}

/* k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1891(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word ab[44],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1891,2,t0,t1);}
t2=*((C_word*)lf[4]+1);
t3=C_mutate(&lf[5] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1903,a[2]=t2,a[3]=((C_word)li0),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[10]+1 /* (set! ##sys#posix-error ...) */,lf[5]);
t5=C_mutate((C_word*)lf[11]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t6=C_mutate((C_word*)lf[12]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t7=C_mutate((C_word*)lf[13]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t8=C_mutate((C_word*)lf[14]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t9=C_mutate((C_word*)lf[15]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[16]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t11=C_mutate((C_word*)lf[17]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t12=C_mutate((C_word*)lf[18]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t13=C_mutate((C_word*)lf[19]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t14=C_mutate((C_word*)lf[20]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t15=C_mutate((C_word*)lf[21]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t16=C_mutate((C_word*)lf[22]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t17=C_mutate((C_word*)lf[23]+1 /* (set! open/noinherit ...) */,C_fix((C_word)O_NOINHERIT));
t18=C_mutate((C_word*)lf[24]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IREAD));
t19=C_mutate((C_word*)lf[25]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWRITE));
t20=C_mutate((C_word*)lf[26]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IEXEC));
t21=C_mutate((C_word*)lf[27]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IREAD));
t22=C_mutate((C_word*)lf[28]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWRITE));
t23=C_mutate((C_word*)lf[29]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IEXEC));
t24=C_mutate((C_word*)lf[30]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IREAD));
t25=C_mutate((C_word*)lf[31]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWRITE));
t26=C_mutate((C_word*)lf[32]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IEXEC));
t27=C_mutate((C_word*)lf[33]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t28=C_mutate((C_word*)lf[34]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t29=C_mutate((C_word*)lf[35]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t30=C_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t31=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t30);
t32=C_mutate((C_word*)lf[36]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1949,a[2]=t31,a[3]=((C_word)li1),tmp=(C_word)a,a+=4,tmp));
t33=C_mutate((C_word*)lf[41]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1990,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t34=*((C_word*)lf[43]+1);
t35=C_mutate((C_word*)lf[44]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2008,a[2]=t34,a[3]=((C_word)li3),tmp=(C_word)a,a+=4,tmp));
t36=C_mutate((C_word*)lf[48]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2053,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t37=*((C_word*)lf[51]+1);
t38=C_mutate((C_word*)lf[52]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2095,a[2]=t37,a[3]=((C_word)li5),tmp=(C_word)a,a+=4,tmp));
t39=C_mutate((C_word*)lf[55]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t40=C_mutate((C_word*)lf[56]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t41=C_mutate((C_word*)lf[57]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t42=C_mutate(&lf[58] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2133,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[61]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2171,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[63]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2202,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t45=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2210,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t46=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5936,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp);
t47=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5942,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1105 getter-with-setter */
((C_proc4)C_retrieve_proc(*((C_word*)lf[393]+1)))(4,*((C_word*)lf[393]+1),t45,t46,t47);}

/* a5941 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5942(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5942,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[394]);
t5=C_i_check_number_2(t3,lf[394]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5965,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5978,a[2]=t6,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1112 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t7,t2);}

/* k5976 in a5941 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5978(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5978,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5955,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t4=C_i_foreign_string_argumentp(t1);
/* ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}
else{
t4=((C_word*)t0)[2];
f_5965(t4,stub123(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t2));}}

/* k5953 in k5976 in a5941 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5955(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_5965(t2,stub123(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[2]));}

/* k5963 in a5941 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5965(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixwin.scm: 1115 posix-error */
t2=lf[5];
f_1903(7,t2,((C_word*)t0)[4],lf[37],lf[394],lf[395],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* a5935 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5936(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5936,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5940,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1107 ##sys#stat */
f_2133(t3,t2);}

/* k5938 in a5935 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5940,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2210(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word ab[39],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2210,2,t0,t1);}
t2=C_mutate((C_word*)lf[64]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate((C_word*)lf[65]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2212,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[66]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2218,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[67]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2224,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[68]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2230,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[69]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2236,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[71]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2259,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6641,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp);
t10=C_mutate((C_word*)lf[72]+1 /* (set! character-device? ...) */,t9);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6635,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp);
t12=C_mutate((C_word*)lf[73]+1 /* (set! block-device? ...) */,t11);
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6629,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp);
t14=C_mutate((C_word*)lf[74]+1 /* (set! fifo? ...) */,t13);
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6623,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp);
t16=C_mutate((C_word*)lf[75]+1 /* (set! socket? ...) */,t15);
t17=C_mutate((C_word*)lf[76]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2288,a[2]=((C_word)li19),tmp=(C_word)a,a+=3,tmp));
t18=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2348,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t19=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5899,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1160 getter-with-setter */
((C_proc4)C_retrieve_proc(*((C_word*)lf[393]+1)))(4,*((C_word*)lf[393]+1),t18,t19,*((C_word*)lf[76]+1));}

/* a5898 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5899(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5899,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5903,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5915,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1162 port? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[80]+1)))(3,*((C_word*)lf[80]+1),t4,t2);}

/* k5913 in a5898 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5915(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[3],C_fix(7));
t3=C_eqp(t2,lf[78]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
f_5903(2,t5,t4);}
else{
t4=((C_word*)t0)[2];
f_5903(2,t4,C_fix(-1));}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t2=C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[2];
f_5903(2,t3,t2);}
else{
/* posixwin.scm: 1169 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[46],lf[83],lf[392],((C_word*)t0)[3]);}}}

/* k5901 in a5898 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5903(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5903,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5906,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t1,C_fix(0)))){
/* posixwin.scm: 1171 posix-error */
t3=lf[5];
f_1903(6,t3,t2,lf[37],lf[83],lf[391],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k5904 in k5901 in a5898 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5906(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word ab[97],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2348,2,t0,t1);}
t2=C_mutate((C_word*)lf[83]+1 /* (set! file-position ...) */,t1);
t3=C_mutate((C_word*)lf[84]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2350,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[90]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2507,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[92]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2532,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp));
t6=*((C_word*)lf[4]+1);
t7=*((C_word*)lf[43]+1);
t8=*((C_word*)lf[94]+1);
t9=C_mutate((C_word*)lf[95]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2557,a[2]=t7,a[3]=((C_word)li29),tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[99]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2717,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp));
t11=*((C_word*)lf[43]+1);
t12=C_mutate((C_word*)lf[98]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2744,a[2]=t11,a[3]=((C_word)li31),tmp=(C_word)a,a+=4,tmp));
t13=*((C_word*)lf[102]+1);
t14=*((C_word*)lf[103]+1);
t15=*((C_word*)lf[104]+1);
t16=*((C_word*)lf[105]+1);
t17=*((C_word*)lf[106]+1);
t18=*((C_word*)lf[4]+1);
t19=*((C_word*)lf[107]+1);
t20=*((C_word*)lf[98]+1);
t21=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2811,a[2]=t20,a[3]=((C_word)li39),tmp=(C_word)a,a+=4,tmp);
t22=C_mutate((C_word*)lf[112]+1 /* (set! canonical-path ...) */,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2867,a[2]=t16,a[3]=t14,a[4]=t19,a[5]=t21,a[6]=t15,a[7]=t13,a[8]=t17,a[9]=t18,a[10]=((C_word)li41),tmp=(C_word)a,a+=11,tmp));
t23=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3242,a[2]=((C_word)li42),tmp=(C_word)a,a+=3,tmp);
t24=C_mutate((C_word*)lf[130]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3260,a[2]=t23,a[3]=((C_word)li43),tmp=(C_word)a,a+=4,tmp));
t25=C_mutate((C_word*)lf[134]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3296,a[2]=t23,a[3]=((C_word)li44),tmp=(C_word)a,a+=4,tmp));
t26=C_mutate((C_word*)lf[135]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3332,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp));
t27=C_mutate((C_word*)lf[138]+1 /* (set! close-output-pipe ...) */,*((C_word*)lf[135]+1));
t28=*((C_word*)lf[130]+1);
t29=*((C_word*)lf[134]+1);
t30=*((C_word*)lf[135]+1);
t31=*((C_word*)lf[138]+1);
t32=C_mutate((C_word*)lf[139]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3351,a[2]=t28,a[3]=t30,a[4]=((C_word)li48),tmp=(C_word)a,a+=5,tmp));
t33=C_mutate((C_word*)lf[140]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3375,a[2]=t29,a[3]=t31,a[4]=((C_word)li51),tmp=(C_word)a,a+=5,tmp));
t34=C_mutate((C_word*)lf[141]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3399,a[2]=t28,a[3]=t30,a[4]=((C_word)li53),tmp=(C_word)a,a+=5,tmp));
t35=C_mutate((C_word*)lf[143]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3419,a[2]=t29,a[3]=t31,a[4]=((C_word)li55),tmp=(C_word)a,a+=5,tmp));
t36=C_mutate((C_word*)lf[145]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3439,a[2]=((C_word)li56),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[147]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t38=C_mutate((C_word*)lf[148]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t39=C_mutate((C_word*)lf[149]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t40=C_mutate((C_word*)lf[150]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t41=C_mutate((C_word*)lf[151]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t42=C_mutate((C_word*)lf[152]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t43=C_mutate((C_word*)lf[153]+1 /* (set! signal/break ...) */,C_fix((C_word)SIGBREAK));
t44=C_set_block_item(lf[154] /* signal/alrm */,0,C_fix(0));
t45=C_set_block_item(lf[155] /* signal/chld */,0,C_fix(0));
t46=C_set_block_item(lf[156] /* signal/cont */,0,C_fix(0));
t47=C_set_block_item(lf[157] /* signal/hup */,0,C_fix(0));
t48=C_set_block_item(lf[158] /* signal/io */,0,C_fix(0));
t49=C_set_block_item(lf[159] /* signal/kill */,0,C_fix(0));
t50=C_set_block_item(lf[160] /* signal/pipe */,0,C_fix(0));
t51=C_set_block_item(lf[161] /* signal/prof */,0,C_fix(0));
t52=C_set_block_item(lf[162] /* signal/quit */,0,C_fix(0));
t53=C_set_block_item(lf[163] /* signal/stop */,0,C_fix(0));
t54=C_set_block_item(lf[164] /* signal/trap */,0,C_fix(0));
t55=C_set_block_item(lf[165] /* signal/tstp */,0,C_fix(0));
t56=C_set_block_item(lf[166] /* signal/urg */,0,C_fix(0));
t57=C_set_block_item(lf[167] /* signal/usr1 */,0,C_fix(0));
t58=C_set_block_item(lf[168] /* signal/usr2 */,0,C_fix(0));
t59=C_set_block_item(lf[169] /* signal/vtalrm */,0,C_fix(0));
t60=C_set_block_item(lf[170] /* signal/winch */,0,C_fix(0));
t61=C_set_block_item(lf[171] /* signal/xcpu */,0,C_fix(0));
t62=C_set_block_item(lf[172] /* signal/xfsz */,0,C_fix(0));
t63=C_a_i_list(&a,7,*((C_word*)lf[147]+1),*((C_word*)lf[148]+1),*((C_word*)lf[149]+1),*((C_word*)lf[150]+1),*((C_word*)lf[151]+1),*((C_word*)lf[152]+1),*((C_word*)lf[153]+1));
t64=C_mutate((C_word*)lf[173]+1 /* (set! signals-list ...) */,t63);
t65=*((C_word*)lf[174]+1);
t66=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3513,a[2]=((C_word*)t0)[2],a[3]=t65,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1495 make-vector */
t67=*((C_word*)lf[390]+1);
((C_proc4)(void*)(*((C_word*)t67+1)))(4,t67,t66,C_fix(256),C_SCHEME_FALSE);}

/* k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word ab[326],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3513,2,t0,t1);}
t2=C_mutate((C_word*)lf[175]+1 /* (set! signal-handler ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3515,a[2]=t1,a[3]=((C_word)li57),tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[176]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3524,a[2]=t1,a[3]=((C_word)li58),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[174]+1 /* (set! ##sys#interrupt-hook ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3537,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li59),tmp=(C_word)a,a+=5,tmp));
t5=C_mutate((C_word*)lf[177]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t6=C_mutate((C_word*)lf[178]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t7=C_mutate((C_word*)lf[179]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t8=C_mutate((C_word*)lf[180]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t9=C_mutate((C_word*)lf[181]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t10=C_mutate((C_word*)lf[182]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t11=C_mutate((C_word*)lf[183]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t12=C_mutate((C_word*)lf[184]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t13=C_mutate((C_word*)lf[185]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t14=C_mutate((C_word*)lf[186]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t15=C_mutate((C_word*)lf[187]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t16=C_mutate((C_word*)lf[188]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t17=C_mutate((C_word*)lf[189]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t18=C_mutate((C_word*)lf[190]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t19=C_mutate((C_word*)lf[191]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t20=C_mutate((C_word*)lf[192]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t21=C_mutate((C_word*)lf[193]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t22=C_mutate((C_word*)lf[194]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t23=C_mutate((C_word*)lf[195]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t24=C_mutate((C_word*)lf[196]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t25=C_mutate((C_word*)lf[197]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t26=C_mutate((C_word*)lf[198]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t27=C_mutate((C_word*)lf[199]+1 /* (set! errno/nxio ...) */,C_fix((C_word)ENXIO));
t28=C_mutate((C_word*)lf[200]+1 /* (set! errno/2big ...) */,C_fix((C_word)E2BIG));
t29=C_mutate((C_word*)lf[201]+1 /* (set! errno/xdev ...) */,C_fix((C_word)EXDEV));
t30=C_mutate((C_word*)lf[202]+1 /* (set! errno/nodev ...) */,C_fix((C_word)ENODEV));
t31=C_mutate((C_word*)lf[203]+1 /* (set! errno/nfile ...) */,C_fix((C_word)ENFILE));
t32=C_mutate((C_word*)lf[204]+1 /* (set! errno/notty ...) */,C_fix((C_word)ENOTTY));
t33=C_mutate((C_word*)lf[205]+1 /* (set! errno/fbig ...) */,C_fix((C_word)EFBIG));
t34=C_mutate((C_word*)lf[206]+1 /* (set! errno/mlink ...) */,C_fix((C_word)EMLINK));
t35=C_mutate((C_word*)lf[207]+1 /* (set! errno/dom ...) */,C_fix((C_word)EDOM));
t36=C_mutate((C_word*)lf[208]+1 /* (set! errno/range ...) */,C_fix((C_word)ERANGE));
t37=C_mutate((C_word*)lf[209]+1 /* (set! errno/deadlk ...) */,C_fix((C_word)EDEADLK));
t38=C_mutate((C_word*)lf[210]+1 /* (set! errno/nametoolong ...) */,C_fix((C_word)ENAMETOOLONG));
t39=C_mutate((C_word*)lf[211]+1 /* (set! errno/nolck ...) */,C_fix((C_word)ENOLCK));
t40=C_mutate((C_word*)lf[212]+1 /* (set! errno/nosys ...) */,C_fix((C_word)ENOSYS));
t41=C_mutate((C_word*)lf[213]+1 /* (set! errno/notempty ...) */,C_fix((C_word)ENOTEMPTY));
t42=C_mutate((C_word*)lf[214]+1 /* (set! errno/ilseq ...) */,C_fix((C_word)EILSEQ));
t43=C_mutate((C_word*)lf[215]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3593,a[2]=((C_word)li60),tmp=(C_word)a,a+=3,tmp));
t44=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3623,a[2]=((C_word)li61),tmp=(C_word)a,a+=3,tmp);
t45=C_mutate((C_word*)lf[217]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3647,a[2]=t44,a[3]=((C_word)li62),tmp=(C_word)a,a+=4,tmp));
t46=C_mutate((C_word*)lf[218]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3653,a[2]=t44,a[3]=((C_word)li63),tmp=(C_word)a,a+=4,tmp));
t47=C_mutate((C_word*)lf[219]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3659,a[2]=t44,a[3]=((C_word)li64),tmp=(C_word)a,a+=4,tmp));
t48=C_mutate((C_word*)lf[220]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)0));
t49=C_mutate((C_word*)lf[221]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)1));
t50=C_mutate((C_word*)lf[222]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)2));
t51=C_SCHEME_UNDEFINED;
t52=(*a=C_VECTOR_TYPE|1,a[1]=t51,tmp=(C_word)a,a+=2,tmp);
t53=C_SCHEME_UNDEFINED;
t54=(*a=C_VECTOR_TYPE|1,a[1]=t53,tmp=(C_word)a,a+=2,tmp);
t55=C_set_block_item(t52,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3668,a[2]=((C_word)li65),tmp=(C_word)a,a+=3,tmp));
t56=C_set_block_item(t54,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3705,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[231]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3723,a[2]=t52,a[3]=t54,a[4]=((C_word)li67),tmp=(C_word)a,a+=5,tmp));
t58=C_mutate((C_word*)lf[232]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3737,a[2]=t52,a[3]=t54,a[4]=((C_word)li68),tmp=(C_word)a,a+=5,tmp));
t59=C_mutate((C_word*)lf[233]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3751,a[2]=((C_word)li69),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[237]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3786,a[2]=((C_word)li70),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[239]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3816,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[240]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3833,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp));
t63=*((C_word*)lf[241]+1);
t64=C_mutate((C_word*)lf[242]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3853,a[2]=t63,a[3]=((C_word)li75),tmp=(C_word)a,a+=4,tmp));
t65=C_mutate((C_word*)lf[243]+1 /* (set! current-environment ...) */,*((C_word*)lf[242]+1));
t66=C_mutate(&lf[244] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3919,a[2]=((C_word)li76),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[246]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3938,a[2]=((C_word)li77),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[249]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3972,a[2]=((C_word)li78),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[250]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4016,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[252]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4074,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[255]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4141,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[259]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4156,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp));
t73=C_mutate((C_word*)lf[260]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4168,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[261]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4184,a[2]=((C_word)li84),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[262]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4203,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[264]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4218,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t77=*((C_word*)lf[270]+1);
t78=*((C_word*)lf[271]+1);
t79=*((C_word*)lf[272]+1);
t80=*((C_word*)lf[95]+1);
t81=*((C_word*)lf[273]+1);
t82=*((C_word*)lf[274]+1);
t83=C_mutate((C_word*)lf[275]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4277,a[2]=t79,a[3]=t77,a[4]=t80,a[5]=t78,a[6]=t81,a[7]=t82,a[8]=((C_word)li92),tmp=(C_word)a,a+=9,tmp));
t84=C_mutate((C_word*)lf[278]+1 /* (set! spawn/overlay ...) */,C_fix((C_word)P_OVERLAY));
t85=C_mutate((C_word*)lf[279]+1 /* (set! spawn/wait ...) */,C_fix((C_word)P_WAIT));
t86=C_mutate((C_word*)lf[280]+1 /* (set! spawn/nowait ...) */,C_fix((C_word)P_NOWAIT));
t87=C_mutate((C_word*)lf[281]+1 /* (set! spawn/nowaito ...) */,C_fix((C_word)P_NOWAITO));
t88=C_mutate((C_word*)lf[282]+1 /* (set! spawn/detach ...) */,C_fix((C_word)P_DETACH));
t89=*((C_word*)lf[283]+1);
t90=*((C_word*)lf[51]+1);
t91=*((C_word*)lf[106]+1);
t92=*((C_word*)lf[4]+1);
t93=C_mutate(&lf[284] /* (set! $quote-args-list ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4394,a[2]=t92,a[3]=t90,a[4]=t91,a[5]=t89,a[6]=((C_word)li96),tmp=(C_word)a,a+=7,tmp));
t94=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4473,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp);
t95=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4490,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp);
t96=*((C_word*)lf[287]+1);
t97=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4507,a[2]=((C_word)li100),tmp=(C_word)a,a+=3,tmp);
t98=C_mutate(&lf[288] /* (set! $exec-setup ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4557,a[2]=t96,a[3]=t94,a[4]=t95,a[5]=t97,a[6]=((C_word)li101),tmp=(C_word)a,a+=7,tmp));
t99=C_mutate(&lf[289] /* (set! $exec-teardown ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4593,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp));
t100=C_mutate((C_word*)lf[290]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4608,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp));
t101=C_mutate((C_word*)lf[292]+1 /* (set! process-spawn ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4695,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t102=C_mutate((C_word*)lf[294]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4782,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t103=C_mutate((C_word*)lf[295]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4785,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t104=C_mutate((C_word*)lf[299]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4806,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t105=*((C_word*)lf[292]+1);
t106=*((C_word*)lf[297]+1);
t107=C_mutate((C_word*)lf[301]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4812,a[2]=t105,a[3]=((C_word)li116),tmp=(C_word)a,a+=4,tmp));
t108=C_mutate((C_word*)lf[302]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4904,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t109=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5023,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp);
t110=C_mutate((C_word*)lf[309]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5085,a[2]=t109,a[3]=((C_word)li127),tmp=(C_word)a,a+=4,tmp));
t111=C_mutate((C_word*)lf[310]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5165,a[2]=t109,a[3]=((C_word)li132),tmp=(C_word)a,a+=4,tmp));
t112=C_mutate((C_word*)lf[311]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5245,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t113=C_mutate((C_word*)lf[312]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5257,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp));
t114=C_mutate((C_word*)lf[314]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5317,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t115=C_mutate((C_word*)lf[315]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5320,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t116=C_mutate((C_word*)lf[317]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5332,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp));
t117=C_mutate((C_word*)lf[107]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5363,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp));
t118=*((C_word*)lf[275]+1);
t119=*((C_word*)lf[271]+1);
t120=*((C_word*)lf[273]+1);
t121=*((C_word*)lf[321]+1);
t122=*((C_word*)lf[99]+1);
t123=C_mutate((C_word*)lf[322]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5378,a[2]=t122,a[3]=t121,a[4]=t120,a[5]=t118,a[6]=t119,a[7]=((C_word)li153),tmp=(C_word)a,a+=8,tmp));
t124=C_mutate((C_word*)lf[329]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5624,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate((C_word*)lf[331]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5630,a[2]=((C_word)li155),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate((C_word*)lf[332]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5636,a[2]=((C_word)li156),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate((C_word*)lf[333]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5642,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[334]+1 /* (set! current-effective-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5648,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate((C_word*)lf[335]+1 /* (set! current-effective-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5654,a[2]=((C_word)li159),tmp=(C_word)a,a+=3,tmp));
t130=C_mutate((C_word*)lf[336]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5660,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t131=C_mutate((C_word*)lf[337]+1 /* (set! current-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5666,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate((C_word*)lf[338]+1 /* (set! current-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5672,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[339]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5678,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[340]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5684,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[341]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5690,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[342]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5696,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[343]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5702,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[344]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5708,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[345]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5714,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[346]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5720,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[347]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5726,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[348]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5732,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate((C_word*)lf[349]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5738,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate((C_word*)lf[350]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5744,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[351]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5750,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[352]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5756,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[353]+1 /* (set! process-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5762,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate((C_word*)lf[354]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5768,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate((C_word*)lf[355]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5774,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t150=C_mutate((C_word*)lf[356]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5780,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate((C_word*)lf[357]+1 /* (set! set-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5786,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate((C_word*)lf[358]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5792,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate((C_word*)lf[359]+1 /* (set! set-process-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5798,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate((C_word*)lf[360]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5804,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate((C_word*)lf[361]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5810,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate((C_word*)lf[362]+1 /* (set! set-user-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5816,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t157=C_mutate((C_word*)lf[363]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5822,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t158=C_mutate((C_word*)lf[364]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5828,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t159=C_mutate((C_word*)lf[365]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5834,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t160=C_mutate((C_word*)lf[366]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5840,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t161=C_mutate((C_word*)lf[367]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5846,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t162=C_mutate((C_word*)lf[368]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5852,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate((C_word*)lf[369]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5858,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp));
t164=C_mutate((C_word*)lf[370]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5864,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp));
t165=C_mutate((C_word*)lf[371]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5870,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t166=C_set_block_item(lf[372] /* errno/wouldblock */,0,C_fix(0));
t167=C_mutate((C_word*)lf[74]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5877,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t168=C_mutate((C_word*)lf[373]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5880,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t169=C_set_block_item(lf[374] /* map/anonymous */,0,C_fix(0));
t170=C_set_block_item(lf[375] /* map/file */,0,C_fix(0));
t171=C_set_block_item(lf[376] /* map/fixed */,0,C_fix(0));
t172=C_set_block_item(lf[377] /* map/private */,0,C_fix(0));
t173=C_set_block_item(lf[378] /* map/shared */,0,C_fix(0));
t174=C_set_block_item(lf[379] /* open/fsync */,0,C_fix(0));
t175=C_set_block_item(lf[380] /* open/noctty */,0,C_fix(0));
t176=C_set_block_item(lf[381] /* open/nonblock */,0,C_fix(0));
t177=C_set_block_item(lf[382] /* open/sync */,0,C_fix(0));
t178=C_set_block_item(lf[383] /* perm/isgid */,0,C_fix(0));
t179=C_set_block_item(lf[384] /* perm/isuid */,0,C_fix(0));
t180=C_set_block_item(lf[385] /* perm/isvtx */,0,C_fix(0));
t181=C_set_block_item(lf[386] /* prot/exec */,0,C_fix(0));
t182=C_set_block_item(lf[387] /* prot/none */,0,C_fix(0));
t183=C_set_block_item(lf[388] /* prot/read */,0,C_fix(0));
t184=C_set_block_item(lf[389] /* prot/write */,0,C_fix(0));
t185=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t185+1)))(2,t185,C_SCHEME_UNDEFINED);}

/* memory-mapped-file? in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5880(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5880,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* fifo? in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5877(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5877,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* string->time in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5870(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5870,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[371],lf[0]);}

/* utc-time->seconds in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5864(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5864,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[370],lf[0]);}

/* user-information in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5858(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5858,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[369],lf[0]);}

/* unmap-file-from-memory in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5852(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5852,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[368],lf[0]);}

/* terminal-name in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5846(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5846,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[367],lf[0]);}

/* signal-unmask! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5840(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5840,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[366],lf[0]);}

/* signal-masked? in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5834(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5834,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[365],lf[0]);}

/* signal-mask! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5828(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5828,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[364],lf[0]);}

/* signal-mask in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5822(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5822,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[363],lf[0]);}

/* set-user-id! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5816(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5816,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[362],lf[0]);}

/* set-signal-mask! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5810(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5810,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[361],lf[0]);}

/* set-root-directory! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5804(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5804,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[360],lf[0]);}

/* set-process-group-id! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5798(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5798,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[359],lf[0]);}

/* set-groups! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5792(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5792,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[358],lf[0]);}

/* set-group-id! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5786(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5786,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[357],lf[0]);}

/* set-alarm! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5780(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5780,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[356],lf[0]);}

/* read-symbolic-link in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5774(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5774,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[355],lf[0]);}

/* process-signal in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5768(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5768,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[354],lf[0]);}

/* process-group-id in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5762(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5762,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[353],lf[0]);}

/* process-fork in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5756(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5756,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[352],lf[0]);}

/* parent-process-id in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5750(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5750,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[351],lf[0]);}

/* memory-mapped-file-pointer in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5744(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5744,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[350],lf[0]);}

/* initialize-groups in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5738(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5738,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[349],lf[0]);}

/* group-information in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5732(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5732,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[348],lf[0]);}

/* get-groups in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5726(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5726,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[347],lf[0]);}

/* file-unlock in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5720(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5720,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[346],lf[0]);}

/* file-truncate in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5714(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5714,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[345],lf[0]);}

/* file-test-lock in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5708(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5708,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[344],lf[0]);}

/* file-select in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5702(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5702,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[343],lf[0]);}

/* file-lock/blocking in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5696(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5696,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[342],lf[0]);}

/* file-lock in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5690(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5690,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[341],lf[0]);}

/* file-link in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5684(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5684,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[340],lf[0]);}

/* map-file-to-memory in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5678(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5678,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[339],lf[0]);}

/* current-user-id in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5672(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5672,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[338],lf[0]);}

/* current-group-id in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5666(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5666,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[337],lf[0]);}

/* current-effective-user-name in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5660(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5660,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[336],lf[0]);}

/* current-effective-user-id in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5654(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5654,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[335],lf[0]);}

/* current-effective-group-id in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5648(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5648,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[334],lf[0]);}

/* create-symbolic-link in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5642(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5642,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[333],lf[0]);}

/* create-session in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5636(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5636,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[332],lf[0]);}

/* create-fifo in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5630(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5630,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[331],lf[0]);}

/* change-file-owner in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5624(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5624,2,t0,t1);}
/* error */
t2=*((C_word*)lf[330]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[329],lf[0]);}

/* find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5378(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+22)){
C_save_and_reclaim((void*)tr4r,(void*)f_5378r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5378r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5378r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(22);
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5380,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t3,a[8]=t2,a[9]=((C_word)li148),tmp=(C_word)a,a+=10,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5545,a[2]=t5,a[3]=((C_word)li149),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5550,a[2]=t6,a[3]=((C_word)li150),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5555,a[2]=t7,a[3]=((C_word)li152),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t4))){
/* def-action12591324 */
t9=t8;
f_5555(t9,t1);}
else{
t9=C_i_car(t4);
t10=C_i_cdr(t4);
if(C_truep(C_i_nullp(t10))){
/* def-id12601322 */
t11=t7;
f_5550(t11,t1,t9);}
else{
t11=C_i_car(t10);
t12=C_i_cdr(t10);
if(C_truep(C_i_nullp(t12))){
/* def-limit12611319 */
t13=t6;
f_5545(t13,t1,t9,t11);}
else{
t13=C_i_car(t12);
t14=C_i_cdr(t12);
if(C_truep(C_i_nullp(t14))){
/* body12571266 */
t15=t5;
f_5380(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[2],t14);}}}}}

/* def-action1259 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5555(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5555,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5561,a[2]=((C_word)li151),tmp=(C_word)a,a+=3,tmp);
/* def-id12601322 */
t3=((C_word*)t0)[2];
f_5550(t3,t1,t2);}

/* a5560 in def-action1259 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5561(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5561,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* def-id1260 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5550(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5550,NULL,3,t0,t1,t2);}
/* def-limit12611319 */
t3=((C_word*)t0)[2];
f_5545(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit1261 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5545(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5545,NULL,4,t0,t1,t2,t3);}
/* body12571266 */
t4=((C_word*)t0)[2];
f_5380(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5380(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5380,NULL,5,t0,t1,t2,t3,t4);}
t5=C_i_check_string_2(((C_word*)t0)[8],lf[322]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5387,a[2]=((C_word*)t0)[8],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=t2,a[10]=t7,a[11]=((C_word*)t0)[6],a[12]=((C_word*)t0)[7],tmp=(C_word)a,a+=13,tmp);
t9=t4;
if(C_truep(t9)){
if(C_truep(C_fixnump(t4))){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5540,a[2]=t4,a[3]=t7,a[4]=((C_word)li146),tmp=(C_word)a,a+=5,tmp);
t11=t8;
f_5387(t11,t10);}
else{
t10=t4;
t11=t8;
f_5387(t11,t10);}}
else{
t10=t8;
f_5387(t10,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5532,a[2]=((C_word)li147),tmp=(C_word)a,a+=3,tmp));}}

/* f_5532 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5532(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5532,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_5540 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5540(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5540,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5387(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5387,NULL,2,t0,t1);}
t2=C_i_stringp(((C_word*)t0)[12]);
t3=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_5520,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[12],a[13]=((C_word*)t0)[11],tmp=(C_word)a,a+=14,tmp);
if(C_truep(t2)){
t4=t3;
f_5520(2,t4,t2);}
else{
/* posixwin.scm: 2083 regexp? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[328]+1)))(3,*((C_word*)lf[328]+1),t3,((C_word*)t0)[12]);}}

/* k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5520(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5520,2,t0,t1);}
t2=(C_truep(t1)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5521,a[2]=((C_word*)t0)[12],a[3]=((C_word*)t0)[13],a[4]=((C_word)li141),tmp=(C_word)a,a+=5,tmp):((C_word*)t0)[12]);
t3=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5397,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=t2,a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],tmp=(C_word)a,a+=12,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5514,a[2]=t3,a[3]=((C_word*)t0)[9],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2086 make-pathname */
t5=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[2],lf[327]);}

/* k5512 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5514(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2086 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5397,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5399,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=t3,a[11]=((C_word)li145),tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];
f_5399(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5399(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5399,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_5418,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=t4,a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t3,a[11]=t5,a[12]=t1,a[13]=((C_word*)t0)[10],tmp=(C_word)a,a+=14,tmp);
/* posixwin.scm: 2092 directory? */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5418(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5418,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5494,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 2093 pathname-file */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5500,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[12],a[7]=((C_word*)t0)[13],tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 2100 pproc */
t3=((C_word*)t0)[6];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[7]);}}

/* k5498 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5500(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5500,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5507,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 2100 action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixwin.scm: 2101 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_5399(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k5505 in k5498 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2100 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5399(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5494(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5494,2,t0,t1);}
if(C_truep((C_truep(C_i_equalp(t1,lf[323]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(t1,lf[324]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixwin.scm: 2093 loop */
t2=((C_word*)((C_word*)t0)[12])[1];
f_5399(t2,((C_word*)t0)[11],((C_word*)t0)[10],((C_word*)t0)[9]);}
else{
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5433,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[8],tmp=(C_word)a,a+=12,tmp);
/* posixwin.scm: 2094 lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[6]);}}

/* k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5433(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[31],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5433,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[11])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5443,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5445,a[2]=t4,a[3]=((C_word*)t0)[11],a[4]=t6,a[5]=((C_word)li142),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5450,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],a[9]=((C_word)li143),tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5474,a[2]=t6,a[3]=((C_word*)t0)[11],a[4]=t4,a[5]=((C_word)li144),tmp=(C_word)a,a+=6,tmp);
/* ##sys#dynamic-wind */
t11=*((C_word*)lf[326]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5484,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5487,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 2099 pproc */
t4=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[6]);}}

/* k5485 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5487(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm: 2099 action */
t2=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posixwin.scm: 2099 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_5399(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}}

/* k5482 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5484(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2099 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5399(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a5473 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5474,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* a5449 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5450(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5450,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5458,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5472,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2097 make-pathname */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[6],lf[325]);}

/* k5470 in a5449 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5472(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2097 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k5456 in a5449 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5458(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5458,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5462,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5465,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t2,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 2098 pproc */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k5463 in k5456 in a5449 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5465(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm: 2098 action */
t2=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posixwin.scm: 2097 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_5399(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}}

/* k5460 in k5456 in a5449 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2097 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5399(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a5444 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5445,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k5441 in k5431 in k5492 in k5416 in loop in k5395 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5443(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2095 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5399(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_5521 in k5518 in k5385 in body1257 in find-files in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5521(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5521,3,t0,t1,t2);}
/* posixwin.scm: 2084 string-match */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* current-user-name in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5363,2,t0,t1);}
if(C_truep(C_get_user_name())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_username),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5373,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2058 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k5371 in current-user-name in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5373(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2059 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[107],lf[320]);}

/* system-information in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5332(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5332,2,t0,t1);}
if(C_truep(C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5343,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5358,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2049 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k5356 in system-information in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2050 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[317],lf[319]);}

/* k5341 in system-information in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5343(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5343,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5347,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k5345 in k5341 in system-information in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5347(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5347,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5351,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k5349 in k5345 in k5341 in system-information in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5351(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5351,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5355,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* k5353 in k5349 in k5345 in k5341 in system-information in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5355(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5355,2,t0,t1);}
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list(&a,5,lf[318],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* get-host-name in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5320,2,t0,t1);}
if(C_truep(C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm: 2039 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[315],lf[316]);}}

/* sleep in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5317(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5317,3,t0,t1,t2);}
t3=C_sleep(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_fix(0));}

/* process-wait in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5257(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr3r,(void*)f_5257r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5257r(t0,t1,t2,t3);}}

static void C_ccall f_5257r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(9);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
if(C_truep(C_i_nullp(t7))){
t8=C_i_check_exact_2(t2,lf[312]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5278,a[2]=t5,a[3]=t2,a[4]=((C_word)li134),tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5284,a[2]=t2,a[3]=((C_word)li135),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}
else{
/* ##sys#error */
t8=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t1,lf[2],t7);}}

/* a5283 in process-wait in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5284(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5284,5,t0,t1,t2,t3,t4);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5294,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2021 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
/* posixwin.scm: 2023 values */
C_values(5,0,t1,t2,t3,t4);}}

/* k5292 in a5283 in process-wait in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5294(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2022 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[303],lf[312],lf[313],((C_word*)t0)[2]);}

/* a5277 in process-wait in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5278(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5278,2,t0,t1);}
/* posixwin.scm: 2018 ##sys#process-wait */
((C_proc4)C_retrieve_proc(*((C_word*)lf[311]+1)))(4,*((C_word*)lf[311]+1),t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5245(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5245,4,t0,t1,t2,t3);}
if(C_truep(C_process_wait(t2,t3))){
/* posixwin.scm: 2011 values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
/* posixwin.scm: 2012 values */
C_values(5,0,t1,C_fix(-1),C_SCHEME_FALSE,C_SCHEME_FALSE);}}

/* process* in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5165(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_5165r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5165r(t0,t1,t2,t3);}}

static void C_ccall f_5165r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5167,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li128),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5172,a[2]=t4,a[3]=((C_word)li129),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5177,a[2]=t5,a[3]=((C_word)li130),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5182,a[2]=t6,a[3]=((C_word)li131),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-args11931209 */
t8=t7;
f_5182(t8,t1);}
else{
t8=C_i_car(t3);
t9=C_i_cdr(t3);
if(C_truep(C_i_nullp(t9))){
/* def-env11941207 */
t10=t6;
f_5177(t10,t1,t8);}
else{
t10=C_i_car(t9);
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
/* def-exactf11951204 */
t12=t5;
f_5172(t12,t1,t8,t10);}
else{
t12=C_i_car(t11);
t13=C_i_cdr(t11);
if(C_truep(C_i_nullp(t13))){
/* body11911200 */
t14=t4;
f_5167(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-args1193 in process* in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5182(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5182,NULL,2,t0,t1);}
/* def-env11941207 */
t2=((C_word*)t0)[2];
f_5177(t2,t1,C_SCHEME_FALSE);}

/* def-env1194 in process* in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5177(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5177,NULL,3,t0,t1,t2);}
/* def-exactf11951204 */
t3=((C_word*)t0)[2];
f_5172(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1195 in process* in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5172(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5172,NULL,4,t0,t1,t2,t3);}
/* body11911200 */
t4=((C_word*)t0)[2];
f_5167(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1191 in process* in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5167(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5167,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 2005 %process */
f_5023(t1,lf[310],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3,t4);}

/* process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5085(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_5085r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5085r(t0,t1,t2,t3);}}

static void C_ccall f_5085r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5087,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li123),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5092,a[2]=t4,a[3]=((C_word)li124),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5097,a[2]=t5,a[3]=((C_word)li125),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5102,a[2]=t6,a[3]=((C_word)li126),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-args11541170 */
t8=t7;
f_5102(t8,t1);}
else{
t8=C_i_car(t3);
t9=C_i_cdr(t3);
if(C_truep(C_i_nullp(t9))){
/* def-env11551168 */
t10=t6;
f_5097(t10,t1,t8);}
else{
t10=C_i_car(t9);
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
/* def-exactf11561165 */
t12=t5;
f_5092(t12,t1,t8,t10);}
else{
t12=C_i_car(t11);
t13=C_i_cdr(t11);
if(C_truep(C_i_nullp(t13))){
/* body11521161 */
t14=t4;
f_5087(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-args1154 in process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5102(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5102,NULL,2,t0,t1);}
/* def-env11551168 */
t2=((C_word*)t0)[2];
f_5097(t2,t1,C_SCHEME_FALSE);}

/* def-env1155 in process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5097(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5097,NULL,3,t0,t1,t2);}
/* def-exactf11561165 */
t3=((C_word*)t0)[2];
f_5092(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1156 in process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5092(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5092,NULL,4,t0,t1,t2,t3);}
/* body11521161 */
t4=((C_word*)t0)[2];
f_5087(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1152 in process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5087(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5087,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 2002 %process */
f_5023(t1,lf[309],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3,t4);}

/* %process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5023(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5023,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5025,a[2]=t2,a[3]=((C_word)li119),tmp=(C_word)a,a+=4,tmp);
t12=C_i_check_string_2(((C_word*)t8)[1],t2);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5044,a[2]=t11,a[3]=t1,a[4]=t10,a[5]=t3,a[6]=t6,a[7]=t9,a[8]=t8,a[9]=t2,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixwin.scm: 1990 chkstrlst */
t14=t11;
f_5025(t14,t13,((C_word*)t9)[1]);}
else{
t14=C_set_block_item(t10,0,C_SCHEME_TRUE);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5079,a[2]=t13,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1993 ##sys#shell-command-arguments */
((C_proc3)C_retrieve_proc(*((C_word*)lf[299]+1)))(3,*((C_word*)lf[299]+1),t15,((C_word*)t8)[1]);}}

/* k5077 in %process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5079(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5079,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5083,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1994 ##sys#shell-command */
((C_proc2)C_retrieve_proc(*((C_word*)lf[295]+1)))(2,*((C_word*)lf[295]+1),t3);}

/* k5081 in k5077 in %process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5083(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_5044(2,t3,t2);}

/* k5042 in %process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5044,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5047,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixwin.scm: 1995 chkstrlst */
t3=((C_word*)t0)[2];
f_5025(t3,t2,((C_word*)t0)[6]);}
else{
t3=t2;
f_5047(2,t3,C_SCHEME_UNDEFINED);}}

/* k5045 in k5042 in %process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5047(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5047,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5052,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word)li120),tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5058,a[2]=((C_word*)t0)[4],a[3]=((C_word)li121),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a5057 in k5045 in k5042 in %process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5058(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_5058,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixwin.scm: 1998 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixwin.scm: 1999 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a5051 in k5045 in k5042 in %process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5052,2,t0,t1);}
/* posixwin.scm: 1996 ##sys#process */
t2=*((C_word*)lf[302]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,t1,((C_word*)t0)[7],((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[4],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[3],((C_word*)((C_word*)t0)[2])[1]);}

/* chkstrlst in %process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_5025(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5025,NULL,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5034,a[2]=((C_word*)t0)[2],a[3]=((C_word)li118),tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[308]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a5033 in chkstrlst in %process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_5034(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5034,3,t0,t1,t2);}
t3=*((C_word*)lf[307]+1);
/* g11221123 */
t4=t3;
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,((C_word*)t0)[2]);}

/* ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4904(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...){
C_word tmp;
C_word t9;
va_list v;
C_word *a,c2=c;
C_save_rest(t8,c2,9);
if(c<9) C_bad_min_argc_2(c,9,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr9r,(void*)f_4904r,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
else{
a=C_alloc((c-9)*3);
t9=C_restore_rest(a,C_rest_count(0));
f_4904r(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}}

static void C_ccall f_4904r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4908,a[2]=t4,a[3]=t2,a[4]=t6,a[5]=t7,a[6]=t8,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_i_nullp(t9))){
t11=t10;
f_4908(2,t11,C_SCHEME_FALSE);}
else{
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
t12=t10;
f_4908(2,t12,C_i_car(t9));}
else{
/* ##sys#error */
t12=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t12+1)))(4,t12,t10,lf[2],t9);}}}

/* k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4908(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4908,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4911,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4999,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=C_a_i_cons(&a,2,((C_word*)t0)[8],((C_word*)t0)[2]);
/* posixwin.scm: 1962 $quote-args-list */
t5=lf[284];
f_4394(t5,t3,t4,t1);}

/* k4997 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4999(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1962 string-intersperse */
((C_proc3)C_retrieve_proc(*((C_word*)lf[113]+1)))(3,*((C_word*)lf[113]+1),((C_word*)t0)[2],t1);}

/* k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4911(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4911,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(1));
t3=C_i_foreign_fixnum_argumentp(C_fix(-1));
t4=((*(int *)C_data_pointer(t2))=C_unfix(t3),C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(1));
t6=C_i_foreign_fixnum_argumentp(C_fix(-1));
t7=((*(int *)C_data_pointer(t5))=C_unfix(t6),C_SCHEME_UNDEFINED);
t8=C_a_i_bytevector(&a,1,C_fix(1));
t9=C_i_foreign_fixnum_argumentp(C_fix(-1));
t10=((*(int *)C_data_pointer(t8))=C_unfix(t9),C_SCHEME_UNDEFINED);
t11=C_a_i_bytevector(&a,1,C_fix(1));
t12=C_i_foreign_fixnum_argumentp(C_fix(-1));
t13=((*(int *)C_data_pointer(t11))=C_unfix(t12),C_SCHEME_UNDEFINED);
t14=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4967,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=((C_word*)t0)[3],a[5]=t5,a[6]=((C_word*)t0)[4],a[7]=t11,a[8]=((C_word*)t0)[5],a[9]=t2,a[10]=((C_word*)t0)[6],a[11]=t1,a[12]=((C_word*)t0)[7],tmp=(C_word)a,a+=13,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[305]+1)))(6,*((C_word*)lf[305]+1),t14,t2,C_fix(0),C_SCHEME_FALSE,lf[306]);}

/* k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4967(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4967,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4971,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],tmp=(C_word)a,a+=14,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[305]+1)))(6,*((C_word*)lf[305]+1),t2,((C_word*)t0)[5],C_fix(0),C_SCHEME_FALSE,lf[306]);}

/* k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4971(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4971,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4975,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[305]+1)))(6,*((C_word*)lf[305]+1),t2,((C_word*)t0)[3],C_fix(0),C_SCHEME_FALSE,lf[306]);}

/* k4973 in k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4975(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4975,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|15,a[1]=(C_word)f_4979,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],tmp=(C_word)a,a+=16,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[305]+1)))(6,*((C_word*)lf[305]+1),t2,((C_word*)t0)[7],C_fix(0),C_SCHEME_FALSE,lf[306]);}

/* k4977 in k4973 in k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4979(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4979,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|16,a[1]=(C_word)f_4983,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],a[16]=((C_word*)t0)[15],tmp=(C_word)a,a+=17,tmp);
t3=(C_truep(((C_word*)t0)[6])?C_fix(0):C_fix(1));
t4=(C_truep(((C_word*)t0)[4])?C_fix(0):C_fix(2));
if(C_truep(((C_word*)t0)[8])){
/* posixwin.scm: 1969 + */
C_plus(5,0,t2,t3,t4,C_fix(0));}
else{
/* posixwin.scm: 1969 + */
C_plus(5,0,t2,t3,t4,C_fix(4));}}

/* k4981 in k4977 in k4973 in k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4983(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4983,2,t0,t1);}
t2=((C_word*)t0)[16];
t3=((C_word*)t0)[15];
t4=((C_word*)t0)[14];
t5=((C_word*)t0)[13];
t6=((C_word*)t0)[12];
t7=((C_word*)t0)[11];
t8=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_4846,a[2]=t3,a[3]=((C_word*)t0)[15],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=t1,a[14]=t7,a[15]=t6,a[16]=t5,a[17]=t4,tmp=(C_word)a,a+=18,tmp);
if(C_truep(t2)){
t9=C_i_foreign_string_argumentp(t2);
/* ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_4846(2,t9,C_SCHEME_FALSE);}}

/* k4844 in k4981 in k4977 in k4973 in k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4846(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4846,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_4850,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=t1,a[13]=((C_word*)t0)[13],a[14]=((C_word*)t0)[14],a[15]=((C_word*)t0)[15],a[16]=((C_word*)t0)[16],a[17]=((C_word*)t0)[17],tmp=(C_word)a,a+=18,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
t4=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}
else{
t3=t2;
f_4850(2,t3,C_SCHEME_FALSE);}}

/* k4848 in k4844 in k4981 in k4977 in k4973 in k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4850(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4850,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[17])?C_i_foreign_pointer_argumentp(((C_word*)t0)[17]):C_SCHEME_FALSE);
t3=(C_truep(((C_word*)t0)[16])?C_i_foreign_pointer_argumentp(((C_word*)t0)[16]):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[15])?C_i_foreign_pointer_argumentp(((C_word*)t0)[15]):C_SCHEME_FALSE);
t5=(C_truep(((C_word*)t0)[14])?C_i_foreign_pointer_argumentp(((C_word*)t0)[14]):C_SCHEME_FALSE);
t6=C_i_foreign_fixnum_argumentp(((C_word*)t0)[13]);
if(C_truep(stub1011(C_SCHEME_UNDEFINED,((C_word*)t0)[12],t1,C_SCHEME_FALSE,t2,t3,t4,t5,t6))){
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4940,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm: 1972 open-input-file* */
((C_proc3)C_retrieve_proc(*((C_word*)lf[231]+1)))(3,*((C_word*)lf[231]+1),t7,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))));}
else{
t8=t7;
f_4940(2,t8,C_SCHEME_FALSE);}}
else{
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4960,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1977 ##sys#update-errno */
t8=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}

/* k4958 in k4848 in k4844 in k4981 in k4977 in k4973 in k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4960(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1978 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[303],((C_word*)t0)[3],lf[304],((C_word*)t0)[2]);}

/* k4938 in k4848 in k4844 in k4981 in k4977 in k4973 in k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4940,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4944,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1973 open-output-file* */
((C_proc3)C_retrieve_proc(*((C_word*)lf[232]+1)))(3,*((C_word*)lf[232]+1),t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_4944(2,t3,C_SCHEME_FALSE);}}

/* k4942 in k4938 in k4848 in k4844 in k4981 in k4977 in k4973 in k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4944(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4944,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4948,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1975 open-input-file* */
((C_proc3)C_retrieve_proc(*((C_word*)lf[231]+1)))(3,*((C_word*)lf[231]+1),t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
/* posixwin.scm: 1971 values */
C_values(6,0,((C_word*)t0)[6],((C_word*)t0)[5],t1,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))),C_SCHEME_FALSE);}}

/* k4946 in k4942 in k4938 in k4848 in k4844 in k4981 in k4977 in k4973 in k4969 in k4965 in k4909 in k4906 in ##sys#process in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4948(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1971 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))),t1);}

/* process-run in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4812(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4812r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4812r(t0,t1,t2,t3);}}

static void C_ccall f_4812r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_i_car(t3):C_SCHEME_FALSE);
if(C_truep(t5)){
/* posixwin.scm: 1933 process-spawn */
t6=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t6))(5,t6,t1,*((C_word*)lf[280]+1),t2,t5);}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4829,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1934 ##sys#shell-command */
((C_proc2)C_retrieve_proc(*((C_word*)lf[295]+1)))(2,*((C_word*)lf[295]+1),t6);}}

/* k4827 in process-run in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4829(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4829,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4833,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1934 ##sys#shell-command-arguments */
((C_proc3)C_retrieve_proc(*((C_word*)lf[299]+1)))(3,*((C_word*)lf[299]+1),t2,((C_word*)t0)[2]);}

/* k4831 in k4827 in process-run in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4833(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1934 process-spawn */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],*((C_word*)lf[280]+1),((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4806(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4806,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_list(&a,2,lf[300],t2));}

/* ##sys#shell-command in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4785(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4785,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4789,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1917 get-environment-variable */
((C_proc3)C_retrieve_proc(*((C_word*)lf[297]+1)))(3,*((C_word*)lf[297]+1),t2,lf[298]);}

/* k4787 in ##sys#shell-command in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4789(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4789,2,t0,t1);}
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
if(C_truep(C_get_shlcmd())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_mpointer(&a,(void*)C_shlcmd),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4801,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1921 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}}

/* k4799 in k4787 in ##sys#shell-command in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4801(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1922 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[295],lf[296]);}

/* current-process-id in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4782,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub986(C_SCHEME_UNDEFINED));}

/* process-spawn in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4695(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_4695r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4695r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4695r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4697,a[2]=t3,a[3]=t2,a[4]=((C_word)li108),tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4709,a[2]=t5,a[3]=((C_word)li109),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4714,a[2]=t6,a[3]=((C_word)li110),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4719,a[2]=t7,a[3]=((C_word)li111),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t4))){
/* def-arglst962979 */
t9=t8;
f_4719(t9,t1);}
else{
t9=C_i_car(t4);
t10=C_i_cdr(t4);
if(C_truep(C_i_nullp(t10))){
/* def-envlst963977 */
t11=t7;
f_4714(t11,t1,t9);}
else{
t11=C_i_car(t10);
t12=C_i_cdr(t10);
if(C_truep(C_i_nullp(t12))){
/* def-exactf964974 */
t13=t6;
f_4709(t13,t1,t9,t11);}
else{
t13=C_i_car(t12);
t14=C_i_cdr(t12);
if(C_truep(C_i_nullp(t14))){
/* body960969 */
t15=t5;
f_4697(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[2],t14);}}}}}

/* def-arglst962 in process-spawn in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4719(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4719,NULL,2,t0,t1);}
/* def-envlst963977 */
t2=((C_word*)t0)[2];
f_4714(t2,t1,C_SCHEME_FALSE);}

/* def-envlst963 in process-spawn in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4714(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4714,NULL,3,t0,t1,t2);}
/* def-exactf964974 */
t3=((C_word*)t0)[2];
f_4709(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf964 in process-spawn in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4709(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4709,NULL,4,t0,t1,t2,t3);}
/* body960969 */
t4=((C_word*)t0)[2];
f_4697(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body960 in process-spawn in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4697(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4697,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4701,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1908 $exec-setup */
t6=lf[288];
f_4557(t6,t5,lf[292],((C_word*)t0)[2],t2,t3,t4);}

/* k4699 in body960 in process-spawn in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4701(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(((C_word*)t0)[5])){
t2=C_spawnvpe(((C_word*)t0)[4],t1);
/* posixwin.scm: 1909 $exec-teardown */
f_4593(((C_word*)t0)[3],lf[292],lf[293],((C_word*)t0)[2],t2);}
else{
t2=C_spawnvp(((C_word*)t0)[4],t1);
/* posixwin.scm: 1909 $exec-teardown */
f_4593(((C_word*)t0)[3],lf[292],lf[293],((C_word*)t0)[2],t2);}}

/* process-execute in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4608(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr3r,(void*)f_4608r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4608r(t0,t1,t2,t3);}}

static void C_ccall f_4608r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(16);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4610,a[2]=t2,a[3]=((C_word)li103),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4622,a[2]=t4,a[3]=((C_word)li104),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4627,a[2]=t5,a[3]=((C_word)li105),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4632,a[2]=t6,a[3]=((C_word)li106),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-arglst920937 */
t8=t7;
f_4632(t8,t1);}
else{
t8=C_i_car(t3);
t9=C_i_cdr(t3);
if(C_truep(C_i_nullp(t9))){
/* def-envlst921935 */
t10=t6;
f_4627(t10,t1,t8);}
else{
t10=C_i_car(t9);
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
/* def-exactf922932 */
t12=t5;
f_4622(t12,t1,t8,t10);}
else{
t12=C_i_car(t11);
t13=C_i_cdr(t11);
if(C_truep(C_i_nullp(t13))){
/* body918927 */
t14=t4;
f_4610(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-arglst920 in process-execute in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4632(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4632,NULL,2,t0,t1);}
/* def-envlst921935 */
t2=((C_word*)t0)[2];
f_4627(t2,t1,C_SCHEME_FALSE);}

/* def-envlst921 in process-execute in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4627(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4627,NULL,3,t0,t1,t2);}
/* def-exactf922932 */
t3=((C_word*)t0)[2];
f_4622(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf922 in process-execute in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4622(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4622,NULL,4,t0,t1,t2,t3);}
/* body918927 */
t4=((C_word*)t0)[2];
f_4610(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body918 in process-execute in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4610(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4610,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4614,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1903 $exec-setup */
t6=lf[288];
f_4557(t6,t5,lf[290],((C_word*)t0)[2],t2,t3,t4);}

/* k4612 in body918 in process-execute in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=C_execve(t1);
/* posixwin.scm: 1904 $exec-teardown */
f_4593(((C_word*)t0)[3],lf[290],lf[291],((C_word*)t0)[2],t2);}
else{
t2=C_execvp(t1);
/* posixwin.scm: 1904 $exec-teardown */
f_4593(((C_word*)t0)[3],lf[290],lf[291],((C_word*)t0)[2],t2);}}

/* $exec-teardown in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4593(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4593,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4597,a[2]=t4,a[3]=t3,a[4]=t2,a[5]=t1,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1895 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k4595 in $exec-teardown in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=C_free_exec_args();
t3=C_free_exec_env();
t4=C_eqp(((C_word*)t0)[6],C_fix(-1));
if(C_truep(t4)){
/* posixwin.scm: 1899 ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t5=((C_word*)t0)[6];
t6=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* $exec-setup in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4557(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4557,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=C_i_check_string_2(t3,t2);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4564,a[2]=t6,a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t5,a[7]=t2,a[8]=((C_word*)t0)[5],a[9]=t3,a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 1887 pathname-strip-directory */
t9=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t9))(3,t9,t8,t3);}

/* k4562 in $exec-setup in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4564(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4564,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4567,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=C_block_size(t1);
/* posixwin.scm: 1888 setarg */
t4=((C_word*)t0)[4];
f_4473(5,t4,t2,C_fix(0),t1,t3);}

/* k4565 in k4562 in $exec-setup in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4567(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4567,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4570,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4584,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[7],a[4]=t2,a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1889 $quote-args-list */
t4=lf[284];
f_4394(t4,t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixwin.scm: 1889 build-exec-argvec */
f_4507(t2,((C_word*)t0)[7],C_SCHEME_FALSE,((C_word*)t0)[4],C_fix(1));}}

/* k4582 in k4565 in k4562 in $exec-setup in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1889 build-exec-argvec */
f_4507(((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2],C_fix(1));}

/* k4568 in k4565 in k4562 in $exec-setup in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4570,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4573,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1890 build-exec-argvec */
f_4507(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* k4571 in k4568 in k4565 in k4562 in $exec-setup in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4573(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4573,2,t0,t1);}
t2=C_flushall();
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4580,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1892 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t3,((C_word*)t0)[2]);}

/* k4578 in k4571 in k4568 in k4565 in k4562 in $exec-setup in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1892 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* build-exec-argvec in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4507(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4507,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(t3)){
t6=C_i_check_list_2(t3,t2);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4519,a[2]=t8,a[3]=t2,a[4]=t4,a[5]=((C_word)li99),tmp=(C_word)a,a+=6,tmp));
t10=((C_word*)t8)[1];
f_4519(t10,t1,t3,t5);}
else{
/* posixwin.scm: 1884 argvec-setter */
t6=t4;
((C_proc5)C_retrieve_proc(t6))(5,t6,t1,t5,C_SCHEME_FALSE,C_fix(0));}}

/* doloop871 in build-exec-argvec in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4519(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4519,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm: 1880 argvec-setter */
t4=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t4))(5,t4,t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4538,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixwin.scm: 1883 argvec-setter */
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,t3,t4,t7);}}

/* k4536 in doloop871 in build-exec-argvec in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4538(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_i_cdr(((C_word*)t0)[5]);
t3=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)((C_word*)t0)[3])[1];
f_4519(t4,((C_word*)t0)[2],t2,t3);}

/* setenv in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4490(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4490,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(t3)?C_i_foreign_block_argumentp(t3):C_SCHEME_FALSE);
t7=C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub860(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* setarg in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4473(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4473,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(t3)?C_i_foreign_block_argumentp(t3):C_SCHEME_FALSE);
t7=C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub850(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* $quote-args-list in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4394(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4394,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=t2;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4399,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li94),tmp=(C_word)a,a+=6,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4437,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li95),tmp=(C_word)a,a+=6,tmp));
t8=((C_word*)t6)[1];
f_4437(t8,t1,t2,C_SCHEME_END_OF_LIST);}}

/* loop in $quote-args-list in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4437(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4437,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm: 1861 reverse */
t4=*((C_word*)lf[116]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}
else{
t4=C_i_car(t2);
t5=C_i_cdr(t2);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4465,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4468,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t3,a[6]=t4,a[7]=t6,a[8]=((C_word*)t0)[3],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1866 needs-quoting? */
t8=((C_word*)t0)[2];
f_4399(t8,t7,t4);}}

/* k4466 in loop in $quote-args-list in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4468(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4468,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1866 string-append */
t2=((C_word*)t0)[8];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[7],lf[285],((C_word*)t0)[6],lf[286]);}
else{
t2=C_a_i_cons(&a,2,((C_word*)t0)[6],((C_word*)t0)[5]);
/* posixwin.scm: 1863 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4437(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}}

/* k4463 in loop in $quote-args-list in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4465(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4465,2,t0,t1);}
t2=C_a_i_cons(&a,2,t1,((C_word*)t0)[5]);
/* posixwin.scm: 1863 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4437(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* needs-quoting? in $quote-args-list in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4399(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4399,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4403,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1853 string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t2);}

/* k4401 in needs-quoting? in $quote-args-list in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4403,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4408,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=t1,a[7]=((C_word)li93),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_4408(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k4401 in needs-quoting? in $quote-args-list in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4408(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4408,NULL,3,t0,t1,t2);}
t3=C_eqp(t2,((C_word*)t0)[6]);
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4421,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4432,a[2]=t4,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1857 string-ref */
t6=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],t2);}}

/* k4430 in loop in k4401 in needs-quoting? in $quote-args-list in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4432(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1857 char-whitespace? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4419 in loop in k4401 in needs-quoting? in $quote-args-list in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4421(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}
else{
t2=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1858 loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_4408(t3,((C_word*)t0)[4],t2);}}

/* glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4277(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_4277r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4277r(t0,t1,t2);}}

static void C_ccall f_4277r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(12);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4283,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t4,a[8]=((C_word*)t0)[7],a[9]=((C_word)li91),tmp=(C_word)a,a+=10,tmp));
t6=((C_word*)t4)[1];
f_4283(t6,t1,t2);}

/* conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4283(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4283,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4298,a[2]=t3,a[3]=((C_word*)t0)[8],a[4]=((C_word)li87),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4304,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,a[9]=((C_word)li90),tmp=(C_word)a,a+=10,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4304(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4304,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4308,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4383,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t7=t3;
/* posixwin.scm: 1815 make-pathname */
t8=((C_word*)t0)[6];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}
else{
/* posixwin.scm: 1815 make-pathname */
t7=((C_word*)t0)[6];
((C_proc5)C_retrieve_proc(t7))(5,t7,t6,C_SCHEME_FALSE,lf[277],t4);}}

/* k4381 in a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4383(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1815 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4306 in a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4308,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4311,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1816 regexp */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,t1);}

/* k4309 in k4306 in a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4311,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4318,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[5])){
t3=((C_word*)t0)[5];
/* posixwin.scm: 1817 directory */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,t3,C_SCHEME_TRUE);}
else{
/* posixwin.scm: 1817 directory */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,lf[276],C_SCHEME_TRUE);}}

/* k4316 in k4309 in k4306 in a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4318(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4318,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4320,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word)li89),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_4320(t5,((C_word*)t0)[2],t1);}

/* loop in k4316 in k4309 in k4306 in a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4320(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4320,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[8]);
/* posixwin.scm: 1818 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_4283(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4337,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
t4=C_i_car(t2);
/* posixwin.scm: 1819 string-match */
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k4335 in loop in k4316 in k4309 in k4306 in a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4337,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4341,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word)li88),tmp=(C_word)a,a+=7,tmp);
/* g810811 */
t3=t2;
f_4341(t3,((C_word*)t0)[2],t1);}
else{
t2=C_i_cdr(((C_word*)t0)[6]);
/* posixwin.scm: 1821 loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_4320(t3,((C_word*)t0)[2],t2);}}

/* g810 in k4335 in loop in k4316 in k4309 in k4306 in a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4341(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4341,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4349,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_i_car(t2);
/* posixwin.scm: 1820 make-pathname */
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}

/* k4347 in g810 in k4335 in loop in k4316 in k4309 in k4306 in a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4349(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4349,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4353,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=C_i_cdr(((C_word*)t0)[3]);
/* posixwin.scm: 1820 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4320(t4,t2,t3);}

/* k4351 in k4347 in g810 in k4335 in loop in k4316 in k4309 in k4306 in a4303 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4353(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4353,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a4297 in conc-loop in glob in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4298,2,t0,t1);}
/* posixwin.scm: 1814 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* set-buffering-mode! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4218(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4218r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4218r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4218r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4222,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1786 ##sys#check-port */
t6=*((C_word*)lf[137]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[264]);}

/* k4220 in set-buffering-mode! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4222(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4222,2,t0,t1);}
t2=C_i_pairp(((C_word*)t0)[5]);
t3=(C_truep(t2)?C_i_car(((C_word*)t0)[5]):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4228,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=C_eqp(t4,lf[266]);
if(C_truep(t6)){
t7=t5;
f_4228(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=C_eqp(t4,lf[267]);
if(C_truep(t7)){
t8=C_fix((C_word)_IOLBF);
t9=t5;
f_4228(2,t9,t8);}
else{
t8=C_eqp(t4,lf[268]);
if(C_truep(t8)){
t9=t5;
f_4228(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm: 1792 ##sys#error */
t9=*((C_word*)lf[62]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[264],lf[269],((C_word*)t0)[4],((C_word*)t0)[2]);}}}}

/* k4226 in k4220 in set-buffering-mode! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4228(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4228,2,t0,t1);}
t2=C_i_check_exact_2(((C_word*)t0)[4],lf[264]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4237,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=C_slot(((C_word*)t0)[2],C_fix(7));
t5=C_eqp(lf[78],t4);
if(C_truep(t5)){
t6=C_setvbuf(((C_word*)t0)[2],t1,((C_word*)t0)[4]);
t7=t3;
f_4237(t7,C_fixnum_lessp(t6,C_fix(0)));}
else{
t6=t3;
f_4237(t6,C_SCHEME_TRUE);}}

/* k4235 in k4226 in k4220 in set-buffering-mode! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_4237(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm: 1798 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[5],lf[264],lf[265],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* terminal-size in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4203(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4203,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4210,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1775 terminal-port? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[261]+1)))(3,*((C_word*)lf[261]+1),t3,t2);}

/* k4208 in terminal-size in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4210(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm: 1776 values */
C_values(4,0,((C_word*)t0)[3],C_fix(0),C_fix(0));}
else{
/* posixwin.scm: 1777 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[262],lf[263],((C_word*)t0)[2]);}}

/* terminal-port? in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4184(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4184,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4188,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1770 ##sys#check-port */
t4=*((C_word*)lf[137]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[261]);}

/* k4186 in terminal-port? in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4188,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4191,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1771 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[236]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k4189 in k4186 in terminal-port? in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4191(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}
else{
t3=C_tty_portp(((C_word*)t0)[2]);
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* _exit in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4168(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_4168r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4168r(t0,t1,t2);}}

static void C_ccall f_4168r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
if(C_truep(C_i_pairp(t2))){
t3=C_i_car(t2);
t4=t1;
t5=C_i_foreign_fixnum_argumentp(t3);
t6=t4;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,stub742(C_SCHEME_UNDEFINED,t5));}
else{
t3=t1;
t4=C_i_foreign_fixnum_argumentp(C_fix(0));
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub742(C_SCHEME_UNDEFINED,t4));}}

/* local-timezone-abbreviation in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4156(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4156,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,stub737(t2),C_fix(0));}

/* local-time->seconds in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4141(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4141,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4145,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1751 check-time-vector */
f_3919(t3,lf[255],t2);}

/* k4143 in local-time->seconds in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4145(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4145,2,t0,t1);}
t2=C_a_mktime(&a,1,((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4151,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1753 fp= */
t4=*((C_word*)lf[257]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[258]);}

/* k4149 in k4143 in local-time->seconds in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4151(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm: 1754 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[255],lf[256],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}}

/* time->string in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4074(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4074r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4074r(t0,t1,t2,t3);}}

static void C_ccall f_4074r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4078,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_4078(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_4078(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k4076 in time->string in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4078(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4078,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4081,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1739 check-time-vector */
f_3919(t2,lf[252],((C_word*)t0)[2]);}

/* k4079 in k4076 in time->string in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4081(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4081,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=C_i_check_string_2(((C_word*)t0)[4],lf[252]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4090,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4100,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1743 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4103,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,stub701(t4,t3),C_fix(0));}}

/* k4101 in k4079 in k4076 in time->string in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4103(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1747 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1748 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[252],lf[254],((C_word*)t0)[2]);}}

/* k4098 in k4079 in k4076 in time->string in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4100(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4100,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],stub707(t3,t2,t1),C_fix(0));}

/* k4088 in k4079 in k4076 in time->string in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4090(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixwin.scm: 1744 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[252],lf[253],((C_word*)t0)[2]);}}

/* seconds->string in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4016(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_4016r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4016r(t0,t1,t2);}}

static void C_ccall f_4016r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4020,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm: 1729 current-seconds */
((C_proc2)C_retrieve_proc(*((C_word*)lf[248]+1)))(2,*((C_word*)lf[248]+1),t3);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=t3;
f_4020(2,t5,C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k4018 in seconds->string in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4020,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4023,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=t1;
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_integer_argumentp(t3);
t6=stub681(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* k4021 in k4018 in seconds->string in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_4023(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1732 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1733 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[250],lf[251],((C_word*)t0)[2]);}}

/* seconds->utc-time in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3972(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3972r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3972r(t0,t1,t2);}}

static void C_ccall f_3972r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3976,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm: 1723 current-seconds */
((C_proc2)C_retrieve_proc(*((C_word*)lf[248]+1)))(2,*((C_word*)lf[248]+1),t3);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=C_i_car(t2);
t6=C_i_check_number_2(t5,lf[249]);
/* posixwin.scm: 1725 ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[247]+1)))(4,*((C_word*)lf[247]+1),t1,t5,C_SCHEME_TRUE);}
else{
/* ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k3974 in seconds->utc-time in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3976(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[249]);
/* posixwin.scm: 1725 ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[247]+1)))(4,*((C_word*)lf[247]+1),((C_word*)t0)[2],t1,C_SCHEME_TRUE);}

/* seconds->local-time in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3938(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3938r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3938r(t0,t1,t2);}}

static void C_ccall f_3938r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3942,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm: 1719 current-seconds */
((C_proc2)C_retrieve_proc(*((C_word*)lf[248]+1)))(2,*((C_word*)lf[248]+1),t3);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=C_i_car(t2);
t6=C_i_check_number_2(t5,lf[246]);
/* posixwin.scm: 1721 ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[247]+1)))(4,*((C_word*)lf[247]+1),t1,t5,C_SCHEME_FALSE);}
else{
/* ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k3940 in seconds->local-time in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3942(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[246]);
/* posixwin.scm: 1721 ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[247]+1)))(4,*((C_word*)lf[247]+1),((C_word*)t0)[2],t1,C_SCHEME_FALSE);}

/* check-time-vector in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3919(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3919,NULL,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm: 1717 ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[245],t3);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* get-environment-variables in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3853(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3853,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3859,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li74),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_3859(t5,t1,C_fix(0));}

/* loop in get-environment-variables in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3859(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3859,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3863,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub634(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3861 in loop in get-environment-variables in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3863(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3863,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3871,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word)li73),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3871(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3861 in loop in get-environment-variables in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3871(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3871,NULL,3,t0,t1,t2);}
t3=C_eqp(C_make_character(61),C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3897,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 1706 substring */
t5=((C_word*)t0)[3];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posixwin.scm: 1707 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3895 in scan in k3861 in loop in get-environment-variables in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3897(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3897,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3901,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=C_block_size(((C_word*)t0)[3]);
/* posixwin.scm: 1706 substring */
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k3899 in k3895 in scan in k3861 in loop in get-environment-variables in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3901(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3901,2,t0,t1);}
t2=C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3889,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1706 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_3859(t5,t3,t4);}

/* k3887 in k3899 in k3895 in scan in k3861 in loop in get-environment-variables in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3889(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3889,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3833(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3833,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[240]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3841,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1694 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3839 in unsetenv in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3816(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3816,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[239]);
t5=C_i_check_string_2(t3,lf[239]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3827,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1689 ##sys#make-c-string */
t7=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k3825 in setenv in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3827(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3827,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3831,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1689 ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3829 in k3825 in setenv in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* duplicate-fileno in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3786(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_3786r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3786r(t0,t1,t2,t3);}}

static void C_ccall f_3786r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_exact_2(t2,*((C_word*)lf[237]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3793,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_3793(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[237]);
t8=t5;
f_3793(t8,C_dup2(t2,t6));}}

/* k3791 in duplicate-fileno in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3793(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3793,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3796,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3802,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1678 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k3800 in k3791 in duplicate-fileno in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3802(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1679 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[237],lf[238],((C_word*)t0)[2]);}

/* k3794 in k3791 in duplicate-fileno in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3796(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3751(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3751,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3755,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1660 ##sys#check-port */
t4=*((C_word*)lf[137]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[233]);}

/* k3753 in port->fileno in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3755,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3784,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1661 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[236]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k3782 in k3753 in port->fileno in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3784(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3784,2,t0,t1);}
if(C_truep(C_i_zerop(t1))){
/* posixwin.scm: 1667 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[46],lf[233],lf[234],((C_word*)t0)[2]);}
else{
t2=C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3764,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3770,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1664 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}}

/* k3768 in k3782 in k3753 in port->fileno in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3770(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1665 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[233],lf[235],((C_word*)t0)[2]);}

/* k3762 in k3782 in k3753 in port->fileno in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3737(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3737r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3737r(t0,t1,t2,t3);}}

static void C_ccall f_3737r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[232]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3749,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1656 mode */
f_3668(t5,C_SCHEME_FALSE,t3);}

/* k3747 in open-output-file* in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3749(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3749,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1656 check */
f_3705(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3723(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3723r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3723r(t0,t1,t2,t3);}}

static void C_ccall f_3723r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[231]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3735,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1652 mode */
f_3668(t5,C_SCHEME_TRUE,t3);}

/* k3733 in open-input-file* in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3735(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3735,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1652 check */
f_3705(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3705(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3705,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3709,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1643 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k3707 in check in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3709(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3709,2,t0,t1);}
if(C_truep(C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1645 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[37],lf[229],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3721,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1646 ##sys#make-port */
t3=*((C_word*)lf[127]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[128]+1),lf[230],lf[78]);}}

/* k3719 in k3707 in check in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3721(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=t1;
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* mode in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3668(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3668,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3676,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_pairp(t3))){
t5=C_i_car(t3);
t6=C_eqp(t5,lf[223]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixwin.scm: 1638 ##sys#error */
t8=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[224],t5);}
else{
/* posixwin.scm: 1634 ##sys#make-c-string */
t8=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t1,lf[225]);}}
else{
/* posixwin.scm: 1639 ##sys#error */
t7=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[226],t5);}}
else{
if(C_truep(t2)){
/* posixwin.scm: 1634 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,lf[227]);}
else{
/* posixwin.scm: 1634 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,lf[228]);}}}

/* k3674 in mode in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1634 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-execute-access? in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3659(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3659,3,t0,t1,t2);}
/* posixwin.scm: 1618 check */
f_3623(t1,t2,C_fix((C_word)2),lf[219]);}

/* file-write-access? in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3653(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3653,3,t0,t1,t2);}
/* posixwin.scm: 1617 check */
f_3623(t1,t2,C_fix((C_word)4),lf[218]);}

/* file-read-access? in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3647(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3647,3,t0,t1,t2);}
/* posixwin.scm: 1616 check */
f_3623(t1,t2,C_fix((C_word)2),lf[217]);}

/* check in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3623(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3623,NULL,4,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3641,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3645,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1613 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t7,t2);}

/* k3643 in check in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1613 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3639 in check in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3641,2,t0,t1);}
t2=C_test_access(t1,((C_word*)t0)[3]);
t3=C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3633,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t3);}
else{
/* posixwin.scm: 1614 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k3631 in k3639 in check in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3633(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-mode in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3593(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3593,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[215]);
t5=C_i_check_exact_2(t3,lf[215]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3617,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3621,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1602 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t7,t2);}

/* k3619 in change-file-mode in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3621(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1602 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3615 in change-file-mode in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3617(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3617,2,t0,t1);}
t2=C_chmod(t1,((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3609,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1603 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3607 in k3615 in change-file-mode in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3609(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1604 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[215],lf[216],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#interrupt-hook in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3537(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3537,4,t0,t1,t2,t3);}
t4=C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3547,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1510 h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixwin.scm: 1512 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k3545 in ##sys#interrupt-hook in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1511 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3524(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3524,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[176]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,C_i_vector_set(((C_word*)t0)[2],t2,t3));}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_i_vector_set(((C_word*)t0)[2],t2,t3));}}

/* signal-handler in k3511 in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3515(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3515,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[175]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3439(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3439r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3439r(t0,t1,t2);}}

static void C_ccall f_3439r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3443,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t4=t3;
f_3443(2,t4,C_fixnum_or(*((C_word*)lf[21]+1),*((C_word*)lf[23]+1)));}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=t3;
f_3443(2,t5,C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k3441 in create-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3443(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3443,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3446,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_lessp(C_pipe(C_SCHEME_FALSE,t1),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3455,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1447 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
/* posixwin.scm: 1449 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}}

/* k3453 in k3441 in create-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3455(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1448 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[37],lf[145],lf[146]);}

/* k3444 in k3441 in create-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3446(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1449 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3419(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3419r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3419r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3419r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[144]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3423,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3421 in with-output-to-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3423(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3423,2,t0,t1);}
t2=C_mutate((C_word*)lf[144]+1 /* (set! ##sys#standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3429,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li54),tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1432 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3428 in k3421 in with-output-to-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3429(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3429r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3429r(t0,t1,t2);}}

static void C_ccall f_3429r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3433,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1434 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3431 in a3428 in k3421 in with-output-to-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3433(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[144]+1 /* (set! ##sys#standard-output ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3399(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3399r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3399r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3399r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[142]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3403,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3401 in with-input-from-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3403,2,t0,t1);}
t2=C_mutate((C_word*)lf[142]+1 /* (set! ##sys#standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3409,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li52),tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1422 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3408 in k3401 in with-input-from-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3409(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3409r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3409r(t0,t1,t2);}}

static void C_ccall f_3409r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3413,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1424 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3411 in a3408 in k3401 in with-input-from-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[142]+1 /* (set! ##sys#standard-input ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3375(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3375r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3375r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3375r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3379,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3377 in call-with-output-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3379(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3379,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3384,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li49),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3390,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li50),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1412 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3389 in k3377 in call-with-output-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3390(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3390r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3390r(t0,t1,t2);}}

static void C_ccall f_3390r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3394,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1415 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3392 in a3389 in k3377 in call-with-output-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3383 in k3377 in call-with-output-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3384(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3384,2,t0,t1);}
/* posixwin.scm: 1413 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3351(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3351r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3351r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3351r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3355,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3353 in call-with-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3355(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3355,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3360,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li46),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3366,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li47),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1404 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3365 in k3353 in call-with-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3366(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3366r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3366r(t0,t1,t2);}}

static void C_ccall f_3366r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3370,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1407 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3368 in a3365 in k3353 in call-with-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3370(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3359 in k3353 in call-with-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3360(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3360,2,t0,t1);}
/* posixwin.scm: 1405 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3332(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3332,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3336,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1391 ##sys#check-port */
t4=*((C_word*)lf[137]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[135]);}

/* k3334 in close-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3336(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3336,2,t0,t1);}
t2=close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3339,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1393 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3337 in k3334 in close-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3339(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
/* posixwin.scm: 1394 ##sys#signal-hook */
t3=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[37],lf[135],lf[136],((C_word*)t0)[2]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* open-output-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3296(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_3296r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3296r(t0,t1,t2,t3);}}

static void C_ccall f_3296r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[134]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[131]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3310,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[131]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3317,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1386 ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
t9=C_eqp(t6,lf[132]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3327,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1387 ##sys#make-c-string */
t11=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t11+1)))(3,t11,t10,t2);}
else{
/* posixwin.scm: 1361 ##sys#error */
t10=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[133],t6);}}}

/* k3325 in open-output-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3327(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3327,2,t0,t1);}
t2=open_binary_output_pipe(&a,1,t1);
/* posixwin.scm: 1383 check */
f_3242(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* k3315 in open-output-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3317,2,t0,t1);}
t2=open_text_output_pipe(&a,1,t1);
/* posixwin.scm: 1383 check */
f_3242(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* k3308 in open-output-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3310(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1383 check */
f_3242(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3260(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_3260r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3260r(t0,t1,t2,t3);}}

static void C_ccall f_3260r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[130]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[131]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3274,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[131]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3281,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1376 ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
t9=C_eqp(t6,lf[132]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3291,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1377 ##sys#make-c-string */
t11=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t11+1)))(3,t11,t10,t2);}
else{
/* posixwin.scm: 1361 ##sys#error */
t10=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[133],t6);}}}

/* k3289 in open-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3291(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3291,2,t0,t1);}
t2=open_binary_input_pipe(&a,1,t1);
/* posixwin.scm: 1373 check */
f_3242(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k3279 in open-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3281,2,t0,t1);}
t2=open_text_input_pipe(&a,1,t1);
/* posixwin.scm: 1373 check */
f_3242(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k3272 in open-input-pipe in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3274(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1373 check */
f_3242(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3242(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3242,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3246,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1363 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k3244 in check in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3246(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3246,2,t0,t1);}
if(C_truep(C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1365 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[37],lf[126],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3258,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1366 ##sys#make-port */
t3=*((C_word*)lf[127]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[128]+1),lf[129],lf[78]);}}

/* k3256 in k3244 in check in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3258(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=t1;
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2867(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[20],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2867,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[112]);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2874,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],tmp=(C_word)a,a+=7,tmp);
t5=C_block_size(t2);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3007,a[2]=t4,a[3]=((C_word*)t0)[9],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1300 cwd */
t8=((C_word*)t0)[5];
f_2811(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3013,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t2,a[8]=t4,a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t8=C_block_size(t2);
if(C_truep(C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3214,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1302 sref */
t10=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t10))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_3013(t9,C_SCHEME_FALSE);}}}

/* k3212 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3214(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_eqp(C_make_character(47),t1);
t3=((C_word*)t0)[2];
f_3013(t3,(C_truep(t2)?t2:C_eqp(C_make_character(92),t1)));}

/* k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3013(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3013,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3020,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3024,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1304 cwd */
t4=((C_word*)t0)[6];
f_2811(t4,t3);}
else{
t2=C_block_size(((C_word*)t0)[7]);
t3=C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3037,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1307 cwd */
t5=((C_word*)t0)[6];
f_2811(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3043,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3189,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[4],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3200,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1308 sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[7],C_fix(0));}}}

/* k3198 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3200(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1308 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k3187 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3189(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3189,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3196,a[2]=((C_word*)t0)[4],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1309 sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[4];
f_3043(t2,C_SCHEME_FALSE);}}

/* k3194 in k3187 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3196(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_eqp(C_make_character(47),t1);
t3=((C_word*)t0)[2];
f_3043(t3,(C_truep(t2)?t2:C_eqp(C_make_character(92),t1)));}

/* k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3043(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3043,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3050,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3066,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1311 cwd */
t4=((C_word*)t0)[5];
f_2811(t4,t3);}
else{
t2=C_block_size(((C_word*)t0)[7]);
t3=C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3079,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1317 cwd */
t5=((C_word*)t0)[5];
f_2811(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3085,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3161,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[4],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3182,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1318 sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[7],C_fix(0));}}}

/* k3180 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3182(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1318 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3159 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3161,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3167,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3178,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1319 sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3085(t2,C_SCHEME_FALSE);}}

/* k3176 in k3159 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1319 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3165 in k3159 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3167,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3174,a[2]=((C_word*)t0)[4],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1320 sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_3085(t2,C_SCHEME_FALSE);}}

/* k3172 in k3165 in k3159 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_eqp(C_make_character(47),t1);
t3=((C_word*)t0)[2];
f_3085(t3,(C_truep(t2)?t2:C_eqp(C_make_character(92),t1)));}

/* k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_3085(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3085,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
f_2874(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3091,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3137,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3158,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1322 sref */
t5=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[8],C_fix(0));}}

/* k3156 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3158(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1322 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k3135 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3137,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3143,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3154,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1323 sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3091(2,t2,C_SCHEME_FALSE);}}

/* k3152 in k3135 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3154(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1323 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3141 in k3135 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3143(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3143,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3150,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1324 sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_3091(2,t2,C_SCHEME_FALSE);}}

/* k3148 in k3141 in k3135 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3150(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1324 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3089 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3091(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3091,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3098,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1326 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t2,((C_word*)t0)[4],C_fix(1),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3134,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1330 sref */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[4],C_fix(0));}}

/* k3132 in k3089 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3134(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3134,2,t0,t1);}
t2=C_eqp(C_make_character(47),t1);
t3=(C_truep(t2)?t2:C_eqp(C_make_character(92),t1));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3119,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3123,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1332 cwd */
t6=((C_word*)t0)[2];
f_2811(t6,t5);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3130,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1335 cwd */
t5=((C_word*)t0)[2];
f_2811(t5,t4);}}

/* k3128 in k3132 in k3089 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3130(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1335 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[125],((C_word*)t0)[2]);}

/* k3121 in k3132 in k3089 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3123(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1332 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k3117 in k3132 in k3089 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3119(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1331 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k3096 in k3089 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3098(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3098,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3102,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1328 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t2,((C_word*)t0)[2],C_fix(3),t3);}

/* k3100 in k3096 in k3089 in k3083 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3102(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1325 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[124],t1);}

/* k3077 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3079(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1317 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[123],((C_word*)t0)[2]);}

/* k3064 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3066(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1311 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[2],t1,C_fix(0),C_fix(3));}

/* k3048 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3050,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3054,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1313 user */
t3=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k3052 in k3048 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3054(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3054,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3058,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1314 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k3056 in k3052 in k3048 in k3041 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1310 sappend */
t2=((C_word*)t0)[5];
((C_proc6)C_retrieve_proc(t2))(6,t2,((C_word*)t0)[4],((C_word*)t0)[3],lf[122],((C_word*)t0)[2],t1);}

/* k3035 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1307 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[121],((C_word*)t0)[2]);}

/* k3022 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1304 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k3018 in k3011 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1303 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k3005 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_3007(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1300 sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],t1,lf[120]);}

/* k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2874(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2874,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2881,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2993,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=C_block_size(t1);
/* posixwin.scm: 1336 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t3,t1,C_fix(3),t4);}

/* k2991 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2993(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=*((C_word*)lf[88]+1);
/* g374375 */
t3=t2;
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[2],t1,lf[119]);}

/* k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2881,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2883,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word)li40),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_2883(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2883(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2883,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2890,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 1338 null? */
t5=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2890(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2890,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2896,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1339 null? */
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[7]);}
else{
t2=C_i_cdr(((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2965,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t4=C_i_car(((C_word*)t0)[4]);
/* posixwin.scm: 1350 string=? */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,lf[118],t4);}}

/* k2963 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2965(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2965,2,t0,t1);}
if(C_truep(t1)){
t2=C_i_cdr(((C_word*)t0)[7]);
/* posixwin.scm: 1348 loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_2883(t3,((C_word*)t0)[5],((C_word*)t0)[4],t2);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2974,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=C_i_car(((C_word*)t0)[3]);
/* posixwin.scm: 1352 string=? */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,lf[117],t3);}}

/* k2972 in k2963 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2974(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2974,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[6];
/* posixwin.scm: 1348 loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_2883(t3,((C_word*)t0)[4],((C_word*)t0)[3],t2);}
else{
t2=C_i_car(((C_word*)t0)[2]);
t3=C_a_i_cons(&a,2,t2,((C_word*)t0)[6]);
/* posixwin.scm: 1348 loop */
t4=((C_word*)((C_word*)t0)[5])[1];
f_2883(t4,((C_word*)t0)[4],((C_word*)t0)[3],t3);}}

/* k2894 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2896(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2896,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1340 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[6],((C_word*)t0)[5],C_fix(0),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2943,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=C_block_size(((C_word*)t0)[5]);
t4=C_a_i_minus(&a,2,t3,C_fix(1));
/* posixwin.scm: 1341 sref */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,((C_word*)t0)[5],t4);}}

/* k2941 in k2894 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2943(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2943,2,t0,t1);}
t2=C_eqp(C_make_character(47),t1);
t3=(C_truep(t2)?t2:C_eqp(C_make_character(92),t1));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2912,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1343 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t4,((C_word*)t0)[2],C_fix(0),C_fix(3));}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2931,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1346 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t4,((C_word*)t0)[2],C_fix(0),C_fix(3));}}

/* k2929 in k2941 in k2894 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2931(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2931,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2935,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2939,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1347 reverse */
t4=*((C_word*)lf[116]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2937 in k2929 in k2941 in k2894 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2939(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=*((C_word*)lf[113]+1);
/* g383384 */
t3=t2;
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[2],t1,lf[114]);}

/* k2933 in k2929 in k2941 in k2894 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2935(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1345 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2910 in k2941 in k2894 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2912,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2916,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2920,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=C_a_i_cons(&a,2,lf[115],((C_word*)t0)[2]);
/* posixwin.scm: 1344 reverse */
t5=*((C_word*)lf[116]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}

/* k2918 in k2910 in k2941 in k2894 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2920(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=*((C_word*)lf[113]+1);
/* g383384 */
t3=t2;
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[2],t1,lf[114]);}

/* k2914 in k2910 in k2941 in k2894 in k2888 in loop in k2879 in k2872 in canonical-path in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2916(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1342 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* cwd in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2811(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2811,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2815,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2820,a[2]=((C_word*)t0)[2],a[3]=((C_word)li38),tmp=(C_word)a,a+=4,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[111]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a2819 in cwd in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2820(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2820,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2826,a[2]=t2,a[3]=((C_word)li33),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2844,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li37),tmp=(C_word)a,a+=5,tmp);
/* with-exception-handler */
((C_proc4)C_retrieve_proc(*((C_word*)lf[110]+1)))(4,*((C_word*)lf[110]+1),t1,t3,t4);}

/* a2843 in a2819 in cwd in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2844,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2850,a[2]=((C_word*)t0)[3],a[3]=((C_word)li34),tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2856,a[2]=((C_word*)t0)[2],a[3]=((C_word)li36),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t2,t3);}

/* a2855 in a2843 in a2819 in cwd in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2856(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2856r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2856r(t0,t1,t2);}}

static void C_ccall f_2856r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2862,a[2]=t2,a[3]=((C_word)li35),tmp=(C_word)a,a+=4,tmp);
/* k399404 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a2861 in a2855 in a2843 in a2819 in cwd in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2862(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2862,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a2849 in a2843 in a2819 in cwd in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2850(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2850,2,t0,t1);}
/* posixwin.scm: 1295 cw */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* a2825 in a2819 in cwd in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2826(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2826,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2832,a[2]=t2,a[3]=((C_word)li32),tmp=(C_word)a,a+=4,tmp);
/* k399404 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a2831 in a2825 in a2819 in cwd in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2832(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2832,2,t0,t1);}
if(C_truep(C_i_structurep(((C_word*)t0)[2],lf[108]))){
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[109]);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,lf[109]);}}

/* k2813 in cwd in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2815(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* g402403 */
t2=t1;
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* current-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2744(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2744r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2744r(t0,t1,t2);}}

static void C_ccall f_2744r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2748,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
t4=t3;
f_2748(2,t4,C_SCHEME_FALSE);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=t3;
f_2748(2,t5,C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k2746 in current-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2748(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2748,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1273 change-directory */
((C_proc3)C_retrieve_proc(*((C_word*)lf[90]+1)))(3,*((C_word*)lf[90]+1),((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2757,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1274 make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}}

/* k2755 in k2746 in current-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2757(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2757,2,t0,t1);}
t2=C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2760,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1276 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2758 in k2755 in k2746 in current-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
/* posixwin.scm: 1278 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[4]);}
else{
/* posixwin.scm: 1279 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[37],lf[98],lf[101]);}}

/* directory? in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2717(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2717,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[99]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2724,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2738,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2742,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1266 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t6,t2);}

/* k2740 in directory? in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2742(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1266 ##sys#platform-fixup-pathname */
((C_proc3)C_retrieve_proc(*((C_word*)lf[100]+1)))(3,*((C_word*)lf[100]+1),((C_word*)t0)[2],t1);}

/* k2736 in directory? in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2738(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1265 ##sys#file-info */
t2=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2722 in directory? in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2724(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2557(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_2557r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2557r(t0,t1,t2);}}

static void C_ccall f_2557r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(12);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2559,a[2]=((C_word*)t0)[2],a[3]=((C_word)li26),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2660,a[2]=t3,a[3]=((C_word)li27),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2665,a[2]=t4,a[3]=((C_word)li28),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
/* def-spec286328 */
t6=t5;
f_2665(t6,t1);}
else{
t6=C_i_car(t2);
t7=C_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
/* def-show-dotfiles?287326 */
t8=t4;
f_2660(t8,t1,t6);}
else{
t8=C_i_car(t7);
t9=C_i_cdr(t7);
if(C_truep(C_i_nullp(t9))){
/* body284292 */
t10=t3;
f_2559(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[2],t9);}}}}

/* def-spec286 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2665(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2665,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2673,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1236 current-directory */
((C_proc2)C_retrieve_proc(*((C_word*)lf[98]+1)))(2,*((C_word*)lf[98]+1),t2);}

/* k2671 in def-spec286 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2673(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?287326 */
t2=((C_word*)t0)[3];
f_2660(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?287 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2660(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2660,NULL,3,t0,t1,t2);}
/* body284292 */
t3=((C_word*)t0)[2];
f_2559(t3,t1,t2,C_SCHEME_FALSE);}

/* body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2559(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2559,NULL,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[95]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2566,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1238 make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2566(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2566,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2569,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1239 ##sys#make-pointer */
((C_proc2)C_retrieve_proc(*((C_word*)lf[97]+1)))(2,*((C_word*)lf[97]+1),t2);}

/* k2567 in k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2569(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2569,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2572,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1240 ##sys#make-pointer */
((C_proc2)C_retrieve_proc(*((C_word*)lf[97]+1)))(2,*((C_word*)lf[97]+1),t2);}

/* k2570 in k2567 in k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2572(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2572,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2576,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2659,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1241 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t3,((C_word*)t0)[4]);}

/* k2657 in k2570 in k2567 in k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1241 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2574 in k2570 in k2567 in k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2576(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2576,2,t0,t1);}
t2=C_opendir(t1,((C_word*)t0)[7]);
if(C_truep(C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2585,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1244 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2593,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word)li25),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_2593(t6,((C_word*)t0)[6]);}}

/* loop in k2574 in k2570 in k2567 in k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2593(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2593,NULL,2,t0,t1);}
t2=C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep(C_null_pointerp(((C_word*)t0)[5]))){
t3=C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2603,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1253 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k2601 in loop in k2574 in k2570 in k2567 in k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2603,2,t0,t1);}
t2=C_i_string_ref(t1,C_fix(0));
t3=C_i_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?C_i_string_ref(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2615,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_2615(t8,t7);}
else{
t8=C_eqp(t4,C_make_character(46));
if(C_truep(t8)){
t9=C_eqp(((C_word*)t0)[5],C_fix(2));
t10=t5;
f_2615(t10,(C_truep(t9)?t9:C_i_not(((C_word*)t0)[2])));}
else{
t9=t5;
f_2615(t9,C_i_not(((C_word*)t0)[2]));}}}
else{
t7=t5;
f_2615(t7,C_SCHEME_FALSE);}}

/* k2613 in k2601 in loop in k2574 in k2570 in k2567 in k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2615(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2615,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1260 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2593(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2625,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1261 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2593(t3,t2);}}

/* k2623 in k2613 in k2601 in loop in k2574 in k2570 in k2567 in k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2625(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2625,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2583 in k2574 in k2570 in k2567 in k2564 in body284 in directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1245 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[95],lf[96],((C_word*)t0)[2]);}

/* delete-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2532(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2532,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[92]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2539,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2555,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1226 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t5,t2);}

/* k2553 in delete-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1226 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2537 in delete-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2539(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2539,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2542,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(0),C_rmdir(t1));
if(C_truep(t3)){
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[2]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2548,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1228 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2546 in k2537 in delete-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1229 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[92],lf[93],((C_word*)t0)[2]);}

/* k2540 in k2537 in delete-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2507(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2507,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[90]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2514,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2530,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1216 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t5,t2);}

/* k2528 in change-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1216 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2512 in change-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2514(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2514,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2517,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(0),C_chdir(t1));
if(C_truep(t3)){
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[2]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2523,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1218 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2521 in k2512 in change-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2523(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1219 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[90],lf[91],((C_word*)t0)[2]);}

/* k2515 in k2512 in change-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2517(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2350(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_2350r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2350r(t0,t1,t2,t3);}}

static void C_ccall f_2350r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2354,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_2354(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_2354(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2354(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2354,2,t0,t1);}
t2=C_i_check_string_2(((C_word*)t0)[3],lf[84]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2360,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1207 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t3,((C_word*)t0)[3]);}

/* k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2360(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2360,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2363,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=t1;
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2368,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1196 string-split */
((C_proc4)C_retrieve_proc(*((C_word*)lf[88]+1)))(4,*((C_word*)lf[88]+1),t4,t3,lf[89]);}
else{
t3=t1;
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2483,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1179 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t3);}}

/* k2481 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2483(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2483,2,t0,t1);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[4]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2475,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1180 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2473 in k2481 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2475(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1181 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[84],lf[85],((C_word*)t0)[2]);}

/* k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2368(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2368,2,t0,t1);}
t2=C_i_car(t1);
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_i_cdr(t1);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2380,a[2]=t7,a[3]=t4,a[4]=((C_word)li21),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_2380(t9,((C_word*)t0)[2],t5);}

/* loop217 in k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2380(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2380,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2388,a[2]=((C_word*)t0)[3],a[3]=((C_word)li20),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2450,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t5=C_slot(t2,C_fix(0));
/* g224225 */
t6=t3;
f_2388(t6,t4,t5);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2448 in loop217 in k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2450(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[4],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_2380(t3,((C_word*)t0)[2],t2);}

/* g224 in loop217 in k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2388(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2388,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2393,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1200 string-append */
t4=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],lf[87],t2);}

/* k2391 in g224 in loop217 in k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2393,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
t4=((C_word*)((C_word*)t0)[3])[1];
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2422,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2406,a[2]=t4,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1185 file-exists? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[86]+1)))(3,*((C_word*)lf[86]+1),t6,t4);}

/* k2404 in k2391 in g224 in loop217 in k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2406(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2406,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2409,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1186 ##sys#file-info */
t3=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_2422(t2,C_SCHEME_FALSE);}}

/* k2407 in k2404 in k2391 in g224 in loop217 in k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2409(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
f_2422(t3,C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
f_2422(t2,C_SCHEME_FALSE);}}

/* k2420 in k2391 in g224 in loop217 in k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2422(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2422,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2441,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1179 ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k2439 in k2420 in k2391 in g224 in loop217 in k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2441(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2441,2,t0,t1);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2433,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1180 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2431 in k2439 in k2420 in k2391 in g224 in loop217 in k2366 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2433(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1181 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[84],lf[85],((C_word*)t0)[2]);}

/* k2361 in k2358 in k2352 in create-directory in k2346 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* set-file-position! in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2288(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2288r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2288r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2288r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=C_i_pairp(t4);
t6=(C_truep(t5)?C_i_car(t4):C_fix((C_word)SEEK_SET));
t7=C_i_check_exact_2(t3,lf[76]);
t8=C_i_check_exact_2(t6,lf[76]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2301,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_negativep(t3))){
/* posixwin.scm: 1149 ##sys#signal-hook */
t10=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[81],lf[76],lf[82],t3,t2);}
else{
t10=t9;
f_2301(2,t10,C_SCHEME_UNDEFINED);}}

/* k2299 in set-file-position! in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2301(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2301,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2307,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2313,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1150 port? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[80]+1)))(3,*((C_word*)lf[80]+1),t3,((C_word*)t0)[4]);}

/* k2311 in k2299 in set-file-position! in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2313(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[5],C_fix(7));
t3=C_eqp(t2,lf[78]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
f_2307(2,t5,t4);}
else{
t4=((C_word*)t0)[2];
f_2307(2,t4,C_SCHEME_FALSE);}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
t2=C_lseek(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
f_2307(2,t3,t2);}
else{
/* posixwin.scm: 1156 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[46],lf[76],lf[79],((C_word*)t0)[5]);}}}

/* k2305 in k2299 in set-file-position! in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2307(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixwin.scm: 1157 posix-error */
t2=lf[5];
f_1903(7,t2,((C_word*)t0)[4],lf[37],lf[76],lf[77],((C_word*)t0)[3],((C_word*)t0)[2]);}}

/* f6623 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f6623(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6623,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[75]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* f6629 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f6629(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6629,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[74]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* f6635 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f6635(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6635,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[73]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* f6641 in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f6641(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6641,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[72]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* symbolic-link? in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2259(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2259,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[71]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* regular-file? in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2236(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2236,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[69]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2243,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2257,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1126 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t5,t2);}

/* k2255 in regular-file? in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2257(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1126 ##sys#file-info */
t2=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2241 in regular-file? in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2243(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_eqp(C_fix(0),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* file-permissions in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2230(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2230,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2234,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1122 ##sys#stat */
f_2133(t3,t2);}

/* k2232 in file-permissions in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2224(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2224,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2228,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1121 ##sys#stat */
f_2133(t3,t2);}

/* k2226 in file-owner in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2228(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2218(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2218,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2222,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1120 ##sys#stat */
f_2133(t3,t2);}

/* k2220 in file-change-time in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2222(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2222,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2212(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2212,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2216,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1119 ##sys#stat */
f_2133(t3,t2);}

/* k2214 in file-access-time in k2208 in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2216(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2216,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-size in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2202(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2202,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2206,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1102 ##sys#stat */
f_2133(t3,t2);}

/* k2204 in file-size in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2171(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_2171r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2171r(t0,t1,t2,t3);}}

static void C_ccall f_2171r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2175,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_2175(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_2175(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k2173 in file-stat in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2175(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2175,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2178,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1096 ##sys#stat */
f_2133(t2,((C_word*)t0)[2]);}

/* k2176 in k2173 in file-stat in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2178,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(0),C_fix(0),C_fix(0),C_fix(0)));}

/* ##sys#stat in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_fcall f_2133(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2133,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2137,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t4=t3;
f_2137(2,t4,C_fstat(t2));}
else{
if(C_truep(C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2162,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2166,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1089 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t5,t2);}
else{
/* posixwin.scm: 1090 ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[46],lf[60],t2);}}}

/* k2164 in ##sys#stat in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2166(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1089 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2160 in ##sys#stat in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2162(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_stat(t1);
t3=((C_word*)t0)[2];
f_2137(2,t3,t2);}

/* k2135 in ##sys#stat in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2137,2,t0,t1);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2146,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1092 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k2144 in k2135 in ##sys#stat in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1093 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[37],lf[59],((C_word*)t0)[2]);}

/* file-mkstemp in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2095(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2095,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[52]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2102,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1058 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2100 in file-mkstemp in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2102(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2102,2,t0,t1);}
t2=C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2105,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1060 string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t1);}

/* k2103 in k2100 in file-mkstemp in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2105(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2105,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2108,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2125,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1062 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_2108(2,t4,C_SCHEME_UNDEFINED);}}

/* k2123 in k2103 in k2100 in file-mkstemp in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2125(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1063 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[52],lf[54],((C_word*)t0)[2]);}

/* k2106 in k2103 in k2100 in file-mkstemp in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2108,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2115,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1064 ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k2113 in k2106 in k2103 in k2100 in file-mkstemp in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2115(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1064 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2053(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2053r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2053r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2053r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=C_i_check_exact_2(t2,lf[48]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2060,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;
f_2060(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1045 ##sys#signal-hook */
t7=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[46],lf[48],lf[50],t3);}}
else{
/* posixwin.scm: 1045 ##sys#signal-hook */
t7=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[46],lf[48],lf[50],t3);}}

/* k2058 in file-write in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2060,2,t0,t1);}
t2=C_i_pairp(((C_word*)t0)[5]);
t3=(C_truep(t2)?C_i_car(((C_word*)t0)[5]):C_block_size(((C_word*)t0)[4]));
t4=C_i_check_exact_2(t3,lf[48]);
t5=C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2069,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2075,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1050 ##sys#update-errno */
t9=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t5);}}

/* k2073 in k2058 in file-write in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2075(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1051 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[48],lf[49],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2067 in k2058 in file-write in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2069(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2008(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2008r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2008r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2008r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=C_i_check_exact_2(t2,lf[44]);
t6=C_i_check_exact_2(t3,lf[44]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2018,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t7;
f_2018(2,t8,C_i_car(t4));}
else{
/* posixwin.scm: 1032 make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k2016 in file-read in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2018,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2021,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t1))){
if(C_truep(C_byteblockp(t1))){
t3=t2;
f_2021(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1034 ##sys#signal-hook */
t3=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,lf[46],lf[44],lf[47],t1);}}
else{
/* posixwin.scm: 1034 ##sys#signal-hook */
t3=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,lf[46],lf[44],lf[47],t1);}}

/* k2019 in k2016 in file-read in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2021,2,t0,t1);}
t2=C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2024,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2033,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1037 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_list(&a,2,((C_word*)t0)[4],t2));}}

/* k2031 in k2019 in k2016 in file-read in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2033(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1038 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[44],lf[45],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2022 in k2019 in k2016 in file-read in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2024,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1990(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1990,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[41]);
if(C_truep(C_fixnum_lessp(C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2003,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1024 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2001 in file-close in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_2003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1025 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[41],lf[42],((C_word*)t0)[2]);}

/* file-open in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1949(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4r,(void*)f_1949r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1949r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1949r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=C_i_pairp(t4);
t6=(C_truep(t5)?C_i_car(t4):((C_word*)t0)[2]);
t7=C_i_check_string_2(t2,lf[36]);
t8=C_i_check_exact_2(t3,lf[36]);
t9=C_i_check_exact_2(t6,lf[36]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1966,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1982,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1014 ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[40]+1)))(3,*((C_word*)lf[40]+1),t11,t2);}

/* k1980 in file-open in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1014 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1964 in file-open in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1966(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1966,2,t0,t1);}
t2=C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1969,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1975,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1016 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* k1973 in k1964 in file-open in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1975(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1017 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[37],lf[36],lf[38],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1967 in k1964 in file-open in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1969(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* posix-error in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1903(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_1903r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_1903r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_1903r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1907,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 945  ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1905 in posix-error in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1907,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1914,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1918,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t1);
t6=stub12(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k1916 in k1905 in posix-error in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1918(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 946  string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[7],t1);}

/* k1912 in k1905 in posix-error in k1889 in k1886 in k1883 in k1880 in k1877 in k1874 in k1871 */
static void C_ccall f_1914(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[6]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[472] = {
{"toplevel:posixwin_scm",(void*)C_posix_toplevel},
{"f_1873:posixwin_scm",(void*)f_1873},
{"f_1876:posixwin_scm",(void*)f_1876},
{"f_1879:posixwin_scm",(void*)f_1879},
{"f_1882:posixwin_scm",(void*)f_1882},
{"f_1885:posixwin_scm",(void*)f_1885},
{"f_1888:posixwin_scm",(void*)f_1888},
{"f_1891:posixwin_scm",(void*)f_1891},
{"f_5942:posixwin_scm",(void*)f_5942},
{"f_5978:posixwin_scm",(void*)f_5978},
{"f_5955:posixwin_scm",(void*)f_5955},
{"f_5965:posixwin_scm",(void*)f_5965},
{"f_5936:posixwin_scm",(void*)f_5936},
{"f_5940:posixwin_scm",(void*)f_5940},
{"f_2210:posixwin_scm",(void*)f_2210},
{"f_5899:posixwin_scm",(void*)f_5899},
{"f_5915:posixwin_scm",(void*)f_5915},
{"f_5903:posixwin_scm",(void*)f_5903},
{"f_5906:posixwin_scm",(void*)f_5906},
{"f_2348:posixwin_scm",(void*)f_2348},
{"f_3513:posixwin_scm",(void*)f_3513},
{"f_5880:posixwin_scm",(void*)f_5880},
{"f_5877:posixwin_scm",(void*)f_5877},
{"f_5870:posixwin_scm",(void*)f_5870},
{"f_5864:posixwin_scm",(void*)f_5864},
{"f_5858:posixwin_scm",(void*)f_5858},
{"f_5852:posixwin_scm",(void*)f_5852},
{"f_5846:posixwin_scm",(void*)f_5846},
{"f_5840:posixwin_scm",(void*)f_5840},
{"f_5834:posixwin_scm",(void*)f_5834},
{"f_5828:posixwin_scm",(void*)f_5828},
{"f_5822:posixwin_scm",(void*)f_5822},
{"f_5816:posixwin_scm",(void*)f_5816},
{"f_5810:posixwin_scm",(void*)f_5810},
{"f_5804:posixwin_scm",(void*)f_5804},
{"f_5798:posixwin_scm",(void*)f_5798},
{"f_5792:posixwin_scm",(void*)f_5792},
{"f_5786:posixwin_scm",(void*)f_5786},
{"f_5780:posixwin_scm",(void*)f_5780},
{"f_5774:posixwin_scm",(void*)f_5774},
{"f_5768:posixwin_scm",(void*)f_5768},
{"f_5762:posixwin_scm",(void*)f_5762},
{"f_5756:posixwin_scm",(void*)f_5756},
{"f_5750:posixwin_scm",(void*)f_5750},
{"f_5744:posixwin_scm",(void*)f_5744},
{"f_5738:posixwin_scm",(void*)f_5738},
{"f_5732:posixwin_scm",(void*)f_5732},
{"f_5726:posixwin_scm",(void*)f_5726},
{"f_5720:posixwin_scm",(void*)f_5720},
{"f_5714:posixwin_scm",(void*)f_5714},
{"f_5708:posixwin_scm",(void*)f_5708},
{"f_5702:posixwin_scm",(void*)f_5702},
{"f_5696:posixwin_scm",(void*)f_5696},
{"f_5690:posixwin_scm",(void*)f_5690},
{"f_5684:posixwin_scm",(void*)f_5684},
{"f_5678:posixwin_scm",(void*)f_5678},
{"f_5672:posixwin_scm",(void*)f_5672},
{"f_5666:posixwin_scm",(void*)f_5666},
{"f_5660:posixwin_scm",(void*)f_5660},
{"f_5654:posixwin_scm",(void*)f_5654},
{"f_5648:posixwin_scm",(void*)f_5648},
{"f_5642:posixwin_scm",(void*)f_5642},
{"f_5636:posixwin_scm",(void*)f_5636},
{"f_5630:posixwin_scm",(void*)f_5630},
{"f_5624:posixwin_scm",(void*)f_5624},
{"f_5378:posixwin_scm",(void*)f_5378},
{"f_5555:posixwin_scm",(void*)f_5555},
{"f_5561:posixwin_scm",(void*)f_5561},
{"f_5550:posixwin_scm",(void*)f_5550},
{"f_5545:posixwin_scm",(void*)f_5545},
{"f_5380:posixwin_scm",(void*)f_5380},
{"f_5532:posixwin_scm",(void*)f_5532},
{"f_5540:posixwin_scm",(void*)f_5540},
{"f_5387:posixwin_scm",(void*)f_5387},
{"f_5520:posixwin_scm",(void*)f_5520},
{"f_5514:posixwin_scm",(void*)f_5514},
{"f_5397:posixwin_scm",(void*)f_5397},
{"f_5399:posixwin_scm",(void*)f_5399},
{"f_5418:posixwin_scm",(void*)f_5418},
{"f_5500:posixwin_scm",(void*)f_5500},
{"f_5507:posixwin_scm",(void*)f_5507},
{"f_5494:posixwin_scm",(void*)f_5494},
{"f_5433:posixwin_scm",(void*)f_5433},
{"f_5487:posixwin_scm",(void*)f_5487},
{"f_5484:posixwin_scm",(void*)f_5484},
{"f_5474:posixwin_scm",(void*)f_5474},
{"f_5450:posixwin_scm",(void*)f_5450},
{"f_5472:posixwin_scm",(void*)f_5472},
{"f_5458:posixwin_scm",(void*)f_5458},
{"f_5465:posixwin_scm",(void*)f_5465},
{"f_5462:posixwin_scm",(void*)f_5462},
{"f_5445:posixwin_scm",(void*)f_5445},
{"f_5443:posixwin_scm",(void*)f_5443},
{"f_5521:posixwin_scm",(void*)f_5521},
{"f_5363:posixwin_scm",(void*)f_5363},
{"f_5373:posixwin_scm",(void*)f_5373},
{"f_5332:posixwin_scm",(void*)f_5332},
{"f_5358:posixwin_scm",(void*)f_5358},
{"f_5343:posixwin_scm",(void*)f_5343},
{"f_5347:posixwin_scm",(void*)f_5347},
{"f_5351:posixwin_scm",(void*)f_5351},
{"f_5355:posixwin_scm",(void*)f_5355},
{"f_5320:posixwin_scm",(void*)f_5320},
{"f_5317:posixwin_scm",(void*)f_5317},
{"f_5257:posixwin_scm",(void*)f_5257},
{"f_5284:posixwin_scm",(void*)f_5284},
{"f_5294:posixwin_scm",(void*)f_5294},
{"f_5278:posixwin_scm",(void*)f_5278},
{"f_5245:posixwin_scm",(void*)f_5245},
{"f_5165:posixwin_scm",(void*)f_5165},
{"f_5182:posixwin_scm",(void*)f_5182},
{"f_5177:posixwin_scm",(void*)f_5177},
{"f_5172:posixwin_scm",(void*)f_5172},
{"f_5167:posixwin_scm",(void*)f_5167},
{"f_5085:posixwin_scm",(void*)f_5085},
{"f_5102:posixwin_scm",(void*)f_5102},
{"f_5097:posixwin_scm",(void*)f_5097},
{"f_5092:posixwin_scm",(void*)f_5092},
{"f_5087:posixwin_scm",(void*)f_5087},
{"f_5023:posixwin_scm",(void*)f_5023},
{"f_5079:posixwin_scm",(void*)f_5079},
{"f_5083:posixwin_scm",(void*)f_5083},
{"f_5044:posixwin_scm",(void*)f_5044},
{"f_5047:posixwin_scm",(void*)f_5047},
{"f_5058:posixwin_scm",(void*)f_5058},
{"f_5052:posixwin_scm",(void*)f_5052},
{"f_5025:posixwin_scm",(void*)f_5025},
{"f_5034:posixwin_scm",(void*)f_5034},
{"f_4904:posixwin_scm",(void*)f_4904},
{"f_4908:posixwin_scm",(void*)f_4908},
{"f_4999:posixwin_scm",(void*)f_4999},
{"f_4911:posixwin_scm",(void*)f_4911},
{"f_4967:posixwin_scm",(void*)f_4967},
{"f_4971:posixwin_scm",(void*)f_4971},
{"f_4975:posixwin_scm",(void*)f_4975},
{"f_4979:posixwin_scm",(void*)f_4979},
{"f_4983:posixwin_scm",(void*)f_4983},
{"f_4846:posixwin_scm",(void*)f_4846},
{"f_4850:posixwin_scm",(void*)f_4850},
{"f_4960:posixwin_scm",(void*)f_4960},
{"f_4940:posixwin_scm",(void*)f_4940},
{"f_4944:posixwin_scm",(void*)f_4944},
{"f_4948:posixwin_scm",(void*)f_4948},
{"f_4812:posixwin_scm",(void*)f_4812},
{"f_4829:posixwin_scm",(void*)f_4829},
{"f_4833:posixwin_scm",(void*)f_4833},
{"f_4806:posixwin_scm",(void*)f_4806},
{"f_4785:posixwin_scm",(void*)f_4785},
{"f_4789:posixwin_scm",(void*)f_4789},
{"f_4801:posixwin_scm",(void*)f_4801},
{"f_4782:posixwin_scm",(void*)f_4782},
{"f_4695:posixwin_scm",(void*)f_4695},
{"f_4719:posixwin_scm",(void*)f_4719},
{"f_4714:posixwin_scm",(void*)f_4714},
{"f_4709:posixwin_scm",(void*)f_4709},
{"f_4697:posixwin_scm",(void*)f_4697},
{"f_4701:posixwin_scm",(void*)f_4701},
{"f_4608:posixwin_scm",(void*)f_4608},
{"f_4632:posixwin_scm",(void*)f_4632},
{"f_4627:posixwin_scm",(void*)f_4627},
{"f_4622:posixwin_scm",(void*)f_4622},
{"f_4610:posixwin_scm",(void*)f_4610},
{"f_4614:posixwin_scm",(void*)f_4614},
{"f_4593:posixwin_scm",(void*)f_4593},
{"f_4597:posixwin_scm",(void*)f_4597},
{"f_4557:posixwin_scm",(void*)f_4557},
{"f_4564:posixwin_scm",(void*)f_4564},
{"f_4567:posixwin_scm",(void*)f_4567},
{"f_4584:posixwin_scm",(void*)f_4584},
{"f_4570:posixwin_scm",(void*)f_4570},
{"f_4573:posixwin_scm",(void*)f_4573},
{"f_4580:posixwin_scm",(void*)f_4580},
{"f_4507:posixwin_scm",(void*)f_4507},
{"f_4519:posixwin_scm",(void*)f_4519},
{"f_4538:posixwin_scm",(void*)f_4538},
{"f_4490:posixwin_scm",(void*)f_4490},
{"f_4473:posixwin_scm",(void*)f_4473},
{"f_4394:posixwin_scm",(void*)f_4394},
{"f_4437:posixwin_scm",(void*)f_4437},
{"f_4468:posixwin_scm",(void*)f_4468},
{"f_4465:posixwin_scm",(void*)f_4465},
{"f_4399:posixwin_scm",(void*)f_4399},
{"f_4403:posixwin_scm",(void*)f_4403},
{"f_4408:posixwin_scm",(void*)f_4408},
{"f_4432:posixwin_scm",(void*)f_4432},
{"f_4421:posixwin_scm",(void*)f_4421},
{"f_4277:posixwin_scm",(void*)f_4277},
{"f_4283:posixwin_scm",(void*)f_4283},
{"f_4304:posixwin_scm",(void*)f_4304},
{"f_4383:posixwin_scm",(void*)f_4383},
{"f_4308:posixwin_scm",(void*)f_4308},
{"f_4311:posixwin_scm",(void*)f_4311},
{"f_4318:posixwin_scm",(void*)f_4318},
{"f_4320:posixwin_scm",(void*)f_4320},
{"f_4337:posixwin_scm",(void*)f_4337},
{"f_4341:posixwin_scm",(void*)f_4341},
{"f_4349:posixwin_scm",(void*)f_4349},
{"f_4353:posixwin_scm",(void*)f_4353},
{"f_4298:posixwin_scm",(void*)f_4298},
{"f_4218:posixwin_scm",(void*)f_4218},
{"f_4222:posixwin_scm",(void*)f_4222},
{"f_4228:posixwin_scm",(void*)f_4228},
{"f_4237:posixwin_scm",(void*)f_4237},
{"f_4203:posixwin_scm",(void*)f_4203},
{"f_4210:posixwin_scm",(void*)f_4210},
{"f_4184:posixwin_scm",(void*)f_4184},
{"f_4188:posixwin_scm",(void*)f_4188},
{"f_4191:posixwin_scm",(void*)f_4191},
{"f_4168:posixwin_scm",(void*)f_4168},
{"f_4156:posixwin_scm",(void*)f_4156},
{"f_4141:posixwin_scm",(void*)f_4141},
{"f_4145:posixwin_scm",(void*)f_4145},
{"f_4151:posixwin_scm",(void*)f_4151},
{"f_4074:posixwin_scm",(void*)f_4074},
{"f_4078:posixwin_scm",(void*)f_4078},
{"f_4081:posixwin_scm",(void*)f_4081},
{"f_4103:posixwin_scm",(void*)f_4103},
{"f_4100:posixwin_scm",(void*)f_4100},
{"f_4090:posixwin_scm",(void*)f_4090},
{"f_4016:posixwin_scm",(void*)f_4016},
{"f_4020:posixwin_scm",(void*)f_4020},
{"f_4023:posixwin_scm",(void*)f_4023},
{"f_3972:posixwin_scm",(void*)f_3972},
{"f_3976:posixwin_scm",(void*)f_3976},
{"f_3938:posixwin_scm",(void*)f_3938},
{"f_3942:posixwin_scm",(void*)f_3942},
{"f_3919:posixwin_scm",(void*)f_3919},
{"f_3853:posixwin_scm",(void*)f_3853},
{"f_3859:posixwin_scm",(void*)f_3859},
{"f_3863:posixwin_scm",(void*)f_3863},
{"f_3871:posixwin_scm",(void*)f_3871},
{"f_3897:posixwin_scm",(void*)f_3897},
{"f_3901:posixwin_scm",(void*)f_3901},
{"f_3889:posixwin_scm",(void*)f_3889},
{"f_3833:posixwin_scm",(void*)f_3833},
{"f_3841:posixwin_scm",(void*)f_3841},
{"f_3816:posixwin_scm",(void*)f_3816},
{"f_3827:posixwin_scm",(void*)f_3827},
{"f_3831:posixwin_scm",(void*)f_3831},
{"f_3786:posixwin_scm",(void*)f_3786},
{"f_3793:posixwin_scm",(void*)f_3793},
{"f_3802:posixwin_scm",(void*)f_3802},
{"f_3796:posixwin_scm",(void*)f_3796},
{"f_3751:posixwin_scm",(void*)f_3751},
{"f_3755:posixwin_scm",(void*)f_3755},
{"f_3784:posixwin_scm",(void*)f_3784},
{"f_3770:posixwin_scm",(void*)f_3770},
{"f_3764:posixwin_scm",(void*)f_3764},
{"f_3737:posixwin_scm",(void*)f_3737},
{"f_3749:posixwin_scm",(void*)f_3749},
{"f_3723:posixwin_scm",(void*)f_3723},
{"f_3735:posixwin_scm",(void*)f_3735},
{"f_3705:posixwin_scm",(void*)f_3705},
{"f_3709:posixwin_scm",(void*)f_3709},
{"f_3721:posixwin_scm",(void*)f_3721},
{"f_3668:posixwin_scm",(void*)f_3668},
{"f_3676:posixwin_scm",(void*)f_3676},
{"f_3659:posixwin_scm",(void*)f_3659},
{"f_3653:posixwin_scm",(void*)f_3653},
{"f_3647:posixwin_scm",(void*)f_3647},
{"f_3623:posixwin_scm",(void*)f_3623},
{"f_3645:posixwin_scm",(void*)f_3645},
{"f_3641:posixwin_scm",(void*)f_3641},
{"f_3633:posixwin_scm",(void*)f_3633},
{"f_3593:posixwin_scm",(void*)f_3593},
{"f_3621:posixwin_scm",(void*)f_3621},
{"f_3617:posixwin_scm",(void*)f_3617},
{"f_3609:posixwin_scm",(void*)f_3609},
{"f_3537:posixwin_scm",(void*)f_3537},
{"f_3547:posixwin_scm",(void*)f_3547},
{"f_3524:posixwin_scm",(void*)f_3524},
{"f_3515:posixwin_scm",(void*)f_3515},
{"f_3439:posixwin_scm",(void*)f_3439},
{"f_3443:posixwin_scm",(void*)f_3443},
{"f_3455:posixwin_scm",(void*)f_3455},
{"f_3446:posixwin_scm",(void*)f_3446},
{"f_3419:posixwin_scm",(void*)f_3419},
{"f_3423:posixwin_scm",(void*)f_3423},
{"f_3429:posixwin_scm",(void*)f_3429},
{"f_3433:posixwin_scm",(void*)f_3433},
{"f_3399:posixwin_scm",(void*)f_3399},
{"f_3403:posixwin_scm",(void*)f_3403},
{"f_3409:posixwin_scm",(void*)f_3409},
{"f_3413:posixwin_scm",(void*)f_3413},
{"f_3375:posixwin_scm",(void*)f_3375},
{"f_3379:posixwin_scm",(void*)f_3379},
{"f_3390:posixwin_scm",(void*)f_3390},
{"f_3394:posixwin_scm",(void*)f_3394},
{"f_3384:posixwin_scm",(void*)f_3384},
{"f_3351:posixwin_scm",(void*)f_3351},
{"f_3355:posixwin_scm",(void*)f_3355},
{"f_3366:posixwin_scm",(void*)f_3366},
{"f_3370:posixwin_scm",(void*)f_3370},
{"f_3360:posixwin_scm",(void*)f_3360},
{"f_3332:posixwin_scm",(void*)f_3332},
{"f_3336:posixwin_scm",(void*)f_3336},
{"f_3339:posixwin_scm",(void*)f_3339},
{"f_3296:posixwin_scm",(void*)f_3296},
{"f_3327:posixwin_scm",(void*)f_3327},
{"f_3317:posixwin_scm",(void*)f_3317},
{"f_3310:posixwin_scm",(void*)f_3310},
{"f_3260:posixwin_scm",(void*)f_3260},
{"f_3291:posixwin_scm",(void*)f_3291},
{"f_3281:posixwin_scm",(void*)f_3281},
{"f_3274:posixwin_scm",(void*)f_3274},
{"f_3242:posixwin_scm",(void*)f_3242},
{"f_3246:posixwin_scm",(void*)f_3246},
{"f_3258:posixwin_scm",(void*)f_3258},
{"f_2867:posixwin_scm",(void*)f_2867},
{"f_3214:posixwin_scm",(void*)f_3214},
{"f_3013:posixwin_scm",(void*)f_3013},
{"f_3200:posixwin_scm",(void*)f_3200},
{"f_3189:posixwin_scm",(void*)f_3189},
{"f_3196:posixwin_scm",(void*)f_3196},
{"f_3043:posixwin_scm",(void*)f_3043},
{"f_3182:posixwin_scm",(void*)f_3182},
{"f_3161:posixwin_scm",(void*)f_3161},
{"f_3178:posixwin_scm",(void*)f_3178},
{"f_3167:posixwin_scm",(void*)f_3167},
{"f_3174:posixwin_scm",(void*)f_3174},
{"f_3085:posixwin_scm",(void*)f_3085},
{"f_3158:posixwin_scm",(void*)f_3158},
{"f_3137:posixwin_scm",(void*)f_3137},
{"f_3154:posixwin_scm",(void*)f_3154},
{"f_3143:posixwin_scm",(void*)f_3143},
{"f_3150:posixwin_scm",(void*)f_3150},
{"f_3091:posixwin_scm",(void*)f_3091},
{"f_3134:posixwin_scm",(void*)f_3134},
{"f_3130:posixwin_scm",(void*)f_3130},
{"f_3123:posixwin_scm",(void*)f_3123},
{"f_3119:posixwin_scm",(void*)f_3119},
{"f_3098:posixwin_scm",(void*)f_3098},
{"f_3102:posixwin_scm",(void*)f_3102},
{"f_3079:posixwin_scm",(void*)f_3079},
{"f_3066:posixwin_scm",(void*)f_3066},
{"f_3050:posixwin_scm",(void*)f_3050},
{"f_3054:posixwin_scm",(void*)f_3054},
{"f_3058:posixwin_scm",(void*)f_3058},
{"f_3037:posixwin_scm",(void*)f_3037},
{"f_3024:posixwin_scm",(void*)f_3024},
{"f_3020:posixwin_scm",(void*)f_3020},
{"f_3007:posixwin_scm",(void*)f_3007},
{"f_2874:posixwin_scm",(void*)f_2874},
{"f_2993:posixwin_scm",(void*)f_2993},
{"f_2881:posixwin_scm",(void*)f_2881},
{"f_2883:posixwin_scm",(void*)f_2883},
{"f_2890:posixwin_scm",(void*)f_2890},
{"f_2965:posixwin_scm",(void*)f_2965},
{"f_2974:posixwin_scm",(void*)f_2974},
{"f_2896:posixwin_scm",(void*)f_2896},
{"f_2943:posixwin_scm",(void*)f_2943},
{"f_2931:posixwin_scm",(void*)f_2931},
{"f_2939:posixwin_scm",(void*)f_2939},
{"f_2935:posixwin_scm",(void*)f_2935},
{"f_2912:posixwin_scm",(void*)f_2912},
{"f_2920:posixwin_scm",(void*)f_2920},
{"f_2916:posixwin_scm",(void*)f_2916},
{"f_2811:posixwin_scm",(void*)f_2811},
{"f_2820:posixwin_scm",(void*)f_2820},
{"f_2844:posixwin_scm",(void*)f_2844},
{"f_2856:posixwin_scm",(void*)f_2856},
{"f_2862:posixwin_scm",(void*)f_2862},
{"f_2850:posixwin_scm",(void*)f_2850},
{"f_2826:posixwin_scm",(void*)f_2826},
{"f_2832:posixwin_scm",(void*)f_2832},
{"f_2815:posixwin_scm",(void*)f_2815},
{"f_2744:posixwin_scm",(void*)f_2744},
{"f_2748:posixwin_scm",(void*)f_2748},
{"f_2757:posixwin_scm",(void*)f_2757},
{"f_2760:posixwin_scm",(void*)f_2760},
{"f_2717:posixwin_scm",(void*)f_2717},
{"f_2742:posixwin_scm",(void*)f_2742},
{"f_2738:posixwin_scm",(void*)f_2738},
{"f_2724:posixwin_scm",(void*)f_2724},
{"f_2557:posixwin_scm",(void*)f_2557},
{"f_2665:posixwin_scm",(void*)f_2665},
{"f_2673:posixwin_scm",(void*)f_2673},
{"f_2660:posixwin_scm",(void*)f_2660},
{"f_2559:posixwin_scm",(void*)f_2559},
{"f_2566:posixwin_scm",(void*)f_2566},
{"f_2569:posixwin_scm",(void*)f_2569},
{"f_2572:posixwin_scm",(void*)f_2572},
{"f_2659:posixwin_scm",(void*)f_2659},
{"f_2576:posixwin_scm",(void*)f_2576},
{"f_2593:posixwin_scm",(void*)f_2593},
{"f_2603:posixwin_scm",(void*)f_2603},
{"f_2615:posixwin_scm",(void*)f_2615},
{"f_2625:posixwin_scm",(void*)f_2625},
{"f_2585:posixwin_scm",(void*)f_2585},
{"f_2532:posixwin_scm",(void*)f_2532},
{"f_2555:posixwin_scm",(void*)f_2555},
{"f_2539:posixwin_scm",(void*)f_2539},
{"f_2548:posixwin_scm",(void*)f_2548},
{"f_2542:posixwin_scm",(void*)f_2542},
{"f_2507:posixwin_scm",(void*)f_2507},
{"f_2530:posixwin_scm",(void*)f_2530},
{"f_2514:posixwin_scm",(void*)f_2514},
{"f_2523:posixwin_scm",(void*)f_2523},
{"f_2517:posixwin_scm",(void*)f_2517},
{"f_2350:posixwin_scm",(void*)f_2350},
{"f_2354:posixwin_scm",(void*)f_2354},
{"f_2360:posixwin_scm",(void*)f_2360},
{"f_2483:posixwin_scm",(void*)f_2483},
{"f_2475:posixwin_scm",(void*)f_2475},
{"f_2368:posixwin_scm",(void*)f_2368},
{"f_2380:posixwin_scm",(void*)f_2380},
{"f_2450:posixwin_scm",(void*)f_2450},
{"f_2388:posixwin_scm",(void*)f_2388},
{"f_2393:posixwin_scm",(void*)f_2393},
{"f_2406:posixwin_scm",(void*)f_2406},
{"f_2409:posixwin_scm",(void*)f_2409},
{"f_2422:posixwin_scm",(void*)f_2422},
{"f_2441:posixwin_scm",(void*)f_2441},
{"f_2433:posixwin_scm",(void*)f_2433},
{"f_2363:posixwin_scm",(void*)f_2363},
{"f_2288:posixwin_scm",(void*)f_2288},
{"f_2301:posixwin_scm",(void*)f_2301},
{"f_2313:posixwin_scm",(void*)f_2313},
{"f_2307:posixwin_scm",(void*)f_2307},
{"f6623:posixwin_scm",(void*)f6623},
{"f6629:posixwin_scm",(void*)f6629},
{"f6635:posixwin_scm",(void*)f6635},
{"f6641:posixwin_scm",(void*)f6641},
{"f_2259:posixwin_scm",(void*)f_2259},
{"f_2236:posixwin_scm",(void*)f_2236},
{"f_2257:posixwin_scm",(void*)f_2257},
{"f_2243:posixwin_scm",(void*)f_2243},
{"f_2230:posixwin_scm",(void*)f_2230},
{"f_2234:posixwin_scm",(void*)f_2234},
{"f_2224:posixwin_scm",(void*)f_2224},
{"f_2228:posixwin_scm",(void*)f_2228},
{"f_2218:posixwin_scm",(void*)f_2218},
{"f_2222:posixwin_scm",(void*)f_2222},
{"f_2212:posixwin_scm",(void*)f_2212},
{"f_2216:posixwin_scm",(void*)f_2216},
{"f_2202:posixwin_scm",(void*)f_2202},
{"f_2206:posixwin_scm",(void*)f_2206},
{"f_2171:posixwin_scm",(void*)f_2171},
{"f_2175:posixwin_scm",(void*)f_2175},
{"f_2178:posixwin_scm",(void*)f_2178},
{"f_2133:posixwin_scm",(void*)f_2133},
{"f_2166:posixwin_scm",(void*)f_2166},
{"f_2162:posixwin_scm",(void*)f_2162},
{"f_2137:posixwin_scm",(void*)f_2137},
{"f_2146:posixwin_scm",(void*)f_2146},
{"f_2095:posixwin_scm",(void*)f_2095},
{"f_2102:posixwin_scm",(void*)f_2102},
{"f_2105:posixwin_scm",(void*)f_2105},
{"f_2125:posixwin_scm",(void*)f_2125},
{"f_2108:posixwin_scm",(void*)f_2108},
{"f_2115:posixwin_scm",(void*)f_2115},
{"f_2053:posixwin_scm",(void*)f_2053},
{"f_2060:posixwin_scm",(void*)f_2060},
{"f_2075:posixwin_scm",(void*)f_2075},
{"f_2069:posixwin_scm",(void*)f_2069},
{"f_2008:posixwin_scm",(void*)f_2008},
{"f_2018:posixwin_scm",(void*)f_2018},
{"f_2021:posixwin_scm",(void*)f_2021},
{"f_2033:posixwin_scm",(void*)f_2033},
{"f_2024:posixwin_scm",(void*)f_2024},
{"f_1990:posixwin_scm",(void*)f_1990},
{"f_2003:posixwin_scm",(void*)f_2003},
{"f_1949:posixwin_scm",(void*)f_1949},
{"f_1982:posixwin_scm",(void*)f_1982},
{"f_1966:posixwin_scm",(void*)f_1966},
{"f_1975:posixwin_scm",(void*)f_1975},
{"f_1969:posixwin_scm",(void*)f_1969},
{"f_1903:posixwin_scm",(void*)f_1903},
{"f_1907:posixwin_scm",(void*)f_1907},
{"f_1918:posixwin_scm",(void*)f_1918},
{"f_1914:posixwin_scm",(void*)f_1914},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
