/* Generated from src/unistd.scm by the CHICKEN compiler, Version 0, Build 990 g
   Command line: src/unistd.scm -optimize-level 2 -quiet -:h96m -explicit-use -output-file src/unistd.c
   Unit: unistd
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <sys/mman.h>
#include <time.h>

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANONYMOUS
# define MAP_ANONYMOUS    0
#endif

extern char **environ;

static char *C_exec_args[ ARG_MAX ];
static struct utsname C_utsname;
static struct flock C_flock;
static DIR *temphandle;
static struct dirent *finddata;
static struct passwd *C_user;
static int C_pipefds[ 2 ];
static time_t C_secs;
static struct tm C_tm;
static fd_set C_fd_sets[ 2 ];
static struct timeval C_timeval;
static char C_hostbuf[ 256 ];

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))
#define C_findfirst(str)    (temphandle = opendir(C_c_string(str)), ((temphandle && (finddata = readdir(temphandle))) ? C_fix(temphandle) : C_SCHEME_FALSE))
#define C_findnext(h)       C_mk_bool(finddata = readdir((DIR *)C_unfix(h)))
#define C_foundfile(buf)    (strcpy(C_c_string(buf), finddata->d_name), C_fix(strlen(finddata->d_name)))
#define C_findclose(h)      (closedir((DIR *)C_unfix(h)), C_SCHEME_UNDEFINED)
#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_fork              fork
#define C_set_exec_arg(i, a) (C_exec_args[ i ] = (a))
#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_fdopen            fdopen
#define C_fileno(p)         C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_alarm             alarm
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_getenventry(i)    environ[ i ]
#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

#if defined(__FreeBSD__) || defined(__NetBSD__)
static int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigprocmask(d)    C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open((char *)C_data_pointer(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)    FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd) FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd) FD_ISSET(fd, &C_fd_sets[ i ])
#define C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if !defined(C_GNU_ENV)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
#endif

C_extern void C_regex_toplevel(int c,C_word d,C_word k) C_noret;

static C_word lf[329];


#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub775(C_word C_buf) C_regparm;
static C_word C_fcall stub775(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
            else return(C_hostbuf);
C_return:
return C_r;
#undef return
}

static C_word C_fcall stub767(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub767(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

static C_word C_fcall stub750(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub750(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

static C_word C_fcall stub744(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub744(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
_exit(t0);
return C_r;}

static C_word C_fcall stub733(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub733(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

static C_word C_fcall stub724(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub724(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

static C_word C_fcall stub709(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub709(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=C_c_pointer_or_null(C_a0);
int t1=C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

static C_word C_fcall stub685(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
static C_word C_fcall stub685(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=C_c_pointer_or_null(C_a0);
int t1=C_num_to_int(C_a1);
int t2=C_unfix(C_a2);
int t3=C_unfix(C_a3);
int t4=C_unfix(C_a4);
int t5=C_num_to_int(C_a5);
C_r=C_mpointer(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

static C_word C_fcall stub667(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub667(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

static C_word C_fcall stub561(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub561(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
char * t1=C_string_or_null(C_a1);
C_r=C_mpointer(&C_a,(void*)C_fdopen(t0,t1));
return C_r;}

static C_word C_fcall stub520(C_word C_buf) C_regparm;
static C_word C_fcall stub520(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

static C_word C_fcall stub518(C_word C_buf) C_regparm;
static C_word C_fcall stub518(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

static C_word C_fcall stub516(C_word C_buf) C_regparm;
static C_word C_fcall stub516(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

static C_word C_fcall stub514(C_word C_buf) C_regparm;
static C_word C_fcall stub514(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

static C_word C_fcall stub478(C_word C_buf) C_regparm;
static C_word C_fcall stub478(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

static C_word C_fcall stub476(C_word C_buf) C_regparm;
static C_word C_fcall stub476(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

static C_word C_fcall stub438(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub438(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
char * t1=C_string_or_null(C_a1);
C_r=C_fix((C_word)C_set_exec_arg(t0,t1));
return C_r;}

static C_word C_fcall stub429(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub429(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
_exit(t0);
return C_r;}

static C_word C_fcall stub424(C_word C_buf) C_regparm;
static C_word C_fcall stub424(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

static C_word C_fcall stub50(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub50(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
int t1=C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

static C_word C_fcall stub44(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub44(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
int t1=C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

static C_word C_fcall stub39(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub39(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

C_extern void C_unistd_toplevel(int c,C_word t0,C_word t1) C_noret;
static void f949(int c,C_word t0,C_word t1) C_noret;
static void f952(int c,C_word t0,C_word t1) C_noret;
static void f4093(int c,C_word t0,C_word t1) C_noret;
static void f1822(int c,C_word t0,C_word t1) C_noret;
static void f1837(int c,C_word t0,C_word t1) C_noret;
static void f1840(int c,C_word t0,C_word t1) C_noret;
static void f2028(int c,C_word t0,C_word t1) C_noret;
static void f4089(int c,C_word t0,C_word t1) C_noret;
static void f2031(int c,C_word t0,C_word t1) C_noret;
static void f2034(int c,C_word t0,C_word t1) C_noret;
static void f2037(int c,C_word t0,C_word t1) C_noret;
static void f2424(int c,C_word t0,C_word t1) C_noret;
static void f4081(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2519(int c,C_word t0,C_word t1) C_noret;
static void f3127(int c,C_word t0,C_word t1) C_noret;
static void f4062(int c,C_word t0,C_word t1) C_noret;
static void f4058(int c,C_word t0,C_word t1) C_noret;
static void f4066(int c,C_word t0,C_word t1) C_noret;
static void f4072(int c,C_word t0,C_word t1) C_noret;
static void f4069(int c,C_word t0,C_word t1) C_noret;
static void f4035(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f4039(int c,C_word t0,C_word t1) C_noret;
static void f4049(int c,C_word t0,C_word t1) C_noret;
static void f4042(int c,C_word t0,C_word t1) C_noret;
static void f4026(int c,C_word t0,C_word t1) C_noret;
static void f4034(int c,C_word t0,C_word t1) C_noret;
static void f4003(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f4007(int c,C_word t0,C_word t1) C_noret;
static void f4010(int c,C_word t0,C_word t1) C_noret;
static void f3950(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f3950r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f3954(int c,C_word t0,C_word t1) C_noret;
static void f3960(int c,C_word t0,C_word t1) C_noret;
static void f3977(int c,C_word t0,C_word t1) C_noret;
static void f3943(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3948(int c,C_word t0,C_word t1) C_noret;
static void f3924(int c,C_word t0,C_word t1,...) C_noret;
static void f3924r(C_word t0,C_word t1,C_word t3) C_noret;
static void f3928(int c,C_word t0,C_word t1) C_noret;
static void f3923(int c,C_word t0,C_word t1) C_noret;
static void f3890(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3897(int c,C_word t0,C_word t1) C_noret;
static void f3886(int c,C_word t0,C_word t1) C_noret;
static void f3900(int c,C_word t0,C_word t1) C_noret;
static void f3903(int c,C_word t0,C_word t1) C_noret;
static void f3870(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3861(int c,C_word t0,C_word t1) C_noret;
static void f3869(int c,C_word t0,C_word t1) C_noret;
static void f3874(int c,C_word t0,C_word t1) C_noret;
static void f3877(int c,C_word t0,C_word t1) C_noret;
static void f3848(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3839(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3801(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3801r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3793(int c,C_word t0,C_word t1) C_noret;
static void f3797(int c,C_word t0,C_word t1) C_noret;
static void f3817(int c,C_word t0,C_word t1) C_noret;
static void f3736(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
static void f3736r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
static void f3740(int c,C_word t0,C_word t1) C_noret;
static void f3746(int c,C_word t0,C_word t1) C_noret;
static void f3708(int c,C_word t0,C_word t1) C_noret;
static void f3712(int c,C_word t0,C_word t1) C_noret;
static void f3716(int c,C_word t0,C_word t1) C_noret;
static void f3720(int c,C_word t0,C_word t1) C_noret;
static void f3724(int c,C_word t0,C_word t1) C_noret;
static void f3728(int c,C_word t0,C_word t1) C_noret;
static void f3732(int c,C_word t0,C_word t1) C_noret;
static void f3768(int c,C_word t0,C_word t1) C_noret;
static void f3761(int c,C_word t0,C_word t1) C_noret;
static void f3752(int c,C_word t0,C_word t1) C_noret;
static void f3630(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3636(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3621(int c,C_word t0,C_word t1) C_noret;
static void f3629(int c,C_word t0,C_word t1) C_noret;
static void f3640(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3648(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3674(int c,C_word t0,C_word t1) C_noret;
static void f3678(int c,C_word t0,C_word t1) C_noret;
static void f3666(int c,C_word t0,C_word t1) C_noret;
static void f3607(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3615(int c,C_word t0,C_word t1) C_noret;
static void f3598(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3573(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3580(int c,C_word t0,C_word t1) C_noret;
static void f3583(int c,C_word t0,C_word t1) C_noret;
static void f3531(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3531r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f3538(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3558(int c,C_word t0,C_word t1) C_noret;
static void f3550(int c,C_word t0,C_word t1) C_noret;
static void f3500(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3521(int c,C_word t0,C_word t1) C_noret;
static void f3473(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3473r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3477(int c,C_word t0,C_word t1) C_noret;
static void f3458(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3458r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3462(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3437(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3441(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3363(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3385(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3391(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3325(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3352(int c,C_word t0,C_word t1) C_noret;
static void f3345(int c,C_word t0,C_word t1) C_noret;
static void f3338(int c,C_word t0,C_word t1) C_noret;
static void f3295(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3295r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f3302(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3311(int c,C_word t0,C_word t1) C_noret;
static void f3305(int c,C_word t0,C_word t1) C_noret;
static void f3273(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3277(int c,C_word t0,C_word t1) C_noret;
static void f3281(int c,C_word t0,C_word t1) C_noret;
static void f3290(int c,C_word t0,C_word t1) C_noret;
static void f3284(int c,C_word t0,C_word t1) C_noret;
static void f3256(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3271(int c,C_word t0,C_word t1) C_noret;
static void f3267(int c,C_word t0,C_word t1) C_noret;
static void f3239(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3239r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3254(int c,C_word t0,C_word t1) C_noret;
static void f3250(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3206(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f3210(int c,C_word t0,C_word t1) C_noret;
static void f3222(int c,C_word t0,C_word t1) C_noret;
static void f3225(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3176(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void C_fcall f3155(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3159(int c,C_word t0,C_word t1) C_noret;
static void f3163(int c,C_word t0,C_word t1) C_noret;
static void f3174(int c,C_word t0,C_word t1) C_noret;
static void f3167(int c,C_word t0,C_word t1) C_noret;
static void f3128(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3136(int c,C_word t0,C_word t1) C_noret;
static void f3148(int c,C_word t0,C_word t1) C_noret;
static void f3139(int c,C_word t0,C_word t1) C_noret;
static void f3095(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3119(int c,C_word t0,C_word t1) C_noret;
static void f3123(int c,C_word t0,C_word t1) C_noret;
static void f3111(int c,C_word t0,C_word t1) C_noret;
static void f3074(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3081(int c,C_word t0,C_word t1) C_noret;
static void f3084(int c,C_word t0,C_word t1) C_noret;
static void f3068(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3068r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3062(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3062r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3056(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3056r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f3003(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_c_regparm C_noret;
static void f3030(int c,C_word t0,C_word t1) C_noret;
static void f3027(int c,C_word t0,C_word t1) C_noret;
static void f3019(int c,C_word t0,C_word t1) C_noret;
static void f2988(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2998(int c,C_word t0,C_word t1) C_noret;
static void f2985(int c,C_word t0,C_word t1) C_noret;
static void f2982(int c,C_word t0,C_word t1) C_noret;
static void f2979(int c,C_word t0,C_word t1) C_noret;
static void f2976(int c,C_word t0,C_word t1) C_noret;
static void f2947(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2974(int c,C_word t0,C_word t1) C_noret;
static void f2966(int c,C_word t0,C_word t1) C_noret;
static void f2921(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2945(int c,C_word t0,C_word t1) C_noret;
static void f2937(int c,C_word t0,C_word t1) C_noret;
static void f2858(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2898(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2862(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2872(int c,C_word t0,C_word t1) C_noret;
static void f2876(int c,C_word t0,C_word t1) C_noret;
static void f2880(int c,C_word t0,C_word t1) C_noret;
static void f2884(int c,C_word t0,C_word t1) C_noret;
static void f2888(int c,C_word t0,C_word t1) C_noret;
static void f2820(int c,C_word t0,C_word t1) C_noret;
static void f2853(int c,C_word t0,C_word t1) C_noret;
static void f2824(int c,C_word t0,C_word t1) C_noret;
static void f2831(int c,C_word t0,C_word t1) C_noret;
static void f2835(int c,C_word t0,C_word t1) C_noret;
static void f2839(int c,C_word t0,C_word t1) C_noret;
static void f2843(int c,C_word t0,C_word t1) C_noret;
static void f2847(int c,C_word t0,C_word t1) C_noret;
static void f2776(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2776r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2783(int c,C_word t0,C_word t1) C_noret;
static void f2798(int c,C_word t0,C_word t1) C_noret;
static void f2746(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2746r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2759(int c,C_word t0,C_word t1) C_noret;
static void f2743(int c,C_word t0,C_word t1) C_noret;
static void f2740(int c,C_word t0,C_word t1) C_noret;
static void f2661(int c,C_word t0,C_word t1,...) C_noret;
static void f2661r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2692(int c,C_word t0,C_word t1) C_noret;
static void f2585(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2585r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2653(int c,C_word t0,C_word t1) C_noret;
static void f2598(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2603(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f2638(int c,C_word t0,C_word t1) C_noret;
static void f2613(int c,C_word t0,C_word t1) C_noret;
static void f2617(int c,C_word t0,C_word t1) C_noret;
static void f2620(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2568(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2573(int c,C_word t0,C_word t1) C_noret;
static void f2584(int c,C_word t0,C_word t1) C_noret;
static void f2577(int c,C_word t0,C_word t1) C_noret;
static void f2523(int c,C_word t0,C_word t1,...) C_noret;
static void f2523r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2530(int c,C_word t0,C_word t1) C_noret;
static void f2548(int c,C_word t0,C_word t1) C_noret;
static void f2552(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2557(int c,C_word t0,C_word t1) C_noret;
static void f2491(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2512(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2498(int c,C_word t0,C_word t1) C_noret;
static void f2507(int c,C_word t0,C_word t1) C_noret;
static void f2473(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2483(int c,C_word t0,C_word t1) C_noret;
static void f2426(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2426r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void C_fcall f2447(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2448(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2454(int c,C_word t0,C_word t1) C_noret;
static void f2289(int c,C_word t0,C_word t1,...) C_noret;
static void f2289r(C_word t0,C_word t1,C_word t3) C_noret;
static void C_fcall f2295(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2316(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2392(int c,C_word t0,C_word t1) C_noret;
static void f2320(int c,C_word t0,C_word t1) C_noret;
static void f2327(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2329(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2346(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2350(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2358(int c,C_word t0,C_word t1) C_noret;
static void f2362(int c,C_word t0,C_word t1) C_noret;
static void f2310(int c,C_word t0,C_word t1) C_noret;
static void f2224(int c,C_word t0,C_word t1,...) C_noret;
static void f2224r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2228(int c,C_word t0,C_word t1) C_noret;
static void f2281(int c,C_word t0,C_word t1) C_noret;
static void f2231(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2242(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2272(int c,C_word t0,C_word t1) C_noret;
static void f2268(int c,C_word t0,C_word t1) C_noret;
static void f2249(int c,C_word t0,C_word t1) C_noret;
static void f2255(int c,C_word t0,C_word t1) C_noret;
static void f2263(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2206(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2218(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2212(int c,C_word t0,C_word t1) C_noret;
static void f2188(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2200(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2194(int c,C_word t0,C_word t1) C_noret;
static void f2170(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2182(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2176(int c,C_word t0,C_word t1) C_noret;
static void f2152(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2164(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2158(int c,C_word t0,C_word t1) C_noret;
static void f2134(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2146(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2140(int c,C_word t0,C_word t1) C_noret;
static void f2119(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2131(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2125(int c,C_word t0,C_word t1) C_noret;
static void f2104(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2116(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2110(int c,C_word t0,C_word t1) C_noret;
static void f2089(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2101(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2095(int c,C_word t0,C_word t1) C_noret;
static void f2038(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2045(int c,C_word t0,C_word t1) C_noret;
static void f2070(int c,C_word t0,C_word t1) C_noret;
static void f1982(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1982r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1990(int c,C_word t0,C_word t1) C_noret;
static void f2006(int c,C_word t0,C_word t1) C_noret;
static void f1996(int c,C_word t0,C_word t1) C_noret;
static void f1875(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1875r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1879(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1885(C_word t0,C_word t1) C_c_regparm C_noret;
static void C_fcall f1922(C_word t0,C_word t1) C_c_regparm C_noret;
static void C_fcall f1902(C_word t0,C_word t1) C_c_regparm C_noret;
static void C_fcall f1842(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void C_fcall f1851(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f1869(int c,C_word t0,C_word t1) C_noret;
static void f1823(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1834(int c,C_word t0,C_word t1) C_noret;
static void f1802(int c,C_word t0,C_word t1) C_noret;
static void f1815(int c,C_word t0,C_word t1) C_noret;
static void f1806(int c,C_word t0,C_word t1) C_noret;
static void f1782(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1782r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1786(int c,C_word t0,C_word t1) C_noret;
static void f1792(int c,C_word t0,C_word t1,...) C_noret;
static void f1792r(C_word t0,C_word t1,C_word t3) C_noret;
static void f1796(int c,C_word t0,C_word t1) C_noret;
static void f1762(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1762r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1766(int c,C_word t0,C_word t1) C_noret;
static void f1772(int c,C_word t0,C_word t1,...) C_noret;
static void f1772r(C_word t0,C_word t1,C_word t3) C_noret;
static void f1776(int c,C_word t0,C_word t1) C_noret;
static void f1738(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1738r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1742(int c,C_word t0,C_word t1) C_noret;
static void f1753(int c,C_word t0,C_word t1,...) C_noret;
static void f1753r(C_word t0,C_word t1,C_word t3) C_noret;
static void f1757(int c,C_word t0,C_word t1) C_noret;
static void f1747(int c,C_word t0,C_word t1) C_noret;
static void f1714(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1714r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1718(int c,C_word t0,C_word t1) C_noret;
static void f1729(int c,C_word t0,C_word t1,...) C_noret;
static void f1729r(C_word t0,C_word t1,C_word t3) C_noret;
static void f1733(int c,C_word t0,C_word t1) C_noret;
static void f1723(int c,C_word t0,C_word t1) C_noret;
static void f1695(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1699(int c,C_word t0,C_word t1) C_noret;
static void f1702(int c,C_word t0,C_word t1) C_noret;
static void f1659(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f1659r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f1690(int c,C_word t0,C_word t1) C_noret;
static void f1680(int c,C_word t0,C_word t1) C_noret;
static void f1673(int c,C_word t0,C_word t1) C_noret;
static void f1623(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f1623r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f1654(int c,C_word t0,C_word t1) C_noret;
static void f1644(int c,C_word t0,C_word t1) C_noret;
static void f1637(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1590(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f1594(int c,C_word t0,C_word t1) C_noret;
static void f1606(int c,C_word t0,C_word t1) C_noret;
static void f1609(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1584(C_word t0,C_word t1) C_c_regparm C_noret;
static C_word C_fcall f1572(C_word t0) C_c_regparm;
static void f1554(int c,C_word t0,C_word t1) C_noret;
static void f1558(int c,C_word t0,C_word t1) C_noret;
static void f1561(int c,C_word t0,C_word t1) C_noret;
static void f1535(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1542(int c,C_word t0,C_word t1) C_noret;
static void f1497(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1504(int c,C_word t0,C_word t1) C_noret;
static void f1508(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1516(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1520(int c,C_word t0,C_word t1) C_noret;
static void f1530(int c,C_word t0,C_word t1) C_noret;
static void f1474(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1495(int c,C_word t0,C_word t1) C_noret;
static void f1487(int c,C_word t0,C_word t1) C_noret;
static void f1451(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1472(int c,C_word t0,C_word t1) C_noret;
static void f1464(int c,C_word t0,C_word t1) C_noret;
static void f1428(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1449(int c,C_word t0,C_word t1) C_noret;
static void f1441(int c,C_word t0,C_word t1) C_noret;
static void f1373(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1373r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1386(int c,C_word t0,C_word t1) C_noret;
static void f1405(int c,C_word t0,C_word t1) C_noret;
static void f1392(int c,C_word t0,C_word t1) C_noret;
static void f1395(int c,C_word t0,C_word t1) C_noret;
static void f1339(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1362(int c,C_word t0,C_word t1) C_noret;
static void f1343(int c,C_word t0,C_word t1) C_noret;
static void f1352(int c,C_word t0,C_word t1) C_noret;
static void f1346(int c,C_word t0,C_word t1) C_noret;
static void f1318(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1325(int c,C_word t0,C_word t1) C_noret;
static void f1328(int c,C_word t0,C_word t1) C_noret;
static void f1297(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1304(int c,C_word t0,C_word t1) C_noret;
static void f1307(int c,C_word t0,C_word t1) C_noret;
static void f1276(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1283(int c,C_word t0,C_word t1) C_noret;
static void f1286(int c,C_word t0,C_word t1) C_noret;
static void f1153(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1153r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1166(int c,C_word t0,C_word t1) C_noret;
static void f1169(int c,C_word t0,C_word t1) C_noret;
static void f1257(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1172(int c,C_word t0,C_word t1) C_noret;
static void f1247(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1175(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1178(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1223(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1230(int c,C_word t0,C_word t1) C_noret;
static void f1202(int c,C_word t0,C_word t1) C_noret;
static void f1210(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1217(int c,C_word t0,C_word t1) C_noret;
static void f1205(int c,C_word t0,C_word t1) C_noret;
static void f1187(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1143(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f1148(int c,C_word t0,C_word t1) C_noret;
static void f1152(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1133(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f1138(int c,C_word t0,C_word t1) C_noret;
static void f1142(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1127(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1132(int c,C_word t0,C_word t1) C_noret;
static void f1085(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1085r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1092(int c,C_word t0,C_word t1) C_noret;
static void f1107(int c,C_word t0,C_word t1) C_noret;
static void f1101(int c,C_word t0,C_word t1) C_noret;
static void f1040(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1040r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1050(int c,C_word t0,C_word t1) C_noret;
static void f1053(int c,C_word t0,C_word t1) C_noret;
static void f1065(int c,C_word t0,C_word t1) C_noret;
static void f1056(int c,C_word t0,C_word t1) C_noret;
static void f1022(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1035(int c,C_word t0,C_word t1) C_noret;
static void f985(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f985r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1002(int c,C_word t0,C_word t1) C_noret;
static void f1011(int c,C_word t0,C_word t1) C_noret;
static void f1005(int c,C_word t0,C_word t1) C_noret;

static void C_fcall trf3636(void *dummy) C_regparm C_noret;
static void C_fcall trf3636(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3636(t0,t1,t2);}

static void C_fcall trf3648(void *dummy) C_regparm C_noret;
static void C_fcall trf3648(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3648(t0,t1,t2);}

static void C_fcall trf3538(void *dummy) C_regparm C_noret;
static void C_fcall trf3538(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3538(t0,t1);}

static void C_fcall trf3437(void *dummy) C_regparm C_noret;
static void C_fcall trf3437(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3437(t0,t1,t2);}

static void C_fcall trf3363(void *dummy) C_regparm C_noret;
static void C_fcall trf3363(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3363(t0,t1,t2);}

static void C_fcall trf3391(void *dummy) C_regparm C_noret;
static void C_fcall trf3391(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3391(t0,t1);}

static void C_fcall trf3302(void *dummy) C_regparm C_noret;
static void C_fcall trf3302(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3302(t0,t1);}

static void C_fcall trf3206(void *dummy) C_regparm C_noret;
static void C_fcall trf3206(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f3206(t0,t1,t2,t3);}

static void C_fcall trf3176(void *dummy) C_regparm C_noret;
static void C_fcall trf3176(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3176(t0,t1,t2);}

static void C_fcall trf3155(void *dummy) C_regparm C_noret;
static void C_fcall trf3155(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3155(t0,t1,t2);}

static void C_fcall trf3003(void *dummy) C_regparm C_noret;
static void C_fcall trf3003(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f3003(t0,t1,t2,t3,t4);}

static void C_fcall trf2862(void *dummy) C_regparm C_noret;
static void C_fcall trf2862(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2862(t0,t1);}

static void C_fcall trf2603(void *dummy) C_regparm C_noret;
static void C_fcall trf2603(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f2603(t0,t1,t2,t3);}

static void C_fcall trf2568(void *dummy) C_regparm C_noret;
static void C_fcall trf2568(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2568(t0,t1,t2);}

static void C_fcall trf2447(void *dummy) C_regparm C_noret;
static void C_fcall trf2447(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2447(t0,t1);}

static void C_fcall trf2295(void *dummy) C_regparm C_noret;
static void C_fcall trf2295(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2295(t0,t1,t2);}

static void C_fcall trf2329(void *dummy) C_regparm C_noret;
static void C_fcall trf2329(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2329(t0,t1,t2);}

static void C_fcall trf2350(void *dummy) C_regparm C_noret;
static void C_fcall trf2350(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2350(t0,t1,t2);}

static void C_fcall trf2242(void *dummy) C_regparm C_noret;
static void C_fcall trf2242(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2242(t0,t1);}

static void C_fcall trf1885(void *dummy) C_regparm C_noret;
static void C_fcall trf1885(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1885(t0,t1);}

static void C_fcall trf1922(void *dummy) C_regparm C_noret;
static void C_fcall trf1922(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1922(t0,t1);}

static void C_fcall trf1902(void *dummy) C_regparm C_noret;
static void C_fcall trf1902(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1902(t0,t1);}

static void C_fcall trf1842(void *dummy) C_regparm C_noret;
static void C_fcall trf1842(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1842(t0,t1,t2);}

static void C_fcall trf1851(void *dummy) C_regparm C_noret;
static void C_fcall trf1851(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1851(t0,t1,t2);}

static void C_fcall trf1590(void *dummy) C_regparm C_noret;
static void C_fcall trf1590(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f1590(t0,t1,t2,t3);}

static void C_fcall trf1584(void *dummy) C_regparm C_noret;
static void C_fcall trf1584(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1584(t0,t1);}

static void C_fcall trf1516(void *dummy) C_regparm C_noret;
static void C_fcall trf1516(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1516(t0,t1);}

static void C_fcall trf1178(void *dummy) C_regparm C_noret;
static void C_fcall trf1178(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1178(t0,t1);}

static void C_fcall trf1143(void *dummy) C_regparm C_noret;
static void C_fcall trf1143(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1143(t0,t1,t2);}

static void C_fcall trf1133(void *dummy) C_regparm C_noret;
static void C_fcall trf1133(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1133(t0,t1,t2);}

static void C_fcall trf1127(void *dummy) C_regparm C_noret;
static void C_fcall trf1127(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1127(t0,t1);}

static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n*3);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

static int toplevel_initialized=0;
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
static void C_fcall toplevel_trampoline(void *dummy){
C_unistd_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_unistd_toplevel(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("unistd_toplevel"));
if(!C_demand(3)){
C_save(t1);
C_reclaim(toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(4079)) C_bad_memory_2();
a=C_alloc(3);
lf[0]=C_intern(C_heaptop,15,"c-1009994153385");
lf[1]=C_string(C_heaptop,28,"too many optional arguments.");
lf[2]=C_intern(C_heaptop,8,"pipe/buf");
lf[3]=C_intern(C_heaptop,11,"open/rdonly");
lf[4]=C_intern(C_heaptop,11,"open/wronly");
lf[5]=C_intern(C_heaptop,9,"open/rdwr");
lf[6]=C_intern(C_heaptop,9,"open/read");
lf[7]=C_intern(C_heaptop,10,"open/write");
lf[8]=C_intern(C_heaptop,10,"open/creat");
lf[9]=C_intern(C_heaptop,11,"open/append");
lf[10]=C_intern(C_heaptop,9,"open/excl");
lf[11]=C_intern(C_heaptop,11,"open/noctty");
lf[12]=C_intern(C_heaptop,13,"open/nonblock");
lf[13]=C_intern(C_heaptop,10,"open/trunc");
lf[14]=C_intern(C_heaptop,9,"open/sync");
lf[15]=C_intern(C_heaptop,10,"perm/irusr");
lf[16]=C_intern(C_heaptop,10,"perm/iwusr");
lf[17]=C_intern(C_heaptop,10,"perm/ixusr");
lf[18]=C_intern(C_heaptop,10,"perm/irgrp");
lf[19]=C_intern(C_heaptop,10,"perm/iwgrp");
lf[20]=C_intern(C_heaptop,10,"perm/ixgrp");
lf[21]=C_intern(C_heaptop,10,"perm/iroth");
lf[22]=C_intern(C_heaptop,10,"perm/iwoth");
lf[23]=C_intern(C_heaptop,10,"perm/ixoth");
lf[24]=C_intern(C_heaptop,10,"perm/irwxu");
lf[25]=C_intern(C_heaptop,10,"perm/irwxg");
lf[26]=C_intern(C_heaptop,10,"perm/irwxo");
lf[27]=C_intern(C_heaptop,10,"perm/isvtx");
lf[28]=C_intern(C_heaptop,10,"perm/isuid");
lf[29]=C_intern(C_heaptop,10,"perm/isgid");
lf[30]=C_intern(C_heaptop,9,"file-open");
lf[31]=C_intern(C_heaptop,15,"\003syssignal-hook");
lf[32]=C_intern(C_heaptop,11,"\000file-error");
lf[33]=C_string(C_heaptop,17,"can not open file");
lf[34]=C_intern(C_heaptop,16,"\003sysupdate-errno");
lf[35]=C_intern(C_heaptop,17,"\003sysmake-c-string");
lf[36]=C_intern(C_heaptop,10,"file-close");
lf[37]=C_string(C_heaptop,18,"can not close file");
lf[38]=C_intern(C_heaptop,11,"make-string");
lf[39]=C_intern(C_heaptop,9,"file-read");
lf[40]=C_string(C_heaptop,22,"can not read from file");
lf[41]=C_intern(C_heaptop,11,"\000type-error");
lf[42]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[43]=C_intern(C_heaptop,10,"file-write");
lf[44]=C_string(C_heaptop,21,"can not write to file");
lf[45]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[46]=C_intern(C_heaptop,27,"\003sysforeign-fixnum-argument");
lf[47]=C_intern(C_heaptop,11,"file-select");
lf[48]=C_string(C_heaptop,28,"call to `file-select\047 failed");
lf[49]=C_intern(C_heaptop,12,"\003sysfor-each");
lf[50]=C_intern(C_heaptop,8,"seek/set");
lf[51]=C_intern(C_heaptop,8,"seek/end");
lf[52]=C_intern(C_heaptop,8,"seek/cur");
lf[53]=C_intern(C_heaptop,9,"file-size");
lf[54]=C_string(C_heaptop,19,"can not access file");
lf[55]=C_intern(C_heaptop,13,"\003sysfile-info");
lf[56]=C_intern(C_heaptop,22,"file-modification-time");
lf[57]=C_string(C_heaptop,19,"can not access file");
lf[58]=C_intern(C_heaptop,10,"file-owner");
lf[59]=C_string(C_heaptop,19,"can not access file");
lf[60]=C_intern(C_heaptop,13,"file-position");
lf[61]=C_string(C_heaptop,38,"can not retrieve file position of port");
lf[62]=C_intern(C_heaptop,21,"\003sysport-file-resolve");
lf[63]=C_string(C_heaptop,12,"invalid file");
lf[64]=C_intern(C_heaptop,18,"set-file-position!");
lf[65]=C_string(C_heaptop,25,"can not set file position");
lf[66]=C_string(C_heaptop,12,"invalid file");
lf[67]=C_intern(C_heaptop,9,"\003syserror");
lf[68]=C_string(C_heaptop,30,"invalid negative port position");
lf[69]=C_intern(C_heaptop,16,"create-directory");
lf[70]=C_string(C_heaptop,24,"can not create directory");
lf[71]=C_intern(C_heaptop,16,"change-directory");
lf[72]=C_string(C_heaptop,32,"can not change current directory");
lf[73]=C_intern(C_heaptop,16,"delete-directory");
lf[74]=C_string(C_heaptop,24,"can not delete directory");
lf[75]=C_intern(C_heaptop,9,"substring");
lf[76]=C_intern(C_heaptop,9,"directory");
lf[77]=C_intern(C_heaptop,10,"directory?");
lf[78]=C_intern(C_heaptop,17,"current-directory");
lf[79]=C_string(C_heaptop,33,"can not examine current directory");
lf[80]=C_intern(C_heaptop,5,"\000text");
lf[81]=C_string(C_heaptop,35,"illegal input/output mode specifier");
lf[82]=C_string(C_heaptop,17,"can not open pipe");
lf[83]=C_string(C_heaptop,6,"(pipe)");
lf[84]=C_intern(C_heaptop,13,"\003sysmake-port");
lf[85]=C_intern(C_heaptop,15,"open-input-pipe");
lf[86]=C_intern(C_heaptop,7,"\000binary");
lf[87]=C_intern(C_heaptop,16,"open-output-pipe");
lf[88]=C_intern(C_heaptop,16,"close-input-pipe");
lf[89]=C_string(C_heaptop,24,"error while closing pipe");
lf[90]=C_intern(C_heaptop,14,"\003syscheck-port");
lf[91]=C_intern(C_heaptop,17,"close-output-pipe");
lf[92]=C_intern(C_heaptop,20,"call-with-input-pipe");
lf[93]=C_intern(C_heaptop,6,"values");
lf[94]=C_intern(C_heaptop,21,"call-with-output-pipe");
lf[95]=C_intern(C_heaptop,20,"with-input-from-pipe");
lf[96]=C_intern(C_heaptop,18,"\003sysstandard-input");
lf[97]=C_intern(C_heaptop,19,"with-output-to-pipe");
lf[98]=C_intern(C_heaptop,19,"\003sysstandard-output");
lf[99]=C_intern(C_heaptop,11,"create-pipe");
lf[100]=C_string(C_heaptop,19,"can not create pipe");
lf[101]=C_intern(C_heaptop,12,"string-match");
lf[102]=C_intern(C_heaptop,18,"absolute-pathname?");
lf[103]=C_intern(C_heaptop,13,"string-append");
lf[104]=C_string(C_heaptop,0,"");
lf[105]=C_string(C_heaptop,0,"");
lf[106]=C_string(C_heaptop,0,"");
lf[107]=C_string(C_heaptop,0,"");
lf[108]=C_intern(C_heaptop,28,"pathname-extension-separator");
lf[109]=C_intern(C_heaptop,28,"pathname-directory-separator");
lf[110]=C_string(C_heaptop,0,"");
lf[111]=C_string(C_heaptop,0,"");
lf[112]=C_string(C_heaptop,0,"");
lf[113]=C_intern(C_heaptop,13,"make-pathname");
lf[114]=C_intern(C_heaptop,22,"make-absolute-pathname");
lf[115]=C_string(C_heaptop,0,"");
lf[116]=C_intern(C_heaptop,18,"decompose-pathname");
lf[117]=C_intern(C_heaptop,18,"pathname-directory");
lf[118]=C_intern(C_heaptop,13,"pathname-file");
lf[119]=C_intern(C_heaptop,18,"pathname-extension");
lf[120]=C_intern(C_heaptop,24,"pathname-strip-directory");
lf[121]=C_intern(C_heaptop,24,"pathname-strip-extension");
lf[122]=C_intern(C_heaptop,26,"pathname-replace-directory");
lf[123]=C_intern(C_heaptop,3,"dir");
lf[124]=C_intern(C_heaptop,21,"pathname-replace-file");
lf[125]=C_intern(C_heaptop,26,"pathname-replace-extension");
lf[126]=C_intern(C_heaptop,6,"getenv");
lf[127]=C_intern(C_heaptop,12,"file-exists?");
lf[128]=C_intern(C_heaptop,21,"call-with-output-file");
lf[129]=C_intern(C_heaptop,21,"create-temporary-file");
lf[130]=C_string(C_heaptop,3,"tmp");
lf[131]=C_string(C_heaptop,1,"t");
lf[132]=C_string(C_heaptop,3,"TMP");
lf[133]=C_string(C_heaptop,4,"TEMP");
lf[134]=C_string(C_heaptop,6,"TMPDIR");
lf[135]=C_intern(C_heaptop,15,"pattern->regexp");
lf[136]=C_intern(C_heaptop,4,"glob");
lf[137]=C_string(C_heaptop,1,".");
lf[138]=C_string(C_heaptop,1,"*");
lf[139]=C_intern(C_heaptop,11,"signal/term");
lf[140]=C_intern(C_heaptop,11,"signal/kill");
lf[141]=C_intern(C_heaptop,10,"signal/int");
lf[142]=C_intern(C_heaptop,10,"signal/hup");
lf[143]=C_intern(C_heaptop,10,"signal/fpe");
lf[144]=C_intern(C_heaptop,10,"signal/ill");
lf[145]=C_intern(C_heaptop,11,"signal/segv");
lf[146]=C_intern(C_heaptop,11,"signal/abrt");
lf[147]=C_intern(C_heaptop,11,"signal/trap");
lf[148]=C_intern(C_heaptop,11,"signal/quit");
lf[149]=C_intern(C_heaptop,11,"signal/alrm");
lf[150]=C_intern(C_heaptop,13,"signal/vtalrm");
lf[151]=C_intern(C_heaptop,11,"signal/prof");
lf[152]=C_intern(C_heaptop,9,"signal/io");
lf[153]=C_intern(C_heaptop,10,"signal/urg");
lf[154]=C_intern(C_heaptop,11,"signal/chld");
lf[155]=C_intern(C_heaptop,11,"signal/cont");
lf[156]=C_intern(C_heaptop,11,"signal/stop");
lf[157]=C_intern(C_heaptop,11,"signal/tstp");
lf[158]=C_intern(C_heaptop,11,"signal/pipe");
lf[159]=C_intern(C_heaptop,11,"signal/xcpu");
lf[160]=C_intern(C_heaptop,11,"signal/xfsz");
lf[161]=C_intern(C_heaptop,11,"signal/usr1");
lf[162]=C_intern(C_heaptop,11,"signal/usr2");
lf[163]=C_intern(C_heaptop,12,"signal/winch");
lf[164]=C_intern(C_heaptop,18,"\003sysinterrupt-hook");
lf[165]=C_intern(C_heaptop,19,"set-signal-handler!");
lf[166]=C_intern(C_heaptop,16,"\003sysdynamic-wind");
lf[167]=C_intern(C_heaptop,22,"\003sysdisable-interrupts");
lf[168]=C_intern(C_heaptop,21,"\003sysenable-interrupts");
lf[169]=C_intern(C_heaptop,18,"\003syscontext-switch");
lf[170]=C_intern(C_heaptop,16,"set-signal-mask!");
lf[171]=C_string(C_heaptop,23,"can not set signal mask");
lf[172]=C_intern(C_heaptop,12,"process-fork");
lf[173]=C_string(C_heaptop,28,"can not create child process");
lf[174]=C_intern(C_heaptop,27,"\003sysforeign-string-argument");
lf[175]=C_intern(C_heaptop,15,"process-execute");
lf[176]=C_string(C_heaptop,23,"can not execute process");
lf[177]=C_intern(C_heaptop,12,"process-wait");
lf[178]=C_string(C_heaptop,32,"waiting for child process failed");
lf[179]=C_intern(C_heaptop,5,"error");
lf[180]=C_intern(C_heaptop,18,"current-process-id");
lf[181]=C_intern(C_heaptop,17,"parent-process-id");
lf[182]=C_intern(C_heaptop,14,"process-signal");
lf[183]=C_string(C_heaptop,32,"could not send signal to process");
lf[184]=C_intern(C_heaptop,11,"process-run");
lf[185]=C_string(C_heaptop,7,"/bin/sh");
lf[186]=C_string(C_heaptop,2,"-c");
lf[187]=C_string(C_heaptop,5,"SHELL");
lf[188]=C_intern(C_heaptop,18,"system-information");
lf[189]=C_intern(C_heaptop,17,"\003syspeek-c-string");
lf[190]=C_string(C_heaptop,35,"can not retrieve system information");
lf[191]=C_intern(C_heaptop,16,"user-information");
lf[192]=C_intern(C_heaptop,10,"errno/perm");
lf[193]=C_intern(C_heaptop,11,"errno/noent");
lf[194]=C_intern(C_heaptop,10,"errno/srch");
lf[195]=C_intern(C_heaptop,10,"errno/intr");
lf[196]=C_intern(C_heaptop,8,"errno/io");
lf[197]=C_intern(C_heaptop,12,"errno/noexec");
lf[198]=C_intern(C_heaptop,10,"errno/badf");
lf[199]=C_intern(C_heaptop,11,"errno/child");
lf[200]=C_intern(C_heaptop,11,"errno/nomem");
lf[201]=C_intern(C_heaptop,11,"errno/acces");
lf[202]=C_intern(C_heaptop,11,"errno/fault");
lf[203]=C_intern(C_heaptop,10,"errno/busy");
lf[204]=C_intern(C_heaptop,12,"errno/notdir");
lf[205]=C_intern(C_heaptop,11,"errno/isdir");
lf[206]=C_intern(C_heaptop,11,"errno/inval");
lf[207]=C_intern(C_heaptop,11,"errno/mfile");
lf[208]=C_intern(C_heaptop,11,"errno/nospc");
lf[209]=C_intern(C_heaptop,11,"errno/spipe");
lf[210]=C_intern(C_heaptop,10,"errno/pipe");
lf[211]=C_intern(C_heaptop,11,"errno/again");
lf[212]=C_intern(C_heaptop,10,"errno/rofs");
lf[213]=C_intern(C_heaptop,16,"change-file-mode");
lf[214]=C_string(C_heaptop,24,"can not change file mode");
lf[215]=C_intern(C_heaptop,17,"change-file-owner");
lf[216]=C_string(C_heaptop,25,"can not change file owner");
lf[217]=C_intern(C_heaptop,15,"current-user-id");
lf[218]=C_intern(C_heaptop,16,"current-group-id");
lf[219]=C_intern(C_heaptop,25,"current-effective-user-id");
lf[220]=C_intern(C_heaptop,26,"current-effective-group-id");
lf[221]=C_intern(C_heaptop,12,"set-user-id!");
lf[222]=C_string(C_heaptop,19,"can not set user id");
lf[223]=C_intern(C_heaptop,17,"file-read-access?");
lf[224]=C_intern(C_heaptop,18,"file-write-access?");
lf[225]=C_intern(C_heaptop,20,"file-execute-access?");
lf[226]=C_intern(C_heaptop,16,"file-permissions");
lf[227]=C_string(C_heaptop,31,"can not access file permissions");
lf[228]=C_intern(C_heaptop,20,"create-symbolic-link");
lf[229]=C_string(C_heaptop,28,"can not create symbolic link");
lf[230]=C_intern(C_heaptop,18,"read-symbolic-link");
lf[231]=C_string(C_heaptop,26,"can not read symbolic link");
lf[232]=C_intern(C_heaptop,12,"fileno/stdin");
lf[233]=C_intern(C_heaptop,13,"fileno/stdout");
lf[234]=C_intern(C_heaptop,13,"fileno/stderr");
lf[235]=C_intern(C_heaptop,19,"\003sysallocate-vector");
lf[236]=C_intern(C_heaptop,7,"\000append");
lf[237]=C_string(C_heaptop,1,"a");
lf[238]=C_string(C_heaptop,27,"invalid mode for input file");
lf[239]=C_string(C_heaptop,21,"invalid mode argument");
lf[240]=C_string(C_heaptop,1,"w");
lf[241]=C_string(C_heaptop,1,"r");
lf[242]=C_string(C_heaptop,17,"can not open file");
lf[243]=C_string(C_heaptop,8,"(fdport)");
lf[244]=C_intern(C_heaptop,16,"open-input-file*");
lf[245]=C_intern(C_heaptop,17,"open-output-file*");
lf[246]=C_string(C_heaptop,1,"w");
lf[247]=C_intern(C_heaptop,12,"port->fileno");
lf[248]=C_string(C_heaptop,38,"can not access file-descriptor of port");
lf[249]=C_intern(C_heaptop,16,"duplicate-fileno");
lf[250]=C_string(C_heaptop,33,"can not duplicate file descriptor");
lf[251]=C_intern(C_heaptop,13,"file-truncate");
lf[252]=C_string(C_heaptop,21,"can not truncate file");
lf[253]=C_string(C_heaptop,12,"invalid file");
lf[254]=C_intern(C_heaptop,4,"lock");
lf[255]=C_intern(C_heaptop,9,"file-lock");
lf[256]=C_string(C_heaptop,17,"can not lock file");
lf[257]=C_intern(C_heaptop,14,"file-test-lock");
lf[258]=C_string(C_heaptop,19,"can not unlock file");
lf[259]=C_intern(C_heaptop,11,"file-unlock");
lf[260]=C_string(C_heaptop,19,"can not unlock file");
lf[261]=C_intern(C_heaptop,11,"create-fifo");
lf[262]=C_string(C_heaptop,19,"can not create FIFO");
lf[263]=C_intern(C_heaptop,5,"fifo?");
lf[264]=C_string(C_heaptop,19,"file does not exist");
lf[265]=C_intern(C_heaptop,6,"setenv");
lf[266]=C_intern(C_heaptop,8,"unsetenv");
lf[267]=C_intern(C_heaptop,19,"current-environment");
lf[268]=C_intern(C_heaptop,9,"prot/read");
lf[269]=C_intern(C_heaptop,10,"prot/write");
lf[270]=C_intern(C_heaptop,9,"prot/exec");
lf[271]=C_intern(C_heaptop,9,"prot/none");
lf[272]=C_intern(C_heaptop,9,"map/fixed");
lf[273]=C_intern(C_heaptop,10,"map/shared");
lf[274]=C_intern(C_heaptop,11,"map/private");
lf[275]=C_intern(C_heaptop,13,"map/anonymous");
lf[276]=C_intern(C_heaptop,8,"map/file");
lf[277]=C_intern(C_heaptop,18,"map-file-to-memory");
lf[278]=C_intern(C_heaptop,4,"mmap");
lf[279]=C_string(C_heaptop,26,"can not map file to memory");
lf[280]=C_intern(C_heaptop,20,"\003syspointer->address");
lf[281]=C_intern(C_heaptop,28,"\003sysforeign-integer-argument");
lf[282]=C_intern(C_heaptop,28,"\003sysforeign-pointer-argument");
lf[283]=C_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[284]=C_intern(C_heaptop,16,"\003sysnull-pointer");
lf[285]=C_intern(C_heaptop,22,"ummap-file-from-memory");
lf[286]=C_string(C_heaptop,30,"can not unmap file from memory");
lf[287]=C_intern(C_heaptop,19,"seconds->local-time");
lf[288]=C_intern(C_heaptop,18,"\003sysdecode-seconds");
lf[289]=C_intern(C_heaptop,17,"seconds->utc-time");
lf[290]=C_intern(C_heaptop,15,"seconds->string");
lf[291]=C_string(C_heaptop,33,"can not convert seconds to string");
lf[292]=C_intern(C_heaptop,12,"time->string");
lf[293]=C_string(C_heaptop,33,"can not convert seconds to string");
lf[294]=C_intern(C_heaptop,4,"secs");
lf[295]=C_string(C_heaptop,21,"time vector too short");
lf[296]=C_intern(C_heaptop,5,"_exit");
lf[297]=C_intern(C_heaptop,23,"\003syscleanup-before-exit");
lf[298]=C_intern(C_heaptop,10,"set-alarm!");
lf[299]=C_intern(C_heaptop,19,"set-buffering-mode!");
lf[300]=C_string(C_heaptop,26,"can not set buffering mode");
lf[301]=C_intern(C_heaptop,5,"\000full");
lf[302]=C_intern(C_heaptop,5,"\000line");
lf[303]=C_intern(C_heaptop,5,"\000none");
lf[304]=C_string(C_heaptop,22,"invalid buffering-mode");
lf[305]=C_intern(C_heaptop,14,"terminal-port?");
lf[306]=C_intern(C_heaptop,25,"\003syspeek-unsigned-integer");
lf[307]=C_intern(C_heaptop,13,"terminal-name");
lf[308]=C_intern(C_heaptop,2,"fp");
lf[309]=C_string(C_heaptop,35,"port is not connected to a terminal");
lf[310]=C_intern(C_heaptop,13,"get-host-name");
lf[311]=C_string(C_heaptop,26,"can not retrieve host-name");
lf[312]=C_intern(C_heaptop,23,"\003sysuser-interrupt-hook");
lf[313]=C_intern(C_heaptop,11,"make-vector");
lf[314]=C_string(C_heaptop,5,"^(.*[");
lf[315]=C_string(C_heaptop,6,"])?((\134");
lf[316]=C_string(C_heaptop,4,")?[^");
lf[317]=C_string(C_heaptop,4,"]+)$");
lf[318]=C_string(C_heaptop,5,"^(.*[");
lf[319]=C_string(C_heaptop,6,"])?([^");
lf[320]=C_string(C_heaptop,5,"]+)(\134");
lf[321]=C_string(C_heaptop,3,"([^");
lf[322]=C_string(C_heaptop,5,"]+))$");
lf[323]=C_string(C_heaptop,1,"/");
lf[324]=C_intern(C_heaptop,6,"string");
lf[325]=C_string(C_heaptop,14,"([A-Za-z]:)?[/");
lf[326]=C_string(C_heaptop,3,"].+");
lf[327]=C_intern(C_heaptop,17,"register-feature!");
lf[328]=C_intern(C_heaptop,6,"unistd");
C_register_lf(lf,329);
t2=C_mutate((C_word*)lf[0]+1,lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f949,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t3);}

static void f949(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f949);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f952,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[327]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[328]);}

static void f952(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word ab[89],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f952);}
t2=C_mutate((C_word*)lf[2]+1,C_fix((C_word)PIPE_BUF));
t3=C_mutate((C_word*)lf[3]+1,C_fix((C_word)O_RDONLY));
t4=C_mutate((C_word*)lf[4]+1,C_fix((C_word)O_WRONLY));
t5=C_mutate((C_word*)lf[5]+1,C_fix((C_word)O_RDWR));
t6=C_mutate((C_word*)lf[6]+1,C_fix((C_word)O_RDWR));
t7=C_mutate((C_word*)lf[7]+1,C_fix((C_word)O_WRONLY));
t8=C_mutate((C_word*)lf[8]+1,C_fix((C_word)O_CREAT));
t9=C_mutate((C_word*)lf[9]+1,C_fix((C_word)O_CREAT));
t10=C_mutate((C_word*)lf[10]+1,C_fix((C_word)O_CREAT));
t11=C_mutate((C_word*)lf[11]+1,C_fix((C_word)O_CREAT));
t12=C_mutate((C_word*)lf[12]+1,C_fix((C_word)O_CREAT));
t13=C_mutate((C_word*)lf[13]+1,C_fix((C_word)O_CREAT));
t14=C_mutate((C_word*)lf[14]+1,C_fix((C_word)O_CREAT));
t15=C_mutate((C_word*)lf[15]+1,C_fix((C_word)S_IRUSR));
t16=C_mutate((C_word*)lf[16]+1,C_fix((C_word)S_IWUSR));
t17=C_mutate((C_word*)lf[17]+1,C_fix((C_word)S_IXUSR));
t18=C_mutate((C_word*)lf[18]+1,C_fix((C_word)S_IRGRP));
t19=C_mutate((C_word*)lf[19]+1,C_fix((C_word)S_IWGRP));
t20=C_mutate((C_word*)lf[20]+1,C_fix((C_word)S_IXGRP));
t21=C_mutate((C_word*)lf[21]+1,C_fix((C_word)S_IROTH));
t22=C_mutate((C_word*)lf[22]+1,C_fix((C_word)S_IWOTH));
t23=C_mutate((C_word*)lf[23]+1,C_fix((C_word)S_IXOTH));
t24=C_mutate((C_word*)lf[24]+1,C_fix((C_word)S_IRWXU));
t25=C_mutate((C_word*)lf[25]+1,C_fix((C_word)S_IRWXG));
t26=C_mutate((C_word*)lf[26]+1,C_fix((C_word)S_IRWXO));
t27=C_mutate((C_word*)lf[27]+1,C_fix((C_word)S_ISVTX));
t28=C_mutate((C_word*)lf[28]+1,C_fix((C_word)S_ISUID));
t29=C_mutate((C_word*)lf[29]+1,C_fix((C_word)S_ISGID));
t30=(C_word)C_fixnum_or(C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t31=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t30);
t32=C_mutate((C_word*)lf[30]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f985,a[2]=t31,tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[36]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1022,tmp=(C_word)a,a+=2,tmp));
t34=*((C_word*)lf[38]+1);
t35=C_mutate((C_word*)lf[39]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1040,a[2]=t34,tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[43]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1085,tmp=(C_word)a,a+=2,tmp));
t37=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1127,tmp=(C_word)a,a+=2,tmp);
t38=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1133,tmp=(C_word)a,a+=2,tmp);
t39=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1143,tmp=(C_word)a,a+=2,tmp);
t40=C_mutate((C_word*)lf[47]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1153,a[2]=t37,a[3]=t38,a[4]=t39,tmp=(C_word)a,a+=5,tmp));
t41=C_mutate((C_word*)lf[50]+1,C_fix((C_word)SEEK_SET));
t42=C_mutate((C_word*)lf[51]+1,C_fix((C_word)SEEK_END));
t43=C_mutate((C_word*)lf[52]+1,C_fix((C_word)SEEK_CUR));
t44=C_mutate((C_word*)lf[53]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1276,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[56]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1297,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[58]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1318,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[60]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1339,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[64]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1373,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[69]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1428,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[71]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1451,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[73]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1474,tmp=(C_word)a,a+=2,tmp));
t52=*((C_word*)lf[38]+1);
t53=*((C_word*)lf[75]+1);
t54=C_mutate((C_word*)lf[76]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1497,a[2]=t52,a[3]=t53,tmp=(C_word)a,a+=4,tmp));
t55=C_mutate((C_word*)lf[77]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1535,tmp=(C_word)a,a+=2,tmp));
t56=*((C_word*)lf[38]+1);
t57=*((C_word*)lf[75]+1);
t58=C_mutate((C_word*)lf[78]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1554,a[2]=t56,a[3]=t57,tmp=(C_word)a,a+=4,tmp));
t59=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1572,tmp=(C_word)a,a+=2,tmp);
t60=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1584,tmp=(C_word)a,a+=2,tmp);
t61=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1590,tmp=(C_word)a,a+=2,tmp);
t62=C_mutate((C_word*)lf[85]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1623,a[2]=t60,a[3]=t61,a[4]=t59,tmp=(C_word)a,a+=5,tmp));
t63=C_mutate((C_word*)lf[87]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1659,a[2]=t60,a[3]=t61,a[4]=t59,tmp=(C_word)a,a+=5,tmp));
t64=C_mutate((C_word*)lf[88]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1695,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[91]+1,*((C_word*)lf[88]+1));
t66=*((C_word*)lf[85]+1);
t67=*((C_word*)lf[87]+1);
t68=*((C_word*)lf[88]+1);
t69=*((C_word*)lf[91]+1);
t70=C_mutate((C_word*)lf[92]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1714,a[2]=t66,a[3]=t68,tmp=(C_word)a,a+=4,tmp));
t71=C_mutate((C_word*)lf[94]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1738,a[2]=t67,a[3]=t69,tmp=(C_word)a,a+=4,tmp));
t72=C_mutate((C_word*)lf[95]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1762,a[2]=t66,a[3]=t68,tmp=(C_word)a,a+=4,tmp));
t73=C_mutate((C_word*)lf[97]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1782,a[2]=t67,a[3]=t69,tmp=(C_word)a,a+=4,tmp));
t74=C_mutate((C_word*)lf[99]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1802,tmp=(C_word)a,a+=2,tmp));
t75=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1822,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t76=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f4093,a[2]=t75,tmp=(C_word)a,a+=3,tmp);
t77=*((C_word*)lf[324]+1);
((C_proc3)C_retrieve_proc(t77))(3,t77,t76,*((C_word*)lf[109]+1));}

static void f4093(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[103]+1);
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[2],lf[325],t1,lf[326]);}

static void f1822(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1822);}
t2=*((C_word*)lf[101]+1);
t3=C_mutate((C_word*)lf[102]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1823,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp));
t4=*((C_word*)lf[103]+1);
t5=*((C_word*)lf[102]+1);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1837,a[2]=((C_word*)t0)[2],a[3]=t5,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t7=*((C_word*)lf[324]+1);
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,*((C_word*)lf[109]+1));}

static void f1837(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1837);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1840,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[324]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,*((C_word*)lf[108]+1));}

static void f1840(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1840);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1842,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1875,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=C_mutate((C_word*)lf[113]+1,t3);
t5=C_mutate((C_word*)lf[114]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1982,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,tmp=(C_word)a,a+=7,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2028,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t7=*((C_word*)lf[324]+1);
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,*((C_word*)lf[108]+1));}

static void f2028(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2028);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2031,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f4089,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[324]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,*((C_word*)lf[109]+1));}

static void f4089(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[103]+1);
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],lf[323],t1);}

static void f2031(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2031);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2034,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[103]+1);
((C_proc12)C_retrieve_proc(t3))(12,t3,t2,lf[318],t1,lf[319],t1,lf[320],((C_word*)t0)[2],lf[321],t1,((C_word*)t0)[2],lf[322]);}

static void f2034(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2034);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2037,a[2]=((C_word*)t0)[4],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[103]+1);
((C_proc9)C_retrieve_proc(t3))(9,t3,t2,lf[314],((C_word*)t0)[3],lf[315],((C_word*)t0)[2],lf[316],((C_word*)t0)[3],lf[317]);}

static void f2037(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word ab[46],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2037);}
t2=*((C_word*)lf[101]+1);
t3=C_mutate((C_word*)lf[116]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2038,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp));
t4=*((C_word*)lf[116]+1);
t5=C_mutate((C_word*)lf[117]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2089,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[118]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2104,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[119]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2119,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[120]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2134,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[121]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2152,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[122]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2170,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[124]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2188,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[125]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2206,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t13=*((C_word*)lf[126]+1);
t14=*((C_word*)lf[113]+1);
t15=*((C_word*)lf[103]+1);
t16=*((C_word*)lf[127]+1);
t17=*((C_word*)lf[128]+1);
t18=C_mutate((C_word*)lf[129]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2224,a[2]=t13,a[3]=t15,a[4]=t14,a[5]=t16,a[6]=t17,tmp=(C_word)a,a+=7,tmp));
t19=*((C_word*)lf[135]+1);
t20=*((C_word*)lf[76]+1);
t21=*((C_word*)lf[113]+1);
t22=*((C_word*)lf[116]+1);
t23=C_mutate((C_word*)lf[136]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2289,a[2]=t19,a[3]=t20,a[4]=t21,a[5]=t22,tmp=(C_word)a,a+=6,tmp));
t24=C_mutate((C_word*)lf[139]+1,C_fix((C_word)SIGTERM));
t25=C_mutate((C_word*)lf[140]+1,C_fix((C_word)SIGKILL));
t26=C_mutate((C_word*)lf[141]+1,C_fix((C_word)SIGINT));
t27=C_mutate((C_word*)lf[142]+1,C_fix((C_word)SIGHUP));
t28=C_mutate((C_word*)lf[143]+1,C_fix((C_word)SIGFPE));
t29=C_mutate((C_word*)lf[144]+1,C_fix((C_word)SIGILL));
t30=C_mutate((C_word*)lf[145]+1,C_fix((C_word)SIGSEGV));
t31=C_mutate((C_word*)lf[146]+1,C_fix((C_word)SIGABRT));
t32=C_mutate((C_word*)lf[147]+1,C_fix((C_word)SIGTRAP));
t33=C_mutate((C_word*)lf[148]+1,C_fix((C_word)SIGQUIT));
t34=C_mutate((C_word*)lf[149]+1,C_fix((C_word)SIGALRM));
t35=C_mutate((C_word*)lf[150]+1,C_fix((C_word)SIGVTALRM));
t36=C_mutate((C_word*)lf[151]+1,C_fix((C_word)SIGPROF));
t37=C_mutate((C_word*)lf[152]+1,C_fix((C_word)SIGIO));
t38=C_mutate((C_word*)lf[153]+1,C_fix((C_word)SIGURG));
t39=C_mutate((C_word*)lf[154]+1,C_fix((C_word)SIGCHLD));
t40=C_mutate((C_word*)lf[155]+1,C_fix((C_word)SIGCONT));
t41=C_mutate((C_word*)lf[156]+1,C_fix((C_word)SIGSTOP));
t42=C_mutate((C_word*)lf[157]+1,C_fix((C_word)SIGTSTP));
t43=C_mutate((C_word*)lf[158]+1,C_fix((C_word)SIGPIPE));
t44=C_mutate((C_word*)lf[159]+1,C_fix((C_word)SIGXCPU));
t45=C_mutate((C_word*)lf[160]+1,C_fix((C_word)SIGXFSZ));
t46=C_mutate((C_word*)lf[161]+1,C_fix((C_word)SIGUSR1));
t47=C_mutate((C_word*)lf[162]+1,C_fix((C_word)SIGUSR2));
t48=C_mutate((C_word*)lf[163]+1,C_fix((C_word)SIGWINCH));
t49=*((C_word*)lf[164]+1);
t50=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2424,a[2]=((C_word*)t0)[2],a[3]=t49,tmp=(C_word)a,a+=4,tmp);
t51=*((C_word*)lf[313]+1);
((C_proc4)C_retrieve_proc(t51))(4,t51,t50,C_fix(256),C_SCHEME_FALSE);}

static void f2424(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2424);}
t2=C_mutate((C_word*)lf[165]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2426,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[164]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2473,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[170]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2491,tmp=(C_word)a,a+=2,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2519,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f4081,tmp=(C_word)a,a+=2,tmp);
t7=*((C_word*)lf[165]+1);
((C_proc5)C_retrieve_proc(t7))(5,t7,t5,*((C_word*)lf[141]+1),t6,C_SCHEME_TRUE);}

static void f4081(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f4081);}
t3=*((C_word*)lf[312]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t1);}

static void f2519(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word ab[58],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2519);}
t2=C_mutate((C_word*)lf[172]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2523,tmp=(C_word)a,a+=2,tmp));
t3=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2568,tmp=(C_word)a,a+=2,tmp);
t4=*((C_word*)lf[120]+1);
t5=C_mutate((C_word*)lf[175]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2585,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp));
t6=C_mutate((C_word*)lf[177]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2661,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[180]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2740,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[181]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2743,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[182]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2746,tmp=(C_word)a,a+=2,tmp));
t10=*((C_word*)lf[172]+1);
t11=*((C_word*)lf[175]+1);
t12=*((C_word*)lf[126]+1);
t13=C_mutate((C_word*)lf[184]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2776,a[2]=t10,a[3]=t12,a[4]=t11,tmp=(C_word)a,a+=5,tmp));
t14=C_mutate((C_word*)lf[188]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2820,tmp=(C_word)a,a+=2,tmp));
t15=C_mutate((C_word*)lf[191]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2858,tmp=(C_word)a,a+=2,tmp));
t16=C_mutate((C_word*)lf[192]+1,C_fix((C_word)EPERM));
t17=C_mutate((C_word*)lf[193]+1,C_fix((C_word)ENOENT));
t18=C_mutate((C_word*)lf[194]+1,C_fix((C_word)ESRCH));
t19=C_mutate((C_word*)lf[195]+1,C_fix((C_word)EINTR));
t20=C_mutate((C_word*)lf[196]+1,C_fix((C_word)EIO));
t21=C_mutate((C_word*)lf[197]+1,C_fix((C_word)ENOEXEC));
t22=C_mutate((C_word*)lf[198]+1,C_fix((C_word)EBADF));
t23=C_mutate((C_word*)lf[199]+1,C_fix((C_word)ECHILD));
t24=C_mutate((C_word*)lf[200]+1,C_fix((C_word)ENOMEM));
t25=C_mutate((C_word*)lf[201]+1,C_fix((C_word)EACCES));
t26=C_mutate((C_word*)lf[202]+1,C_fix((C_word)EFAULT));
t27=C_mutate((C_word*)lf[203]+1,C_fix((C_word)EBUSY));
t28=C_mutate((C_word*)lf[204]+1,C_fix((C_word)ENOTDIR));
t29=C_mutate((C_word*)lf[205]+1,C_fix((C_word)EISDIR));
t30=C_mutate((C_word*)lf[206]+1,C_fix((C_word)EINVAL));
t31=C_mutate((C_word*)lf[207]+1,C_fix((C_word)EMFILE));
t32=C_mutate((C_word*)lf[208]+1,C_fix((C_word)ENOSPC));
t33=C_mutate((C_word*)lf[209]+1,C_fix((C_word)ESPIPE));
t34=C_mutate((C_word*)lf[210]+1,C_fix((C_word)EPIPE));
t35=C_mutate((C_word*)lf[211]+1,C_fix((C_word)EAGAIN));
t36=C_mutate((C_word*)lf[212]+1,C_fix((C_word)EROFS));
t37=C_mutate((C_word*)lf[213]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2921,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[215]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2947,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[217]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2976,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[218]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2979,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[219]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2982,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[220]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2985,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[221]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2988,tmp=(C_word)a,a+=2,tmp));
t44=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3003,tmp=(C_word)a,a+=2,tmp);
t45=C_mutate((C_word*)lf[223]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3056,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[224]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3062,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[225]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3068,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[226]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3074,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[228]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3095,tmp=(C_word)a,a+=2,tmp));
t50=*((C_word*)lf[75]+1);
t51=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3127,a[2]=((C_word*)t0)[2],a[3]=t50,tmp=(C_word)a,a+=4,tmp);
t52=(C_word)C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
t53=*((C_word*)lf[38]+1);
((C_proc3)C_retrieve_proc(t53))(3,t53,t51,t52);}

static void f3127(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word ab[75],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3127);}
t2=C_mutate((C_word*)lf[230]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3128,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[232]+1,C_fix((C_word)STDIN_FILENO));
t4=C_mutate((C_word*)lf[233]+1,C_fix((C_word)STDOUT_FILENO));
t5=C_mutate((C_word*)lf[234]+1,C_fix((C_word)STDERR_FILENO));
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3155,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3176,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3206,tmp=(C_word)a,a+=2,tmp);
t9=C_mutate((C_word*)lf[244]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3239,a[2]=t7,a[3]=t6,a[4]=t8,tmp=(C_word)a,a+=5,tmp));
t10=C_mutate((C_word*)lf[245]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3256,a[2]=t7,a[3]=t6,a[4]=t8,tmp=(C_word)a,a+=5,tmp));
t11=C_mutate((C_word*)lf[247]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3273,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[249]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3295,tmp=(C_word)a,a+=2,tmp));
t13=C_mutate((C_word*)lf[251]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3325,tmp=(C_word)a,a+=2,tmp));
t14=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3363,tmp=(C_word)a,a+=2,tmp);
t15=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3437,tmp=(C_word)a,a+=2,tmp);
t16=C_mutate((C_word*)lf[255]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3458,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t17=C_mutate((C_word*)lf[257]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3473,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t18=C_mutate((C_word*)lf[259]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3500,tmp=(C_word)a,a+=2,tmp));
t19=C_mutate((C_word*)lf[261]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3531,tmp=(C_word)a,a+=2,tmp));
t20=C_mutate((C_word*)lf[263]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3573,tmp=(C_word)a,a+=2,tmp));
t21=C_mutate((C_word*)lf[265]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3598,tmp=(C_word)a,a+=2,tmp));
t22=C_mutate((C_word*)lf[266]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3607,tmp=(C_word)a,a+=2,tmp));
t23=*((C_word*)lf[75]+1);
t24=C_mutate((C_word*)lf[267]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3630,a[2]=t23,tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[268]+1,C_fix((C_word)PROT_READ));
t26=C_mutate((C_word*)lf[269]+1,C_fix((C_word)PROT_WRITE));
t27=C_mutate((C_word*)lf[270]+1,C_fix((C_word)PROT_EXEC));
t28=C_mutate((C_word*)lf[271]+1,C_fix((C_word)PROT_NONE));
t29=C_mutate((C_word*)lf[272]+1,C_fix((C_word)MAP_FIXED));
t30=C_mutate((C_word*)lf[273]+1,C_fix((C_word)MAP_SHARED));
t31=C_mutate((C_word*)lf[274]+1,C_fix((C_word)MAP_PRIVATE));
t32=C_mutate((C_word*)lf[275]+1,C_fix((C_word)MAP_ANONYMOUS));
t33=C_mutate((C_word*)lf[276]+1,C_fix((C_word)MAP_FILE));
t34=C_mutate((C_word*)lf[277]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3736,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[285]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3801,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[287]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3839,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[289]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3848,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[290]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3870,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[292]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3890,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[296]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3924,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[298]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3943,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[299]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3950,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[305]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f4003,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[307]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f4035,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[310]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f4062,tmp=(C_word)a,a+=2,tmp));
t46=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t46+1)))(2,t46,t45);}

static void f4062(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f4062);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f4066,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f4058,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[235]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f4058(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],(C_word)stub775(t1),C_fix(0));}

static void f4066(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f4066);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4069,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f4069(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f4072,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

static void f4072(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[67]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],lf[311]);}

static void f4069(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f4035(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f4035);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4039,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[90]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f4039(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f4039);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f4042,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4049,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[62]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

static void f4049(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_tty_portp(t1))){
t2=((C_word*)t0)[3];
f4042(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],lf[309],((C_word*)t0)[2]);}}

static void f4042(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f4042);}
t2=((C_word*)t0)[2];
t3=(C_word)C_fileno(*((C_word*)lf[308]+1));
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4026,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[235]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t4,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f4026(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f4026);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4034,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f4034(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub767(((C_word*)t0)[3],t1);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[2],t2,C_fix(0));}

static void f4003(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f4003);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4007,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[90]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f4007(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f4007);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4010,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[306]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

static void f4010(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

static void f3950(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f3950r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f3950r(t0,t1,t2,t3,t4);}}

static void f3950r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3954,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[90]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

static void f3954(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3954);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3960,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[301]);
if(C_truep(t6)){
t7=t5;
f3960(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[302]);
if(C_truep(t7)){
t8=t5;
f3960(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[303]);
if(C_truep(t8)){
t9=t5;
f3960(2,t9,C_fix((C_word)_IONBF));}
else{
t9=*((C_word*)lf[67]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t5,lf[304],((C_word*)t0)[4],((C_word*)t0)[2]);}}}}

static void f3960(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3960);}
t2=(C_word)C_i_check_exact(((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3977,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[62]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

static void f3977(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setvbuf(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=*((C_word*)lf[67]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[300],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f3943(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3943);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3948,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f3948(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub750(C_SCHEME_UNDEFINED,t1));}

static void f3924(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-6)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2rv,f3924r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f3924r(t0,t1,t2);}}

static void f3924r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3928,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[297]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

static void f3928(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3928);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3923,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}

static void f3923(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub744(C_SCHEME_UNDEFINED,t1));}

static void f3890(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3890);}
t3=(C_word)C_i_check_vector(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3897,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(9)))){
t6=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[295],t2);}
else{
t6=t4;
f3897(2,t6,C_SCHEME_UNDEFINED);}}

static void f3897(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3897);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3900,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=((C_word*)t0)[2];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3886,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[235]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t4,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3886(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],(C_word)stub733(t1,((C_word*)t0)[2]),C_fix(0));}

static void f3900(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3900);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3903,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3903(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,lf[293],*((C_word*)lf[294]+1));}}

static void f3903(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f3870(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3870);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3874,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3861,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[235]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t5,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3861(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3861);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3869,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3869(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub724(((C_word*)t0)[3],t1);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[2],t2,C_fix(0));}

static void f3874(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3874);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3877,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3877(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,lf[291],((C_word*)t0)[2]);}}

static void f3877(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f3848(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3848);}
t3=(C_word)C_i_check_exact(t2);
t4=*((C_word*)lf[288]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_TRUE);}

static void f3839(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3839);}
t3=(C_word)C_i_check_exact(t2);
t4=*((C_word*)lf[288]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_FALSE);}

static void f3801(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-8)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f3801r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3801r(t0,t1,t2,t3);}}

static void f3801r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_structure(t2,lf[278]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3793,a[2]=t6,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t7)){
t9=*((C_word*)lf[282]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t7);}
else{
t9=t8;
f3793(2,t9,C_SCHEME_FALSE);}}

static void f3793(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3793);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3797,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[281]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3797(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3797);}
t2=(C_word)stub709(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
t3=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3817,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

static void f3817(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[286],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3736(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc(c,7);
if(!C_stack_probe(&a-15)){
C_adjust_stack(7);
C_rescue(t0,6);
C_rescue(t1,5);
C_rescue(t2,4);
C_rescue(t3,3);
C_rescue(t4,2);
C_rescue(t5,1);
C_rescue(t6,0);
C_reclaim(tr7rv,f3736r);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f3736r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void f3736r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3740,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f3740(2,t10,t2);}
else{
t10=*((C_word*)lf[284]+1);
((C_proc2)C_retrieve_proc(t10))(2,t10,t8);}}

static void f3740(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3740);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3746,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_pointerp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f3746(2,t6,C_SCHEME_UNDEFINED);}
else{
t6=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[41],lf[283],t1);}}

static void f3746(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3746);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f3708,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t5,a[6]=t6,a[7]=((C_word*)t0)[2],a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[5],a[10]=((C_word*)t0)[6],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[7],a[13]=((C_word*)t0)[3],tmp=(C_word)a,a+=14,tmp);
t8=*((C_word*)lf[235]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t7,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3708(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3708);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f3712,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,tmp=(C_word)a,a+=14,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=*((C_word*)lf[282]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f3712(2,t3,C_SCHEME_FALSE);}}

static void f3712(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3712);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f3716,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=t1,a[13]=((C_word*)t0)[13],tmp=(C_word)a,a+=14,tmp);
t3=*((C_word*)lf[281]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3716(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3716);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f3720,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=t1,a[12]=((C_word*)t0)[12],a[13]=((C_word*)t0)[13],tmp=(C_word)a,a+=14,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3720(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3720);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f3724,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=t1,a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],a[13]=((C_word*)t0)[13],tmp=(C_word)a,a+=14,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3724(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3724);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f3728,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=t1,a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],a[13]=((C_word*)t0)[13],tmp=(C_word)a,a+=14,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3728(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3728);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f3732,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t1,a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
t3=*((C_word*)lf[281]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3732(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3732);}
t2=(C_word)stub685(((C_word*)t0)[14],((C_word*)t0)[13],((C_word*)t0)[12],((C_word*)t0)[11],((C_word*)t0)[10],((C_word*)t0)[9],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3752,a[2]=((C_word*)t0)[7],a[3]=t2,a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3768,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],a[8]=t3,tmp=(C_word)a,a+=9,tmp);
t5=*((C_word*)lf[280]+1);
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

static void f3768(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3768);}
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3761,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[8];
f3752(2,t3,C_SCHEME_UNDEFINED);}}

static void f3761(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,((C_word*)t0)[8],lf[32],lf[279],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3752(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3752);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[278],((C_word*)t0)[3],((C_word*)t0)[2]));}

static void f3630(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3630);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3636,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f3636(t5,t1,C_fix(0));}

static void C_fcall f3636(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf3636,NULL);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3640,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3621,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[235]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t5,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3621(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3621);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3629,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3629(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub667(((C_word*)t0)[3],t1);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[2],t2,C_fix(0));}

static void f3640(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3640);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3648,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f3648(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

static void C_fcall f3648(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf3648,NULL);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3674,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
t5=((C_word*)t0)[3];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

static void f3674(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3674);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3678,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

static void f3678(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3678);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3666,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[2])[1];
f3636(t5,t3,t4);}

static void f3666(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3666);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

static void f3607(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3607);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3615,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f3615(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

static void f3598(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f3598);}
t4=(C_word)C_i_check_string(t2);
t5=(C_word)C_i_check_string(t3);
t6=(C_word)C_setenv(t2,t3);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,C_SCHEME_UNDEFINED);}

static void f3573(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3573);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3580,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[55]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f3580(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3580);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3583,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f3583(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[264],((C_word*)t0)[2]);}}

static void f3531(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-7)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f3531r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3531r(t0,t1,t2,t3);}}

static void f3531r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3538,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f3538(t6,(C_word)C_i_vector_ref(t3,C_fix(0)));}
else{
t6=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f3538(t7,(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

static void C_fcall f3538(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf3538,NULL);}
t2=(C_word)C_i_check_exact(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3558,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

static void f3558(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3558);}
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3550,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f3550(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[262],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3500(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3500);}
t3=(C_word)C_i_check_structure(t2,lf[254]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3521,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t10=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

static void f3521(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[260],((C_word*)t0)[2]);}

static void f3473(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-8)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3473r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3473r(t0,t1,t2,t3);}}

static void f3473r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3477,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f3363(t4,t2,t3);}

static void f3477(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=(C_word)C_eqp(t2,C_fix(0));
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_truep(t4)?C_SCHEME_FALSE:t2));}
else{
f3437(((C_word*)t0)[3],lf[258],t1);}}

static void f3458(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-8)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3458r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3458r(t0,t1,t2,t3);}}

static void f3458r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3462,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f3363(t4,t2,t3);}

static void f3462(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
f3437(((C_word*)t0)[2],lf[256],t1);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

static void C_fcall f3437(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf3437,NULL);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3441,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

static void f3441(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(1));
t3=(C_word)C_slot(((C_word*)t0)[4],C_fix(2));
t4=(C_word)C_slot(((C_word*)t0)[4],C_fix(3));
t5=*((C_word*)lf[67]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,((C_word*)t0)[3],((C_word*)t0)[2],t2,t3,t4);}

static void C_fcall f3363(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf3363,NULL);}
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_fix(0):(C_word)C_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
t8=(C_word)C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:(C_word)C_i_car(t7));
t10=t9;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(C_word)C_i_nullp(t7);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t7));
if(C_truep((C_word)C_i_nullp(t13))){
t14=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3385,a[2]=t1,a[3]=t11,a[4]=t2,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
t15=*((C_word*)lf[90]+1);
((C_proc3)(void*)(*((C_word*)t15+1)))(3,t15,t14,t2);}
else{
t14=*((C_word*)lf[179]+1);
((C_proc4)C_retrieve_proc(t14))(4,t14,t1,*((C_word*)lf[0]+1),t13);}}

static void f3385(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3385);}
t2=(C_word)C_i_check_number(((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3391,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f3391(t6,t5);}
else{
t5=t3;
f3391(t5,(C_word)C_i_check_number(((C_word*)((C_word*)t0)[3])[1]));}}

static void C_fcall f3391(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf3391,NULL);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_WRLCK):C_fix((C_word)F_RDLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[254],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

static void f3325(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f3325);}
t4=(C_word)C_i_check_number(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3345,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3352,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f3345(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
t6=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,lf[253],t2);}}}

static void f3352(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f3345(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

static void f3345(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3345);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3338,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

static void f3338(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[252],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3295(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-8)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3295r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3295r(t0,t1,t2,t3);}}

static void f3295r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3302,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t6=t5;
f3302(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_car(t3);
t7=(C_word)C_i_check_exact(t6);
t8=t5;
f3302(t8,(C_word)C_dup2(t2,t6));}}

static void C_fcall f3302(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf3302,NULL);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3305,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3311,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f3305(2,t3,C_SCHEME_UNDEFINED);}}

static void f3311(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[250],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3305(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f3273(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3273);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3277,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[90]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f3277(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3277);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3281,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[62]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3281(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3281);}
t2=(C_word)C_fileno(t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3284,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3290,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f3284(2,t4,C_SCHEME_UNDEFINED);}}

static void f3290(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],lf[248],((C_word*)t0)[2]);}

static void f3284(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f3256(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3256);}
t3=(C_word)C_i_check_exact(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3267,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3271,a[2]=t2,a[3]=t4,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
f3176(t5,C_SCHEME_TRUE,lf[246]);}

static void f3271(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f3155(((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f3267(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f3206(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

static void f3239(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-13)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3239r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3239r(t0,t1,t2,t3);}}

static void f3239r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(10);
t4=(C_word)C_i_check_exact(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3250,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3254,a[2]=t2,a[3]=t5,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
f3176(t6,C_SCHEME_FALSE,t3);}

static void f3254(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f3155(((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f3250(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f3206(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

static void C_fcall f3206(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(trf3206,NULL);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3210,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

static void f3210(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3210);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[32],lf[242],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3222,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[84]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,C_fix(-1),C_fix(6),C_SCHEME_FALSE,((C_word*)t0)[5]);}}

static void f3222(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3222);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3225,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f3225(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_setslot(((C_word*)t0)[4],C_fix(1),((C_word*)t0)[3]);
t3=(C_word)C_i_setslot(((C_word*)t0)[4],C_fix(3),lf[243]);
t4=(C_word)C_i_set_i_slot(((C_word*)t0)[4],C_fix(4),C_fix(0));
t5=(C_word)C_i_set_i_slot(((C_word*)t0)[4],C_fix(5),C_fix(0));
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,((C_word*)t0)[4]);}

static void C_fcall f3176(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf3176,NULL);}
if(C_truep((C_word)C_i_pairp(t3))){
t4=(C_word)C_i_car(t3);
t5=(C_word)C_eqp(t4,lf[236]);
if(C_truep(t5)){
if(C_truep(t2)){
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,lf[237]);}
else{
t6=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,lf[238],t4);}}
else{
t6=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,lf[239],t4);}}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t2)?lf[240]:lf[241]));}}

static void C_fcall f3155(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf3155,NULL);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3159,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[235]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t4,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3159(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3159);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3163,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3163(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3163);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3167,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3174,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[174]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}
else{
t3=t2;
f3167(2,t3,C_SCHEME_FALSE);}}

static void f3174(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

static void f3167(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub561(((C_word*)t0)[3],((C_word*)t0)[2],t1));}

static void f3128(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3128);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3136,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f3136(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3136);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3139,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3148,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f3139(2,t4,C_SCHEME_UNDEFINED);}}

static void f3148(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[231],((C_word*)t0)[2]);}

static void f3139(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[5];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

static void f3095(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f3095);}
t4=(C_word)C_i_check_string(t2);
t5=(C_word)C_i_check_string(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3119,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

static void f3119(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3119);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3123,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3123(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3123);}
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3111,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f3111(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[229],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3074(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3074);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3081,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[55]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f3081(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3081);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3084,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f3084(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(5)));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[227],((C_word*)t0)[2]);}}

static void f3068(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-3)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3068r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3068r(t0,t1,t2,t3);}}

static void f3068r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
f3003(t1,t2,t3,C_fix((C_word)X_OK),C_fix((C_word)S_IXUSR));}

static void f3062(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-3)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3062r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3062r(t0,t1,t2,t3);}}

static void f3062r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
f3003(t1,t2,t3,C_fix((C_word)W_OK),C_fix((C_word)S_IWUSR));}

static void f3056(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-3)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3056r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3056r(t0,t1,t2,t3);}}

static void f3056r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
f3003(t1,t2,t3,C_fix((C_word)R_OK),C_fix((C_word)S_IRUSR));}

static void C_fcall f3003(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t1,4);
C_rescue(t2,3);
C_rescue(t3,2);
C_rescue(t4,1);
C_rescue(t5,0);
C_reclaim(trf3003,NULL);}
t6=(C_word)C_i_check_string(t2);
t7=(C_word)C_i_pairp(t3);
t8=(C_truep(t7)?(C_word)C_i_car(t3):C_SCHEME_FALSE);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3027,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t10=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3030,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t10=*((C_word*)lf[55]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}}

static void f3030(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(5));
t3=(C_word)C_fixnum_and(((C_word*)t0)[3],t2);
t4=(C_word)C_eqp(C_fix(0),t3);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_i_not(t4));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

static void f3027(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3027);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3019,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f3019(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

static void f3019(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f2988(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2988);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2998,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f2998(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],lf[222],((C_word*)t0)[2]);}

static void f2985(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2985);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub520(C_SCHEME_UNDEFINED));}

static void f2982(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2982);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub518(C_SCHEME_UNDEFINED));}

static void f2979(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2979);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub516(C_SCHEME_UNDEFINED));}

static void f2976(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2976);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub514(C_SCHEME_UNDEFINED));}

static void f2947(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2947);}
t5=(C_word)C_i_check_string(t2);
t6=(C_word)C_i_check_exact(t3);
t7=(C_word)C_i_check_exact(t4);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2974,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}

static void f2974(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2974);}
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2966,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f2966(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[5],lf[32],lf[216],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f2921(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2921);}
t4=(C_word)C_i_check_string(t2);
t5=(C_word)C_i_check_exact(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2945,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

static void f2945(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2945);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2937,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f2937(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[214],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f2858(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2858);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2862,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f2862(t4,(C_word)C_getpwuid(t2));}
else{
t4=(C_word)C_i_check_string(t2);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2898,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

static void f2898(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f2862(t2,(C_word)C_getpwnam(t1));}

static void C_fcall f2862(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf2862,NULL);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2872,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

static void f2872(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2872);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2876,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

static void f2876(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2876);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2880,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

static void f2880(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2880);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2884,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

static void f2884(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2884);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2888,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

static void f2888(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(9,0,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f2820(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2820);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2824,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2853,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f2824(2,t3,C_SCHEME_UNDEFINED);}}

static void f2853(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[67]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],lf[190]);}

static void f2824(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2824);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2831,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

static void f2831(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2831);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2835,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

static void f2835(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2835);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2839,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

static void f2839(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2839);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2843,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

static void f2843(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2843);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2847,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[189]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

static void f2847(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(7,0,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f2776(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-10)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f2776r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2776r(t0,t1,t2,t3);}}

static void f2776r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2783,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}

static void f2783(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2783);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[6])){
t3=((C_word*)t0)[5];
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[6]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2798,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,lf[187]);}}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

static void f2798(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2798);}
t2=(C_truep(t1)?t1:lf[185]);
t3=(C_word)C_a_i_list(&a,2,lf[186],((C_word*)t0)[4]);
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,((C_word*)t0)[2],t2,t3);}

static void f2746(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-9)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f2746r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2746r(t0,t1,t2,t3);}}

static void f2746r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact(t2);
t7=(C_word)C_i_check_exact(t5);
t8=(C_word)C_kill(t2,t5);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2759,a[2]=t5,a[3]=t2,a[4]=t1,a[5]=t8,tmp=(C_word)a,a+=6,tmp);
t10=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}

static void f2759(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[67]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[4],lf[183],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f2743(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2743);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub478(C_SCHEME_UNDEFINED));}

static void f2740(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2740);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub476(C_SCHEME_UNDEFINED));}

static void f2661(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-8)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f2661r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2661r(t0,t1,t2);}}

static void f2661r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(6);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t2));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t6));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_truep(t8)?C_fix((C_word)WNOHANG):C_fix(0));
t13=(C_word)C_i_check_exact(t11);
t14=(C_word)C_waitpid(t11,t12);
t15=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t16=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2692,a[2]=t15,a[3]=t11,a[4]=t1,a[5]=t14,tmp=(C_word)a,a+=6,tmp);
t17=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t17+1)))(2,t17,t16);}
else{
t11=*((C_word*)lf[179]+1);
((C_proc4)C_retrieve_proc(t11))(4,t11,t1,*((C_word*)lf[0]+1),t10);}}

static void f2692(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[4],lf[178],((C_word*)t0)[3]);}
else{
t3=(C_truep(((C_word*)t0)[2])?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[2],t3);}}

static void f2585(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-13)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f2585r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2585r(t0,t1,t2,t3);}}

static void f2585r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(10);
t4=(C_word)C_i_check_string(t2);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_END_OF_LIST);
t7=(C_word)C_i_check_list(t6);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2598,a[2]=t6,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2653,a[2]=t8,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t10=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t10))(3,t10,t9,t2);}

static void f2653(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f2568(((C_word*)t0)[2],C_fix(0),t1);}

static void f2598(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2598);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2603,a[2]=t3,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f2603(t5,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

static void C_fcall f2603(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf2603,NULL);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2613,a[2]=((C_word*)t0)[4],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
f2568(t4,t3,C_SCHEME_FALSE);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string(t4);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2638,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
f2568(t6,t3,t4);}}

static void f2638(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)((C_word*)t0)[3])[1];
f2603(t4,((C_word*)t0)[2],t2,t3);}

static void f2613(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2613);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2617,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f2617(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2617);}
t2=(C_word)C_execvp(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2620,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

static void f2620(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[4],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],lf[176],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void C_fcall f2568(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf2568,NULL);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2573,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f2573(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2573);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2577,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2584,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[174]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}
else{
t3=t2;
f2577(2,t3,C_SCHEME_FALSE);}}

static void f2584(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

static void f2577(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub438(C_SCHEME_UNDEFINED,((C_word*)t0)[2],t1));}

static void f2523(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-7)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2rv,f2523r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f2523r(t0,t1,t2);}}

static void f2523r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t3=(C_word)stub424(C_SCHEME_UNDEFINED);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2530,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

static void f2530(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2530);}
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[67]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,((C_word*)t0)[3],lf[173]);}
else{
t3=(C_word)C_notvemptyp(((C_word*)t0)[2]);
t4=(C_truep(t3)?(C_word)C_eqp(((C_word*)t0)[4],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2548,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t6=(C_word)C_i_vector_ref(((C_word*)t0)[2],C_fix(0));
t7=t6;
((C_proc2)C_retrieve_proc(t7))(2,t7,t5);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[4]);}}}

static void f2548(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2548);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2552,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

static void f2552(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2552);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2557,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f2557(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub429(C_SCHEME_UNDEFINED,t1));}

static void f2491(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2491);}
t3=(C_word)C_i_check_list(t2);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2498,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2512,tmp=(C_word)a,a+=2,tmp);
t7=*((C_word*)lf[49]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

static void f2512(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2512);}
t3=(C_word)C_i_check_exact(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

static void f2498(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2498);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask(C_fix(0)),C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2507,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

static void f2507(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[67]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],lf[171]);}

static void f2473(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2473);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2483,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

static void f2483(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[169]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f2426(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f2426r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f2426r(t0,t1,t2,t3,t4);}}

static void f2426r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact(t2);
t6=(C_truep(t3)?t2:C_SCHEME_FALSE);
t7=(C_word)C_establish_signal_handler(t2,t6);
t8=(C_word)C_i_not(t3);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2447,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t8)){
t10=t9;
f2447(t10,t8);}
else{
if(C_truep((C_word)C_notvemptyp(t4))){
t10=(C_word)C_i_vector_ref(t4,C_fix(0));
t11=t9;
f2447(t11,(C_word)C_i_not(t10));}
else{
t10=t9;
f2447(t10,C_SCHEME_FALSE);}}}

static void C_fcall f2447(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf2447,NULL);}
t2=(C_truep(t1)?((C_word*)t0)[5]:(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2448,a[2]=((C_word*)t0)[5],tmp=(C_word)a,a+=3,tmp));
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_vector_set(((C_word*)t0)[3],((C_word*)t0)[2],t2));}

static void f2448(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2448);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2454,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[166]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t1,*((C_word*)lf[167]+1),t3,*((C_word*)lf[168]+1));}

static void f2454(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2454);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2289(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-11)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f2289r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2289r(t0,t1,t2);}}

static void f2289r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2295,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f2295(t6,t1,t2);}

static void C_fcall f2295(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf2295,NULL);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2310,a[2]=t3,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2316,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
C_call_with_values(4,0,t1,t4,t5);}}

static void f2316(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2316);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2320,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2392,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[138]);
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

static void f2392(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

static void f2320(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2320);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2327,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[137]);
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t2,t3);}

static void f2327(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2327);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2329,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f2329(t5,((C_word*)t0)[2],t1);}

static void C_fcall f2329(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf2329,NULL);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[7]);
t4=((C_word*)((C_word*)t0)[6])[1];
f2295(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2346,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
t5=*((C_word*)lf[101]+1);
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

static void f2346(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2346);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2350,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=t2;
f2350(t3,((C_word*)t0)[2],t1);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[6]);
t3=((C_word*)((C_word*)t0)[5])[1];
f2329(t3,((C_word*)t0)[2],t2);}}

static void C_fcall f2350(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf2350,NULL);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2358,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_i_car(t2);
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}

static void f2358(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2358);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2362,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
t4=((C_word*)((C_word*)t0)[2])[1];
f2329(t4,t2,t3);}

static void f2362(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2362);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

static void f2310(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2310);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2224(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-11)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2rv,f2224r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f2224r(t0,t1,t2);}}

static void f2224r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f2228,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,lf[134]);}

static void f2228(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2228);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2231,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t1)){
t3=t2;
f2231(2,t3,t1);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2281,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,lf[133]);}}

static void f2281(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
f2231(2,t2,t1);}
else{
t2=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],lf[132]);}}

static void f2231(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2231);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[7],C_fix(0)):lf[130]);
t4=(C_word)C_i_check_string(t3);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f2242,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t6,tmp=(C_word)a,a+=9,tmp));
t8=((C_word*)t6)[1];
f2242(t8,((C_word*)t0)[2]);}

static void C_fcall f2242(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf2242,NULL);}
t2=(C_word)C_fudge(C_fix(16));
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2249,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=t1,a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2268,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2272,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
C_number_to_string(4,0,t5,t2,C_fix(16));}

static void f2272(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],lf[131],t1);}

static void f2268(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[5];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

static void f2249(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2249);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2255,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,t1);}

static void f2255(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2255);}
if(C_truep(t1)){
t2=((C_word*)((C_word*)t0)[5])[1];
f2242(t2,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2263,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],t2);}}

static void f2263(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2263);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,((C_word*)t0)[2]);}

static void f2206(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2206);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2212,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2218,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
C_call_with_values(4,0,t1,t4,t5);}

static void f2218(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2218);}
t5=*((C_word*)lf[113]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t1,t2,t3,((C_word*)t0)[2]);}

static void f2212(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2212);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2188(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2188);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2194,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2200,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
C_call_with_values(4,0,t1,t4,t5);}

static void f2200(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2200);}
t5=*((C_word*)lf[113]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t1,t2,((C_word*)t0)[2],t4);}

static void f2194(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2194);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2170(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2170);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2176,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2182,tmp=(C_word)a,a+=2,tmp);
C_call_with_values(4,0,t1,t4,t5);}

static void f2182(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2182);}
t5=*((C_word*)lf[113]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t1,*((C_word*)lf[123]+1),t3,t4);}

static void f2176(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2176);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2152(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2152);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2158,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2164,tmp=(C_word)a,a+=2,tmp);
C_call_with_values(4,0,t1,t3,t4);}

static void f2164(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2164);}
t5=*((C_word*)lf[113]+1);
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}

static void f2158(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2158);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2134(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2134);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2140,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2146,tmp=(C_word)a,a+=2,tmp);
C_call_with_values(4,0,t1,t3,t4);}

static void f2146(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2146);}
t5=*((C_word*)lf[113]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t1,C_SCHEME_FALSE,t3,t4);}

static void f2140(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2140);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2119(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2119);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2125,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2131,tmp=(C_word)a,a+=2,tmp);
C_call_with_values(4,0,t1,t3,t4);}

static void f2131(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2131);}
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

static void f2125(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2125);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2104(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2104);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2110,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2116,tmp=(C_word)a,a+=2,tmp);
C_call_with_values(4,0,t1,t3,t4);}

static void f2116(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2116);}
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t3);}

static void f2110(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2110);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2089(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2089);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2095,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2101,tmp=(C_word)a,a+=2,tmp);
C_call_with_values(4,0,t1,t3,t4);}

static void f2101(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2101);}
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}

static void f2095(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2095);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f2038(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2038);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2045,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t5=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[2],t2);}

static void f2045(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2045);}
if(C_truep(t1)){
t2=(C_word)C_i_cadr(t1);
t3=(C_word)C_i_caddr(t1);
t4=(C_word)C_i_cddddr(t1);
t5=(C_word)C_i_car(t4);
C_values(5,0,((C_word*)t0)[5],t2,t3,t5);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2070,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],((C_word*)t0)[4]);}}

static void f2070(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_i_cadr(t1);
t3=(C_word)C_i_caddr(t1);
C_values(5,0,((C_word*)t0)[3],t2,t3,C_SCHEME_FALSE);}
else{
C_values(5,0,((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,C_SCHEME_FALSE);}}

static void f1982(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-13)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1982r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1982r(t0,t1,t2,t3,t4);}}

static void f1982r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(9);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f1990,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=t3,a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t6=(C_word)C_i_not(t2);
t7=(C_truep(t6)?t6:(C_word)C_i_nullp(t2));
if(C_truep(t7)){
t8=t5;
f1990(2,t8,lf[115]);}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t8=t5;
f1990(2,t8,t2);}
else{
t8=((C_word*)t0)[2];
f1842(t8,t5,t2);}}}

static void f1990(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1990);}
t2=(C_word)C_block_size(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1996,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2006,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t1);}

static void f2006(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f1996(2,t2,((C_word*)t0)[4]);}
else{
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[5],((C_word*)t0)[2],((C_word*)t0)[4]);}}

static void f1996(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(6,0,((C_word*)t0)[5],((C_word*)t0)[4],t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f1875(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-12)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f1875r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1875r(t0,t1,t2,t3,t4);}}

static void f1875r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(8);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f1879,a[2]=t4,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t6=(C_word)C_i_not(t2);
t7=(C_truep(t6)?t6:(C_word)C_i_nullp(t2));
if(C_truep(t7)){
t8=t5;
f1879(2,t8,lf[112]);}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t8=t5;
f1879(2,t8,t2);}
else{
t8=((C_word*)t0)[2];
f1842(t8,t5,t2);}}}

static void f1879(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1879);}
t2=((C_word*)t0)[7];
t3=(C_truep(t2)?t2:lf[105]);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f1885,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_notvemptyp(((C_word*)t0)[2]))){
t5=(C_word)C_i_vector_ref(((C_word*)t0)[2],C_fix(0));
t6=t4;
f1885(t6,(C_truep(t5)?t5:lf[110]));}
else{
t5=t4;
f1885(t5,lf[111]);}}

static void C_fcall f1885(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf1885,NULL);}
t2=(C_word)C_i_check_string(t1);
t3=(C_word)C_block_size(((C_word*)t0)[7]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f1922,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
if(C_truep((C_word)C_fixnum_greaterp(t3,C_fix(0)))){
t5=(C_word)C_fixnum_difference(t3,C_fix(1));
t6=(C_word)C_subchar(((C_word*)t0)[7],t5);
if(C_truep(t6)){
t7=(C_word)C_eqp(*((C_word*)lf[109]+1),t6);
if(C_truep(t7)){
t8=t4;
f1922(t8,C_SCHEME_FALSE);}
else{
t8=(C_word)C_eqp(C_make_character(47),t6);
t9=t4;
f1922(t9,(C_word)C_i_not(t8));}}
else{
t7=t4;
f1922(t7,C_SCHEME_FALSE);}}
else{
t5=t4;
f1922(t5,C_SCHEME_FALSE);}}
else{
t5=t4;
f1922(t5,C_SCHEME_FALSE);}}

static void C_fcall f1922(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf1922,NULL);}
t2=(C_truep(t1)?((C_word*)t0)[8]:lf[106]);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f1902,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t4=(C_word)C_block_size(((C_word*)t0)[2]);
if(C_truep((C_word)C_fixnum_greaterp(t4,C_fix(0)))){
t5=(C_word)C_eqp((C_word)C_subchar(((C_word*)t0)[2],C_fix(0)),*((C_word*)lf[108]+1));
t6=t3;
f1902(t6,(C_word)C_i_not(t5));}
else{
t5=t3;
f1902(t5,C_SCHEME_FALSE);}}

static void C_fcall f1902(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(t1)?((C_word*)t0)[8]:lf[107]);
t3=((C_word*)t0)[7];
((C_proc7)C_retrieve_proc(t3))(7,t3,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t2,((C_word*)t0)[2]);}

static void C_fcall f1842(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf1842,NULL);}
t3=(C_word)C_i_check_list(t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1851,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f1851(t7,t1,t2);}

static void C_fcall f1851(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(6);
if(!C_stack_probe(a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf1851,NULL);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[104]);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1869,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_i_cdr(t2);
t7=t4;
t8=t5;
t1=t7;
t2=t8;
goto loop;}}

static void f1869(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[5];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f1823(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1823);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1834,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[2],t2);}

static void f1834(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_i_pairp(t1));}

static void f1802(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1802);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1806,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1815,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f1806(2,t3,C_SCHEME_UNDEFINED);}}

static void f1815(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[32],lf[100]);}

static void f1806(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

static void f1782(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1782r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1782r(t0,t1,t2,t3,t4);}}

static void f1782r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[98]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1786,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

static void f1786(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1786);}
t2=C_mutate((C_word*)lf[98]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1792,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

static void f1792(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-7)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f1792r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f1792r(t0,t1,t2);}}

static void f1792r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1796,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

static void f1796(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[98]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[93]+1),((C_word*)t0)[2]);}

static void f1762(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1762r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1762r(t0,t1,t2,t3,t4);}}

static void f1762r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[96]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1766,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

static void f1766(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1766);}
t2=C_mutate((C_word*)lf[96]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1772,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

static void f1772(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-7)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f1772r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f1772r(t0,t1,t2);}}

static void f1772r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1776,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

static void f1776(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[96]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[93]+1),((C_word*)t0)[2]);}

static void f1738(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-9)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1738r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1738r(t0,t1,t2,t3,t4);}}

static void f1738r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1742,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

static void f1742(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1742);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1747,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1753,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

static void f1753(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-6)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f1753r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f1753r(t0,t1,t2);}}

static void f1753r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1757,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

static void f1757(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[93]+1),((C_word*)t0)[2]);}

static void f1747(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1747);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f1714(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-9)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1714r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1714r(t0,t1,t2,t3,t4);}}

static void f1714r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1718,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

static void f1718(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1718);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1723,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1729,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

static void f1729(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-6)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f1729r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f1729r(t0,t1,t2);}}

static void f1729r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1733,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

static void f1733(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[93]+1),((C_word*)t0)[2]);}

static void f1723(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1723);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

static void f1695(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1695);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1699,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[90]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f1699(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1699);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1702,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

static void f1702(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[3],lf[32],lf[89],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f1659(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-14)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f1659r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f1659r(t0,t1,t2,t3);}}

static void f1659r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string(t2);
t5=f1572(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1673,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[80]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1680,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[86]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1690,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t10=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
f1584(t6,t5);}}}

static void f1690(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1690);}
t2=((C_word*)t0)[2];
f1673(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

static void f1680(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1680);}
t2=((C_word*)t0)[2];
f1673(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

static void f1673(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f1590(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

static void f1623(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_stack_probe(&a-14)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f1623r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f1623r(t0,t1,t2,t3);}}

static void f1623r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string(t2);
t5=f1572(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1637,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[80]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1644,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[86]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1654,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t10=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
f1584(t6,t5);}}}

static void f1654(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1654);}
t2=((C_word*)t0)[2];
f1637(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

static void f1644(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1644);}
t2=((C_word*)t0)[2];
f1637(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

static void f1637(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f1590(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

static void C_fcall f1590(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(trf1590,NULL);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1594,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

static void f1594(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1594);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[32],lf[82],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1606,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[84]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,C_fix(-1),C_fix(6),C_SCHEME_FALSE,((C_word*)t0)[5]);}}

static void f1606(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1606);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1609,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f1609(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_setslot(((C_word*)t0)[4],C_fix(1),((C_word*)t0)[3]);
t3=(C_word)C_i_setslot(((C_word*)t0)[4],C_fix(3),lf[83]);
t4=(C_word)C_i_set_i_slot(((C_word*)t0)[4],C_fix(4),C_fix(0));
t5=(C_word)C_i_set_i_slot(((C_word*)t0)[4],C_fix(5),C_fix(0));
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,((C_word*)t0)[4]);}

static void C_fcall f1584(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf1584,NULL);}
t3=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[81],t2);}

static C_word C_fcall f1572(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[80]));}

static void f1554(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1554);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1558,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}

static void f1558(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1558);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1561,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

static void f1561(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[5])){
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[5]);}
else{
t2=*((C_word*)lf[31]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],lf[32],lf[79]);}}

static void f1535(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1535);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1542,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[55]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f1542(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

static void f1497(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1497);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1504,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,C_fix(256));}

static void f1504(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1504);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1508,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f1508(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1508);}
t2=(C_word)C_findfirst(t1);
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1516,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f1516(t6,((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}}

static void C_fcall f1516(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf1516,NULL);}
t2=(C_word)C_foundfile(((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1520,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t4))(5,t4,t3,((C_word*)t0)[5],C_fix(0),t2);}

static void f1520(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1520);}
if(C_truep((C_word)C_findnext(((C_word*)t0)[4]))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1530,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)((C_word*)t0)[2])[1];
f1516(t3,t2);}
else{
t2=(C_word)C_findclose(((C_word*)t0)[4]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST));}}

static void f1530(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1530);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

static void f1474(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1474);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1495,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f1495(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1495);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1487,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

static void f1487(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[74],((C_word*)t0)[2]);}

static void f1451(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1451);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1472,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f1472(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1472);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1464,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

static void f1464(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[72],((C_word*)t0)[2]);}

static void f1428(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1428);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1449,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f1449(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1449);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1441,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

static void f1441(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[70],((C_word*)t0)[2]);}

static void f1373(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f1373r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1373r(t0,t1,t2,t3,t4);}}

static void f1373r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact(t3);
t8=(C_word)C_i_check_exact(t6);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1386,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t10=*((C_word*)lf[67]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,t9,lf[68],t3,t2);}
else{
t10=t9;
f1386(2,t10,C_SCHEME_UNDEFINED);}}

static void f1386(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1386);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1392,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_portp(((C_word*)t0)[4]))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1405,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[62]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
t3=t2;
f1392(2,t3,(C_word)C_lseek(((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[41],lf[66],((C_word*)t0)[4]);}}}

static void f1405(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
f1392(2,t2,(C_word)C_fseek(t1,((C_word*)t0)[3],((C_word*)t0)[2]));}

static void f1392(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1392);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1395,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

static void f1395(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[65],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f1339(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1339);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1343,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_portp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1362,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[62]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f1343(2,t4,(C_word)C_lseek(t2,C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
t4=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[41],lf[63],t2);}}}

static void f1362(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f1343(2,t2,(C_word)C_ftell(t1));}

static void f1343(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1343);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1346,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1352,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f1346(2,t3,C_SCHEME_UNDEFINED);}}

static void f1352(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[61],((C_word*)t0)[2]);}

static void f1346(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f1318(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1318);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1325,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[55]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f1325(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1325);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1328,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f1328(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(6)));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[59],((C_word*)t0)[2]);}}

static void f1297(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1297);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1304,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[55]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f1304(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1304);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1307,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f1307(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(2)));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[57],((C_word*)t0)[2]);}}

static void f1276(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1276);}
t3=(C_word)C_i_check_string(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1283,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[55]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f1283(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1283);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1286,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f1286(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(3)));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[54],((C_word*)t0)[2]);}}

static void f1153(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-16)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f1153r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1153r(t0,t1,t2,t3,t4);}}

static void f1153r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(12);
t5=(C_word)C_i_check_list(t2);
t6=(C_word)C_i_check_list(t3);
t7=C_fix(0);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=(C_word)C_notvemptyp(t4);
t10=(C_truep(t9)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_SCHEME_FALSE);
t11=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f1166,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t8,a[5]=t10,a[6]=((C_word*)t0)[4],a[7]=t3,a[8]=t2,a[9]=t1,tmp=(C_word)a,a+=10,tmp);
f1127(t11,C_fix(0));}

static void f1166(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1166);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f1169,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
f1127(t2,C_fix(1));}

static void f1169(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1169);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f1172,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1257,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[49]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,((C_word*)t0)[7]);}

static void f1257(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1257);}
t3=(C_word)C_i_check_exact(t2);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
f1133(t1,C_fix(0),t2);}

static void f1172(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1172);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f1175,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1247,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[49]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,((C_word*)t0)[6]);}

static void f1247(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1247);}
t3=(C_word)C_i_check_exact(t2);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
f1133(t1,C_fix(1),t2);}

static void f1175(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1175);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1178,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_exact(((C_word*)t0)[3]);
t4=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f1178(t5,(C_word)C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f1178(t4,(C_word)C_select(t3));}}

static void C_fcall f1178(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf1178,NULL);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1187,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
C_values(4,0,((C_word*)t0)[5],C_SCHEME_END_OF_LIST,C_SCHEME_END_OF_LIST);}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_END_OF_LIST;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1202,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1223,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t9=*((C_word*)lf[49]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t7,t8,((C_word*)t0)[4]);}}}

static void f1223(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1223);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1230,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f1143(t3,C_fix(0),t2);}

static void f1230(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1230);}
if(C_truep(t1)){
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

static void f1202(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1202);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1205,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1210,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[49]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,((C_word*)t0)[2]);}

static void f1210(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1210);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1217,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f1143(t3,C_fix(1),t2);}

static void f1217(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1217);}
if(C_truep(t1)){
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

static void f1205(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);}

static void f1187(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[48],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void C_fcall f1143(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf1143,NULL);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1148,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f1148(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1148);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1152,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f1152(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub50(C_SCHEME_UNDEFINED,((C_word*)t0)[2],t1));}

static void C_fcall f1133(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf1133,NULL);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1138,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f1138(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1138);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1142,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f1142(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub44(C_SCHEME_UNDEFINED,((C_word*)t0)[2],t1));}

static void C_fcall f1127(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf1127,NULL);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1132,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f1132(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub39(C_SCHEME_UNDEFINED,t1));}

static void f1085(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f1085r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1085r(t0,t1,t2,t3,t4);}}

static void f1085r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact(t2);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1092,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f1092(2,t8,C_SCHEME_UNDEFINED);}
else{
t8=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,lf[41],lf[45],t3);}}

static void f1092(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1092);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact(t3);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1101,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1107,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t6;
f1101(2,t8,C_SCHEME_UNDEFINED);}}

static void f1107(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[44],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f1101(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f1040(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-9)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f1040r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1040r(t0,t1,t2,t3,t4);}}

static void f1040r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact(t2);
t6=(C_word)C_i_check_exact(t3);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1050,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f1050(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

static void f1050(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1050);}
t2=(C_word)C_read(((C_word*)t0)[4],t1,((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1053,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=t1,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
t4=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=t3;
f1053(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t3,lf[41],lf[42],t1);}}

static void f1053(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1053);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1056,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1065,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f1056(2,t4,C_SCHEME_UNDEFINED);}}

static void f1065(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[40],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f1056(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f1022(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1022);}
t3=(C_word)C_i_check_exact(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1035,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

static void f1035(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[37],((C_word*)t0)[2]);}

static void f985(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f985r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f985r(t0,t1,t2,t3,t4);}}

static void f985r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string(t2);
t8=(C_word)C_i_check_exact(t3);
t9=(C_word)C_i_check_exact(t6);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1002,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t11+1)))(3,t11,t10,t2);}

static void f1002(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1002);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1005,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1011,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f1005(2,t5,C_SCHEME_UNDEFINED);}}

static void f1011(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[5],lf[32],lf[33],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f1005(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
/* END OF FILE */
