;;;; runsample.scm - Run "nsample" and gather output to write "c_defaults.h" - felix


(declare
  (uses extras unistd)
  (standard-bindings)
  (extended-bindings) 
  (fixnum) )


(define prg (cadr (argv)))

(define (run size)
  (let* ([in (open-input-pipe (sprintf "~a -:s~Sk" prg size))]
	 [n (read in)] )
    (close-input-pipe in)
    n) )

(let([best 99999]
     [bestn #f] )
  (for-each
   (lambda (size)
     (let* ([tm1 (run size)]
	    [tm2 (run size)]
	    [tm3 (run size)] 
	    [tm (/ (+ tm1 tm2 tm3) 3)] )
       (printf "        ~SK -> ~S ms~%" size tm)
       (when (< tm best)
	 (set! best tm)
	 (set! bestn size) ) ) )
   '(8 10 12 16 24 32 48 64 128 256 512) )
  (printf "the optimal size of the nursery seems to be ~SK~%~
           creating 'c_defaults.h' ...~%" bestn) 
  (with-output-to-file "c_defaults.h"
    (lambda ()
      (printf "#define C_DEFAULT_TARGET_STACK_SIZE (~S * 1024)~%" bestn) ) ) )
