### Makefile.d
#
# This is a template makefile for shipping projects as compiled C sources.
# It should be easy to adapt to your own projects. Basically only a couple
# of source files are needed in addition to your code:
#
#  chicken.h           this is included by every compiled Scheme file
#  runtime.c           the basic Chicken runtime system (this is the only handcoded C file)
#  library.c           the core Scheme library
#  eval.c              `eval' and some support definitions
#  modules.c           support code for the module system
#  debugger.c          support code for debugged executables
#
# For more functionality we need these (also compiled Scheme files):
#
#  extras.c
#  srfi-1.c
#  srfi-4.c
#  match.c
#  syntax-case.c
#  format.c            uses `extras'
#  tinyclos.c	       uses `extras'
#  srfi-13.c           uses `srfi-14'
#  srfi-14.c
#  srfi-18.c
#  lolevel.c           uses `extras' and `srfi-4'
#  regex.c
#  unistd.c            uses `regex'
#
# Alternatively, we can use the `unsafe' versions:
#
#  uextras.c
#  usrfi-1.c
#  usrfi-4.c
#  umatch.c
#  usyntax-case.c
#  uformat.c          uses `extras'
#  utinyclos.c        uses `extras'
#  usrfi-13.c         uses `srfi-14'
#  usrfi-14.c
#  usrfi-18.c
#  ulolevel.c         uses `extras' and `srfi-4'
#  uregex.c
#  uunistd.c          uses `regex'
#
# The easiest way to explain the process is a simple example. Say we have two source
# files `foo.scm' and `bar.scm'. `foo' is the main unit, `bar' is a library unit:
#
# --------------------------------------------------------------------------------
# ;;; foo.scm
#
# (declare (uses bar))
#
# (say-hello)
# --------------------------------------------------------------------------------
# ;;; bar.scm
#
# (declare (unit bar) (uses unistd))
#
# (define (say-hello)
#   (print "Hello, " (nth-value 0 (user-information (current-user-id)))) )
# --------------------------------------------------------------------------------
#
# The makefile rules for generating the executable `foo' would be:
#
#  foo : foo.o bar.o libchicken.a libstuffed-chicken.a
#          gcc -s -L. foo.o bar.o -o $@ -lchicken -lstuffed-chicken
#
#  foo.o : foo.c chicken.h
#  bar.o : bar.c chicken.h
#
# To pack a distribution, create an archive of your compiled C files (in this case
# `foo.c' and `bar.c') and the C files of the Chicken libraries (normally to be found 
# in `$(CHICKEN_HOME)/src'), and `chicken.h' (normally to be found in the `include'
# directory of your installation, like `/usr/local/include').
#
#
# The rest of this file contains standard definitions, just enter your makefile
# rules at the relevant position.
#
# Here a few variables:

CC = gcc
CFLAGS = -I. -O3 -fomit-frame-pointer -fstrict-aliasing

# For SPARC, consider this:
#CFLAGS = -I. -O3 -fomit-frame-pointer -fstrict-aliasing -mflat

# For Windows/VC++:
#CC = cl
#CFLAGS = /nologo /O2


# --- PUT YOUR RULES HERE ------------------------------------------------------
#
# The main target:
#
#foo : foo.o bar.o libchicken.a libstuffed-chicken.a
#        gcc -s -L. foo.o bar.o -o $@ -lchicken -lstuffed-chicken
#
# Object files:
#
#foo.o : foo.c chicken.h
#bar.o : bar.c chicken.h
#
# --------------------------------------------------------------------------------


# The runtime library:

libchicken.a : runtime.o library.o eval.o syntax-case.o modules.o debugger.o
	ar rus $@ $^
libstuffed-chicken.a : extras.o format.o srfi-1.o srfi-4.o srfi-13.o srfi-14.o match.o srfi-18.o lolevel.o regex.o unistd.o tinyclos.o
	ar rus $@ $^
libembedded-chicken.a : embedded-runtime.o library.o eval.o syntax-case.o modules.o debugger.o
	ar rus $@ $^

libuchicken.a : runtime.o ulibrary.o ueval.o usyntax-case.o umodules.o
	ar rus $@ $^
libustuffed-chicken.a : uextras.o uformat.o usrfi-1.o usrfi-4.o usrfi-13.o usrfi-14.o umatch.o usrfi-18.o \
	  ulolevel.o uregex.o uunistd.o utinyclos.o
	ar rus $@ $^
libuembedded-chicken.a : embedded-runtime.o ulibrary.o ueval.o usyntax-case.o umodules.o
	ar rus $@ $^

runtime.o : runtime.c chicken.h
embedded-runtime.o : runtime.c chicken.h
	$(CC) $(CFLAGS) -DC_EMBEDDED -c $< -o $@

eval.o : eval.c chicken.h
library.o : library.c chicken.h
debugger.o : debugger.c chicken.h
modules.o : modules.c chicken.h
extras.o : extras.c chicken.h
srfi-1.o : srfi-1.c chicken.h
srfi-4.o : srfi-4.c chicken.h
match.o : match.c chicken.h
syntax-case.o : syntax-case.c chicken.h
srfi-18.o : srfi-18.c chicken.h
format.o : format.c chicken.h
tinyclos.o : tinyclos.c chicken.h
srfi-13.o : srfi-13.c chicken.h
srfi-14.o : srfi-14.c chicken.h
lolevel.o : lolevel.c chicken.h
regex.o : regex.c chicken.h
unistd.o : unistd.c chicken.h

ueval.o : ueval.c chicken.h
ulibrary.o : ulibrary.c chicken.h
umodules.o : umodules.c chicken.h
uextras.o : uextras.c chicken.h
usrfi-1.o : usrfi-1.c chicken.h
usrfi-4.o : usrfi-4.c chicken.h
umatch.o : umatch.c chicken.h
usyntax-case.o : usyntax-case.c chicken.h
usrfi-18.o : usrfi-18.c chicken.h
uformat.o : uformat.c chicken.h
utinyclos.o : utinyclos.c chicken.h
usrfi-13.o : usrfi-13.c chicken.h
usrfi-14.o : usrfi-14.c chicken.h
ulolevel.o : ulolevel.c chicken.h
uregex.o : uregex.c chicken.h
uunistd.o : uunistd.c chicken.h
