/***************************************************************************
                          mixer_software.cpp  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mixer_software.h"

 /* Mixing macros */
#define EXTRACT_SAMPLE(var,size) var=*srce++>>(BITSHIFT+16-size)
#define CHECK_SAMPLE(var,bound) var=(var>=bound)?bound-1:(var<-bound)?-bound:var
#define PUT_SAMPLE(var) *dste++=var

void Mixer_Software::Mix32To16(Sint16* dste,Sint32* srce,NATIVE count)
{
	Sint32 x1,x2,x3,x4;
	int	remain;

	remain=count&3;
	for(count>>=2;count;count--) {
		EXTRACT_SAMPLE(x1,16); EXTRACT_SAMPLE(x2,16);
		EXTRACT_SAMPLE(x3,16); EXTRACT_SAMPLE(x4,16);

		CHECK_SAMPLE(x1,32768); CHECK_SAMPLE(x2,32768);
		CHECK_SAMPLE(x3,32768); CHECK_SAMPLE(x4,32768);

		PUT_SAMPLE(x1); PUT_SAMPLE(x2); PUT_SAMPLE(x3); PUT_SAMPLE(x4);
	}
	while(remain--) {
		EXTRACT_SAMPLE(x1,16);
		CHECK_SAMPLE(x1,32768);
		PUT_SAMPLE(x1);
	}
}

void Mixer_Software::Mix32To8(Sint8* dste,Sint32* srce,NATIVE count)
{
	Sint16 x1,x2,x3,x4;
	int	remain;

	remain=count&3;
	for(count>>=2;count;count--) {
		EXTRACT_SAMPLE(x1,8); EXTRACT_SAMPLE(x2,8);
		EXTRACT_SAMPLE(x3,8); EXTRACT_SAMPLE(x4,8);

		CHECK_SAMPLE(x1,128); CHECK_SAMPLE(x2,128);
		CHECK_SAMPLE(x3,128); CHECK_SAMPLE(x4,128);

		PUT_SAMPLE(x1+128); PUT_SAMPLE(x2+128);
		PUT_SAMPLE(x3+128); PUT_SAMPLE(x4+128);
	}
	while(remain--) {
		EXTRACT_SAMPLE(x1,8);
		CHECK_SAMPLE(x1,128);
		PUT_SAMPLE(x1+128);
	}
}

Uint32 Mixer_Software::samples2bytes(Uint32 samples) {

        if ( mix_16bits ) samples <<= 1;
        if ( mix_stereo ) samples <<= 1;
        return samples;
}

Uint32 Mixer_Software::bytes2samples(Uint32 bytes)
{
        if ( mix_16bits ) bytes >>= 1;
        if ( mix_stereo) bytes >>= 1;

        return bytes;
}


void Mixer_Software::add_channel_to_mix_buffer(VC_Info *vchannel,NATIVE todo)
{
	Sint64 end,done;
	Sint32 *mixing_buffer_index;
	Sint32 *reverb_buffer_index;
	mixing_buffer_index=internal_mixing_buffer;
	reverb_buffer_index=reverb_send_buffer;
	int total=todo;
	
	float ramp_tangent_l;
	float ramp_tangent_r;

        if ( vchannel->sample_data_ptr == NULL ) {
	
		vchannel->current_index=0;
		vchannel->active=false;
		return;
	}

	
	/* precalculate ramp */
	
	
	
	/* update the 'current' index so the sample loops, or stops playing if it
	   reached the end of the sample */
	
	if (todo<=0) return;
		
	ramp_tangent_l=(float)(vchannel->lvolsel-vchannel->oldlvol)/(float)todo;
	ramp_tangent_r=(float)(vchannel->rvolsel-vchannel->oldrvol)/(float)todo;
	
	
	//                  2
	
	while(todo>0) {

		Sint64 endpos;

		if ( vchannel->playing_backwards ) {
			/* The sample is playing in reverse */
			if( ( vchannel->sample_data_ptr->loop_on )&&(vchannel->current_index<idxlpos) ) {
				/* the sample is looping and has reached the loopstart index */
				if ( vchannel->sample_data_ptr->pingpong_loop ) {
					/* sample is doing bidirectional loops, so 'bounce' the
					   current index against the idxlpos */
					vchannel->current_index = idxlpos+(idxlpos-vchannel->current_index);
					vchannel->playing_backwards=false;
					vchannel->increment_index = -vchannel->increment_index;
				} else
					/* normal backwards looping, so set the current position to
					   loopend index */
					vchannel->current_index=idxlend-(idxlpos-vchannel->current_index);
			} else {
				/* the sample is not looping, so check if it reached index 0 */
				if(vchannel->current_index < 0) {
					/* playing index reached 0, so stop playing this sample */
					vchannel->current_index=0;
					vchannel->active=false;

					break;
				}
			}
		} else {
			/* The sample is playing forward */
			if ( (vchannel->sample_data_ptr->loop_on) && (vchannel->current_index >= idxlend)) {
				/* the sample is looping, check the loopend index */
				if( vchannel->sample_data_ptr->pingpong_loop ) {
					/* sample is doing bidirectional loops, so 'bounce' the
					   current index against the idxlend */
					vchannel->playing_backwards=true;
					vchannel->increment_index = -vchannel->increment_index;
					vchannel->current_index = idxlend-(vchannel->current_index-idxlend);
				} else
					/* normal backwards looping, so set the current position
					   to loopend index */
					vchannel->current_index=idxlpos+(vchannel->current_index-idxlend);
			} else {
				/* sample is not looping, so check if it reached the last
				   position */
				if(vchannel->current_index >= idxsize) {
					/* yes, so stop playing this sample */
					vchannel->current_index=0;
					vchannel->active=false;

					break;
				}
			}
		}

		end=(vchannel->playing_backwards)?(vchannel->sample_data_ptr->loop_on)?idxlpos:0:
		     (vchannel->sample_data_ptr->loop_on)?idxlend:idxsize;

		/* if the sample is not blocked... */
		if( (end==vchannel->current_index) || ( !vchannel->increment_index ) )
			done=0;
		else {
			done=MIN((end-vchannel->current_index)/vchannel->increment_index+1,todo);
			if ( done<0 ) done=0;
		}

		if( !done ) {
			vchannel->active = 0;
			break;
		}

		endpos=vchannel->current_index+done*vchannel->increment_index;

		if (vchannel->volume || (vchannel->oldlvol) || (vchannel->oldrvol)) {

			if((vchannel->current_index<0x7fffffff)&&(endpos<0x7fffffff)) {

                        	int l_vol_old,l_vol_new;
                        	int r_vol_old,r_vol_new;
                        	int written=total-todo;
                        	
                        	l_vol_old=vchannel->oldlvol+((float)written*ramp_tangent_l);
                        	r_vol_old=vchannel->oldrvol+((float)written*ramp_tangent_r);
                        	l_vol_new=vchannel->oldlvol+((float)(written+done)*ramp_tangent_l);
                        	r_vol_new=vchannel->oldrvol+((float)(written+done)*ramp_tangent_r);
				                      				
			
				curent_mixer_procedure->set_sample_data(vchannel->sample_data_ptr);
				curent_mixer_procedure->set_dest_buffer(mixing_buffer_index);
				curent_mixer_procedure->set_reverb_send_buffer(reverb_buffer_index);
				curent_mixer_procedure->set_sample_index (vchannel->current_index);
				curent_mixer_procedure->set_increment(vchannel->increment_index);
				curent_mixer_procedure->set_samples_to_mix(done);
				curent_mixer_procedure->set_l_volume(l_vol_new);
				curent_mixer_procedure->set_r_volume(r_vol_new);
				curent_mixer_procedure->set_previous_l_volume(l_vol_old);
				curent_mixer_procedure->set_previous_t_volume(r_vol_old);

				curent_mixer_procedure->set_filter(vchannel->filter_enabled,vchannel->filter_coef1,vchannel->filter_coef2,vchannel->filter_coef3,&vchannel->filter_history1,&vchannel->filter_history2,vchannel->filter_history3);
				curent_mixer_procedure->set_reverb_send(vchannel->reverb_send);

       				if ( mix_stereo ) {

       					if( ( vchannel->panning==PAN_SURROUND ) && ( mix_surround ) ) {	

       						vchannel->current_index=curent_mixer_procedure->mix_surround();
       					} else {
       						vchannel->current_index=curent_mixer_procedure->mix_stereo();
       					}

       				} else {

       					vchannel->current_index=curent_mixer_procedure->mix_mono();

       				}
                         	
			}

		} else {

			/* update sample position */
			vchannel->current_index=endpos;
		}

		todo-=done;

		mixing_buffer_index += ( mix_stereo )?(done<<1):done;
		reverb_buffer_index += ( mix_stereo )?(done<<1):done;
	}
}

void Mixer_Software::write_samples(Sint8* p_dest_buf,Uint32 p_todo) {

	int samples_written,samples_left_to_write,portion=0,count;
	Sint8  *dest_buffer_ptr;
	int i, pan, vol;

	while ( p_todo ) {
	
        	/* Calculates amount of samples left to mix */

		if(!current_tick_size) {

	 		player_data->process_tick();
	        	/* recalculates the tick size (in samples) */
			current_tick_size=(mix_frequency*125L)/(player_data->get_current_tempo()*50L);
		}

		/* calculate how many samples to write! if we can fit a tick (or the remaining of it),
		then we fit it.. if not then just mix as much as we can and let the next call to this
		method handle the rest! */

		samples_left_to_write = MIN(current_tick_size, p_todo);
		samples_written=samples_left_to_write;
		dest_buffer_ptr = p_dest_buf;

 		current_tick_size -= samples_left_to_write; // just in case we CANT fit a whole tick.. then how much we'll fit in the next call

		p_todo -= samples_left_to_write;

		p_dest_buf += samples2bytes(samples_left_to_write);

		while( samples_left_to_write ) {

			portion = MIN(samples_left_to_write, mixing_buffer_size);

			count   = ( mix_stereo )?(portion<<1):portion;

			memset(internal_mixing_buffer, 0, count<<2);
			memset(reverb_send_buffer, 0, count<<2);

			for( i=0;i<mix_channels;i++) {

				if ( channel[i]->needs_restart ) channel[i]->restart();

				if ( channel[i]->current_frequency==0 ) channel[i]->active=false;
				if ( (channel[i]->sample_data_ptr==NULL) || (channel[i]->sample_data_ptr->data_ptr==NULL) ) channel[i]->active=false;

				if ( channel[i]->active ) {

                                        // Calculate increment index depending on frequency difference
					channel[i]->increment_index=((Sint64)(channel[i]->current_frequency<<FRACBITS))/mix_frequency;

					if (channel[i]->playing_backwards) channel[i]->increment_index=-channel[i]->increment_index;

					vol = channel[i]->volume;
					pan = channel[i]->panning;

					channel[i]->oldlvol=channel[i]->lvolsel;
					channel[i]->oldrvol=channel[i]->rvolsel;

					if( mix_stereo ) {
						if(pan != PAN_SURROUND) {
							channel[i]->lvolsel=(vol*(PAN_RIGHT-pan))>>8;
							channel[i]->rvolsel=(vol*pan)>>8;
						} else
							channel[i]->lvolsel=channel[i]->rvolsel=vol/2;
					} else  {

						channel[i]->lvolsel=vol;
					}

					idxsize = (channel[i]->sample_data_ptr->size)? ((Sint64)channel[i]->sample_data_ptr->size << FRACBITS)-1 : 0;
					idxlend = (channel[i]->sample_data_ptr->loop_end)? ((Sint64)channel[i]->sample_data_ptr->loop_end << FRACBITS)-1 : 0;
					idxlpos = (Sint64)channel[i]->sample_data_ptr->loop_begin << FRACBITS;

					add_channel_to_mix_buffer(channel[i], portion);
				}
			}

			//DO REVERB STUFF HERE
			do_freeverb(internal_mixing_buffer,reverb_send_buffer,samples_written);
			
			if( mix_16bits ) {

				Mix32To16((Sint16*) dest_buffer_ptr, internal_mixing_buffer, count);
			} else {

				Mix32To8((Sint8*) dest_buffer_ptr, internal_mixing_buffer, count);
                        }

			dest_buffer_ptr += samples2bytes(portion);

			samples_left_to_write   -= portion;
		}
	}
}



void Mixer_Software::do_freeverb(Sint32 *p_buff,Sint32 *p_reverb_in, int p_length) {
	
	float soften = 0.65;
	float *rev_l,*rev_r;
	int samples_todo;
	Sint32 *buff_write;
	
	if ((!mix_stereo) || (!do_reverb)) return;
	
	samples_todo=p_length;
	rev_l=reverb_in_l;
	rev_r=reverb_in_r;
	buff_write=p_reverb_in;
	
		
	//copy to mix buffer!
	while (samples_todo--) {
	
		*rev_l++ = (float)(*(buff_write++)) * soften;
		*rev_r++ = (float)(*(buff_write++)) * soften;
	}
		
	//mmmmmmmix reverb!
	reverb.processreplace(reverb_in_l, reverb_in_r,reverb_out_l,reverb_out_r,p_length,1);
	
	samples_todo=p_length;
	rev_l=reverb_out_l;
	rev_r=reverb_out_r;
	buff_write=p_buff;

	//mix BACK to main BUFFER!	
	while (samples_todo--) {
	
		*buff_write++ += (int)*rev_l++;
		*buff_write++ += (int)*rev_r++;
	}

}








Uint32 Mixer_Software::write_bytes(Sint8* buf,Uint32 todo) {

        todo = bytes2samples(todo);
        write_samples(buf,todo);

        return samples2bytes(todo);
}

void Mixer_Software::link_player_data(Player_Data *p_player_data) {
	
	player_data=p_player_data;

}

void Mixer_Software::set_mix_stereo(bool p_mix_stereo) {

	mix_stereo=p_mix_stereo;

	if (mix_stereo) mixing_buffer_size = real_mixing_buffer_size >> 1;
}

void Mixer_Software::set_mix_16bits(bool p_mix_16bits) {

	mix_16bits=p_mix_16bits;
}

void Mixer_Software::set_number_of_channels(int p_numb_channels) {
	
	if (p_numb_channels<1) return;
	if (p_numb_channels==mix_channels) return;

	int i;

	if (p_numb_channels<mix_channels) {

		for (i=p_numb_channels;i<mix_channels;i++) delete channel[i];
	}
	
	if (channel==NULL) {

		(void*)channel=malloc(sizeof(VC_Info*)*p_numb_channels);
	
        } else {

		realloc(channel,sizeof(VC_Info*)*p_numb_channels);
	}

	if (p_numb_channels>mix_channels) {

		for (i=mix_channels;i<p_numb_channels;i++) channel[i] = new VC_Info;
	}
	
	mix_channels=p_numb_channels;
}


Mixer_Software::Mixer_Software(){

	internal_mixing_buffer=(Sint32*)malloc((TICKLSIZE+32)*sizeof(Sint32));
	reverb_send_buffer=(Sint32*)malloc((TICKLSIZE+32)*sizeof(Sint32));
	reverb_in_l = (float*)malloc((TICKLSIZE+32)*sizeof(float));
	reverb_in_r = (float*)malloc((TICKLSIZE+32)*sizeof(float));
	reverb_out_l = (float*)malloc((TICKLSIZE+32)*sizeof(float));
	reverb_out_r = (float*)malloc((TICKLSIZE+32)*sizeof(float));
	
	
	real_mixing_buffer_size=TICKLSIZE;
	current_tick_size=0;
	mix_channels=0;
	channel=NULL;
	set_number_of_channels(DEFAULT_VIRTUAL_CHANNELS);
        mix_interpolated=false;

        reverb.setroomsize(0.6);
        reverb.setdamp(0.43);
	reverb.setwet(0.64);
	reverb.setdry(0.50);
	reverb.setwidth(0.43);
	reverb.setmode(0);
	
	do_reverb=false;

}



Mixer_Software::~Mixer_Software(){

	//delete stuff IN channel
	free(channel);
	free(internal_mixing_buffer);

}

void Mixer_Software::register_mixer_procedure(Mixer_Procedure* p_mixer_proc) {

	if (mixerprocs_list.empty()) curent_mixer_procedure=p_mixer_proc;

	mixerprocs_list.push_back(p_mixer_proc);

}
int Mixer_Software::get_mixer_procedure_in_use() {

	if (mixerprocs_list.empty()) return -1;

 	for (int i=0;i<mixerprocs_list.size();i++) {

    		if (mixerprocs_list[i]==curent_mixer_procedure)
      			return i;
	}

 	return -1;

}

int Mixer_Software::get_amount_of_mixer_procedures() {

	return mixerprocs_list.size();
}

string Mixer_Software::get_mixer_procedure_name(int p_mixer_proc_index) {

	if ((p_mixer_proc_index<0) || ((unsigned)p_mixer_proc_index>=mixerprocs_list.size())) return "INVALID ELEMENT!";

	return mixerprocs_list[p_mixer_proc_index]->get_name();

}

void Mixer_Software::set_mixer_procedure_in_use(int p_mixer_proc_index) {

	curent_mixer_procedure=mixerprocs_list[p_mixer_proc_index];
}
