#include "loader_wav.h"

#include <iostream>

struct format_chunk {

   short int channels;
   int sample_rate;
   short int bytes_per_sample;
};

struct data_chunk {

   int length;
   unsigned char* samples;
};

struct smpl_chunk {

   int rate;
};

struct multi_chunk {

   multi_chunk() : has_riff(0), has_format(0), has_data(0), has_smpl(0) {};

   bool has_riff, has_format, has_data, has_smpl;

   format_chunk format;
   data_chunk data;
   smpl_chunk smpl; // not implemented yet***
};

// a little mac to make the code a bit cleaner
#define FREAD(DATA, SIZE) \
   if( !fread( DATA, SIZE, 1, Source ) ) { \
      ERROR("load_chunk fatal: can't read from file"); \
   };

static int load_chunk( char chunk_id[4], FILE* Source, multi_chunk& Dest ) {

   if( !Source ) ERROR("load chunk fatal: no input file pointer");

   // check for the types of chunks we know
   if( !memcmp( chunk_id, "RIFF", 4 ) ) {

      if( Dest.has_riff ) {

         ERROR("load chunk ERRORing: file has many riff headers, that's odd but I don't care I'm just ignoring the extras");
         return 0;
      };

      int length;
      FREAD( &length, 4 );

      char WAVE[4];
      FREAD( &WAVE[0], 4 );

      for( int a = 0; a < 4; ++a ) cout << WAVE[a] << endl;

      if( memcmp( WAVE, "WAVE", 4 ) )
         ERROR("load chunk ERRORing: WAVE != WAVE, this sample might be from another universe, please zip it and send 10 times to reduz@anime.com.ar");

      Dest.has_riff = 1;
   }
   else if( !memcmp( chunk_id, "fmt ", 4 ) ) {

      if( Dest.has_format ) {

         ERROR("load chunk ERRORing: file has already a format chunk, ignoring");
         return 0;
      };

      int length;
      FREAD( &length, 4 );
      if( length != 0x10 ) ERROR("load chunk fatal: format chunk length ain't right");

      short int one;
      FREAD( &one, 2 );
      if( one != 1 ) ERROR("load chunk fatal: one isn't one, what is WRONG with microsoft!");

      FREAD( &Dest.format.channels, 2 );
      if( Dest.format.channels < 1 || Dest.format.channels > 2 )
         ERROR("load chunk fatal: this file has " << Dest.format.channels << " channels, I can't deal with it sorry");

      FREAD( &Dest.format.sample_rate, 4 );
      if( Dest.format.sample_rate < 0 )
         ERROR("load chunk fatal: this file has got some wack sample rate going on");

      int bytes_per_second; // ignored
      FREAD( &bytes_per_second, 4 );

      FREAD( &Dest.format.bytes_per_sample, 2 );
      if( Dest.format.channels == 1 ) {

         if( Dest.format.bytes_per_sample != 1 && Dest.format.bytes_per_sample != 2 )
            ERROR("load chunk fatal: I can only load 8bit or 16bit samples, this mono sample says its " << Dest.format.bytes_per_sample * 8 << "bit");
      }
      else {

         if( Dest.format.bytes_per_sample != 2 && Dest.format.bytes_per_sample != 4 )
            ERROR("load chunk fatal: I can only load 8bit or 16bit samples, this stereo sample says its " << Dest.format.bytes_per_sample * 8 / 2 << "bit");
      };

      short int bits_per_sample; // ignored
      FREAD( &bits_per_sample, 2 );

      Dest.has_format = 1;
   }
   else if( !memcmp( chunk_id, "data", 4 ) ) {

      if( Dest.has_data ) {

         ERROR("load chunk ERRORing: file has more than one data chunks, ignoring secondary ones.");
         return 0;
      };

      if( !Dest.has_format )
         ERROR("load chunk fatal: format chunk not defined before data chunk, I don't know how to load this sorry!");

      Dest.has_data = 1;
      FREAD( &Dest.data.length, 4 );
      if( Dest.data.length < 0 )
         ERROR("load chunk fatal: size < 0 loading sample data, that ain't right");

      Dest.data.samples = new unsigned char[ Dest.data.length ];
      FREAD( Dest.data.samples, Dest.data.length );

      Dest.has_data = 1;
   }
/*   else if( !memcmp( chunk_id, "smpl", 4 ) ) {

      if( Dest.has_smpl ) {

         ERROR("load chunk ERRORing: file has more than one smpl chunk");
         return 0;
      };


   }
   else {*/

   else {

      // unknonw chunk format, skip over it
      int skip;
      FREAD( &skip, 4 );
      fseek( Source, skip, SEEK_CUR );

//      return 0;
//      ERROR("Loader_WAV.cpp: load sample: load chunk fatal: unrecognized chunk type " << chunk_id);
   };

   return 0;
};

int Loader_WAV::load_sample(char *p_filename, int p_dest_index) {



   // try and open the file
   FILE* Source = fopen( p_filename, "rb+" ); // haha I used b
   if( !Source ) return FILE_ERROR;

   // our detection scheme is simple, we just need to see a riff chunk first thing.
   bool first_chunk_detection_flag = 1;

   // gobble the file up while we still can; putting the chunks into our multichunk collection
   multi_chunk Header;
   while(1) {

      char chunk_id[4];
      fread( &chunk_id[0], 4, 1, Source );
      if( feof( Source ) ) break; // no more chunks, that's probably a-ok! (we have to hit eof sometime)

      // if this is the first chunk, we'll "detect" the file format by checking if
      // the first chunk id is a RIFF header.
      if( first_chunk_detection_flag ) {

         if( memcmp( chunk_id, "RIFF", 4 ) ) {

            // no worries, it just means we don't know what the heck this is.
            fclose( Source );
            return FILE_FORMAT_NOT_RECOGNIZED;
         };

         first_chunk_detection_flag = 0;
      };

      if( load_chunk( chunk_id, Source, Header ) ) {

         // oop!
         fclose( Source );
         if( Header.has_data ) delete[] Header.data.samples; // don't leak memory
         ERROR("load sample fatal: I thought I could load this sample, now I realize that I can't. I'm sorry.");
         return HEADER_CORRUPT; // probably.. ok well
      };
   };

   // check that we aren't missing any of our chunks
   if( !Header.has_riff || !Header.has_format || !Header.has_data ) {

      ERROR("load sample fatal: this WAV file seems to be incomplete, I can't load it");
      return HEADER_CORRUPT;
   };

   // we've got everything, now what remains is to pass it on.
   Sample* S = song->get_sample(p_dest_index);

   // setup the header
   S->reset();
   S->name = p_filename;
   S->filename = p_filename;
   S->in_use = true;

   Sample_Data* SD = &S->data;
   SD->import_frequency(Header.format.sample_rate);

   // set up the data; we'll just do this two ways depending on stereo or mono
   if( Header.format.channels == 1 ) {

      // mono; the easy case
      SD->is_16bits = (Header.format.bytes_per_sample == 2);
      SD->size = (Header.data.length / Header.format.bytes_per_sample);
      SD->data_ptr = (Sint16*) Header.data.samples;
   }
   else {

      // stereo is a bit more complicated;
      SD->is_16bits = (Header.format.bytes_per_sample == 4);
      SD->size = (Header.data.length / Header.format.bytes_per_sample / 2);

      // we'll introduce a bizarre but useful kind of behaviour, and decide what channel
      // to load based on the parity of the input index; we'll document this by saying
      // "if you want to load stereo samples, just load a stereo sample twice consecutively!
      // MAGIC!" baaah
      int channel = p_dest_index % 2;

      if( SD->is_16bits ) {

         short int* Source = (short int*) Header.data.samples;

         SD->data_ptr = new short int[SD->size];
         short int* Dest = (short int*) SD->data_ptr;
         for( int a = 0; a < SD->size; ++a ) {

            short int X = Source[a * 2 + channel];
            *Dest++ = X;
         };
      }
      else {

         char* Source = (char*) Header.data.samples;

         SD->data_ptr = (short int*) new char[SD->size];
         char* Dest = (char*) SD->data_ptr;
         for( int a = 0; a < SD->size; ++a ) {

            char X = Source[a * 2 + channel];
            *Dest++ = X;
         };
      };

      // we just copied all the data (had to to dis-intereleave the stereo sample)
      // so we'll now deallocate our other buffer;
      delete[] Header.data.samples;
   };

   if (!SD->is_16bits) SD->change_sign();

   return SUCCESS;
};

bool Loader_WAV::test(char *p_filename) {

   return false;
};

// the following methods shouldn't be called since this is just a sample loader
// (test returns false letting the tracker know that we don't load songs)

int Loader_WAV::load(char *p_filename,bool p_load_patterns) {

   ERROR("load: unexpected method invocation");
   return FILE_FORMAT_NOT_RECOGNIZED; // not valid to load a song file as a sample
};

int Loader_WAV::get_amount_of_samples() {

   ERROR("get_amount_of_samples: unexpected method invocation");
   return 0;
};

Sample_Data *Loader_WAV::get_sample_data(int p_sample_index) {

   ERROR("get_sample_data: unexpected method invocation");
   return NULL;
};

string Loader_WAV::get_sample_name(int p_sample_index) {

   ERROR("get_sample_name: unexpected method invocation");
   return "";
};

void Loader_WAV::add_sample_to_song(int p_sample_index,int p_dest_index,bool create_instrument) {

   ERROR("add_sample_to_song: unexpected method invocation");
};

int Loader_WAV::load_samples_from_instrument(char *p_filename) {

   ERROR("load_samples_from_instrument: unexpected method invocation");
   return FUNCTION_FAILED;
};

int Loader_WAV::load_instrument(char *p_filename,int p_dest_index) {

   ERROR("load_instrument: unexpected method invocation");
   return FUNCTION_FAILED;
};

void Loader_WAV::transfer_data_to_song() {

   ERROR("transfer_data_to_song: unexpected method invocation");
};

void Loader_WAV::free_info(bool free_sampledata) {

   ERROR("free_info: unexpected method invocation");
};

Loader_WAV::Loader_WAV() {

	format_name="Microsoft WAV";

}
Loader_WAV::~Loader_WAV() {

}
