/***************************************************************************
                          interface_callbacks_pattern.cpp  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

gint Interface::tracker_key_press_callback(GdkEventKey* event) {


	bool alt,shift,control;
	int previous_cursor_x,previous_cursor_y;
        int aux_instrument;

	alt=event->state & GDK_MOD1_MASK;
	shift=event->state & GDK_SHIFT_MASK;
	control=event->state & GDK_CONTROL_MASK;

	if (shift && !previous_shift) editor.shift_selection_begin();
	if (!shift && previous_shift) editor.shift_selection_end();
        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');
	
	variables_lock->grab();

	aux_instrument=editor.get_instrument_mask_value();

	if (control) {

       		switch (event->keyval) {
       			case GDK_KP_Add: {
		
       				editor.orderlist_move_down();
				if (song->get_order(editor.orderlist_get_cursor_y())<MAX_PATTERNS) editor.cursor_goto_pattern(song->get_order(editor.orderlist_get_cursor_y()));
       				tracker.queue_draw();

       			} break;
       			case GDK_KP_Subtract: {

       				editor.orderlist_move_up();
				if (song->get_order(editor.orderlist_get_cursor_y())<MAX_PATTERNS) editor.cursor_goto_pattern(song->get_order(editor.orderlist_get_cursor_y()));
       				tracker.queue_draw();
		
       			} break;
			case GDK_Home: {

       				editor.cursor_move_up(1);
       				tracker.queue_draw();

			} break;
			case GDK_F7: {

				editor.set_mark();
                                tracker.queue_draw();
			} break;
			case GDK_End: {

       				editor.cursor_move_down(1);
       				tracker.queue_draw();
			} break;
       			case GDK_BackSpace: {

				editor.undo_index(0);
       				tracker.queue_draw();
			} break;
		}

	} else if (alt) {
	
			
       		switch (event->keyval) {
	                case '1': {
				editor.set_cursor_spacing(1);				
			}break;
	                case '2': {
				editor.set_cursor_spacing(2);				
			}break;
	                case '3': {
				editor.set_cursor_spacing(3);				
			}break;
	                case '4': {
				editor.set_cursor_spacing(4);				
			}break;
	                case '5': {
				editor.set_cursor_spacing(5);				
			}break;
	                case '6': {
				editor.set_cursor_spacing(6);				
			}break;
	                case '7': {
				editor.set_cursor_spacing(7);				
			}break;
	                case '8': {
				editor.set_cursor_spacing(8);				
			}break;
	                case '9': {
				editor.set_cursor_spacing(9);				
			}break;
       			case 'A': {
	
       				editor.selection_lower();
       				tracker.queue_draw();
       			} break;

       			case 'B': {
	
       				editor.mark_block_begining();
       				tracker.queue_draw();
       			} break;
       			case 'C': {
	
       				editor.selection_copy();
       				tracker.queue_draw();
       			} break;
	
       			case 'E': {
	
       				editor.mark_block_end();
       				tracker.queue_draw();
       			} break;
	
       			case 'U': {
	
       				editor.selection_release();
       				tracker.queue_draw();
       			} break;
	
       			case 'L': {
	
       				editor.mark_column_all();
       				tracker.queue_draw();
       			} break;
       			case 'V': {
	
       				editor.selection_set_volume_mask();
       				tracker.queue_draw();
       			} break;
       			case 'S': {
	
       				editor.selection_set_instrument_mask();
       				tracker.queue_draw();
       			} break;
       			case 'W': {
	
       				editor.selection_wipe_stray_volumes();
       				tracker.queue_draw();
       			} break;

       			case 'Q': {
	
       				editor.selection_raise();
       				tracker.queue_draw();
       			} break;
       			case 'J': {

				input_value_popup=new Dialog_Enter_Value("Volume Amplification %",volume_scale_memory,0,200,*kit);	

		 		if (input_value_popup->get_action()==Dialog_Enter_Value::PRESS) {

					volume_scale_memory=input_value_popup->get_value();
					editor.selection_volume_scale(volume_scale_memory);
				}

				delete input_value_popup;

       			} break;
       			case 'Z': {
	
       				editor.selection_zap();
       				tracker.queue_draw();
       			} break;
       			case 'X': {
	
       				editor.selection_parameter_ramp();
       				tracker.queue_draw();
       			} break;
       			case 'K': {

       				editor.selection_volume_ramp();
       				tracker.queue_draw();
       			} break;
       			case 'O': {
	
       				editor.selection_paste_overwrite();
       				tracker.queue_draw();
       			} break;
       			case 'M': {
	
       				editor.selection_paste_mix();
       				tracker.queue_draw();
       			} break;

       			case 'P': {
	
       				editor.selection_paste_insert();
       				tracker.queue_draw();
       			} break;
       			case '[': {
       				//tmpres=song->editor.remove_column_to_current_track();
       				//if (tmpres>=0) {
						
       				//	selected_track=tmpres;

       				//	button_track_remove_pressed();
       				//}
	
       			//	tracker.queue_draw();
       			} break;
      			case GDK_Left: {
		
       				editor.cursor_move_left(1);
       				tracker.queue_draw();
       			} break;
       			case GDK_Right: {
		
       				editor.cursor_move_right(1);
       				tracker.queue_draw();
       			} break;
       			case GDK_BackSpace: {
        			int j;
	
				pattern_undo_popup = new Popup_Undo_Window;
				pattern_undo_popup->button_undo.clicked.connect(slot(this,&Interface::on_pattern_undo_popup_select_row));
				for (j=0;j<editor.get_undo_max();j++) {

					pattern_undo_popup->add_row(editor.get_undo_pattern(j),editor.get_undo_info(j));
				}

					

       			} break;
  	
       		}
	
	
	
       	} else {
	
	
       		switch (event->keyval) {
				
       			case GDK_F2: {

				pattern_properties_popup = new PopUp_Pattern_Properties(editor.get_default_octave(),editor.get_cursor_spacing(),editor.get_hl_minor(),editor.get_hl_major(),song->get_pattern(editor.get_current_pattern())->get_length(),1);
				pattern_properties_popup->button_ok.clicked.connect(slot(this,&Interface::on_pattern_properties_popup_ok_clicked));
	
       			} break;
       			case GDK_F9: {

				editor.current_channel_mute_toggle();	
       				tracker.queue_draw();
                                update_volume_pan_list();
       			} break;

       			case GDK_F10: {
				editor.current_channel_solo_toggle();	
       				tracker.queue_draw();
	                        update_volume_pan_list();
       			} break;

       			case GDK_Up: {
       				editor.cursor_move_up();
       				tracker.queue_draw();
				
       			} break;
       			case GDK_Down: {
		
       				editor.cursor_move_down();
       				tracker.queue_draw();
       			} break;
       			case GDK_Left: {
		
       				editor.cursor_move_field_left();
       				tracker.queue_draw();
       			} break;
       			case GDK_Right: {
		
       				editor.cursor_move_field_right();
       				tracker.queue_draw();
       			} break;
       			case GDK_Page_Up: {
		
       				editor.cursor_page_up();
       				tracker.queue_draw();
       			} break;
       			case GDK_Page_Down: {
		
       				editor.cursor_page_down();
       				tracker.queue_draw();
       			} break;
       			case GDK_Home: {
		
       				editor.cursor_home();
       				tracker.queue_draw();
       			} break;
       			case GDK_End: {
		
       				editor.cursor_end();
       				tracker.queue_draw();
       			} break;
       			case GDK_Tab: {
		
       				editor.cursor_tab();
       				tracker.queue_draw();
       			} break;
       			case GDK_ISO_Left_Tab: {
		
       				editor.cursor_back_tab();
       				tracker.queue_draw();
       			} break;
       			case GDK_Insert: {
		
       				editor.cursor_insert();
       				tracker.queue_draw();
       			} break;
       			case GDK_Delete: {
		
       				editor.cursor_delete();
       				tracker.queue_draw();
       			} break;
       			case GDK_KP_Add: {
		                if (player->is_playing() && song_follow_mode) {

					player->goto_next_order();
				} else {

	       				editor.cursor_next_pattern();
	       				tracker.queue_draw();
				}
       			} break;
       			case GDK_KP_Subtract: {

		                if (player->is_playing() && song_follow_mode) {

					player->goto_previous_order();
				} else {
		
	       				editor.cursor_prev_pattern();
	       				tracker.queue_draw();
				}
       			} break;
       			case GDK_Scroll_Lock: {
		
				song_follow_mode=!song_follow_mode;
       			} break;
          	}

           	if (is_key(KEY_TOGGLE_MASK,event->keyval)) {

		
       			editor.toggle_mask_at_cursor();
       			tracker.queue_draw();
		}


           	if (is_key(KEY_ERASE_FIELD,event->keyval)) {
		
       			editor.clear_field_at_cursor();
       			tracker.queue_draw();
           	}

		
           	if (is_key(KEY_NOTEOFF,event->keyval)) {
      			
         		editor.press_note_off_at_cursor();
      			tracker.queue_draw();
		}
           	if (is_key(KEY_NOTECUT,event->keyval)) {

			if (editor.get_cursor_field()==0) {
				
    				editor.press_note_cut_at_cursor();
				tracker.queue_draw();
    			}
		}
	
           	if (is_key(KEY_REPEAT_LAST_FIELD,event->keyval)) {

			editor.press_mask_write_cursor();
			tracker.queue_draw();
		}
           	if (is_key(KEY_NEXT_INSTRUMENT,event->keyval)) {

			if (editor.get_instrument_mask_value()<MAX_INSTRUMENTS-1) editor.set_instrument_mask_value(editor.get_instrument_mask_value()+1);
		}

           	if (is_key(KEY_PREV_INSTRUMENT,event->keyval)) {
			
   			if (editor.get_instrument_mask_value()>0) editor.set_instrument_mask_value(editor.get_instrument_mask_value()-1);
      		}

           	if (event->keyval==GDK_Return) {

                        editor.get_mask_from_cursor();
       			tracker.queue_draw();
           	}
		

       		if ((editor.get_cursor_field()==0) && is_key(KEY_PLAY_NOTE,event->keyval)) {

                       	variables_lock->release();
        		player->play_note(editor.get_cursor_x(),song->get_pattern(editor.get_current_pattern())->get_note(editor.get_cursor_x(),editor.get_cursor_y()));
                       	variables_lock->grab();

       			editor.cursor_move_down();
       			tracker.queue_draw();
          		
       		} else if ((editor.get_cursor_field()==0) && is_key(KEY_PLAY_ROW,event->keyval)) {

        		int i;
                       	variables_lock->release();
       			for (i=0;i<PATTERN_WIDTH;i++) player->play_note(i,song->get_pattern(editor.get_current_pattern())->get_note(i,editor.get_cursor_y()));
                       	variables_lock->grab();
       			editor.cursor_move_down();
       			
          		tracker.queue_draw();

                } else if (is_note(event->keyval) || ((event->keyval>='0') && (event->keyval<='9')) || ((event->keyval>='A') && (event->keyval<='Z') ))  { //quickhack!

       			previous_cursor_x=editor.get_cursor_x();
       			previous_cursor_y=editor.get_cursor_y();
 	
       			if (editor.press_key_at_cursor(event->keyval)) {

                               	variables_lock->release();	
       				if (event->keyval!='`') player->play_note(previous_cursor_x,song->get_pattern(editor.get_current_pattern())->get_note(previous_cursor_x,previous_cursor_y));
                               	variables_lock->grab();

       			}
       			tracker.queue_draw();
       		}
       	}


	update_main_editing_entries();

	variables_lock->release();

	if (aux_instrument!=editor.get_instrument_mask_value()) {
		//something changed the insturment mask.. let's update..

		selected_sample_updating_in_progress=true;
		selected_instrument_updating_in_progress=true;

		if (editor.get_instrument_mask_value()!=EMPTY_FIELD) {

	        	if (song->variables.use_instruments) {

				clist_instrments_names.row(editor.get_instrument_mask_value()).select();
				selected_instrument=editor.get_instrument_mask_value();
				update_selected_instrument_info();

				selected_sample=song->find_first_sample_in_instrument(editor.get_instrument_mask_value());
				clist_samples_list.row(selected_sample).select();
				update_selected_sample_info();
			} else {
				clist_samples_list.row(editor.get_instrument_mask_value()).select();
				selected_sample=editor.get_instrument_mask_value();
				update_selected_sample_info();
			}
		}

		selected_sample_updating_in_progress=false;
		selected_instrument_updating_in_progress=false;
	}


	gtk_signal_emit_stop_by_name(GTK_OBJECT(tracker.gtkobj()),"key_press_event");
	
	previous_shift=shift;
	
	return TRUE;

	return 0;

}


void Interface::on_pattern_properties_popup_ok_clicked() {

	int i,max,current;

	variables_lock->grab();

	editor.set_default_octave(pattern_properties_popup->spinbutton_base_octave->get_value_as_int());
	editor.set_cursor_spacing(pattern_properties_popup->spinbutton_cursor_step->get_value_as_int());
	editor.set_hl_minor(pattern_properties_popup->spinbutton_row_highlight_minor->get_value_as_int());
	editor.set_hl_major(pattern_properties_popup->spinbutton_row_highlight_major->get_value_as_int());
	
	
	current=editor.get_current_pattern();	
	max=current+pattern_properties_popup->spinbutton_repeat_pattern_length->get_value_as_int();
	max=(max>MAX_PATTERNS)?MAX_PATTERNS:max;

	for (i=current;i<max;i++) {

		song->get_pattern(i)->set_length(pattern_properties_popup->spinbutton_pattern_length->get_value_as_int());
	}

        update_main_all_entries();
        tracker.queue_draw();

	variables_lock->release();

	delete pattern_properties_popup;
}


void Interface::on_pattern_undo_popup_select_row() {


	if (pattern_undo_popup->selected_row==-1) return;

	variables_lock->grab();


	editor.undo_index(pattern_undo_popup->selected_row);

	delete pattern_undo_popup;

	variables_lock->release();

	tracker.queue_draw();
}

