/***************************************************************************
                          interface_callbacks_instruments.cpp  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

gint Interface::equivtable_key_press_callback(GdkEventKey* event) {

	bool stop_signal=true;

        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');

	switch (event->keyval) {

		case GDK_Up: {

			equivtable_instruments.MoveUp();
 				
		} break;

		case GDK_Down: {

			equivtable_instruments.MoveDown();
		} break;

		case GDK_Left: {

			equivtable_instruments.MoveLeft(); 		
		} break;
		case GDK_Right: {

			equivtable_instruments.MoveRight();	
		} break;
		case GDK_Page_Up: {

			equivtable_instruments.PageUp();	
		 		
		} break;
		case GDK_Page_Down: {

			equivtable_instruments.PageDown();	 		
		} break;        	

		case '.':{

			equivtable_instruments.ClearOrder();
		} break;
		case GDK_Insert: {

			equivtable_instruments.InsertBlank();		
		} break;
		case GDK_Delete: {

			equivtable_instruments.DeleteRow();				
		} break;
		case GDK_KP_Add: {

			equivtable_instruments.AddSeparator();
		} break;
		case GDK_KP_Subtract: {
			
			equivtable_instruments.InsertRepeat();		
		} break;
		default: {
			if (((event->keyval>='0') && (event->keyval<='9')) || ((event->keyval>='A') && (event->keyval<='Z'))) equivtable_instruments.InsertValue(event->keyval);
		}break;

	}

	equivtable_instruments.queue_draw();

	if (stop_signal) {

		gtk_signal_emit_stop_by_name(GTK_OBJECT(equivtable_instruments.gtkobj()),"key_press_event");

		return TRUE;
	} else {

		return FALSE;
	}

}
gint Interface::on_instruments_piano_enabled_widgets_key_pressed(GdkEventKey* event) {

	if (! ((event->keyval>='a' && event->keyval<='z') ||
   	    (event->keyval>='A' && event->keyval<='Z') ||
	    (event->keyval>='0' && event->keyval<='9')) ) return 1;


        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');

	int pressed_note=editor.get_note_from_key(event->keyval);

	if (pressed_note!=255) realtime_keyboard.instrument_press_key(pressed_note,255);

	return 1;
}

gint Interface::on_instruments_piano_enabled_widgets_key_released(GdkEventKey* event) {

	if (! ((event->keyval>='a' && event->keyval<='z') ||
   	    (event->keyval>='A' && event->keyval<='Z') ||
	    (event->keyval>='0' && event->keyval<='9')) ) return 1;

	if (xlib_key_is_pressed(event->keyval)) return 1;

        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');

	int pressed_note=editor.get_note_from_key(event->keyval);

	if (pressed_note!=255) realtime_keyboard.instrument_stop_key(pressed_note);

	return 1;
}

gint Interface::on_envelope_instruments_volume_clicked(GdkEventButton* event) {

	int tmp_nodes_amount=song->get_instrument(selected_instrument)->volume.envelope.node_count;

	switch (event->button) {

		case 1: {

			envelope_instruments_volume.attempt_node_grab(event->x,event->y);
		} break;

		case 2: {

			envelope_instruments_volume.start_zoom(event->x,event->y);
		} break;

		case 3: {

			envelope_instruments_volume.delete_selected_node();
		} break;

	}

	if (tmp_nodes_amount!=song->get_instrument(selected_instrument)->volume.envelope.node_count) {
	//new point?
	       update_selected_instrument_info();
	}

	return 0;
}

gint Interface::on_envelope_instruments_pan_clicked(GdkEventButton* event) {

	int tmp_nodes_amount=song->get_instrument(selected_instrument)->panning.envelope.node_count;


        switch (event->button) {

		case 1: {

			envelope_instruments_pan.attempt_node_grab(event->x,event->y);
		} break;

		case 2: {

			envelope_instruments_pan.start_zoom(event->x,event->y);
		} break;

		case 3: {

			envelope_instruments_pan.delete_selected_node();
		} break;

	}

	if (tmp_nodes_amount!=song->get_instrument(selected_instrument)->panning.envelope.node_count) {
	//new point?
	       update_selected_instrument_info();
	}

	return 0;
}

gint Interface::on_envelope_instruments_frequency_clicked(GdkEventButton* event) {

	int tmp_nodes_amount=song->get_instrument(selected_instrument)->pitch.envelope.node_count;

        switch (event->button) {

		case 1: {

			envelope_instruments_frequency.attempt_node_grab(event->x,event->y);
		} break;

		case 2: {

			envelope_instruments_frequency.start_zoom(event->x,event->y);
		} break;

		case 3: {

			envelope_instruments_frequency.delete_selected_node();
		} break;

	}


	if (tmp_nodes_amount!=song->get_instrument(selected_instrument)->pitch.envelope.node_count) {
	//new point?
	       update_selected_instrument_info();
	}

	return 0;
}

gint Interface::on_envelope_instruments_volume_key_pressed(GdkEventKey* event) {

	int tmp_nodes_amount=song->get_instrument(selected_instrument)->volume.envelope.node_count;

	//envelope_instruments_volume.process_keyval(event->keyval);	

	if (tmp_nodes_amount!=song->get_instrument(selected_instrument)->volume.envelope.node_count) {
	//new point?
	       update_selected_instrument_info();
	}
	return 0;
}

gint Interface::on_envelope_instruments_pan_key_pressed(GdkEventKey* event) {

	int tmp_nodes_amount=song->get_instrument(selected_instrument)->panning.envelope.node_count;

	//envelope_instruments_pan.process_keyval(event->keyval);	

	if (tmp_nodes_amount!=song->get_instrument(selected_instrument)->panning.envelope.node_count) {
	//new point?
	       update_selected_instrument_info();
	}

	return 0;
}

gint Interface::on_envelope_instruments_frequency_key_pressed(GdkEventKey* event) {

	int tmp_nodes_amount=song->get_instrument(selected_instrument)->pitch.envelope.node_count;

	//envelope_instruments_frequency.process_keyval(event->keyval);	

	if (tmp_nodes_amount!=song->get_instrument(selected_instrument)->pitch.envelope.node_count) {
	//new point?
	       update_selected_instrument_info();
	}

	return 0;
}


void Interface::on_clist_instrments_names_select_row(gint row, gint column, GdkEvent *event){

	if (selected_instrument_updating_in_progress) return;

	selected_instrument=row;

	update_selected_instrument_info();

	if (song->variables.use_instruments) {

		editor.set_instrument_mask_value(row);
		selected_sample=song->find_first_sample_in_instrument(editor.get_instrument_mask_value());
		clist_samples_list.row(selected_sample).select();
		update_selected_sample_info();
		editor.set_instrument_mask_value(row); // <- bleh

	}

	update_main_editing_entries();
}

void Interface::on_entry_instrument_name_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->name=entry_instrument_name.get_text();
        clist_instrments_names.set_text(selected_instrument,1,song->get_instrument(selected_instrument)->name);

	update_main_editing_entries();

}
void Interface::on_button_instrument_options_clicked() {

	if (selected_instrument_updating_in_progress) return;

	instrument_utils_popup.instrument_menu.popup(1,0);
}
void Interface::on_radiobutton_instruments_nna_note_cut_clicked(){

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->NNA_type=Instrument::NNA_NOTE_CUT;
}

void Interface::on_radiobutton_instruments_nna_note_continue_clicked(){

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->NNA_type=Instrument::NNA_NOTE_CONTINUE;

}

void Interface::on_radiobutton_instruments_nna_note_off_clicked(){

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->NNA_type=Instrument::NNA_NOTE_OFF;

}

void Interface::on_radiobutton_instruments_nna_note_fade_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->NNA_type=Instrument::NNA_NOTE_FADE;

}

void Interface::on_radiobutton_instruments_dca_disabled_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->duplicate_check_type=Instrument::DCT_DISABLED;


}

void Interface::on_radiobutton_instruments_dca_note_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->duplicate_check_type=Instrument::DCT_NOTE;

}

void Interface::on_radiobutton_instruments_dca_sample_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->duplicate_check_type=Instrument::DCT_SAMPLE;

}

void Interface::on_radiobutton_instruments_dca_disabled_instrument_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->duplicate_check_type=Instrument::DCT_INSTRUMENT;

}

void Interface::on_radiobutton_instruments_dca_note_fade_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->duplicate_check_action=Instrument::DCA_NOTE_FADE;

}

void Interface::on_radiobutton_instruments_dca_note_off_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->duplicate_check_action=Instrument::DCA_NOTE_OFF;

}

void Interface::on_radiobutton_instruments_dca_note_cut_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->duplicate_check_action=Instrument::DCA_NOTE_CUT;

}

void Interface::on_entry_instruments_name_changed() {

	if (selected_instrument_updating_in_progress) return;

}

void Interface::on_checkbutton_instruments_volume_envelope_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.envelope.on=checkbutton_instruments_volume_envelope.get_active();

}

void Interface::on_checkbutton_instruments_pitch_envelope_clicked() {

	if (selected_instrument_updating_in_progress) return;

		song->get_instrument(selected_instrument)->pitch.envelope.on=checkbutton_instruments_pitch_envelope.get_active();

	
}
void Interface::on_checkbutton_instruments_pitch_envelope_filter_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.use_as_filter=checkbutton_instruments_pitch_envelope_filter.get_active();


}


void Interface::on_checkbutton_instruments_volume_envelope_carry_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.envelope.carry=checkbutton_instruments_volume_envelope_carry.get_active();
}

void Interface::on_checkbutton_instruments_volume_envelope_loop_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.envelope.loop_on=checkbutton_instruments_volume_envelope_loop.get_active();

	envelope_instruments_volume.set_redraw_all();
	envelope_instruments_volume.queue_draw();

}

void Interface::on_checkbutton_instruments_volume_envelope_susloop_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.envelope.sustain_loop_on=checkbutton_instruments_volume_envelope_susloop.get_active();

	envelope_instruments_volume.set_redraw_all();
	envelope_instruments_volume.queue_draw();

}

void Interface::on_checkbutton_instruments_pan_envelope_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.envelope.on=checkbutton_instruments_pan_envelope.get_active();

}

void Interface::on_checkbutton_instruments_pan_envelope_carry_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.envelope.carry=checkbutton_instruments_pan_envelope_carry.get_active();

}

void Interface::on_checkbutton_instruments_pan_envelope_loop_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.envelope.loop_on=checkbutton_instruments_pan_envelope_loop.get_active();

	envelope_instruments_pan.set_redraw_all();
	envelope_instruments_pan.queue_draw();
}

void Interface::on_checkbutton_instruments_pan_envelope_susloop_add() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.envelope.sustain_loop_on=checkbutton_instruments_pan_envelope_susloop.get_active();

	envelope_instruments_pan.set_redraw_all();
	envelope_instruments_pan.queue_draw();

}

void Interface::on_checkbutton_instruments_pan_default_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.use_default=checkbutton_instruments_pan_default.get_active();
}

void Interface::on_checkbutton_instruments_frequency_envelope_carry_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.envelope.carry=checkbutton_instruments_frequency_envelope_carry.get_active();
}

void Interface::on_checkbutton_instruments_frequency_envelope_loop_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.envelope.loop_on=checkbutton_instruments_frequency_envelope_loop.get_active();

	envelope_instruments_frequency.set_redraw_all();
	envelope_instruments_frequency.queue_draw();

}


void Interface::on_checkbutton_instruments_frequency_envelope_susloop_clicked(){

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.envelope.sustain_loop_on=checkbutton_instruments_frequency_envelope_susloop.get_active();

	envelope_instruments_frequency.set_redraw_all();
	envelope_instruments_frequency.queue_draw();


}
void Interface::on_spinbutton_instruments_volume_envelope_loop_begin_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.envelope.set_loop_begin(spinbutton_instruments_volume_envelope_loop_begin->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_volume_envelope_loop_end->set_value(song->get_instrument(selected_instrument)->volume.envelope.loop_end_node);

	envelope_instruments_volume.set_redraw_all();
	envelope_instruments_volume.queue_draw();

	selected_instrument_updating_in_progress=false;	

}
void Interface::on_spinbutton_instruments_volume_envelope_loop_end_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.envelope.set_loop_end(spinbutton_instruments_volume_envelope_loop_end->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_volume_envelope_loop_begin->set_value(song->get_instrument(selected_instrument)->volume.envelope.loop_begin_node);

	envelope_instruments_volume.set_redraw_all();
	envelope_instruments_volume.queue_draw();

	selected_instrument_updating_in_progress=false;	

}
void Interface::on_spinbutton_instruments_volume_envelope_susloop_begin_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.envelope.set_sustain_loop_begin(spinbutton_instruments_volume_envelope_susloop_begin->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_volume_envelope_susloop_end->set_value(song->get_instrument(selected_instrument)->volume.envelope.sustain_loop_end_node);

	envelope_instruments_volume.set_redraw_all();
	envelope_instruments_volume.queue_draw();

	selected_instrument_updating_in_progress=false;	

}
void Interface::on_spinbutton_instruments_volume_envelope_susloop_end_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.envelope.set_sustain_loop_end(spinbutton_instruments_volume_envelope_susloop_end->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_volume_envelope_susloop_begin->set_value(song->get_instrument(selected_instrument)->volume.envelope.sustain_loop_begin_node);

	envelope_instruments_volume.set_redraw_all();
	envelope_instruments_volume.queue_draw();

	selected_instrument_updating_in_progress=false;	

}
void Interface::on_spinbutton_instruments_pan_envelope_loop_begin_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.envelope.set_loop_begin(spinbutton_instruments_pan_envelope_loop_begin->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_pan_envelope_loop_end->set_value(song->get_instrument(selected_instrument)->panning.envelope.loop_end_node);


	envelope_instruments_pan.set_redraw_all();
	envelope_instruments_pan.queue_draw();

	selected_instrument_updating_in_progress=false;	


}
void Interface::on_spinbutton_instruments_pan_envelope_loop_end_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.envelope.set_loop_end(spinbutton_instruments_pan_envelope_loop_end->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_pan_envelope_loop_begin->set_value(song->get_instrument(selected_instrument)->panning.envelope.loop_begin_node);

	envelope_instruments_pan.set_redraw_all();
	envelope_instruments_pan.queue_draw();

	selected_instrument_updating_in_progress=false;	

}
void Interface::on_spinbutton_instruments_pan_envelope_susloop_begin_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.envelope.set_sustain_loop_begin(spinbutton_instruments_pan_envelope_susloop_begin->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_pan_envelope_susloop_end->set_value(song->get_instrument(selected_instrument)->panning.envelope.sustain_loop_end_node);

	envelope_instruments_pan.set_redraw_all();
	envelope_instruments_pan.queue_draw();

	selected_instrument_updating_in_progress=false;	

}


void Interface::on_spinbutton_instruments_pan_envelope_susloop_end_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.envelope.set_sustain_loop_end(spinbutton_instruments_pan_envelope_susloop_end->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_pan_envelope_susloop_begin->set_value(song->get_instrument(selected_instrument)->panning.envelope.sustain_loop_begin_node);


	envelope_instruments_pan.set_redraw_all();
	envelope_instruments_pan.queue_draw();

	selected_instrument_updating_in_progress=false;	

}

void Interface::on_spinbutton_instruments_frequency_envelope_loop_begin_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.envelope.set_loop_begin(spinbutton_instruments_frequency_envelope_loop_begin->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_frequency_envelope_loop_end->set_value(song->get_instrument(selected_instrument)->pitch.envelope.loop_end_node);

	envelope_instruments_frequency.set_redraw_all();
	envelope_instruments_frequency.queue_draw();

	selected_instrument_updating_in_progress=false;	

}


void Interface::on_spinbutton_instruments_frequency_envelope_loop_end_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.envelope.set_loop_end(spinbutton_instruments_frequency_envelope_loop_end->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_frequency_envelope_loop_begin->set_value(song->get_instrument(selected_instrument)->pitch.envelope.loop_begin_node);

	envelope_instruments_frequency.set_redraw_all();
	envelope_instruments_frequency.queue_draw();

	selected_instrument_updating_in_progress=false;	

}



void Interface::on_spinbutton_instruments_frequency_envelope_susloop_begin_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.envelope.set_sustain_loop_begin(spinbutton_instruments_frequency_envelope_susloop_begin->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_frequency_envelope_susloop_end->set_value(song->get_instrument(selected_instrument)->pitch.envelope.sustain_loop_end_node);

	envelope_instruments_frequency.set_redraw_all();
	envelope_instruments_frequency.queue_draw();

	selected_instrument_updating_in_progress=false;	

}

void Interface::on_spinbutton_instruments_frequency_envelope_susloop_end_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.envelope.set_sustain_loop_end(spinbutton_instruments_frequency_envelope_susloop_end->get_value_as_int());

	selected_instrument_updating_in_progress=true;	

	spinbutton_instruments_frequency_envelope_susloop_begin->set_value(song->get_instrument(selected_instrument)->pitch.envelope.sustain_loop_begin_node);

	envelope_instruments_frequency.set_redraw_all();
	envelope_instruments_frequency.queue_draw();

	selected_instrument_updating_in_progress=false;	


}
void Interface::on_spinbutton_instruments_global_volume_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.global_amount=spinbutton_instruments_global_volume->get_value_as_int();

}
void Interface::on_spinbutton_instruments_volume_fadeout_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.fadeout=spinbutton_instruments_volume_fadeout->get_value_as_int();

}
void Interface::on_spinbutton_instruments_volume_swing_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->volume.random_variation=spinbutton_instruments_volume_swing->get_value_as_int();

}
void Interface::on_spinbutton_instruments_pan_default_value_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.default_amount=spinbutton_instruments_pan_default_value->get_value_as_int();

}
void Interface::on_spinbutton_instruments_pan_pitch_center_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.pitch_center=spinbutton_instruments_pan_pitch_center->get_value_as_int();
	entry_instruments_pan_pitch_center.set_text(editor.get_single_note_string(song->get_instrument(selected_instrument)->panning.pitch_center));

}
void Interface::on_spinbutton_instruments_pitch_pan_separation_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.pitch_separation=spinbutton_instruments_pitch_pan_separation->get_value_as_int();

}
void Interface::on_spinbutton_instruments_pan_swing_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->panning.random_variation=spinbutton_instruments_pan_swing->get_value_as_int();

}


void Interface::on_spinbutton_instruments_default_cutoff_adj_changed() {

	if (selected_instrument_updating_in_progress) return;


	song->get_instrument(selected_instrument)->pitch.default_cutoff=spinbutton_instruments_default_cutoff->get_value_as_int();
}
void Interface::on_checkbutton_instruments_use_default_cutoff_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.use_default_cutoff=checkbutton_instruments_use_default_cutoff.get_active();

}

void Interface::on_spinbutton_instruments_default_Q_adj_changed() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.default_Q=spinbutton_instruments_default_Q->get_value_as_int();

}
void Interface::on_checkbutton_instruments_use_default_Q_clicked() {

	if (selected_instrument_updating_in_progress) return;

	song->get_instrument(selected_instrument)->pitch.use_default_Q=checkbutton_instruments_use_default_Q.get_active();

}






void Interface::on_popup_instrument_edit_clicked(int option) {

	realtime_keyboard.instrument_stop_all();
	realtime_keyboard.sample_stop_all();
      	player->play_stop();		
	
	variables_lock->grab();

	switch (option) {

		case Popup_Instrument_Utils::OPTION_LOAD: {

		 	string filename;
		      	bool load_ok=false;
	
		      	file_select_popup= new File_Access_Widget;
	      		file_select_popup->set_mode(File_Access_Widget::LOAD);
		        if (data_path!="") file_select_popup->set_filename(data_path);
  			file_select_popup->make_default.connect(SigC::bind<string>(slot(this,&Interface::set_some_default_path),"data"));

	
			do {
	
		      		file_select_popup->poll_until_action(*kit);
		      		filename=file_select_popup->get_filename();
	
		      		if (file_select_popup->get_action()!=File_Access_Widget::CANCEL) {
	
			      		if (file_manager->load_instrument((char*)filename.c_str(),selected_instrument)==FUNCTION_SUCCESS) {

						load_ok=true;
					}	
				}
		
		      	} while (!load_ok && (file_select_popup->get_action()!=File_Access_Widget::CANCEL));
                        delete file_select_popup;

		} break;

		case Popup_Instrument_Utils::OPTION_SAVE: {
			
   			variables_lock->release();
	                save_instrument();
			variables_lock->grab();

		} break;

		case Popup_Instrument_Utils::OPTION_COPY: {

			instrument_clipboard=*song->get_instrument(selected_instrument);
			clipboard_instrument_index=selected_instrument;

		} break;
		case Popup_Instrument_Utils::OPTION_PASTE: {

			if (clipboard_instrument_index==-1) break;
			*song->get_instrument(selected_instrument)=instrument_clipboard;
	
		} break;
		case Popup_Instrument_Utils::OPTION_PASTE_EXCHANGE: {

			if (clipboard_instrument_index==-1) break;

			instrument_clipboard=*song->get_instrument(selected_instrument);
			*song->get_instrument(selected_instrument)=*song->get_instrument(clipboard_instrument_index);
			*song->get_instrument(clipboard_instrument_index)=instrument_clipboard;
		} break;
		case Popup_Instrument_Utils::OPTION_PASTE_EXCHANGE_SONG: {

			if (clipboard_instrument_index==-1) break;

			instrument_clipboard=*song->get_instrument(selected_instrument);
			*song->get_instrument(selected_instrument)=*song->get_instrument(clipboard_instrument_index);
			*song->get_instrument(clipboard_instrument_index)=instrument_clipboard;
		} break;
		case Popup_Instrument_Utils::OPTION_DELETE_SAMPLES: {

			int j;

			for (j=0;j<Note::NOTES;j++) {
			        //first delete the samples!
				if (song->get_instrument(selected_instrument)->sample_number[j]<MAX_SAMPLES) {

					song->get_sample(song->get_instrument(selected_instrument)->sample_number[j])->reset();
				}
			}
			//then reset
			song->get_instrument(selected_instrument)->reset();

			//then set instrument/note relation
			for (j=0;j<Note::NOTES;j++) {

				song->get_instrument(selected_instrument)->sample_number[j]=selected_instrument;
				song->get_instrument(selected_instrument)->note_number[j]=j;
			}


		} break;
		case Popup_Instrument_Utils::OPTION_DELETE: {

			int j;
			song->get_instrument(selected_instrument)->reset();

			for (j=0;j<Note::NOTES;j++) {
			
				song->get_instrument(selected_instrument)->sample_number[j]=selected_instrument;
				song->get_instrument(selected_instrument)->note_number[j]=j;
			}

		} break;
	}
	
	variables_lock->release();
	update_clist_samples_list();
        update_clist_instrments_names();
	update_selected_sample_info();
        update_selected_instrument_info();

}

void Interface::save_instrument() {


 	string filename;
      	bool load_ok=false;

	
	realtime_keyboard.instrument_stop_all();
	realtime_keyboard.sample_stop_all();

      	file_select_popup= new File_Access_Widget;
      	file_select_popup->set_mode(File_Access_Widget::SAVE);
        if (data_path!="") file_select_popup->set_filename(data_path);
	file_select_popup->make_default.connect(SigC::bind<string>(slot(this,&Interface::set_some_default_path),"data"));       	
      	do {

      		file_select_popup->poll_until_action(*kit);
      		filename=file_select_popup->get_filename();


      		if (file_select_popup->get_action()!=File_Access_Widget::CANCEL) {

			int error;
			
			if ((error=file_manager->save_instrument((char*)filename.c_str(),selected_instrument))==Saver::SAVE_OK) {
				//hooray! we got a sample!
				load_ok=true;

			} else if  (error==Saver::SAVE_ERROR) {
 				
 				accept_dialog = new Dialog_Accept("Error opening file for writing",*kit);
      				delete accept_dialog;
			
	      		} else if  (error==Saver::UNKNOWN_TYPE) {
	      		
      				accept_dialog = new Dialog_Accept("Unknown file format (check extension?)",*kit);      			
      				delete accept_dialog;      				
	      		}
	      		
		}

      	} while (!load_ok && (file_select_popup->get_action()!=File_Access_Widget::CANCEL));

      	delete file_select_popup;

}

