import dbus

class StatusAWN:
	def __init__(self, checker, app_name):
		
		self.checker = checker
		self.app_name = app_name
		self.checker.add_status_cb(self.set_status)

		self.awn = None
		try:
			bus = dbus.SessionBus()
			obj = bus.get_object("com.google.code.Awn", "/com/google/code/Awn")
			self.awn = dbus.Interface(obj, "com.google.code.Awn")
		except dbus.DBusException:
			print "DBUS error while trying to communicate with AWN. Is it running?"

	
	def set_status(self, mcount, title, message):
		if self.awn is not None:
					
			if mcount > 0:
				self.awn.SetInfoByName (self.app_name, "%s" % mcount)
			else:
				self.awn.UnsetInfoByName (self.app_name)
