/***************************************************************************
                          SpeedPnl.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SPEEDPNL_H
#define SPEEDPNL_H

#include <qvariant.h>
#include <qwidget.h>
#include <qslider.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QFrame;
class QGroupBox;
class QLCDNumber;
class QLabel;
class KConfig;

class SpeedPnl : public QWidget
{ 
    Q_OBJECT

public:
    	SpeedPnl( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    	~SpeedPnl();
	
    	void readOptions();
    	void saveOptions();
    	inline QString getSpeed() { return QString::number(speedSld->value());}
    	
protected slots:
    	void speedChangeSlot();

private:
	QGroupBox* SpeedPnlFrm;
     QLCDNumber* speedLcd;
     QFrame* spaser;
     QLabel* minLbl;
     QSlider* speedSld;
     QLabel* maxLbl;
     QHBoxLayout* SpeedPnlLayout;
     QHBoxLayout* SpeedPnlFrmLayout;
     bool event( QEvent* );

     KConfig *config;
};

#endif // SPEEDPNL_H
