/***************************************************************************
                          CdboDialogActionFactory.h  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CDBODIALOGACTIONFACTORY_H
#define CDBODIALOGACTIONFACTORY_H

#include <qobject.h>
#include "SessionTypeDialog.h"

class KProcess;
class KShellProcess;
class KConfig;

class CdboDialogBase;

class CdboDialogActionFactory : public QObject{
	Q_OBJECT
public:
	CdboDialogActionFactory(CdboDialogBase *, const char *);
	~CdboDialogActionFactory();	
	/** available for all dialog types */
	void checkDrive();
	/** available for erase dialog only */
	void erase();
	/** available for all dialog types */
	void fixate();
	/** available for all dialog types */
	void burn(QString image, bool audio = false);
	/** available for all dialog types */
	void readData(QString in, QString *out);
	/** available for all dialog types */
	void readAudio(QString in, QString *out);
	/** available for all dialog types */
	void createISO(QStringList *flist, QString imageName);
	/** available for all dialog types */
	void createISO(QString *mappings, QString imageName);
	/** available for all dialog types */
	void createCdOnTheFly(QStringList *flist);
	/** available for all dialog types */
	void createCdOnTheFly(QString *mappings);
	//void createAudioCdOnTheFly(QStringList *flist);
	/** available for all dialog types */
	void convertMp3(QStringList *flist, QString);
	/** available for all dialog types */
	//void convertOgg(QStringList *flist);
	
	
	void killCurrentTask();
	void removeTmpImage(QString image, QString dirName);
	void removeOneFile(QString fileName);
	/*returns false if dir does not exist */
	bool checkTmp(QString tempDir, int minSize);
	
	inline void resetSessionType(){ sessionType = SessionTypeDialog::invalidSession; }//
		
signals:
	void processDone(bool);
	void tmpCheckProcessDone(bool);
	void failedToLunchProcess();
	void processCancelled();
	
private slots:
//protected slots:
    	void receivedMessageSlot(KProcess *proc, char *buffer, int buflen);
    	void receivedErrMessageSlot(KProcess *proc, char *buffer, int buflen);
	void processDoneSlot(KProcess *);
	
	void receivedSizeMessageSlot(KProcess *, char *, int);
    	void sizeCheckProcessDoneSlot(KProcess *);
    	
    	void receivedCountAudioMessageSlot(KProcess *, char *, int);
    	void countAudioProcessDoneSlot(KProcess *);
    	
    	void receivedFetchLastSessionMessageSlot(KProcess *, char *, int);
    	void fetchLastSessionDoneSlot(KProcess *);
    	
    	void receivedCheckLastSessionsMessageSlot(KProcess *, char *, int);
    	
private:
	//members
	KProcess *cdboProc;
	KProcess *currentProc;
	KShellProcess *cdboShellProc;
	CdboDialogBase *user;
	KConfig *config;
	
	bool checkingDrive;
	bool burning;
	bool erasing;
	bool readingData;
	bool readingAudio;
	bool creatingISO;
	bool creatingCdOnTheFly;
	bool fixating;
	bool unfixated;
	bool gotAnswer;
	
	bool hasSpase;//used for size check
	QString tempDirName;//used for size check
	int minTmpSize;//used for size check
	
	int sessionType;
	
	QString fromTrack;//used for audio
	QString toTrack;//used for audio
	QString *imageAddr;
	QString isoImageName;
	QString *isoFileMappings;
	QString drName;
	QStringList *flist;
	
	//methods
	void initDriveCheckProcess();
	void initEraseProcess();
	void initFixateProcess();
	void initBurnProcess(QString image, bool audio);
	void addCustomBurnOpt();
	void initReadDataProcess(QString in, QString *out);
	void countAudioTracks();
	void initCdparanoiaProcess();
	void initCdda2wavProcess();
	void initConvertMp3Process(QStringList *flist, QString imageName);
	
	
	bool initCreateISOProcess();
	void initStdISOProcess();
	void initCustomISOProcess();
	QString createFileListString(QStringList *);
	void addHybridOptions();
	void addBootOptions();
	void fetchLastSession();
	void checkLastSessions();
	
	void lunchProcess(KProcess *);
	bool DEBUG_COMMANDS;
};
#endif	