/***************************************************************************
                          CdCopyDialog.h  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                :  alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDCOPYDIALOG_H
#define CDCOPYDIALOG_H

#include <qwidget.h>
#include <qstring.h>
#include <qevent.h>
#include <qdatetime.h>

#include <kconfig.h>
#include <kprocess.h>

#include "CdCopyDialogBase.h"
#include "CdboDialogBase.h"
#include "CdboDialogActionFactory.h"

#include "dialogParts/DriveInfoPnl.h"
#include "dialogParts/SpeedPnl.h"
#include "dialogParts/DialogCntPnl.h"


/**
  *@author
  */

class CdCopyDialog : public CdCopyDialogBase, public CdboDialogBase  {
   Q_OBJECT
public:
	CdCopyDialog(QWidget *parent=0, const char *name=0);
	~CdCopyDialog();
	
	//implementing pure virtuals
	virtual void blockBtns(bool) const;
	virtual QString getActionType() const;
	
	inline virtual void output(int type, QString message) const { dialogCntPnl->output(type, message); }
	inline virtual void status(QString message) const { dialogCntPnl->status(message); }
	
	inline virtual QString getScsiDevice() const { return targetDevicePnl->getScsiDevice(); }
	inline virtual QString getSpeed() const { return speedPnl->getSpeed(); }

protected slots:
	void taskFailedToStart();
	void taskDone(bool success);
	void tmpChecked(bool);
	
 	void cancelSlot();
	void quitSlot();
	void settingsSlot();
	void startBtnSlot();
	void eraseSlot();
	void previewSlot();
	
    virtual void customBtnSlot();
    virtual void detectDestSlot();
    virtual void readOptionsBtnSlot();

    virtual void closeEvent(QCloseEvent *e);
    virtual void keyPressEvent(QKeyEvent *e);

private:
	bool checkTmpSize;
	
	bool stillCopying;
	bool stillReading;
	bool stillChecking;
	
	bool readOnly;
	int minTmpSize;
	
	int copiesWanted;
	int copiesDone;
	
	QString fromTrack;
	QString toTrack;
	
	QString imageAddr;
	QString tempDir;
	KConfig *config;
	CdboDialogActionFactory *factory;
	
	//methods
	void saveOptions();
	void readOptions();
	void initBtns();
	bool confermExit();
	void popUpSettings(int);
	
	inline int getCopyType(){ return actionCmb->currentItem(); }

	void startCopyProcess();	
	void doCopy();
};
#endif