/***************************************************************************
                          NewCdCompilationView.h  -  description
                             -------------------
    begin                : Sun Nov 18 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NEWCDCOMPILATIONVIEW_H
#define NEWCDCOMPILATIONVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>

#include "CdboCompilationView.h"

// forward declaration of the NewCdCompilationView classes
class TargetTreeCntPanel;
class EstimatePnl;
class DataCompilationTreeView;
class CDBakeOvenApp;

class NewCdCompilationView : public CdboCompilationView{
  Q_OBJECT
public:
    /** Constructor for the main view */
    NewCdCompilationView(CDBakeOvenApp * cdboApp, QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~NewCdCompilationView();

	void saveOptions();
	inline CDBakeOvenApp* getCdboApp() {return cdboApp;}
	inline DataCompilationTreeView* getView() { return compilView;}
	
public slots:
	void showTargetControl(bool);
	void showEstimate(bool);
	

private:
  	void initView();
  	
  	//members
  	CDBakeOvenApp *cdboApp;
  	
  	TargetTreeCntPanel *targetCnt;
  	EstimatePnl *estimate;	
  	DataCompilationTreeView *compilView;
  	
  	int eTimeId;
  	int lastPercent;
	
};

#endif // NEWCDCOMPILATIONVIEW_H